/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaRequestHandlerPool$;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\u0011\"\u0001\u0019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tq\u0001\u0011)\u0019!C\u0001s!AQ\t\u0001B\u0001B\u0003%!\b\u0003\u0005G\u0001\t\u0015\r\u0011\"\u0001H\u0011!Y\u0005A!A!\u0002\u0013A\u0005\u0002\u0003'\u0001\u0005\u000b\u0007I\u0011A'\t\u0011Q\u0003!\u0011!Q\u0001\n9C\u0001\"\u0016\u0001\u0003\u0006\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0011)A\u0005/\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003I\u0011!I\u0007A!A!\u0002\u0013Q\u0004\u0002\u00036\u0001\u0005\u000b\u0007I\u0011B6\t\u0011E\u0004!\u0011!Q\u0001\n1D\u0001B\u001d\u0001\u0003\u0006\u0004%\ta\u001d\u0005\t\u007f\u0002\u0011\t\u0011)A\u0005i\"I\u0011\u0011\u0001\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011%\ty\u0002\u0001b\u0001\n\u0003\t\t\u0003\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u0012\u0011%\ti\u0004\u0001b\u0001\n\u0013\ty\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA!\u0011%\ty\u0005\u0001b\u0001\n\u0003\t\t\u0006\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA*\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!!\u001f\u0001\t\u0003\tY\bC\u0004\u0002\u0002\u0002!\t!a!\b\u0013\u0005\u0015\u0015%!A\t\u0002\u0005\u001de\u0001\u0003\u0011\"\u0003\u0003E\t!!#\t\u000f\u0005\rQ\u0004\"\u0001\u0002\f\"I\u0011QR\u000f\u0012\u0002\u0013\u0005\u0011q\u0012\u0002\u0018\u0017\u000647.\u0019*fcV,7\u000f\u001e%b]\u0012dWM\u001d)p_2T!AI\u0012\u0002\rM,'O^3s\u0015\u0005!\u0013!B6bM.\f7\u0001A\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/c5\tqF\u0003\u00021G\u0005)Q\u000f^5mg&\u0011!g\f\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0011QGN\u0007\u0002C%\u0011q'\t\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0005dYV\u001cH/\u001a:JIV\t!\b\u0005\u0002<\u0005:\u0011A\b\u0011\t\u0003{%j\u0011A\u0010\u0006\u0003\u007f\u0015\na\u0001\u0010:p_Rt\u0014BA!*\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005K\u0013AC2mkN$XM]%eA\u0005A!M]8lKJLE-F\u0001I!\tA\u0013*\u0003\u0002KS\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011kI\u0001\b]\u0016$xo\u001c:l\u0013\t\u0019\u0006K\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002\u001fI,\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002\nA!\u00199jgV\tq\u000b\u0005\u000261&\u0011\u0011,\t\u0002\u0012\u0003BL'+Z9vKN$\b*\u00198eY\u0016\u0014\u0018!B1qSN\u0004\u0013\u0001\u0002;j[\u0016\u0004\"!\u00184\u000e\u0003yS!\u0001M0\u000b\u0005\u0001\f\u0017AB2p[6|gN\u0003\u0002%E*\u00111\rZ\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\f1a\u001c:h\u0013\t9gL\u0001\u0003US6,\u0017A\u00038v[RC'/Z1eg\u0006y\"/Z9vKN$\b*\u00198eY\u0016\u0014\u0018I^4JI2,W*\u001a;sS\u000et\u0015-\\3\u0002\u000f5,GO]5dgV\tA\u000e\u0005\u0002n_6\taN\u0003\u0002k?&\u0011\u0001O\u001c\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013AE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ,\u0012\u0001\u001e\t\u0003kvl\u0011A\u001e\u0006\u0003ob\fAaY8sK*\u0011!.\u001f\u0006\u0003un\fa!_1n[\u0016\u0014(\"\u0001?\u0002\u0007\r|W.\u0003\u0002\u007fm\n)Q*\u001a;fe\u0006\u0019\u0012mZ4sK\u001e\fG/Z%eY\u0016lU\r^3sA\u0005Aan\u001c3f\u001d\u0006lW-\u0001\u0004=S:LGO\u0010\u000b\u0019\u0003\u000f\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0001CA\u001b\u0001\u0011\u0015\u0019$\u00031\u00015\u0011\u0015A$\u00031\u0001;\u0011\u00151%\u00031\u0001I\u0011\u0015a%\u00031\u0001O\u0011\u0015)&\u00031\u0001X\u0011\u0015Y&\u00031\u0001]\u0011\u0015A'\u00031\u0001I\u0011\u0015I'\u00031\u0001;\u0011\u0015Q'\u00031\u0001m\u0011\u0015\u0011(\u00031\u0001u\u0011!\t\tA\u0005I\u0001\u0002\u0004Q\u0014A\u0004;ie\u0016\fG\rU8pYNK'0Z\u000b\u0003\u0003G\u0001B!!\n\u000285\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003[\ty#\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\r\u00024\u0005!Q\u000f^5m\u0015\t\t)$\u0001\u0003kCZ\f\u0017\u0002BA\u001d\u0003O\u0011Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018a\u0004;ie\u0016\fG\rU8pYNK'0\u001a\u0011\u00027QD'/Z1ea>|GnQ1qC\u000eLG/_*f]N|'o\u00149u+\t\t\t\u0005E\u0003)\u0003\u0007\n9%C\u0002\u0002F%\u0012aa\u00149uS>t\u0007cA7\u0002J%\u0019\u00111\n8\u0003\rM+gn]8s\u0003q!\bN]3bIB|w\u000e\\\"ba\u0006\u001c\u0017\u000e^=TK:\u001cxN](qi\u0002\n\u0011B];o]\u0006\u0014G.Z:\u0016\u0005\u0005M\u0003CBA+\u0003?\n\u0019'\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u001diW\u000f^1cY\u0016T1!!\u0018*\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\n9FA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA\u001b\u0002f%\u0019\u0011qM\u0011\u0003'-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:\u0002\u0015I,hN\\1cY\u0016\u001c\b%A\u0007de\u0016\fG/\u001a%b]\u0012dWM\u001d\u000b\u0005\u0003_\n)\bE\u0002)\u0003cJ1!a\u001d*\u0005\u0011)f.\u001b;\t\r\u0005]\u0014\u00041\u0001I\u0003\tIG-\u0001\tsKNL'0\u001a+ie\u0016\fG\rU8pYR!\u0011qNA?\u0011\u0019\tyH\u0007a\u0001\u0011\u00069a.Z<TSj,\u0017\u0001C:ikR$wn\u001e8\u0015\u0005\u0005=\u0014aF&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014\bk\\8m!\t)Td\u0005\u0002\u001eOQ\u0011\u0011qQ\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00192+\t\t\tJK\u0002;\u0003'[#!!&\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?K\u0013AC1o]>$\u0018\r^5p]&!\u00111UAM\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class KafkaRequestHandlerPool
implements Logging {
    private final KafkaConfig config;
    private final String clusterId;
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final Metrics metrics;
    private final Meter aggregateIdleMeter;
    private final String nodeName;
    private final AtomicInteger threadPoolSize;
    private final Option<Sensor> threadpoolCapacitySensorOpt;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$11() {
        return KafkaRequestHandlerPool$.MODULE$.$lessinit$greater$default$11();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KafkaRequestHandlerPool kafkaRequestHandlerPool = this;
        synchronized (kafkaRequestHandlerPool) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Option<Sensor> threadpoolCapacitySensorOpt() {
        return this.threadpoolCapacitySensorOpt;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        this.runnables().$plus$eq(new KafkaRequestHandler(id, this.config, this.clusterId(), this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time, this.nodeName));
        KafkaThread.daemon("data-plane-kafka-request-handler-" + id, this.runnables().apply(id)).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String> & Serializable)() -> "Resizing request handler thread pool size from " + currentSize + " to " + newSize);
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp(i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp(i -> this.runnables().remove(currentSize - i).stop());
        }
        this.threadPoolSize().set(newSize);
        this.threadpoolCapacitySensorOpt().foreach((Function1<Sensor, Object> & Serializable)sensor -> {
            sensor.record(100.0 * (double)newSize);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void shutdown() {
        this.info((Function0<String> & Serializable)() -> "shutting down");
        this.runnables().foreach((Function1<KafkaRequestHandler, Object> & Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1<KafkaRequestHandler, Object> & Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String> & Serializable)() -> "shut down completely");
    }

    public KafkaRequestHandlerPool(KafkaConfig config, String clusterId, int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, Metrics metrics, Meter aggregateIdleMeter, String nodeName) {
        Option option;
        this.config = config;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.metrics = metrics;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.nodeName = nodeName;
        Logging.$init$(this);
        this.threadPoolSize = new AtomicInteger(numThreads);
        String string = requestHandlerAvgIdleMetricName;
        String string2 = "RequestHandlerAvgIdlePercent";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Sensor sensor = metrics.sensor("TotalIoThreadsPercentage");
            sensor.add(ThreadUsageMetrics$.MODULE$.ioThreadPoolCapacityMetricName(metrics), new Value());
            sensor.record(100.0 * (double)numThreads);
            option = new Some<Sensor>(sensor);
        } else {
            option = None$.MODULE$;
        }
        this.threadpoolCapacitySensorOpt = option;
        this.logIdent_$eq("[data-plane Kafka Request Handler on " + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(nodeName)) + " " + brokerId + "] ");
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp(i -> this.createHandler(i));
    }
}

