/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import kafka.server.ConfigHelper;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.KraftInternalAdmin$;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.tier.backupObjectLifecycle.NameAndId;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.Nothing$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001B\t\u0013\u0005]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tk\u0001\u0011\t\u0011)A\u0005m!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015\t\b\u0001\"\u0003s\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002Z\u0001!\t%a\u0017\b\u000f\u0005%$\u0003#\u0001\u0002l\u00191\u0011C\u0005E\u0001\u0003[BaA\u0014\u0007\u0005\u0002\u0005=\u0004bBA9\u0019\u0011%\u00111\u000f\u0005\b\u0003\u000bcA\u0011AAD\u0011\u001d\t9\u000b\u0004C\u0001\u0003S\u0013!c\u0013:bMRLe\u000e^3s]\u0006d\u0017\tZ7j]*\u00111\u0003F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u00011y\u0011\u0003CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 A5\t!#\u0003\u0002\"%\ti\u0011J\u001c;fe:\fG.\u00113nS:\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u000b\u0002\u000bU$\u0018\u000e\\:\n\u0005\u001d\"#a\u0002'pO\u001eLgnZ\u0001\bG\"\fgN\\3m!\tQ3'D\u0001,\u0015\taS&\u0001\u0004d_6lwN\u001c\u0006\u0003'9R!!F\u0018\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0005\u0003i-\u0012aDT8eKR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\t9$(D\u00019\u0015\tI$#\u0001\u0005nKR\fG-\u0019;b\u0013\tY\u0004HA\fL%\u00064G/S7bO\u0016lU\r^1eCR\f7)Y2iK\u0006IA/[7f_V$Xj\u001d\t\u00033yJ!a\u0010\u000e\u0003\u0007%sG/A\nlC\u001a\\\u0017mQ8oM&<7+\u001e9qY&,'\u000fE\u0002C\u0013.k\u0011a\u0011\u0006\u0003\t\u0016\u000b\u0001BZ;oGRLwN\u001c\u0006\u0003\r\u001e\u000bA!\u001e;jY*\t\u0001*\u0001\u0003kCZ\f\u0017B\u0001&D\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\bCA\u0010M\u0013\ti%CA\u0006LC\u001a\\\u0017mQ8oM&<\u0017A\u0002\u001fj]&$h\bF\u0003Q#J\u001bF\u000b\u0005\u0002 \u0001!)\u0001&\u0002a\u0001S!)Q'\u0002a\u0001m!)A(\u0002a\u0001{!)\u0001)\u0002a\u0001\u0003\u0006YQM\\:ve\u0016$v\u000e]5d)\u0015it\u000b\u001a4l\u0011\u0015Af\u00011\u0001Z\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0002[C:\u00111l\u0018\t\u00039ji\u0011!\u0018\u0006\u0003=Z\ta\u0001\u0010:p_Rt\u0014B\u00011\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001T\u0002\"B3\u0007\u0001\u0004i\u0014!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0003h\r\u0001\u0007\u0001.A\tsKBd\u0017nY1uS>tg)Y2u_J\u0004\"!G5\n\u0005)T\"!B*i_J$\b\"\u00027\u0007\u0001\u0004i\u0017a\u0003;pa&\u001c7i\u001c8gS\u001e\u0004\"A\\8\u000e\u0003\u0015K!\u0001]#\u0003\u0015A\u0013x\u000e]3si&,7/A\u0006de\u0016\fG/\u001a+pa&\u001cG#C:\u0002\u0002\u0005\r\u0011QAA\u0004!\r!x/_\u0007\u0002k*\u0011aOG\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001=v\u0005\u00191U\u000f^;sKB\u0011!P`\u0007\u0002w*\u0011A0`\u0001\b[\u0016\u001c8/Y4f\u0015\tac&\u0003\u0002\u0000w\nA2I]3bi\u0016$v\u000e]5dgJ+7\u000f]8og\u0016$\u0015\r^1\t\u000ba;\u0001\u0019A-\t\u000b\u0015<\u0001\u0019A\u001f\t\u000b\u001d<\u0001\u0019\u00015\t\u000b1<\u0001\u0019A7\u0002\u001b1L7\u000f^!mYR{\u0007/[2t)\t\ti\u0001\u0005\u0003o\u0003\u001fI\u0016bAA\t\u000b\n\u00191+\u001a;\u0002'Q|\u0007/[2D_:4\u0017nZ;sCRLwN\\:\u0015\r\u0005]\u0011QJA+!\u001dq\u0017\u0011DA\u000f\u0003[I1!a\u0007F\u0005\ri\u0015\r\u001d\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003U\u0011\u0017mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016T1!a\n\u0015\u0003\u0011!\u0018.\u001a:\n\t\u0005-\u0012\u0011\u0005\u0002\n\u001d\u0006lW-\u00118e\u0013\u0012\u0004b!a\f\u0002:\u0005}b\u0002BA\u0019\u0003kq1\u0001XA\u001a\u0013\u0005Y\u0012bAA\u001c5\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001e\u0003{\u0011A\u0001T5ti*\u0019\u0011q\u0007\u000e\u0011\t\u0005\u0005\u0013q\t\b\u0004u\u0006\r\u0013bAA#w\u0006YB)Z:de&\u0014WmQ8oM&<7OU3ta>t7/\u001a#bi\u0006LA!!\u0013\u0002L\t)B)Z:de&\u0014WmQ8oM&<7OU3tk2$(bAA#w\"9\u0011qJ\u0005A\u0002\u0005E\u0013A\u0002;pa&\u001c7\u000f\u0005\u0003o\u0003'J\u0016bAA\u001e\u000b\"9\u0011qK\u0005A\u0002\u0005E\u0013AC2p]\u001aLwmS3zg\u0006\tR\u000f\u001d3bi\u0016$v\u000e]5d\u0007>tg-[4\u0015\r\u0005u\u00131MA3!\rI\u0012qL\u0005\u0004\u0003CR\"\u0001B+oSRDQ\u0001\u0017\u0006A\u0002eCa!a\u001a\u000b\u0001\u0004i\u0017AB2p]\u001aLw-\u0001\nLe\u00064G/\u00138uKJt\u0017\r\\!e[&t\u0007CA\u0010\r'\ta\u0001\u0004\u0006\u0002\u0002l\u0005y2m\u001c8wKJ$Hk\u001c+pa&\u001c7i\u001c8gS\u001e\u001cu\u000e\u001c7fGRLwN\\:\u0015\t\u0005U\u00141\u0011\t\u0005\u0003o\niHD\u0002{\u0003sJ1!a\u001f|\u0003]\u0019%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002\u0000\u0005\u0005%AH\"sK\u0006$\u0018M\u00197f)>\u0004\u0018nY\"p]\u001aLwmQ8mY\u0016\u001cG/[8o\u0015\r\tYh\u001f\u0005\u0007\u0003Or\u0001\u0019A7\u0002%\r\u0014X-\u0019;f)>\u0004\u0018n\u0019*fcV,7\u000f\u001e\u000b\r\u0003\u0013\u000bi*a(\u0002\"\u0006\r\u0016Q\u0015\t\u0005\u0003\u0017\u000b9J\u0004\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\t*`\u0001\te\u0016\fX/Z:ug&!\u0011QSAH\u0003M\u0019%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u\u0013\u0011\tI*a'\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011QSAH\u0011\u0015Av\u00021\u0001Z\u0011\u0015)w\u00021\u0001>\u0011\u00159w\u00021\u0001i\u0011\u0015aw\u00021\u0001n\u0011\u0015at\u00021\u0001>\u0003M\tG\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u)\u0019\tY+a.\u0002:B!\u0011QVAZ\u001d\u0011\ti)a,\n\t\u0005E\u0016qR\u0001\u001f\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgRLA!!'\u00026*!\u0011\u0011WAH\u0011\u0015A\u0006\u00031\u0001Z\u0011\u0015a\u0007\u00031\u0001n\u0001")
public final class KraftInternalAdmin
implements InternalAdmin,
Logging {
    private final NodeToControllerChannelManager channel;
    private final KRaftImageMetadataCache metadataCache;
    public final int kafka$server$KraftInternalAdmin$$timeoutMs;
    private final Supplier<KafkaConfig> kafkaConfigSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static IncrementalAlterConfigsRequest.Builder alterConfigsRequest(String topicName, Properties topicConfig) {
        return KraftInternalAdmin$.MODULE$.alterConfigsRequest(topicName, topicConfig);
    }

    public static CreateTopicsRequest.Builder createTopicRequest(String topicName, int numPartitions, short replicationFactor, Properties topicConfig, int timeoutMs) {
        return KraftInternalAdmin$.MODULE$.createTopicRequest(topicName, numPartitions, replicationFactor, topicConfig, timeoutMs);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KraftInternalAdmin kraftInternalAdmin = this;
        synchronized (kraftInternalAdmin) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public int ensureTopic(String topicName, int numPartitions, short replicationFactor, Properties topicConfig) {
        Option<Integer> option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.metadataCache.numPartitions(topicName)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Integer numberOfPartitions = (Integer)some.value();
            if (!BoxesRunTime.equalsNumObject(numberOfPartitions, BoxesRunTime.boxToInteger(numPartitions))) {
                this.warn((Function0<String> & Serializable)() -> "Topic " + topicName + " already exists. Mismatch between existing partition count " + numberOfPartitions + " and configured partition count " + numPartitions + ".");
            } else {
                this.info((Function0<String> & Serializable)() -> "Topic " + topicName + " exists with " + numberOfPartitions + " partitions");
            }
            return Predef$.MODULE$.Integer2int(numberOfPartitions);
        }
        if (None$.MODULE$.equals(option)) {
            Errors error;
            CreateTopicsResponseData.CreatableTopicResult response = Await$.MODULE$.result(this.createTopic(topicName, numPartitions, replicationFactor, topicConfig), new package.DurationInt(package$.MODULE$.DurationInt(this.kafka$server$KraftInternalAdmin$$timeoutMs)).millis()).topics().find(topicName);
            Errors errors = error = Errors.forCode(response.errorCode());
            Errors errors2 = Errors.TOPIC_ALREADY_EXISTS;
            if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                return Predef$.MODULE$.Integer2int(this.metadataCache.numPartitions(topicName).orElseGet(() -> {
                    throw Errors.UNKNOWN_TOPIC_OR_PARTITION.exception();
                }));
            }
            error.maybeThrow();
            this.info((Function0<String> & Serializable)() -> "Created topic " + topicName + " with " + numPartitions + " partitions");
            return numPartitions;
        }
        throw new MatchError(option);
    }

    private Future<CreateTopicsResponseData> createTopic(String topicName, int numPartitions, short replicationFactor, Properties topicConfig) {
        Promise promise = Promise$.MODULE$.apply();
        ControllerRequestCompletionHandler completionHandler = new ControllerRequestCompletionHandler(this, promise, topicName){
            private final /* synthetic */ KraftInternalAdmin $outer;
            private final Promise promise$1;
            private final String topicName$2;

            public void onTimeout() {
                this.promise$1.failure(new TimeoutException("Create topics request for " + this.topicName$2 + " timedout after " + this.$outer.kafka$server$KraftInternalAdmin$$timeoutMs + " ms"));
            }

            public void onComplete(ClientResponse response) {
                if (response.authenticationException() != null) {
                    this.promise$1.failure(response.authenticationException());
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.promise$1.failure(response.versionMismatch());
                    return;
                }
                if (response.hasResponse()) {
                    this.promise$1.tryComplete(Try$.MODULE$.apply((Function0<CreateTopicsResponseData> & Serializable)() -> ((CreateTopicsResponse)response.responseBody()).data()));
                    return;
                }
                this.promise$1.failure(new IllegalStateException("Response expected when creating topic for " + this.topicName$2 + " and request header: " + response.requestHeader()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.promise$1 = promise$1;
                this.topicName$2 = topicName$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        };
        this.channel.sendRequest(KraftInternalAdmin$.MODULE$.createTopicRequest(topicName, numPartitions, replicationFactor, topicConfig, this.kafka$server$KraftInternalAdmin$$timeoutMs), completionHandler);
        return promise.future();
    }

    @Override
    public Set<String> listAllTopics() {
        return this.metadataCache.topicNamesToIds().keySet();
    }

    @Override
    public Map<NameAndId, List<DescribeConfigsResponseData.DescribeConfigsResult>> topicConfigurations(java.util.List<String> topics, java.util.List<String> configKeys) {
        HashMap<NameAndId, List<DescribeConfigsResponseData.DescribeConfigsResult>> topicToConfigs = new HashMap<NameAndId, List<DescribeConfigsResponseData.DescribeConfigsResult>>();
        ConfigHelper configHelper = new ConfigHelper(this.metadataCache, this.kafkaConfigSupplier.get(), this.metadataCache, None$.MODULE$, null);
        topics.stream().forEach(topic -> {
            Uuid tpId = $this.metadataCache.getTopicId((String)topic);
            if (!tpId.equals(Uuid.ZERO_UUID)) {
                $colon$colon<Nothing$> configResources = new $colon$colon<Nothing$>((Nothing$)((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName((String)topic).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(configKeys)), Nil$.MODULE$);
                List<DescribeConfigsResponseData.DescribeConfigsResult> configResults = configHelper.describeConfigs(configResources, false, null, false);
                if (tpId.equals($this.metadataCache.getTopicId((String)topic))) {
                    topicToConfigs.put(new NameAndId((String)topic, tpId), configResults);
                    return;
                }
                this.info((Function0<String> & Serializable)() -> "Ignoring topic " + topic + ". It has been deleted or recreated with same name");
                return;
            }
            this.warn((Function0<String> & Serializable)() -> "No topic Id for " + topic);
        });
        return topicToConfigs;
    }

    @Override
    public void updateTopicConfig(String topicName, Properties config) {
        Object object = new Object();
        try {
            Map<NameAndId, List<DescribeConfigsResponseData.DescribeConfigsResult>> configs = this.topicConfigurations(Collections.singletonList(topicName), Collections.emptyList());
            configs.forEach((x$1, results) -> results.foreach((Function1<DescribeConfigsResponseData.DescribeConfigsResult, Object> & Serializable)result -> {
                KraftInternalAdmin.$anonfun$updateTopicConfig$2(this, topicName, object, config, result);
                return BoxedUnit.UNIT;
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$updateTopicConfig$2(KraftInternalAdmin $this, String topicName$3, Object nonLocalReturnKey1$1, Properties config$1, DescribeConfigsResponseData.DescribeConfigsResult result) {
        Errors errors;
        Errors errors2 = errors = Errors.forCode(result.errorCode());
        Errors errors3 = Errors.NONE;
        if (errors2 == null ? errors3 != null : !((Object)((Object)errors2)).equals((Object)errors3)) {
            $this.error((Function0<String> & Serializable)() -> "Error when describe topic config for " + topicName$3 + ", " + errors + ", " + result.errorMessage());
            throw new NonLocalReturnControl$mcV$sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        HashMap prevConfig = new HashMap();
        result.configs().forEach(config -> prevConfig.put(config.name(), config.value()));
        boolean mismatchedConfig = config$1.entrySet().stream().anyMatch(expected -> {
            Object v = prevConfig.get(expected.getKey());
            String string = expected.getValue().toString();
            return v == null ? string != null : !v.equals(string);
        });
        if (mismatchedConfig) {
            Promise promise = Promise$.MODULE$.apply();
            $this.channel.sendRequest(KraftInternalAdmin$.MODULE$.alterConfigsRequest(topicName$3, config$1), new ControllerRequestCompletionHandler($this, promise, topicName$3){
                private final /* synthetic */ KraftInternalAdmin $outer;
                private final Promise promise$2;
                private final String topicName$3;

                public void onTimeout() {
                    this.promise$2.failure(new TimeoutException("Alter topic config request for " + this.topicName$3 + " timeout after " + this.$outer.kafka$server$KraftInternalAdmin$$timeoutMs + " ms"));
                }

                public void onComplete(ClientResponse response) {
                    if (response.authenticationException() != null) {
                        this.promise$2.failure(response.authenticationException());
                        return;
                    }
                    if (response.versionMismatch() != null) {
                        this.promise$2.failure(response.versionMismatch());
                        return;
                    }
                    if (response.hasResponse()) {
                        this.promise$2.tryComplete(Try$.MODULE$.apply((Function0<IncrementalAlterConfigsResponseData> & Serializable)() -> ((IncrementalAlterConfigsResponse)response.responseBody()).data()));
                        return;
                    }
                    this.promise$2.failure(new IllegalStateException("Response expected when altering topic config for " + this.topicName$3));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.promise$2 = promise$2;
                    this.topicName$3 = topicName$3;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$2(org.apache.kafka.clients.ClientResponse )}, serializedLambda);
                }
            });
            IncrementalAlterConfigsResponseData incrementalAlterConfigsResponse = (IncrementalAlterConfigsResponseData)Await$.MODULE$.result(promise.future(), new package.DurationInt(package$.MODULE$.DurationInt($this.kafka$server$KraftInternalAdmin$$timeoutMs)).millis());
            incrementalAlterConfigsResponse.responses().forEach(response -> {
                Errors error = Errors.forCode(response.errorCode());
                error.maybeThrow();
            });
            $this.info((Function0<String> & Serializable)() -> "Successfully updated topic " + topicName$3 + " to config " + config$1);
            return;
        }
        $this.info((Function0<String> & Serializable)() -> "Skipped updating topic config for " + topicName$3 + " as the config values are expected");
    }

    public KraftInternalAdmin(NodeToControllerChannelManager channel, KRaftImageMetadataCache metadataCache, int timeoutMs, Supplier<KafkaConfig> kafkaConfigSupplier) {
        this.channel = channel;
        this.metadataCache = metadataCache;
        this.kafka$server$KraftInternalAdmin$$timeoutMs = timeoutMs;
        this.kafkaConfigSupplier = kafkaConfigSupplier;
        Logging.$init$(this);
    }
}

