/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientSensors;
import kafka.server.ProducerIdQuotaManagerConfig;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.storage.internals.log.ProducerIdQuotaRecorder;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=f\u0001B\r\u001b\u0001}A\u0001b\r\u0001\u0003\u0006\u0004%I\u0001\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001BC\u0002\u0013%!\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003<\u0011!\u0011\u0005A!b\u0001\n\u0013\u0019\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u00111\u0003!Q1A\u0005R5C\u0011\u0002\u0016\u0001\u0003\u0002\u0003\u0006IAT+\t\u0011Y\u0003!Q1A\u0005\n]C\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\tM\u0002\u0011)\u0019!C\u0005O\"Aq\u000f\u0001B\u0001B\u0003%\u0001\u000eC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0003\u0002\u0006!A\u0011Q\u0002\u0001!\u0002\u0013\t9\u0001C\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u00111\b\u0001\u0005B\u0005u\u0002bBA)\u0001\u0011\u0005\u00131\u000b\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002\u001e\u0002!I!a(\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\n1\u0002K]8ek\u000e,'/\u00133Rk>$\u0018-T1oC\u001e,'O\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001\u0005\n\t\u0003C\tj\u0011AG\u0005\u0003Gi\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4feB\u0011Q%M\u0007\u0002M)\u0011q\u0005K\u0001\u0004Y><'BA\u0015+\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002,Y\u000591\u000f^8sC\u001e,'BA\u000f.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005I2#a\u0006)s_\u0012,8-\u001a:JIF+x\u000e^1SK\u000e|'\u000fZ3s\u0003\u0019\u0019wN\u001c4jOV\tQ\u0007\u0005\u0002\"m%\u0011qG\u0007\u0002\u001d!J|G-^2fe&#\u0017+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nAb\u00197jK:$8i\u001c8gS\u001e,\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0003gyR!a\u0007\u0017\n\u0005\u0001k$\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\u0006i1\r\\5f]R\u001cuN\u001c4jO\u0002\nq!\\3ue&\u001c7/F\u0001E!\t)\u0015*D\u0001G\u0015\t\u0011uI\u0003\u0002IY\u000511m\\7n_:L!A\u0013$\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,W#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E;\u0015!B;uS2\u001c\u0018BA*Q\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\n\u00051\u0013\u0013\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y+\u0005A\u0006CA-c\u001d\tQ\u0006\r\u0005\u0002\\=6\tAL\u0003\u0002^=\u00051AH]8pizR\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u000ba\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011MX\u0001\u0012i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004\u0013aE2mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\W#\u00015\u0011\u0007%TG.D\u0001_\u0013\tYgL\u0001\u0004PaRLwN\u001c\t\u0004[>\fX\"\u00018\u000b\u0005%:\u0015B\u00019o\u0005\u0019\u0001F.^4j]B\u0011!/^\u0007\u0002g*\u0011AOP\u0001\u0006cV|G/Y\u0005\u0003mN\u00141c\u00117jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.\fAc\u00197jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0005{wrlhp`A\u0001!\t\t\u0003\u0001C\u00034\u001b\u0001\u0007Q\u0007C\u0003:\u001b\u0001\u00071\bC\u0003C\u001b\u0001\u0007A\tC\u0003M\u001b\u0001\u0007a\nC\u0003W\u001b\u0001\u0007\u0001\fC\u0003g\u001b\u0001\u0007\u0001.A\tuQJ|G\u000f\u001e7f)\"\u0014Xm\u001d5pY\u0012,\"!a\u0002\u0011\u0007%\fI!C\u0002\u0002\fy\u0013a\u0001R8vE2,\u0017A\u0005;ie>$H\u000f\\3UQJ,7\u000f[8mI\u0002\n1CY1dWB\u0014Xm]:ve\u0016,e.\u00192mK\u0012,\"!a\u0005\u0011\u0007%\f)\"C\u0002\u0002\u0018y\u0013qAQ8pY\u0016\fg.\u0001\u000esK\u000e|'\u000fZ!oI\u001e+G\u000f\u00165s_R$H.\u001a+j[\u0016l5\u000f\u0006\u0005\u0002\u001e\u0005\r\u0012QFA\u0019!\rI\u0017qD\u0005\u0004\u0003Cq&aA%oi\"9\u0011QE\tA\u0002\u0005\u001d\u0012!D2mS\u0016tGoU3og>\u00148\u000fE\u0002\"\u0003SI1!a\u000b\u001b\u00055\u0019E.[3oiN+gn]8sg\"9\u0011qF\tA\u0002\u0005\u001d\u0011!\u0002<bYV,\u0007bBA\u001a#\u0001\u0007\u0011QG\u0001\u0007i&lW-T:\u0011\u0007%\f9$C\u0002\u0002:y\u0013A\u0001T8oO\u0006!2\r\\5f]R\u0014\u0016\r^3NKR\u0014\u0018n\u0019(b[\u0016$B!a\u0010\u0002HA!\u0011\u0011IA\"\u001b\u00059\u0015bAA#\u000f\nQQ*\u001a;sS\u000et\u0015-\\3\t\u000f\u0005%#\u00031\u0001\u0002L\u0005y\u0011/^8uC6+GO]5d)\u0006<7\u000fE\u0003Z\u0003\u001bB\u0006,C\u0002\u0002P\u0011\u00141!T1q\u0003Q\u0011XmZ5ti\u0016\u0014\u0018+^8uC6+GO]5dgR!\u0011QKA4)\u0011\t9&!\u0018\u0011\u0007%\fI&C\u0002\u0002\\y\u0013A!\u00168ji\"9\u0011qL\nA\u0002\u0005\u0005\u0014AB:f]N|'\u000fE\u0002F\u0003GJ1!!\u001aG\u0005\u0019\u0019VM\\:pe\"9\u0011\u0011N\nA\u0002\u0005-\u0013AC7fiJL7\rV1hg\u00061R.Y=cK\u001e+G\u000f\u00165s_R$H.\u001a+j[\u0016l5\u000f\u0006\u0004\u0002\u001e\u0005=\u0014q\u0011\u0005\b\u0003c\"\u0002\u0019AA:\u0003\u001d\u0011X-];fgR\u0004B!!\u001e\u0002\u0002:!\u0011qOA?\u001b\t\tIHC\u0002\u0002|q\tqA\\3uo>\u00148.\u0003\u0003\u0002\u0000\u0005e\u0014A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003\u0007\u000b)IA\u0004SKF,Xm\u001d;\u000b\t\u0005}\u0014\u0011\u0010\u0005\b\u0003g!\u0002\u0019AA\u001b\u0003E9W\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u0007\u0003;\ti)a$\t\u000f\u0005\u0015R\u00031\u0001\u0002(!9\u00111G\u000bA\u0002\u0005U\u0012aC7bs\n,'+Z2pe\u0012$\u0002\"a\u0016\u0002\u0016\u0006e\u00151\u0014\u0005\u0007\u0003/3\u0002\u0019\u0001-\u0002\u0013Q|\u0007/[2OC6,\u0007bBA\u0018-\u0001\u0007\u0011q\u0001\u0005\b\u0003g1\u0002\u0019AA\u001b\u0003\u0019\u0011XmY8sIRA\u0011qKAQ\u0003K\u000b9\u000bC\u0004\u0002$^\u0001\r!!\u0019\u0002\u0017E,x\u000e^1TK:\u001cxN\u001d\u0005\b\u0003_9\u0002\u0019AA\u0004\u0011\u001d\t\u0019d\u0006a\u0001\u0003k\tQc\u00197jK:$8i\\;oi6+GO]5d\u001d\u0006lW\r\u0006\u0003\u0002@\u00055\u0006bBA%1\u0001\u0007\u00111\n")
public class ProducerIdQuotaManager
extends ClientQuotaManager
implements ProducerIdQuotaRecorder {
    private final ProducerIdQuotaManagerConfig config;
    private final ClientQuotaManagerConfig clientConfig;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<Plugin<ClientQuotaCallback>> clientQuotaCallback;
    private final double throttleThreshold;

    private ProducerIdQuotaManagerConfig config() {
        return this.config;
    }

    private ClientQuotaManagerConfig clientConfig() {
        return this.clientConfig;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Time time() {
        return super.time();
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<Plugin<ClientQuotaCallback>> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    private double throttleThreshold() {
        return this.throttleThreshold;
    }

    @Override
    public boolean backpressureEnabled() {
        return false;
    }

    @Override
    public int recordAndGetThrottleTimeMs(ClientSensors clientSensors, double value, long timeMs) {
        int throttleTimeMs;
        block0: {
            throttleTimeMs = this.getThrottleTimeMs(clientSensors, timeMs);
            if (throttleTimeMs > 0) break block0;
            this.record(clientSensors.quotaSensor(), value, timeMs);
        }
        return throttleTimeMs;
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("usage-rate", this.quotaType().toString(), "Tracking usage-rate per tenant", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public void registerQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
        super.registerQuotaMetrics(metricTags, sensor);
        sensor.add(this.clientCountMetricName(metricTags), new CumulativeSum(), new MetricConfig());
    }

    public int maybeGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        if (this.quotasEnabled()) {
            Session session = request.session();
            String clientId = request.header().clientId();
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return this.getThrottleTimeMs(clientSensors, timeMs);
        }
        return 0;
    }

    private int getThrottleTimeMs(ClientSensors clientSensors, long timeMs) {
        int n;
        Sensor quotaSensor = clientSensors.quotaSensor();
        try {
            KafkaMetric countMetric = this.metrics().metrics().get(this.clientCountMetricName(clientSensors.metricTags()));
            if (countMetric != null && countMetric.measurableValue(timeMs) > this.throttleThreshold()) {
                quotaSensor.checkQuotas(timeMs);
            }
            n = 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)this.throttleTime(e, this.quotaMaxThrottleTimeMs());
            this.debug((Function0<String> & Serializable)() -> "Quota violated for sensor (" + quotaSensor.name() + "). Delay time: (" + throttleTimeMs + ")");
            n = throttleTimeMs;
        }
        return n;
    }

    @Override
    public void maybeRecord(String topicName, double value, long timeMs) {
        if (this.quotasEnabled()) {
            Map<String, String> metricTags = CollectionConverters$.MODULE$.MapHasAsScala(this.quotaCallback().quotaMetricTagsFromTopic(this.clientQuotaType(), topicName)).asScala().toMap($less$colon$less$.MODULE$.refl());
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(metricTags, this.getOrCreateQuotaSensors$default$2(), this.getOrCreateQuotaSensors$default$3());
            this.record(clientSensors.quotaSensor(), value, timeMs);
            return;
        }
    }

    private void record(Sensor quotaSensor, double value, long timeMs) {
        quotaSensor.record(value, timeMs, false);
    }

    private MetricName clientCountMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("count", this.quotaType().toString(), "Tracking total count per tenant/user", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    public ProducerIdQuotaManager(ProducerIdQuotaManagerConfig config, ClientQuotaManagerConfig clientConfig, Metrics metrics, Time time, String threadNamePrefix, Option<Plugin<ClientQuotaCallback>> clientQuotaCallback) {
        this.config = config;
        this.clientConfig = clientConfig;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(clientConfig, metrics, QuotaType.PRODUCER_ID, time, threadNamePrefix, clientQuotaCallback, ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        this.throttleThreshold = (double)config.cacheLimit() * ((double)config.cachePerTenantPercent() / 100.0);
    }
}

