/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.ReplicationQuotaManagerConfig;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.server.quota.SensorAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationQuotaManager
extends ReplicaQuota
implements DiskUsageBasedThrottleListener {
    public static final List<Integer> ALL_REPLICAS = List.of(Integer.valueOf(-1));
    public static final List<Integer> NO_REPLICAS = List.of(Integer.valueOf(-2));
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationQuotaManager.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentHashMap<String, List<Integer>> throttledPartitions = new ConcurrentHashMap();
    private final ReplicationQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType quotaType;
    private final Time time;
    private final SensorAccess sensorAccess;
    protected final MetricName rateMetricName;
    private Quota quota;
    private final AtomicBoolean allReplicasThrottled;
    private final AtomicReference<Optional<Long>> lastSignalledQuotaOptRef = new AtomicReference(Optional.empty());

    public ReplicationQuotaManager(ReplicationQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.quotaType = quotaType;
        this.allReplicasThrottled = new AtomicBoolean(config.allReplicasThrottled);
        this.time = time;
        this.sensorAccess = new SensorAccess(this.lock, metrics);
        this.rateMetricName = metrics.metricName("byte-rate", quotaType.toString(), "Tracking byte-rate for " + String.valueOf((Object)quotaType));
        this.updateQuota(Quota.upperBound(config.quotaBytesPerSecondDefault));
    }

    public void updateQuota(Quota quota) {
        LOGGER.debug("updateQuota requested for {} from {} to {}", new Object[]{this.quotaType, this.quota, quota});
        if (this.hasDiskThrottling() && this.lastSignalledQuotaOptRef().get().isPresent()) {
            LOGGER.info("Can't update replication throttle since disk throttling is currently active!");
            return;
        }
        this.doUpdateQuota(quota);
    }

    public void doUpdateQuota(Quota quota) {
        this.lock.writeLock().lock();
        try {
            this.quota = quota;
            KafkaMetric metric = this.metrics.metrics().get(this.rateMetricName);
            if (metric != null) {
                metric.config(this.getQuotaMetricConfig(quota));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isQuotaExceeded() {
        try {
            this.sensor().checkQuotas();
            return false;
        }
        catch (QuotaViolationException qve) {
            LOGGER.trace("{}: Quota violated for sensor ({}), metric: ({}), metric-value: ({}), bound: ({})", new Object[]{this.quotaType, this.sensor().name(), qve.metric().metricName(), qve.value(), qve.bound()});
            return true;
        }
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        List<Integer> partitions = this.throttledPartitions.get(topicPartition.topic());
        if (partitions == null || partitions.isEmpty()) {
            return this.allReplicasThrottled.get();
        }
        return partitions.equals(ALL_REPLICAS) || partitions.contains(topicPartition.partition());
    }

    @Override
    public void record(long value) {
        this.sensor().record(value, this.time.milliseconds(), false);
    }

    public void markThrottled(String topic, List<Integer> partitions) {
        this.throttledPartitions.put(topic, partitions);
    }

    public void markBrokerThrottled() {
        this.allReplicasThrottled.set(true);
    }

    public void removeThrottle(String topic) {
        this.throttledPartitions.remove(topic);
    }

    public void removeBrokerThrottle(boolean resetThrottle) {
        boolean throttleEnabled = false;
        if (resetThrottle) {
            throttleEnabled = this.config.allReplicasThrottled;
        }
        this.allReplicasThrottled.set(throttleEnabled);
    }

    public long upperBound() {
        this.lock.readLock().lock();
        try {
            long l = this.quota != null ? (long)this.quota.bound() : Long.MAX_VALUE;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow(this.config.quotaWindowSizeSeconds, TimeUnit.SECONDS).samples(this.config.numQuotaSamples).quota(quota);
    }

    private Sensor sensor() {
        return this.sensorAccess.getOrCreate(this.quotaType.toString(), 3600L, sensor -> sensor.add(this.rateMetricName, new SimpleRate(), this.getQuotaMetricConfig(this.quota)));
    }

    @Override
    public QuotaType quotaType() {
        return this.quotaType;
    }

    @Override
    public void handleDiskSpaceLow(long cappedQuotaInBytesPerSec) {
        if (this.hasDiskThrottling()) {
            LOGGER.info("Updating {} quota (due to low disk) to: {}", (Object)this.quotaType, (Object)cappedQuotaInBytesPerSec);
            this.doUpdateQuota(Quota.upperBound(cappedQuotaInBytesPerSec));
            this.markBrokerThrottled();
        }
    }

    @Override
    public void handleDiskSpaceRecovered() {
        if (this.hasDiskThrottling()) {
            long resetQuota = this.config.quotaBytesPerSecondDefault;
            LOGGER.info("Resetting {} quota (due to low disk) to: {}", (Object)this.quotaType, (Object)resetQuota);
            this.doUpdateQuota(Quota.upperBound(resetQuota));
            this.removeBrokerThrottle(true);
        }
    }

    @Override
    public AtomicReference<Optional<Long>> lastSignalledQuotaOptRef() {
        return this.lastSignalledQuotaOptRef;
    }

    private boolean hasDiskThrottling() {
        return this.quotaType == QuotaType.FOLLOWER_REPLICATION || this.quotaType == QuotaType.CLUSTER_LINK_REPLICATION;
    }

    public double getBrokerQuotaLimit() {
        return this.quota.bound();
    }

    public ReplicationQuotaManagerConfig config() {
        return this.config;
    }
}

