/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper$;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.quota.ThrottleCallback;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t5s!B\u000f\u001f\u0011\u0003\u0019c!B\u0013\u001f\u0011\u00031\u0003\"B\u001a\u0002\t\u0003!\u0004\"B\u001b\u0002\t\u00031\u0004\"B)\u0002\t\u0003\u0011\u0006\"B.\u0002\t\u0003a\u0006\"B1\u0002\t\u0003\u0011\u0007\"\u00029\u0002\t\u0003\t\bbBA\u0006\u0003\u0011%\u0011Q\u0002\u0004\u0006Ky\u0001\u0011\u0011\u0007\u0005\u000b\u0003gI!\u0011!Q\u0001\n\u0005U\u0002BCA\u001e\u0013\t\u0005\t\u0015!\u0003\u0002>!Q\u00111K\u0005\u0003\u0002\u0003\u0006I!!\u0016\t\rMJA\u0011AA0\u0011\u001d\tI'\u0003C\u0001\u0003WBq!!\u001b\n\t\u0003\t\u0019\tC\u0004\u0002\u001e&!\t!a(\t\u000f\u00055\u0016\u0002\"\u0001\u00020\"9\u00111X\u0005\u0005\u0002\u0005u\u0006bBAf\u0013\u0011\u0005\u0011Q\u001a\u0005\b\u0003'LA\u0011AAk\u0011\u001d\t\u0019/\u0003C\u0001\u0003KDq!a;\n\t\u0003\ti\u000fC\u0004\u0002r&!\t!a=\t\u000f\t\r\u0011\u0002\"\u0001\u0003\u0006!I!\u0011E\u0005\u0012\u0002\u0013\u0005!1\u0005\u0005\b\u0005sIA\u0011\u0002B\u001e\u0011\u001d\u0011\t%\u0003C\u0001\u0005\u0007BqAa\u0012\n\t\u0003\u0011I%\u0001\u000bSKF,Xm\u001d;IC:$G.\u001a:IK2\u0004XM\u001d\u0006\u0003?\u0001\naa]3sm\u0016\u0014(\"A\u0011\u0002\u000b-\fgm[1\u0004\u0001A\u0011A%A\u0007\u0002=\t!\"+Z9vKN$\b*\u00198eY\u0016\u0014\b*\u001a7qKJ\u001c2!A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011a&M\u0007\u0002_)\u0011\u0001\u0007I\u0001\u0006kRLGn]\u0005\u0003e=\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002G\u00059\"o\\;uS:<\u0007+\u0019;i!J,g-\u001b=Pe:+H\u000e\u001c\u000b\u0003o\t\u0003\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e*\u001b\u0005Y$B\u0001\u001f#\u0003\u0019a$o\\8u}%\u0011a(K\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?S!)1i\u0001a\u0001\t\u000691m\u001c8uKb$\bCA#P\u001b\u00051%BA$I\u0003!\u0011X-];fgR\u001c(BA%K\u0003\u0019\u0019w.\\7p]*\u0011\u0011e\u0013\u0006\u0003\u00196\u000ba!\u00199bG\",'\"\u0001(\u0002\u0007=\u0014x-\u0003\u0002Q\r\nq!+Z9vKN$8i\u001c8uKb$\u0018A\u000b<bY&$\u0017\r^3BYR,'O\u0011:pW\u0016\u0014(+\u001a9mS\u000e\fW\t_2mkNLwN\u001c*fcV,7\u000f\u001e\u000b\u0003'Z\u0003\"\u0001\u000b+\n\u0005UK#\u0001B+oSRDQa\u0016\u0003A\u0002a\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002F3&\u0011!L\u0012\u0002$\u00032$XM\u001d\"s_.,'OU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8t%\u0016\fX/Z:u\u0003q1\u0018\r\\5eCR,'+Z7pm\u0016\u0014%o\\6feN\u0014V-];fgR$\"aU/\t\u000b]+\u0001\u0019\u00010\u0011\u0005\u0015{\u0016B\u00011G\u0005Q\u0011V-\\8wK\n\u0013xn[3sgJ+\u0017/^3ti\u0006\u00014m\u001c8wKJ$XI^3o\u00072,8\u000f^3s\u0019>\fG\r\u00157b]&sG/\u001a:oC2$vNU3ta>t7/\u001a#bi\u0006$\"aY5\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019D\u0015aB7fgN\fw-Z\u0005\u0003Q\u0016\u0014aeQ8naV$X-\u0012<f]\u000ecWo\u001d;fe2{\u0017\r\u001a)mC:\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u0015Qg\u00011\u0001l\u0003\u0011\u0001H.\u00198\u0011\u00051tW\"A7\u000b\u0005%\u0003\u0013BA8n\u0005m)e/\u001a8DYV\u001cH/\u001a:M_\u0006$\u0007\u000b\\1o\u0013:$XM\u001d8bY\u0006\tS.Y=cKB{\u0007/\u001e7bi\u0016\u0014%o\\6fej{g.Z:J]\u000e{g\u000e^3yiR\u00191K]?\t\u000b];\u0001\u0019A:\u0011\u0005QThBA;y\u001b\u00051(BA<!\u0003\u001dqW\r^<pe.L!!\u001f<\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u00111\u0010 \u0002\b%\u0016\fX/Z:u\u0015\tIh\u000fC\u0003\u007f\u000f\u0001\u0007q0A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001&\u0002\u00115,G/\u00193bi\u0006LA!!\u0003\u0002\u0004\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\f!eY8om\u0016\u0014H\u000f\u00157b]\u001e{\u0017\r\\*uCR\u001cHk\u001c*fgB|gn]3ECR\fG\u0003BA\b\u0003_\u0001b!!\u0005\u0002\u001c\u0005\u0005b\u0002BA\n\u0003/q1AOA\u000b\u0013\u0005Q\u0013bAA\rS\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u000f\u0003?\u0011A\u0001T5ti*\u0019\u0011\u0011D\u0015\u0011\t\u0005\r\u0012\u0011\u0006\b\u0004I\u0006\u0015\u0012bAA\u0014K\u000613i\\7qkR,WI^3o\u00072,8\u000f^3s\u0019>\fG\r\u00157b]J+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005-\u0012Q\u0006\u0002\t\u000f>\fGn\u0015;bi*\u0019\u0011qE3\t\u000b)D\u0001\u0019A6\u0014\u0007%9S&\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0011\u0007U\f9$C\u0002\u0002:Y\u0014aBU3rk\u0016\u001cHo\u00115b]:,G.\u0001\u0004rk>$\u0018m\u001d\t\u0005\u0003\u007f\tiE\u0004\u0003\u0002B\u0005%c\u0002BA\"\u0003\u000fr1AOA#\u0013\u0005\t\u0013BA\u0010!\u0013\r\tYEH\u0001\r#V|G/\u0019$bGR|'/_\u0005\u0005\u0003\u001f\n\tFA\u0007Rk>$\u0018-T1oC\u001e,'o\u001d\u0006\u0004\u0003\u0017r\u0012\u0001\u0002;j[\u0016\u0004B!a\u0016\u0002\\5\u0011\u0011\u0011\f\u0006\u0003a!KA!!\u0018\u0002Z\t!A+[7f)!\t\t'a\u0019\u0002f\u0005\u001d\u0004C\u0001\u0013\n\u0011\u001d\t\u0019$\u0004a\u0001\u0003kAq!a\u000f\u000e\u0001\u0004\ti\u0004C\u0004\u0002T5\u0001\r!!\u0016\u0002\u0011QD'o\u001c;uY\u0016$raUA7\u0003o\nI\bC\u0004\u0002p9\u0001\r!!\u001d\u0002\u0019E,x\u000e^1NC:\fw-\u001a:\u0011\u0007\u0011\n\u0019(C\u0002\u0002vy\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\")qK\u0004a\u0001g\"9\u00111\u0010\bA\u0002\u0005u\u0014A\u0004;ie>$H\u000f\\3US6,Wj\u001d\t\u0004Q\u0005}\u0014bAAAS\t\u0019\u0011J\u001c;\u0015\u0013M\u000b))a\"\u0002\n\u0006-\u0005bBA8\u001f\u0001\u0007\u0011\u0011\u000f\u0005\u0006/>\u0001\ra\u001d\u0005\b\u0003wz\u0001\u0019AA?\u0011\u001d\tii\u0004a\u0001\u0003\u001f\u000b\u0001bY1mY\n\f7m\u001b\t\u0005\u0003#\u000bI*\u0004\u0002\u0002\u0014*!\u0011QSAL\u0003\u0015\tXo\u001c;b\u0015\ty\"*\u0003\u0003\u0002\u001c\u0006M%\u0001\u0005+ie>$H\u000f\\3DC2d'-Y2l\u0003-A\u0017M\u001c3mK\u0016\u0013(o\u001c:\u0015\u000bM\u000b\t+a)\t\u000b]\u0003\u0002\u0019A:\t\u000f\u0005\u0015\u0006\u00031\u0001\u0002(\u0006\tQ\r\u0005\u0003\u0002\u0012\u0005%\u0016\u0002BAV\u0003?\u0011\u0011\u0002\u00165s_^\f'\r\\3\u00025M,g\u000eZ#se>\u0014xJ]\"m_N,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u000fM\u000b\t,a-\u00028\")q+\u0005a\u0001g\"9\u0011QW\tA\u0002\u0005\u001d\u0016!B3se>\u0014\bbBA]#\u0001\u0007\u0011QP\u0001\u000bi\"\u0014x\u000e\u001e;mK6\u001b\u0018!F:f]\u00124uN]<be\u0012,GMU3ta>t7/\u001a\u000b\u0006'\u0006}\u0016\u0011\u0019\u0005\u0006/J\u0001\ra\u001d\u0005\b\u0003\u0007\u0014\u0002\u0019AAc\u0003!\u0011Xm\u001d9p]N,\u0007cA#\u0002H&\u0019\u0011\u0011\u001a$\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0017!E:f]\u0012l\u0015-\u001f2f)\"\u0014x\u000e\u001e;mKR)1+a4\u0002R\")qk\u0005a\u0001g\"9\u00111Y\nA\u0002\u0005\u0015\u0017!G:f]\u0012\u0014Vm\u001d9p]N,W*Y=cKRC'o\u001c;uY\u0016$RaUAl\u00033DQa\u0016\u000bA\u0002MDq!a7\u0015\u0001\u0004\ti.\u0001\bde\u0016\fG/\u001a*fgB|gn]3\u0011\u000f!\ny.! \u0002F&\u0019\u0011\u0011]\u0015\u0003\u0013\u0019+hn\u0019;j_:\f\u0014AH:f]\u0012,%O]8s%\u0016\u001c\bo\u001c8tK6\u000b\u0017PY3UQJ|G\u000f\u001e7f)\u0015\u0019\u0016q]Au\u0011\u00159V\u00031\u0001t\u0011\u001d\t),\u0006a\u0001\u0003O\u000bq$\\1zE\u0016\u0014VmY8sI\u0006sGmR3u)\"\u0014x\u000e\u001e;mKRKW.Z't)\u0011\ti(a<\t\u000b]3\u0002\u0019A:\u0002YM,g\u000e\u001a*fgB|gn]3NCf\u0014W\r\u00165s_R$H.Z,ji\"\u001cuN\u001c;s_2dWM])v_R\fGcB*\u0002v\u0006}(\u0011\u0001\u0005\b\u0003o<\u0002\u0019AA}\u0003]\u0019wN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\rE\u0002%\u0003wL1!!@\u001f\u0005]\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\rC\u0003X/\u0001\u00071\u000fC\u0004\u0002D^\u0001\r!!2\u00025M,g\u000e\u001a*fgB|gn]3Fq\u0016l\u0007\u000f\u001e+ie>$H\u000f\\3\u0015\u000fM\u00139A!\u0003\u0003\f!)q\u000b\u0007a\u0001g\"9\u00111\u0019\rA\u0002\u0005\u0015\u0007\"\u0003B\u00071A\u0005\t\u0019\u0001B\b\u0003)ygnQ8na2,G/\u001a\t\u0006Q\tE!QC\u0005\u0004\u0005'I#AB(qi&|g\u000e\u0005\u0004)\u0003?\u00149b\u0015\t\u0005\u00053\u0011i\"\u0004\u0002\u0003\u001c)\u0011q\u000fS\u0005\u0005\u0005?\u0011YB\u0001\u0003TK:$\u0017\u0001J:f]\u0012\u0014Vm\u001d9p]N,W\t_3naR$\u0006N]8ui2,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0015\"\u0006\u0002B\b\u0005OY#A!\u000b\u0011\t\t-\"QG\u0007\u0003\u0005[QAAa\f\u00032\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005gI\u0013AC1o]>$\u0018\r^5p]&!!q\u0007B\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001 g\u0016tG-\u0012:s_J\u0014Vm\u001d9p]N,W\t_3naR$\u0006N]8ui2,G#B*\u0003>\t}\u0002\"B,\u001b\u0001\u0004\u0019\bbBA[5\u0001\u0007\u0011qU\u0001\u001fg\u0016tGMT8PaJ+7\u000f]8og\u0016,\u00050Z7qiRC'o\u001c;uY\u0016$2a\u0015B#\u0011\u001596\u00041\u0001t\u0003q\u0019Gn\\:f\u0007>tg.Z2uS>tgi\u001c:To&$8\r[8wKJ$2a\u0015B&\u0011\u00159F\u00041\u0001t\u0001")
public class RequestHandlerHelper
implements Logging {
    public final RequestChannel kafka$server$RequestHandlerHelper$$requestChannel;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void maybePopulateBrokerZonesInContext(RequestChannel.Request request, MetadataCache metadataCache) {
        RequestHandlerHelper$.MODULE$.maybePopulateBrokerZonesInContext(request, metadataCache);
    }

    public static ComputeEvenClusterLoadPlanResponseData convertEvenClusterLoadPlanInternalToResponseData(EvenClusterLoadPlanInternal plan) {
        return RequestHandlerHelper$.MODULE$.convertEvenClusterLoadPlanInternalToResponseData(plan);
    }

    public static void validateRemoveBrokersRequest(RemoveBrokersRequest request) {
        RequestHandlerHelper$.MODULE$.validateRemoveBrokersRequest(request);
    }

    public static void validateAlterBrokerReplicaExclusionRequest(AlterBrokerReplicaExclusionsRequest request) {
        RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(request);
    }

    public static String routingPathPrefixOrNull(RequestContext context) {
        return RequestHandlerHelper$.MODULE$.routingPathPrefixOrNull(context);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        RequestHandlerHelper requestHandlerHelper = this;
        synchronized (requestHandlerHelper) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void throttle(ClientQuotaManager quotaManager, RequestChannel.Request request, int throttleTimeMs) {
        ThrottleCallback callback = new ThrottleCallback(this, request){
            private final /* synthetic */ RequestHandlerHelper $outer;
            private final RequestChannel.Request request$2;

            public void startThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.startThrottling(this.request$2);
            }

            public void endThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.endThrottling(this.request$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$2 = request$2;
            }
        };
        quotaManager.throttle(request, callback, throttleTimeMs);
    }

    public void throttle(ClientQuotaManager quotaManager, RequestChannel.Request request, int throttleTimeMs, ThrottleCallback callback) {
        quotaManager.throttle(request, callback, throttleTimeMs);
    }

    public void handleError(RequestChannel.Request request, Throwable e) {
        boolean mayThrottle;
        boolean bl = mayThrottle = e instanceof ClusterAuthorizationException || !request.header().apiKey().clusterAction;
        if (mayThrottle) {
            this.sendErrorResponseMaybeThrottle(request, e);
            return;
        }
        this.sendErrorResponseExemptThrottle(request, e);
    }

    public void sendErrorOrCloseConnection(RequestChannel.Request request, Throwable error, int throttleMs) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        AbstractResponse response = ((AbstractRequest)requestBody).getErrorResponse(throttleMs, error);
        if (response == null) {
            this.kafka$server$RequestHandlerHelper$$requestChannel.closeConnection(request, ((AbstractRequest)requestBody).errorCounts(error));
            return;
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, None$.MODULE$);
    }

    public void sendForwardedResponse(RequestChannel.Request request, AbstractResponse response) {
        int controllerThrottleTimeMs = response.throttleTimeMs();
        int requestThrottleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        int appliedThrottleTimeMs = package$.MODULE$.max(controllerThrottleTimeMs, requestThrottleTimeMs);
        this.throttle(this.quotas.request(), request, appliedThrottleTimeMs);
        response.maybeSetThrottleTimeMs(appliedThrottleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, None$.MODULE$);
    }

    public void sendMaybeThrottle(RequestChannel.Request request, AbstractResponse response) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        response.maybeSetThrottleTimeMs(throttleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, None$.MODULE$);
    }

    public void sendResponseMaybeThrottle(RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, createResponse.apply(BoxesRunTime.boxToInteger(throttleTimeMs)), None$.MODULE$);
    }

    public void sendErrorResponseMaybeThrottle(RequestChannel.Request request, Throwable error) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (error instanceof ClusterAuthorizationException || !request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.sendErrorOrCloseConnection(request, error, throttleTimeMs);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        int throttleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, this.time.milliseconds());
        request.apiThrottleTimeMs_$eq(throttleTimeMs);
        return throttleTimeMs;
    }

    public void sendResponseMaybeThrottleWithControllerQuota(ControllerMutationQuota controllerMutationQuota, RequestChannel.Request request, AbstractResponse response) {
        int requestThrottleTimeMs;
        long timeMs = this.time.milliseconds();
        int controllerThrottleTimeMs = controllerMutationQuota.throttleTime();
        int maxThrottleTimeMs = Math.max(controllerThrottleTimeMs, requestThrottleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, timeMs));
        if (maxThrottleTimeMs > 0 && !request.isForwarded()) {
            request.apiThrottleTimeMs_$eq(maxThrottleTimeMs);
            if (controllerThrottleTimeMs > requestThrottleTimeMs) {
                this.throttle(this.quotas.controllerMutation(), request, controllerThrottleTimeMs);
            } else {
                this.throttle(this.quotas.request(), request, requestThrottleTimeMs);
            }
        }
        response.maybeSetThrottleTimeMs(maxThrottleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, None$.MODULE$);
    }

    public void sendResponseExemptThrottle(RequestChannel.Request request, AbstractResponse response, Option<Function1<Send, BoxedUnit>> onComplete) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, onComplete);
    }

    public Option<Function1<Send, BoxedUnit>> sendResponseExemptThrottle$default$3() {
        return None$.MODULE$;
    }

    private void sendErrorResponseExemptThrottle(RequestChannel.Request request, Throwable error) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendErrorOrCloseConnection(request, error, 0);
    }

    public void sendNoOpResponseExemptThrottle(RequestChannel.Request request) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendNoOpResponse(request);
    }

    public void closeConnectionForSwitchover(RequestChannel.Request request) {
        this.kafka$server$RequestHandlerHelper$$requestChannel.closeConnectionForSwitchover(request);
    }

    public RequestHandlerHelper(RequestChannel requestChannel, QuotaFactory.QuotaManagers quotas, Time time) {
        this.kafka$server$RequestHandlerHelper$$requestChannel = requestChannel;
        this.quotas = quotas;
        this.time = time;
        Logging.$init$(this);
    }
}

