/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import kafka.server.AllRequests$;
import kafka.server.IoThread$;
import kafka.server.NetworkThread$;
import kafka.server.NonExemptRequest$;
import kafka.server.RequestType;
import kafka.server.ThreadType;
import kafka.server.ThreadUsageMetrics$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import scala.Function1;
import scala.Option$;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\u000b\u0016\u0001iA\u0001\"\t\u0001\u0003\u0006\u0004%IA\t\u0005\t_\u0001\u0011\t\u0011)A\u0005G!)\u0001\u0007\u0001C\u0001c!9Q\u0007\u0001b\u0001\n\u00131\u0004B\u0002\u001e\u0001A\u0003%q\u0007C\u0004<\u0001\t\u0007I\u0011\u0002\u001c\t\rq\u0002\u0001\u0015!\u00038\u0011\u001di\u0004A1A\u0005\nyBa\u0001\u0016\u0001!\u0002\u0013y\u0004bB+\u0001\u0005\u0004%IA\u0010\u0005\u0007-\u0002\u0001\u000b\u0011B \t\u000b]\u0003A\u0011\u0001-\t\u000b-\u0004A\u0011\u00017\t\u000bI\u0004A\u0011A:\t\u000bU\u0004A\u0011\u0001<\t\u000ba\u0004A\u0011A=\t\u000bi\u0004A\u0011B>\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011q\u0003\u0001\u0005\n\u0005e!A\u0005+ie\u0016\fG-V:bO\u0016\u001cVM\\:peNT!AF\f\u0002\rM,'O^3s\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017aB7fiJL7m]\u000b\u0002GA\u0011A%L\u0007\u0002K)\u0011\u0011E\n\u0006\u0003O!\naaY8n[>t'B\u0001\r*\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\n\u00059*#aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u00051A(\u001b8jiz\"\"A\r\u001b\u0011\u0005M\u0002Q\"A\u000b\t\u000b\u0005\u001a\u0001\u0019A\u0012\u00029%|G\u000b\u001b:fC\u0012tuN\\#yK6\u0004H/V:bO\u0016\u001cVM\\:peV\tq\u0007\u0005\u0002%q%\u0011\u0011(\n\u0002\u0007'\u0016t7o\u001c:\u0002;%|G\u000b\u001b:fC\u0012tuN\\#yK6\u0004H/V:bO\u0016\u001cVM\\:pe\u0002\n\u0001$[8UQJ,\u0017\r\u001a+pi\u0006dWk]1hKN+gn]8s\u0003eIw\u000e\u00165sK\u0006$Gk\u001c;bYV\u001b\u0018mZ3TK:\u001cxN\u001d\u0011\u0002E9,Go^8sWRC'/Z1e\u001d>tW\t_3naR,6/Y4f'\u0016t7o\u001c:t+\u0005y\u0004\u0003\u0002!H\u0013^j\u0011!\u0011\u0006\u0003\u0005\u000e\u000b!bY8oGV\u0014(/\u001a8u\u0015\t!U)\u0001\u0003vi&d'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u0006\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tQ\u0015K\u0004\u0002L\u001fB\u0011A*H\u0007\u0002\u001b*\u0011a*G\u0001\u0007yI|w\u000e\u001e \n\u0005Ak\u0012A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001U\u000f\u0002G9,Go^8sWRC'/Z1e\u001d>tW\t_3naR,6/Y4f'\u0016t7o\u001c:tA\u0005qb.\u001a;x_J\\G\u000b\u001b:fC\u0012$v\u000e^1m+N\fw-Z*f]N|'o]\u0001 ]\u0016$xo\u001c:l)\"\u0014X-\u00193U_R\fG.V:bO\u0016\u001cVM\\:peN\u0004\u0013a\u0005:fG>\u0014H-S8UQJ,\u0017\rZ+tC\u001e,G\u0003B-]C\u001a\u0004\"\u0001\b.\n\u0005mk\"\u0001B+oSRDQ!\u0018\u0007A\u0002y\u000bQA^1mk\u0016\u0004\"\u0001H0\n\u0005\u0001l\"A\u0002#pk\ndW\rC\u0003c\u0019\u0001\u00071-\u0001\u0004uS6,Wj\u001d\t\u00039\u0011L!!Z\u000f\u0003\t1{gn\u001a\u0005\u0006O2\u0001\r\u0001[\u0001\fe\u0016\fX/Z:u)f\u0004X\r\u0005\u00024S&\u0011!.\u0006\u0002\f%\u0016\fX/Z:u)f\u0004X-\u0001\rsK\u000e|'\u000f\u001a(fi^|'o\u001b+ie\u0016\fG-V:bO\u0016$R!W7o_FDQ!X\u0007A\u0002yCQAY\u0007A\u0002\rDQ\u0001]\u0007A\u0002%\u000bA\u0002\\5ti\u0016tWM\u001d(b[\u0016DQaZ\u0007A\u0002!\f!#\u00193e\u0019&\u001cH/\u001a8fe6+GO]5dgR\u0011\u0011\f\u001e\u0005\u0006a:\u0001\r!S\u0001\u0016e\u0016lwN^3MSN$XM\\3s\u001b\u0016$(/[2t)\tIv\u000fC\u0003q\u001f\u0001\u0007\u0011*A\u0003dY>\u001cX\rF\u0001Z\u0003U!\bN]3bIV\u001b\u0018mZ3TK:\u001cxN\u001d(b[\u0016$b!\u0013?\u0002\u0004\u00055\u0001\"B?\u0012\u0001\u0004q\u0018A\u0003;ie\u0016\fG\rV=qKB\u00111g`\u0005\u0004\u0003\u0003)\"A\u0003+ie\u0016\fG\rV=qK\"9\u0011QA\tA\u0002\u0005\u001d\u0011AC7fiJL7\rV1hgB)!*!\u0003J\u0013&\u0019\u00111B*\u0003\u00075\u000b\u0007\u000fC\u0003h#\u0001\u0007\u0001.\u0001\u0010de\u0016\fG/\u001a(fi^|'o\u001b+ie\u0016\fG-V:bO\u0016\u001cVM\\:peR)q'a\u0005\u0002\u0016!)\u0001O\u0005a\u0001\u0013\")qM\u0005a\u0001Q\u0006I2M]3bi\u0016Lu\u000e\u00165sK\u0006$Wk]1hKN+gn]8s)\r9\u00141\u0004\u0005\u0006ON\u0001\r\u0001\u001b")
public class ThreadUsageSensors {
    private final Metrics metrics;
    private final Sensor ioThreadNonExemptUsageSensor;
    private final Sensor ioThreadTotalUsageSensor;
    private final ConcurrentHashMap<String, Sensor> networkThreadNonExemptUsageSensors;
    private final ConcurrentHashMap<String, Sensor> networkThreadTotalUsageSensors;

    private Metrics metrics() {
        return this.metrics;
    }

    private Sensor ioThreadNonExemptUsageSensor() {
        return this.ioThreadNonExemptUsageSensor;
    }

    private Sensor ioThreadTotalUsageSensor() {
        return this.ioThreadTotalUsageSensor;
    }

    private ConcurrentHashMap<String, Sensor> networkThreadNonExemptUsageSensors() {
        return this.networkThreadNonExemptUsageSensors;
    }

    private ConcurrentHashMap<String, Sensor> networkThreadTotalUsageSensors() {
        return this.networkThreadTotalUsageSensors;
    }

    public void recordIoThreadUsage(double value, long timeMs, RequestType requestType) {
        this.ioThreadTotalUsageSensor().record(value, timeMs, false);
        RequestType requestType2 = requestType;
        if (NonExemptRequest$.MODULE$.equals(requestType2)) {
            this.ioThreadNonExemptUsageSensor().record(value, timeMs, false);
            return;
        }
    }

    public void recordNetworkThreadUsage(double value, long timeMs, String listenerName, RequestType requestType) {
        Option$.MODULE$.apply(this.networkThreadTotalUsageSensors().get(listenerName)).foreach((Function1<Sensor, Object> & Serializable)x$1 -> {
            x$1.record(value, timeMs, false);
            return BoxedUnit.UNIT;
        });
        RequestType requestType2 = requestType;
        if (NonExemptRequest$.MODULE$.equals(requestType2)) {
            Option$.MODULE$.apply(this.networkThreadNonExemptUsageSensors().get(listenerName)).foreach((Function1<Sensor, Object> & Serializable)x$2 -> {
                x$2.record(value, timeMs, false);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void addListenerMetrics(String listenerName) {
        ThreadUsageSensors threadUsageSensors = this;
        synchronized (threadUsageSensors) {
            this.networkThreadNonExemptUsageSensors().computeIfAbsent(listenerName, x$3 -> this.createNetworkThreadUsageSensor(listenerName, NonExemptRequest$.MODULE$));
            this.networkThreadTotalUsageSensors().computeIfAbsent(listenerName, x$4 -> this.createNetworkThreadUsageSensor(listenerName, AllRequests$.MODULE$));
        }
    }

    public void removeListenerMetrics(String listenerName) {
        ThreadUsageSensors threadUsageSensors = this;
        synchronized (threadUsageSensors) {
            Option$.MODULE$.apply(this.networkThreadNonExemptUsageSensors().get(listenerName)).foreach((Function1<Sensor, Object> & Serializable)sensor -> {
                ThreadUsageSensors.$anonfun$removeListenerMetrics$1(this, sensor);
                return BoxedUnit.UNIT;
            });
            this.networkThreadNonExemptUsageSensors().remove(listenerName);
            Option$.MODULE$.apply(this.networkThreadTotalUsageSensors().get(listenerName)).foreach((Function1<Sensor, Object> & Serializable)sensor -> {
                ThreadUsageSensors.$anonfun$removeListenerMetrics$2(this, sensor);
                return BoxedUnit.UNIT;
            });
            this.networkThreadTotalUsageSensors().remove(listenerName);
        }
    }

    public void close() {
        this.metrics().removeSensor(this.ioThreadTotalUsageSensor().name());
        this.metrics().removeSensor(this.ioThreadNonExemptUsageSensor().name());
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.networkThreadNonExemptUsageSensors().values()).asScala().foreach((Function1<Sensor, Object> & Serializable)sensor -> {
            ThreadUsageSensors.$anonfun$close$1(this, sensor);
            return BoxedUnit.UNIT;
        });
        this.networkThreadNonExemptUsageSensors().clear();
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.networkThreadTotalUsageSensors().values()).asScala().foreach((Function1<Sensor, Object> & Serializable)sensor -> {
            ThreadUsageSensors.$anonfun$close$2(this, sensor);
            return BoxedUnit.UNIT;
        });
        this.networkThreadTotalUsageSensors().clear();
    }

    private String threadUsageSensorName(ThreadType threadType, Map<String, String> metricTags, RequestType requestType) {
        String suffix = metricTags.isEmpty() ? "" : "-" + metricTags.values().mkString(":");
        String prefix = requestType.name();
        return prefix + "-" + threadType.name() + "-thread-usage-" + suffix;
    }

    private Sensor createNetworkThreadUsageSensor(String listenerName, RequestType requestType) {
        Map<String, String> metricTags = ThreadUsageMetrics$.MODULE$.listenerNetworkThreadUsageMetricTags(listenerName);
        String sensorName = this.threadUsageSensorName(NetworkThread$.MODULE$, metricTags, requestType);
        Sensor sensor = this.metrics().sensor(sensorName);
        sensor.add(ThreadUsageMetrics$.MODULE$.threadUsageMetricName(this.metrics(), NetworkThread$.MODULE$, metricTags, requestType), new Rate());
        return sensor;
    }

    private Sensor createIoThreadUsageSensor(RequestType requestType) {
        Map<String, String> metricTags = ThreadUsageMetrics$.MODULE$.ioThreadUsageMetricTags();
        String sensorName = this.threadUsageSensorName(IoThread$.MODULE$, metricTags, requestType);
        Sensor sensor = this.metrics().sensor(sensorName);
        sensor.add(ThreadUsageMetrics$.MODULE$.threadUsageMetricName(this.metrics(), IoThread$.MODULE$, metricTags, requestType), new Rate());
        return sensor;
    }

    public static final /* synthetic */ void $anonfun$removeListenerMetrics$1(ThreadUsageSensors $this, Sensor sensor) {
        $this.metrics().removeSensor(sensor.name());
    }

    public static final /* synthetic */ void $anonfun$removeListenerMetrics$2(ThreadUsageSensors $this, Sensor sensor) {
        $this.metrics().removeSensor(sensor.name());
    }

    public static final /* synthetic */ void $anonfun$close$1(ThreadUsageSensors $this, Sensor sensor) {
        $this.metrics().removeSensor(sensor.name());
    }

    public static final /* synthetic */ void $anonfun$close$2(ThreadUsageSensors $this, Sensor sensor) {
        $this.metrics().removeSensor(sensor.name());
    }

    public ThreadUsageSensors(Metrics metrics) {
        this.metrics = metrics;
        this.ioThreadNonExemptUsageSensor = this.createIoThreadUsageSensor(NonExemptRequest$.MODULE$);
        this.ioThreadTotalUsageSensor = this.createIoThreadUsageSensor(AllRequests$.MODULE$);
        this.networkThreadNonExemptUsageSensors = new ConcurrentHashMap();
        this.networkThreadTotalUsageSensors = new ConcurrentHashMap();
    }
}

