/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001B\t\u0013\u0001eA\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00039\u0011!a\u0004A!A!\u0002\u0013i\u0004\"\u0002!\u0001\t\u0003\t\u0005b\u0002$\u0001\u0005\u0004%Ia\u0012\u0005\u0007)\u0002\u0001\u000b\u0011\u0002%\t\u000fU\u0003!\u0019!C\u0005-\"1!\f\u0001Q\u0001\n]CQa\u0017\u0001\u0005BqCQ\u0001\u001b\u0001\u0005B%Dq!a\u0004\u0001\t\u0003\n\t\u0002C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<!9\u0011\u0011\b\u0001\u0005\n\u0005\u0005#AH\"mkN$XM\u001d'j].\u001cun\u001c:eS:\fGo\u001c:MSN$XM\\3s\u0015\t\u0019B#\u0001\u0003mS:\\'BA\u000b\u0017\u0003\u0019\u0019XM\u001d<fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Q\"E\u000b\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tA\u0001\\1oO*\tq$\u0001\u0003kCZ\f\u0017BA\u0011\u001d\u0005\u0019y%M[3diB\u00111e\n\b\u0003I\u0015j\u0011AE\u0005\u0003MI\t!c\u00117vgR,'\u000fT5oW\u001a\u000b7\r^8ss&\u0011\u0001&\u000b\u0002\u0018\u0019&t7nQ8pe\u0012Lg.\u0019;pe2K7\u000f^3oKJT!A\n\n\u0011\u0005-rS\"\u0001\u0017\u000b\u000552\u0012!B;uS2\u001c\u0018BA\u0018-\u0005\u001daunZ4j]\u001e\f1\u0002\\5oW6\u000bg.Y4feV\t!\u0007\u0005\u0002%g%\u0011AG\u0005\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T1oC\u001e,'/\u0001\u0007mS:\\W*\u00198bO\u0016\u0014\b%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\u0005A\u0004C\u0001\u0013:\u0013\tQ$C\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005I1o\u00195fIVdWM\u001d\t\u0003IyJ!a\u0010\n\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0003\u0019a\u0014N\\5u}Q!!i\u0011#F!\t!\u0003\u0001C\u00031\r\u0001\u0007!\u0007C\u00037\r\u0001\u0007\u0001\bC\u0003=\r\u0001\u0007Q(\u0001\nle\u00064G/T3uC\u0012\fG/Y\"bG\",W#\u0001%\u0011\u0007%ce*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u0019y\u0005\u000f^5p]B\u0011qJU\u0007\u0002!*\u0011\u0011\u000bF\u0001\t[\u0016$\u0018\rZ1uC&\u00111\u000b\u0015\u0002\u0013\u0017J\u000bg\r^'fi\u0006$\u0017\r^1DC\u000eDW-A\nle\u00064G/T3uC\u0012\fG/Y\"bG\",\u0007%A\biCN\\%+\u00194u'V\u0004\bo\u001c:u+\u00059\u0006CA%Y\u0013\tI&JA\u0004C_>dW-\u00198\u0002!!\f7o\u0013*bMR\u001cV\u000f\u001d9peR\u0004\u0013\u0001\u00028b[\u0016$\u0012!\u0018\t\u0003=\u0016t!aX2\u0011\u0005\u0001TU\"A1\u000b\u0005\tD\u0012A\u0002\u001fs_>$h(\u0003\u0002e\u0015\u00061\u0001K]3eK\u001aL!AZ4\u0003\rM#(/\u001b8h\u0015\t!'*\u0001\tp]6+G/\u00193bi\u0006,\u0006\u000fZ1uKR!!.\u001c>\u0000!\tI5.\u0003\u0002m\u0015\n!QK\\5u\u0011\u0015qG\u00021\u0001p\u00035iW\r^1eCR\fG)\u001a7uCB\u0011\u0001\u000f_\u0007\u0002c*\u0011!o]\u0001\u0006S6\fw-\u001a\u0006\u0003/QT!!\u001e<\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0018aA8sO&\u0011\u00110\u001d\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u0012+G\u000e^1\t\u000bmd\u0001\u0019\u0001?\u0002!9,w/T3uC\u0012\fG/Y%nC\u001e,\u0007C\u00019~\u0013\tq\u0018OA\u0007NKR\fG-\u0019;b\u00136\fw-\u001a\u0005\b\u0003\u0003a\u0001\u0019AA\u0002\u0003!i\u0017M\\5gKN$\b\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0011/\u0001\u0004m_\u0006$WM]\u0005\u0005\u0003\u001b\t9A\u0001\bM_\u0006$WM]'b]&4Wm\u001d;\u0002A=t7\t\\;ti\u0016\u0014H*\u001b8l\u0007>|'\u000fZ5oCR|'/\u00127fGRLwN\u001c\u000b\u0004U\u0006M\u0001bBA\u000b\u001b\u0001\u0007\u0011qC\u0001\u0006Y&t7n\u001d\t\u0006=\u0006e\u0011QD\u0005\u0004\u000379'aA*fiB\u0019A%a\b\n\u0007\u0005\u0005\"CA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0003\rzgn\u00117vgR,'\u000fT5oW\u000e{wN\u001d3j]\u0006$xN\u001d*fg&<g.\u0019;j_:$2A[A\u0014\u0011\u001d\tIC\u0004a\u0001\u0003W\t\u0011\u0002\\5oW&#7+\u001a;\u0011\u000by\u000bI\"!\f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\rt\u0003\u0019\u0019w.\\7p]&!\u0011qGA\u0019\u0005\u0011)V/\u001b3\u0002?\rDWmY6NSJ\u0014xN]*uCR,\u0017I\u001c3Fq\u0016\u001cW\u000f^3UCN\\7\u000fF\u0002k\u0003{Aa!a\u0010\u0010\u0001\u0004y\u0017!\u00023fYR\fGc\u00016\u0002D!11\u0003\u0005a\u0001\u0003;\u0001")
public class ClusterLinkCoordinatorListener
implements ClusterLinkFactory.LinkCoordinatorListener,
Logging {
    private final ClusterLinkManager linkManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkScheduler scheduler;
    private final Option<KRaftMetadataCache> kraftMetadataCache;
    private final boolean hasKRaftSupport;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkCoordinatorListener clusterLinkCoordinatorListener = this;
        synchronized (clusterLinkCoordinatorListener) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager linkManager() {
        return this.linkManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Option<KRaftMetadataCache> kraftMetadataCache() {
        return this.kraftMetadataCache;
    }

    private boolean hasKRaftSupport() {
        return this.hasKRaftSupport;
    }

    @Override
    public String name() {
        return "ClusterLinkCoordinatorListener";
    }

    @Override
    public void onMetadataUpdate(MetadataDelta metadataDelta, MetadataImage newMetadataImage, LoaderManifest manifest) {
        this.scheduler.scheduleOnce("scheduleChangesForDeltaByClusterLinkLeaders", () -> this.checkMirrorStateAndExecuteTasks(metadataDelta));
    }

    @Override
    public void onClusterLinkCoordinatorElection(Set<ClusterLinkData> links) {
        this.debug((Function0<String> & Serializable)() -> "link coordinator elected for links: " + links.map((Function1<ClusterLinkData, String> & Serializable)x$1 -> x$1.linkName()));
        links.foreach((Function1<ClusterLinkData, Object> & Serializable)cld -> {
            Object object;
            block4: {
                try {
                    if (cld.isDeleted()) {
                        if (!this.hasKRaftSupport()) {
                            this.linkManager().processClusterLinkChanges(cld.linkId(), new Properties(), this.linkManager().processClusterLinkChanges$default$3());
                            object = BoxedUnit.UNIT;
                            break block4;
                        }
                        this.error((Function0<String> & Serializable)() -> "Found link " + cld.linkName() + " marked for deletion in KRaft mode");
                        throw new IllegalStateException("Found link " + cld.linkName() + " marked for deletion in KRaft mode");
                    }
                    this.checkMirrorStateAndExecuteTasks((ClusterLinkData)cld);
                    this.linkManager().connectionManager(cld.linkId()).foreach((Function1<ClusterLinkFactory.ConnectionManager, Object> & Serializable)x$2 -> {
                        x$2.onLinkMetadataPartitionLeaderChange();
                        return BoxedUnit.UNIT;
                    });
                    object = this.linkManager().maybeMigrateBootstrapOverride((ClusterLinkData)cld);
                }
                catch (Throwable ex) {
                    this.error((Function0<String> & Serializable)() -> "Unable to process link coordinator change for link " + cld.linkName(), (Function0<Throwable> & Serializable)() -> ex);
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
    }

    @Override
    public void onClusterLinkCoordinatorResignation(Set<Uuid> linkIdSet) {
        this.debug((Function0<String> & Serializable)() -> "link coordinator resigned for links: " + linkIdSet);
        linkIdSet.foreach((Function1<Uuid, Object> & Serializable)linkId -> {
            ClusterLinkCoordinatorListener.$anonfun$onClusterLinkCoordinatorResignation$2(this, linkId);
            return BoxedUnit.UNIT;
        });
    }

    private void checkMirrorStateAndExecuteTasks(MetadataDelta delta) {
        if (delta.topicsDelta() != null && !delta.topicsDelta().changedTopics().isEmpty()) {
            delta.topicsDelta().changedTopics().values().forEach(changedTopic -> {
                if (changedTopic.mirrorTopicDelta().changed()) {
                    changedTopic.latestMirrorTopicState().ifPresent(newState -> this.linkManager().processMirrorStateChange(changedTopic.name(), ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)newState), OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(changedTopic.image().mirrorTopic())).map((Function1<MirrorTopic, ClusterLinkTopicState> & Serializable)mirrorTopic -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorTopic))));
                    return;
                }
            });
            return;
        }
    }

    private void checkMirrorStateAndExecuteTasks(ClusterLinkData link) {
        this.metadataManager().mirrorTopicStatesFromMetadataCache(link.linkId()).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            ClusterLinkCoordinatorListener.$anonfun$checkMirrorStateAndExecuteTasks$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$onClusterLinkCoordinatorResignation$6(Uuid linkId$1, ClusterLinkFactory.ClientManager x$4) {
        x$4.taskManager().onLinkCoordinatorResignation(linkId$1);
    }

    public static final /* synthetic */ void $anonfun$onClusterLinkCoordinatorResignation$2(ClusterLinkCoordinatorListener $this, Uuid linkId) {
        try {
            $this.linkManager().connectionManager(linkId).foreach((Function1<ClusterLinkFactory.ConnectionManager, Object> & Serializable)x$3 -> {
                x$3.onLinkMetadataPartitionLeaderChange();
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable ex) {
            $this.error((Function0<String> & Serializable)() -> "Connection manager unable to process link coordinator change for link " + linkId, (Function0<Throwable> & Serializable)() -> ex);
        }
        try {
            $this.linkManager().clientManager(linkId).foreach((Function1<ClusterLinkFactory.ClientManager, Object> & Serializable)x$4 -> {
                ClusterLinkCoordinatorListener.$anonfun$onClusterLinkCoordinatorResignation$6(linkId, x$4);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable ex) {
            $this.error((Function0<String> & Serializable)() -> "Task manager unable to process link coordinator change for link " + linkId, (Function0<Throwable> & Serializable)() -> ex);
        }
    }

    public static final /* synthetic */ void $anonfun$checkMirrorStateAndExecuteTasks$4(ClusterLinkCoordinatorListener $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String topic = (String)tuple2._1();
            ClusterLinkTopicState state = (ClusterLinkTopicState)tuple2._2();
            $this.linkManager().processMirrorStateChange(topic, state, None$.MODULE$);
            return;
        }
        throw new MatchError(tuple2);
    }

    public ClusterLinkCoordinatorListener(ClusterLinkManager linkManager, ClusterLinkMetadataManager metadataManager, ClusterLinkScheduler scheduler) {
        Option option;
        this.linkManager = linkManager;
        this.metadataManager = metadataManager;
        this.scheduler = scheduler;
        Logging.$init$(this);
        MetadataCache metadataCache = metadataManager.metadataCache();
        if (metadataCache instanceof KRaftMetadataCache) {
            KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)metadataCache;
            option = new Some<KRaftMetadataCache>(kRaftMetadataCache);
        } else {
            option = None$.MODULE$;
        }
        this.kraftMetadataCache = option;
        this.hasKRaftSupport = this.kraftMetadataCache().nonEmpty();
    }
}

