/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkClientType;
import kafka.server.link.ClusterLinkSelectorMetrics;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\u0005\u000b\u0001EA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\t;\u0001\u0011\t\u0011)A\u0005=!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u00032\u0001\u0011\u0005!\u0007C\u00049\u0001\t\u0007I\u0011B\u001d\t\rA\u0003\u0001\u0015!\u0003;\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\u0011!e\u00117vgR,'\u000fT5oWN+G.Z2u_JlU\r\u001e:jGN\u0014VmZ5tiJL(BA\u0006\r\u0003\u0011a\u0017N\\6\u000b\u00055q\u0011AB:feZ,'OC\u0001\u0010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u00031\u0011'o\\6fe\u000e{gNZ5h!\tQ2$D\u0001\r\u0013\taBBA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB7fiJL7m\u001d\t\u0003?!j\u0011\u0001\t\u0006\u0003;\u0005R!AI\u0012\u0002\r\r|W.\\8o\u0015\tyAE\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<\u0017BA\u0015!\u0005\u001diU\r\u001e:jGN\fA\u0001^5nKB\u0011AfL\u0007\u0002[)\u0011a&I\u0001\u0006kRLGn]\u0005\u0003a5\u0012A\u0001V5nK\u00061A(\u001b8jiz\"BaM\u001b7oA\u0011A\u0007A\u0007\u0002\u0015!)\u0001\u0004\u0002a\u00013!)Q\u0004\u0002a\u0001=!)!\u0006\u0002a\u0001W\u0005A!/Z4jgR\u0014\u00180F\u0001;!\u0011Y\u0004IQ'\u000e\u0003qR!!\u0010 \u0002\u000f5,H/\u00192mK*\u0011q\bF\u0001\u000bG>dG.Z2uS>t\u0017BA!=\u0005\ri\u0015\r\u001d\t\u0003\u0007*s!\u0001\u0012%\u0011\u0005\u0015#R\"\u0001$\u000b\u0005\u001d\u0003\u0012A\u0002\u001fs_>$h(\u0003\u0002J)\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tIE\u0003\u0005\u00025\u001d&\u0011qJ\u0003\u0002\u001b\u00072,8\u000f^3s\u0019&t7nU3mK\u000e$xN]'fiJL7m]\u0001\ne\u0016<\u0017n\u001d;ss\u0002\n!dZ3u\u001fJ\u001c%/Z1uKN+G.Z2u_JlU\r\u001e:jGN$ra\u00154l\u0003\u0007\t9\u0001\u0005\u0002UG:\u0011Q\u000b\u0019\b\u0003-zs!aV/\u000f\u0005acfBA-\\\u001d\t)%,C\u0001(\u0013\t)c%\u0003\u0002\u0010I%\u0011!eI\u0005\u0003?\u0006\nqA\\3uo>\u00148.\u0003\u0002bE\u0006A1+\u001a7fGR|'O\u0003\u0002`C%\u0011A-\u001a\u0002\u0010'\u0016dWm\u0019;pe6+GO]5dg*\u0011\u0011M\u0019\u0005\u0006O\u001e\u0001\r\u0001[\u0001\u000bG2LWM\u001c;UsB,\u0007C\u0001\u001bj\u0013\tQ'BA\u000bDYV\u001cH/\u001a:MS:\\7\t\\5f]R$\u0016\u0010]3\t\u000b1<\u0001\u0019A7\u0002\u00175\f\u0007\u0010T8h\u0019\u00164X\r\u001c\t\u0004]^LX\"A8\u000b\u0005A\f\u0018AB1u_6L7M\u0003\u0002sg\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Q,\u0018\u0001B;uS2T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002y_\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006)QM^3oi*\u0011aPJ\u0001\u0006g24GG[\u0005\u0004\u0003\u0003Y(!\u0002'fm\u0016d\u0007BBA\u0003\u000f\u0001\u0007!)A\bnKR\u0014\u0018nY$saB\u0013XMZ5y\u0011\u001d\tIa\u0002a\u0001\u0003\u0017\t!\"\\3ue&\u001cG+Y4t!\u0019\ti!a\u0004C\u00056\t1/\u0003\u0002Bg\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002\u0016A\u00191#a\u0006\n\u0007\u0005eAC\u0001\u0003V]&$\b")
public class ClusterLinkSelectorMetricsRegistry {
    private final KafkaConfig brokerConfig;
    private final Metrics metrics;
    private final Time time;
    private final scala.collection.mutable.Map<String, ClusterLinkSelectorMetrics> registry;

    private scala.collection.mutable.Map<String, ClusterLinkSelectorMetrics> registry() {
        return this.registry;
    }

    public Selector.SelectorMetrics getOrCreateSelectorMetrics(ClusterLinkClientType clientType, AtomicReference<Level> maxLogLevel, String metricGrpPrefix, Map<String, String> metricTags) {
        Selector.SelectorMetrics selectorMetrics;
        if (!Predef$.MODULE$.Boolean2boolean(this.brokerConfig.clusterLinkEnableMetricsReduction())) {
            return null;
        }
        scala.collection.mutable.Map<String, ClusterLinkSelectorMetrics> map = this.registry();
        synchronized (map) {
            Selector.SelectorMetrics selectorMetrics2;
            HashMap<String, String> reducedMetricTags = new HashMap<String, String>();
            reducedMetricTags.put("broker-id", String.valueOf(this.brokerConfig.brokerId()));
            String selectorMetricsKey = Selector.SelectorMetrics.buildTagSuffix(clientType.name(), reducedMetricTags);
            if (this.registry().contains(selectorMetricsKey)) {
                selectorMetrics2 = (Selector.SelectorMetrics)this.registry().apply(selectorMetricsKey);
            } else {
                LogContext logContext = new LogContext("[ClusterLinkNetworkClient brokerId=" + this.brokerConfig.brokerId() + " ]", maxLogLevel);
                ClusterLinkSelectorMetrics selectorMetrics3 = new ClusterLinkSelectorMetrics(this.metrics, this.time, metricGrpPrefix, reducedMetricTags, logContext);
                this.registry().put(selectorMetricsKey, selectorMetrics3);
                selectorMetrics2 = selectorMetrics3;
            }
            selectorMetrics = selectorMetrics2;
        }
        return selectorMetrics;
    }

    public void shutdown() {
        scala.collection.mutable.Map<String, ClusterLinkSelectorMetrics> map = this.registry();
        synchronized (map) {
            this.registry().values().foreach((Function1<ClusterLinkSelectorMetrics, Object> & Serializable)s -> {
                ClusterLinkSelectorMetricsRegistry.$anonfun$shutdown$1(s);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$shutdown$1(ClusterLinkSelectorMetrics s) {
        Utils.closeQuietly(() -> s.shutdown(), "ClusterLink selectorMetrics");
    }

    public ClusterLinkSelectorMetricsRegistry(KafkaConfig brokerConfig, Metrics metrics, Time time) {
        this.brokerConfig = brokerConfig;
        this.metrics = metrics;
        this.time = time;
        this.registry = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    }
}

