/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u000b\u0017\u0001uA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u001dY\u0006\u00011A\u0005\nqCq\u0001\u0019\u0001A\u0002\u0013%\u0011\r\u0003\u0004e\u0001\u0001\u0006K!\u0018\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u0011\u001dY\u0007\u00011A\u0005\n1DaA\u001c\u0001!B\u0013\u0001\u0006b\u00029\u0001\u0001\u0004%I!\u001d\u0005\bk\u0002\u0001\r\u0011\"\u0003w\u0011\u0019A\b\u0001)Q\u0005e\")\u0011\u0010\u0001C\u0001u\")Q\u0010\u0001C\u00019\")a\u0010\u0001C\u0001\u007f\"1\u0011\u0011\u0001\u0001\u0005\u0002}Da!a\u0001\u0001\t\u0003y\bBBA\u0003\u0001\u0011\u0005qP\u0001\u0007MCjL(+Z:pkJ\u001cWM\u0003\u0002\u00181\u0005!A.\u001b8l\u0015\tI\"$\u0001\u0004tKJ4XM\u001d\u0006\u00027\u0005)1.\u00194lC\u000e\u0001QC\u0001\u00102'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!R\u0012!B;uS2\u001c\u0018B\u0001\u0016(\u0005\u001daunZ4j]\u001e\fac\u0019:fCR,'+Z:pkJ\u001cW-\u00138ti\u0006t7-\u001a\t\u0004A5z\u0013B\u0001\u0018\"\u0005%1UO\\2uS>t\u0007\u0007\u0005\u00021c1\u0001A!\u0002\u001a\u0001\u0005\u0004\u0019$!\u0001+\u0012\u0005Q:\u0004C\u0001\u00116\u0013\t1\u0014EA\u0004O_RD\u0017N\\4\u0011\u0005\u0001B\u0014BA\u001d\"\u0005\r\te._\u0001\u0016G2|7/\u001a*fg>,(oY3J]N$\u0018M\\2f!\u0011\u0001Ch\f \n\u0005u\n#!\u0003$v]\u000e$\u0018n\u001c82!\t\u0001s(\u0003\u0002AC\t!QK\\5u\u0003\u0011!\u0018.\\3\u0011\u0005\rcU\"\u0001#\u000b\u0005!*%B\u0001$H\u0003\u0019\u0019w.\\7p]*\u00111\u0004\u0013\u0006\u0003\u0013*\u000ba!\u00199bG\",'\"A&\u0002\u0007=\u0014x-\u0003\u0002N\t\n!A+[7f\u0003%i\u0017\r_%eY\u0016l5\u000fE\u0002![A\u0003\"\u0001I)\n\u0005I\u000b#\u0001\u0002'p]\u001e\fa\u0001P5oSRtD#B+X1fS\u0006c\u0001,\u0001_5\ta\u0003C\u0003,\u000b\u0001\u0007A\u0006C\u0003;\u000b\u0001\u00071\bC\u0003B\u000b\u0001\u0007!\tC\u0003O\u000b\u0001\u0007q*\u0001\u0007dkJ\u0014XM\u001c;WC2,X-F\u0001^!\r\u0001clL\u0005\u0003?\u0006\u0012aa\u00149uS>t\u0017\u0001E2veJ,g\u000e\u001e,bYV,w\fJ3r)\tq$\rC\u0004d\u000f\u0005\u0005\t\u0019A/\u0002\u0007a$\u0013'A\u0007dkJ\u0014XM\u001c;WC2,X\r\t\u0015\u0003\u0011\u0019\u0004\"\u0001I4\n\u0005!\f#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0017%$G.Z*uCJ$Xj]\u000b\u0002!\u0006y\u0011\u000e\u001a7f'R\f'\u000f^'t?\u0012*\u0017\u000f\u0006\u0002?[\"91MCA\u0001\u0002\u0004\u0001\u0016\u0001D5eY\u0016\u001cF/\u0019:u\u001bN\u0004\u0003FA\u0006g\u0003!I7/Q2uSZ,W#\u0001:\u0011\u0005\u0001\u001a\u0018B\u0001;\"\u0005\u001d\u0011un\u001c7fC:\fA\"[:BGRLg/Z0%KF$\"AP<\t\u000f\rl\u0011\u0011!a\u0001e\u0006I\u0011n]!di&4X\rI\u0001\fO\u0016$xJ]\"sK\u0006$X\r\u0006\u00020w\")Ap\u0004a\u0001e\u0006i\u0011-\u001e;p'R\f'\u000f^%eY\u0016\fQA^1mk\u0016\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002}\u0005i1\r\\8tKJ+7o\\;sG\u0016\f\u0011c\u00197pg\u0016LE\r\\3SKN|WO]2f\u0003%\u0019H/\u0019:u\u0013\u0012dW\r")
public class LazyResource<T>
implements Logging {
    private final Function0<T> createResourceInstance;
    private final Function1<T, BoxedUnit> closeResourceInstance;
    private final Time time;
    private final Function0<Object> maxIdleMs;
    private volatile Option<T> currentValue;
    private volatile long idleStartMs;
    private boolean isActive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LazyResource lazyResource = this;
        synchronized (lazyResource) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Option<T> currentValue() {
        return this.currentValue;
    }

    private void currentValue_$eq(Option<T> x$1) {
        this.currentValue = x$1;
    }

    private long idleStartMs() {
        return this.idleStartMs;
    }

    private void idleStartMs_$eq(long x$1) {
        this.idleStartMs = x$1;
    }

    private boolean isActive() {
        return this.isActive;
    }

    private void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    public synchronized T getOrCreate(boolean autoStartIdle) {
        if (!this.isActive()) {
            throw new IllegalStateException("This instance is no longer active, no more resources can be created");
        }
        if (autoStartIdle) {
            this.idleStartMs_$eq(this.time.milliseconds());
        } else {
            this.idleStartMs_$eq(Long.MAX_VALUE);
        }
        Option<T> option = this.currentValue();
        if (option instanceof Some) {
            Some some = (Some)option;
            Object resource = some.value();
            return (T)resource;
        }
        if (None$.MODULE$.equals(option)) {
            Object t;
            try {
                t = this.createResourceInstance.apply();
            }
            catch (Throwable t2) {
                this.error((Function0<String> & Serializable)() -> "Failed to create resource", (Function0<Throwable> & Serializable)() -> t2);
                throw t2;
            }
            Object resource = t;
            this.currentValue_$eq(new Some<T>(resource));
            this.debug((Function0<String> & Serializable)() -> "Created new resource " + resource);
            return resource;
        }
        throw new MatchError(option);
    }

    public Option<T> value() {
        return this.currentValue();
    }

    public synchronized void shutdown() {
        this.closeResource();
        this.isActive_$eq(false);
    }

    public synchronized void closeResource() {
        this.idleStartMs_$eq(Long.MAX_VALUE);
        this.currentValue().foreach((Function1<Object, Object> & Serializable)value -> {
            LazyResource.$anonfun$closeResource$1(this, value);
            return BoxedUnit.UNIT;
        });
        this.currentValue_$eq(None$.MODULE$);
    }

    public void closeIdleResource() {
        if (this.idleStartMs() != Long.MAX_VALUE && this.time.milliseconds() - this.idleStartMs() > this.maxIdleMs.apply$mcJ$sp()) {
            this.closeResource();
            return;
        }
    }

    public void startIdle() {
        if (this.idleStartMs() == Long.MAX_VALUE) {
            Option<T> option = this.currentValue();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object value = some.value();
                this.debug((Function0<String> & Serializable)() -> "Starting idle time for resource " + value);
                this.idleStartMs_$eq(this.time.milliseconds());
                return;
            }
            if (None$.MODULE$.equals(option)) {
                return;
            }
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$closeResource$1(LazyResource $this, Object value) {
        $this.debug((Function0<String> & Serializable)() -> "Shutting down resource " + value);
        CoreUtils$.MODULE$.swallow(() -> $this.closeResourceInstance.apply(value), $this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public LazyResource(Function0<T> createResourceInstance, Function1<T, BoxedUnit> closeResourceInstance, Time time, Function0<Object> maxIdleMs) {
        this.createResourceInstance = createResourceInstance;
        this.closeResourceInstance = closeResourceInstance;
        this.time = time;
        this.maxIdleMs = maxIdleMs;
        Logging.$init$(this);
        this.currentValue = None$.MODULE$;
        this.idleStartMs = Long.MAX_VALUE;
        this.isActive = true;
    }
}

