/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.ClusterLink;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f!B\u000f\u001f\u0003\u0003)\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u000be\u0002A\u0011\u0001\u001e\t\u000fy\u0002!\u0019!C\t\u007f!1q\n\u0001Q\u0001\n\u0001Cq\u0001\u0015\u0001C\u0002\u0013E\u0011\u000b\u0003\u0004Y\u0001\u0001\u0006IA\u0015\u0005\b3\u0002\u0011\r\u0011\"\u0005[\u0011\u0019\u0019\u0007\u0001)A\u00057\"9A\r\u0001a\u0001\n#)\u0007bB5\u0001\u0001\u0004%\tB\u001b\u0005\u0007a\u0002\u0001\u000b\u0015\u00024\t\u000bE\u0004a\u0011\u0003:\t\u000bM\u0004a\u0011\u0001;\t\u000bU\u0004a\u0011\u0001<\t\u000bm\u0004a\u0011\u0001?\t\u000f\u0005\u0015\u0001A\"\u0001\u0002\b!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA)\u0001\u0011E\u00111\u000b\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Ba!!\u0019\u0001\t\u0003!\bbBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kBq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002\u0014\u0002!\t!!\u001e\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u00111\u0014\u0001\u0005\u0012\u0005u%A\u0006'j].\u001cun\u001c:eS:\fGo\u001c:NC:\fw-\u001a:\u000b\u0005}\u0001\u0013\u0001\u00027j].T!!\t\u0012\u0002\rM,'O^3s\u0015\u0005\u0019\u0013!B6bM.\f7\u0001A\n\u0004\u0001\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002.a5\taF\u0003\u00020E\u0005)Q\u000f^5mg&\u0011\u0011G\f\u0002\b\u0019><w-\u001b8h\u00035iW\r^1eCR\f7)Y2iKB\u0011AgN\u0007\u0002k)\u0011a\u0007I\u0001\t[\u0016$\u0018\rZ1uC&\u0011\u0001(\u000e\u0002\u0018\u0017J\u000bg\r^%nC\u001e,W*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\u0001P5oSRtDCA\u001e>!\ta\u0004!D\u0001\u001f\u0011\u0015\u0011$\u00011\u00014\u0003YiW\r^1eCR\f\u0017*\\1hK2K7\u000f^3oKJ\u001cX#\u0001!\u0011\u0007\u00053\u0005*D\u0001C\u0015\t\u0019E)A\u0004nkR\f'\r\\3\u000b\u0005\u0015C\u0013AC2pY2,7\r^5p]&\u0011qI\u0011\u0002\u0007\u0005V4g-\u001a:\u0011\u0005%ceB\u0001\u001fK\u0013\tYe$\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL\u0018BA'O\u0005]a\u0015N\\6D_>\u0014H-\u001b8bi>\u0014H*[:uK:,'O\u0003\u0002L=\u00059R.\u001a;bI\u0006$\u0018-S7bO\u0016d\u0015n\u001d;f]\u0016\u00148\u000fI\u0001\u0010_^tW\r\u001a)beRLG/[8ogV\t!\u000bE\u0002B'VK!\u0001\u0016\"\u0003\u0007M+G\u000f\u0005\u0002(-&\u0011q\u000b\u000b\u0002\u0004\u0013:$\u0018\u0001E8x]\u0016$\u0007+\u0019:uSRLwN\\:!\u0003\u0011awnY6\u0016\u0003m\u0003\"\u0001X1\u000e\u0003uS!AX0\u0002\t1\fgn\u001a\u0006\u0002A\u0006!!.\u0019<b\u0013\t\u0011WL\u0001\u0004PE*,7\r^\u0001\u0006Y>\u001c7\u000eI\u0001\fS:LG/[1mSj,G-F\u0001g!\t9s-\u0003\u0002iQ\t9!i\\8mK\u0006t\u0017aD5oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\u0005-t\u0007CA\u0014m\u0013\ti\u0007F\u0001\u0003V]&$\bbB8\u000b\u0003\u0003\u0005\rAZ\u0001\u0004q\u0012\n\u0014\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013\u0001G4fi:+X.T3uC\u0012\fG/\u0019)beRLG/[8ogV\tQ+A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003-\f!b\u001c8FY\u0016\u001cG/[8o)\rYw/\u001f\u0005\u0006q:\u0001\r!V\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0003{\u001d\u0001\u0007Q+A\u0006mK\u0006$WM]#q_\u000eD\u0017!D8o%\u0016\u001c\u0018n\u001a8bi&|g\u000eF\u0002l{zDQ\u0001_\bA\u0002UCQA_\bA\u0002}\u0004BaJA\u0001+&\u0019\u00111\u0001\u0015\u0003\r=\u0003H/[8o\u0003=a\u0017N\\6D_>\u0014H-\u001b8bi>\u0014HCBA\u0005\u0003C\tY\u0004E\u0003(\u0003\u0003\tY\u0001\u0005\u0003\u0002\u000e\u0005uQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\r\r|W.\\8o\u0015\r\u0019\u0013Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u00037\t1a\u001c:h\u0013\u0011\ty\"a\u0004\u0003\t9{G-\u001a\u0005\b\u0003G\u0001\u0002\u0019AA\u0013\u0003!a\u0017N\\6OC6,\u0007\u0003BA\u0014\u0003kqA!!\u000b\u00022A\u0019\u00111\u0006\u0015\u000e\u0005\u00055\"bAA\u0018I\u00051AH]8pizJ1!a\r)\u0003\u0019\u0001&/\u001a3fM&!\u0011qGA\u001d\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0007\u0015\t\u000f\u0005u\u0002\u00031\u0001\u0002@\u0005aA.[:uK:,'OT1nKB!\u0011\u0011IA$\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005=\u0011a\u00028fi^|'o[\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0007MSN$XM\\3s\u001d\u0006lW-A\u000fmS:\\g*Y7f)>\u0004\u0016M\u001d;ji&|g.\u00133XSRDGj\\2l)\r)\u0016q\n\u0005\b\u0003G\t\u0002\u0019AA\u0013\u0003Ua\u0017N\\6OC6,Gk\u001c)beRLG/[8o\u0013\u0012$2!VA+\u0011\u001d\t\u0019C\u0005a\u0001\u0003K\t\u0011#[:MS:\\7i\\8sI&t\u0017\r^8s)\r1\u00171\f\u0005\b\u0003G\u0019\u0002\u0019AA\u0013\u0003qI7\u000fT5oW\u000e{wN\u001d3j]\u0006$xN]%oSRL\u0017\r\\5{K\u0012$\u0012AZ\u0001\tg\",H\u000fZ8x]\u0006A!/Z4jgR,'\u000fF\u0002l\u0003OBa!!\u001b\u0017\u0001\u0004A\u0015\u0001\u00037jgR,g.\u001a:\u00027=<h.\u001a3MS:\\W*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8t)\t\ty\u0007E\u0003\u0002(\u0005ET+C\u0002U\u0003s\t\u0001%\\3uC\u0012\fG/\u0019+pa&\u001cwj\u001e8fIB\u000b'\u000f^5uS>t7i\\;oiR\tQ+A\fhKR\fE\u000e\u001c'j].\u001chI]8n\u001b\u0016$\u0018\rZ1uCR\u0011\u00111\u0010\t\u0007\u0003{\n9)!$\u000f\t\u0005}\u00141\u0011\b\u0005\u0003W\t\t)C\u0001*\u0013\r\t)\tK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI)a#\u0003\u0007M+\u0017OC\u0002\u0002\u0006\"\u00022\u0001PAH\u0013\r\t\tJ\b\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006)S.\u0019=MS:\\7i\\;oiB+'/T3uC\u0012\fG/\u0019+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001(O\u0016$8\t\\;ti\u0016\u0014H*\u001b8lg^KG\u000f[(x]\u0016$G*\u001b8l\u0007>|'\u000fZ5oCR|'\u000f\u0006\u0002\u0002\u001aB1\u0011qEA9\u0003\u001b\u000bQdZ3u\u00072,8\u000f^3s\u0019&t7n\u001d$peB\u000b'\u000f^5uS>t\u0017\n\u001a\u000b\u0005\u00033\u000by\nC\u0003y9\u0001\u0007Q\u000b")
public abstract class LinkCoordinatorManager
implements Logging {
    private final KRaftImageMetadataCache metadataCache;
    private final Buffer<ClusterLinkFactory.LinkCoordinatorListener> metadataImageListeners;
    private final Set<Object> ownedPartitions;
    private final Object lock;
    private boolean initialized;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LinkCoordinatorManager linkCoordinatorManager = this;
        synchronized (linkCoordinatorManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Buffer<ClusterLinkFactory.LinkCoordinatorListener> metadataImageListeners() {
        return this.metadataImageListeners;
    }

    public Set<Object> ownedPartitions() {
        return this.ownedPartitions;
    }

    public Object lock() {
        return this.lock;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    public abstract int getNumMetadataPartitions();

    public abstract void startup();

    public abstract void onElection(int var1, int var2);

    public abstract void onResignation(int var1, Option<Object> var2);

    public abstract Option<Node> linkCoordinator(String var1, ListenerName var2);

    public int linkNameToPartitionIdWithLock(String linkName) {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = this.linkNameToPartitionId(linkName);
        }
        return n;
    }

    public int linkNameToPartitionId(String linkName) {
        if (!this.initialized()) {
            return -1;
        }
        return Utils.toPositive(Utils.murmur2(linkName.getBytes())) % this.getNumMetadataPartitions();
    }

    public boolean isLinkCoordinator(String linkName) {
        boolean bl;
        block5: {
            Object object = this.lock();
            synchronized (object) {
                boolean bl2;
                block4: {
                    if (!this.initialized()) {
                        bl2 = false;
                        break block4;
                    }
                    bl = this.ownedPartitions().contains(BoxesRunTime.boxToInteger(this.linkNameToPartitionId(linkName)));
                    break block5;
                }
                return bl2;
            }
        }
        return bl;
    }

    public boolean isLinkCoordinatorInitialized() {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            bl = this.initialized();
        }
        return bl;
    }

    public void shutdown() {
        Object object = this.lock();
        synchronized (object) {
            this.ownedPartitions().clear();
            this.initialized_$eq(false);
        }
    }

    public void register(ClusterLinkFactory.LinkCoordinatorListener listener) {
        this.metadataImageListeners().$plus$eq(listener);
    }

    public synchronized scala.collection.immutable.Set<Object> ownedLinkMetadataPartitions() {
        return this.ownedPartitions().toSet();
    }

    public int metadataTopicOwnedPartitionCount() {
        return this.ownedPartitions().size();
    }

    private Seq<ClusterLinkData> getAllLinksFromMetadata() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(this.metadataCache.currentImage().clusterLinks().linksById()).asScala().values().map((Function1<ClusterLink, ClusterLinkData> & Serializable)clusterLink -> new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), new Some<String>(clusterLink.remoteClusterId()), OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(clusterLink.tenantPrefix())), false))).toSeq();
    }

    public int maxLinkCountPerMetadataTopicPartition() {
        Iterable grouped = (Iterable)this.getAllLinksFromMetadata().groupBy((Function1<ClusterLinkData, Object> & Serializable)cld -> BoxesRunTime.boxToInteger(this.linkNameToPartitionId(cld.linkName()))).values().map((Function1<Seq, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.size()));
        if (grouped.isEmpty()) {
            return 0;
        }
        return BoxesRunTime.unboxToInt(grouped.max(Ordering.Int$.MODULE$));
    }

    public scala.collection.immutable.Set<ClusterLinkData> getClusterLinksWithOwnedLinkCoordinator() {
        return ((IterableOnceOps)this.getAllLinksFromMetadata().filter((Function1<ClusterLinkData, Object> & Serializable)cld -> BoxesRunTime.boxToBoolean(this.isLinkCoordinator(cld.linkName())))).toSet();
    }

    public scala.collection.immutable.Set<ClusterLinkData> getClusterLinksForPartitionId(int partitionId) {
        scala.collection.immutable.Set<ClusterLinkData> set;
        block8: {
            Object object = this.lock();
            synchronized (object) {
                Object object2;
                block7: {
                    if (!this.initialized()) {
                        object2 = Predef$.MODULE$.Set().empty();
                        break block7;
                    }
                    break block8;
                }
                return object2;
            }
        }
        Seq<ClusterLinkData> links = this.getAllLinksFromMetadata();
        Object object = this.lock();
        synchronized (object) {
            set = ((IterableOnceOps)links.filter((Function1<ClusterLinkData, Object> & Serializable)cld -> BoxesRunTime.boxToBoolean(LinkCoordinatorManager.$anonfun$getClusterLinksForPartitionId$1(this, partitionId, cld)))).toSet();
        }
        return set;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterLinksForPartitionId$1(LinkCoordinatorManager $this, int partitionId$1, ClusterLinkData cld) {
        return $this.linkNameToPartitionId(cld.linkName()) == partitionId$1;
    }

    public LinkCoordinatorManager(KRaftImageMetadataCache metadataCache) {
        this.metadataCache = metadataCache;
        Logging.$init$(this);
        this.metadataImageListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.ownedPartitions = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
        this.lock = new Object();
        this.initialized = false;
    }
}

