/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.OptionalDouble;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.network.ConnectionQuotas;
import kafka.network.FetchRequestInterceptor;
import kafka.network.ProduceRequestInterceptor;
import kafka.server.ClientQuotaManager;
import kafka.server.MetadataRequestMinimumThrottleConfig;
import kafka.server.QuotaFactory;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.ClientQuotaMetadataManager$;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultIpEntity$;
import kafka.server.metadata.DefaultTenantEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.IpEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.TenantEntity;
import kafka.server.metadata.UserEntity;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.image.ClientQuotaDelta;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.server.authorizer.AuthorizerConfig;
import org.apache.kafka.server.policy.CreateClusterLinkPolicy;
import org.apache.kafka.server.quota.ClientQuotaEntity;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t5b\u0001B\u0010!\u0001\u001dB\u0011\u0002\u000e\u0001\u0003\u0006\u0004%\t\u0001I\u001b\t\u0011\u0011\u0003!\u0011!Q\u0001\nYB\u0011\"\u0012\u0001\u0003\u0006\u0004%\t\u0001\t$\t\u00115\u0003!\u0011!Q\u0001\n\u001dC\u0011B\u0014\u0001\u0003\u0006\u0004%\t\u0001I(\t\u0011}\u0003!\u0011!Q\u0001\nAC\u0011\u0002\u0019\u0001\u0003\u0006\u0004%\t\u0001I1\t\u0011\u0019\u0004!\u0011!Q\u0001\n\tD\u0011b\u001a\u0001\u0003\u0006\u0004%\t\u0001\t5\t\u0011M\u0004!\u0011!Q\u0001\n%D\u0011\u0002\u001e\u0001\u0003\u0006\u0004%\t\u0001I;\t\u0011i\u0004!\u0011!Q\u0001\nYD\u0011b\u001f\u0001\u0003\u0006\u0004%\t\u0001\t?\t\u0013\u0005\r\u0001A!A!\u0002\u0013i\bbCA\u0003\u0001\t\u0015\r\u0011\"\u0001!\u0003\u000fA!\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u0005\u0011-\ti\u0002\u0001BC\u0002\u0013\u0005\u0001%a\b\t\u0015\u0005=\u0002A!A!\u0002\u0013\t\t\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u00111\n\u0001\u0005\n\u0005\u0015\u0004\u0002CAB\u0001\u0011\u0005\u0001%!\"\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\"9\u0011Q\u0014\u0001\u0005\n\u0005}uaBAcA!\u0005\u0011q\u0019\u0004\u0007?\u0001B\t!!3\t\u000f\u0005E\"\u0004\"\u0001\u0002L\"9\u0011Q\u001a\u000e\u0005\u0002\u0005=\u0007\"\u0003B\b5E\u0005I\u0011\u0001B\t\u0011%\u00119CGI\u0001\n\u0003\u0011IC\u0001\u000eDY&,g\u000e^)v_R\fW*\u001a;bI\u0006$\u0018-T1oC\u001e,'O\u0003\u0002\"E\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002$I\u000511/\u001a:wKJT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0013!B;uS2\u001c\u0018BA\u001a1\u0005\u001daunZ4j]\u001e\fQ\"];pi\u0006l\u0015M\\1hKJ\u001cX#\u0001\u001c\u0011\u0005]\neB\u0001\u001d@\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=M\u00051AH]8pizJ\u0011!J\u0005\u0003G\u0011J!\u0001\u0011\u0012\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\u0005\t\u001b%!D)v_R\fW*\u00198bO\u0016\u00148O\u0003\u0002AE\u0005q\u0011/^8uC6\u000bg.Y4feN\u0004\u0013\u0001E2p]:,7\r^5p]F+x\u000e^1t+\u00059\u0005C\u0001%L\u001b\u0005I%B\u0001&%\u0003\u001dqW\r^<pe.L!\u0001T%\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\u0018!E2p]:,7\r^5p]F+x\u000e^1tA\u0005Q\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u001cuN\u001c4jOV\t\u0001\u000b\u0005\u0002R;6\t!K\u0003\u0002T)\u0006\u0019An\\4\u000b\u0005U3\u0016!C5oi\u0016\u0014h.\u00197t\u0015\t9\u0006,A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u0015J&B\u0001.\\\u0003\u0019\t\u0007/Y2iK*\tA,A\u0002pe\u001eL!A\u0018*\u00035A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u00027A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4!\u0003\u0011jW\r^1eCR\f'+Z9vKN$X*\u001b8j[VlG\u000b\u001b:piRdWmQ8oM&<W#\u00012\u0011\u0005\r$W\"\u0001\u0012\n\u0005\u0015\u0014#\u0001J'fi\u0006$\u0017\r^1SKF,Xm\u001d;NS:LW.^7UQJ|G\u000f\u001e7f\u0007>tg-[4\u0002K5,G/\u00193bi\u0006\u0014V-];fgRl\u0015N\\5nk6$\u0006N]8ui2,7i\u001c8gS\u001e\u0004\u0013aE1vi\"|'/\u001b>fe\u000e{gNZ5h\u001fB$X#A5\u0011\u0007%RG.\u0003\u0002lU\t1q\n\u001d;j_:\u0004\"!\\9\u000e\u00039T!a\u001c9\u0002\u0015\u0005,H\u000f[8sSj,'O\u0003\u0002$1&\u0011!O\u001c\u0002\u0011\u0003V$\bn\u001c:ju\u0016\u00148i\u001c8gS\u001e\fA#Y;uQ>\u0014\u0018N_3s\u0007>tg-[4PaR\u0004\u0013A\u00074fi\u000eD'+Z9vKN$\u0018J\u001c;fe\u000e,\u0007\u000f^8s\u001fB$X#\u0001<\u0011\u0007%Rw\u000f\u0005\u0002Iq&\u0011\u00110\u0013\u0002\u0018\r\u0016$8\r\u001b*fcV,7\u000f^%oi\u0016\u00148-\u001a9u_J\f1DZ3uG\"\u0014V-];fgRLe\u000e^3sG\u0016\u0004Ho\u001c:PaR\u0004\u0013\u0001\b9s_\u0012,8-\u001a*fcV,7\u000f^%oi\u0016\u00148-\u001a9u_J|\u0005\u000f^\u000b\u0002{B\u0019\u0011F\u001b@\u0011\u0005!{\u0018bAA\u0001\u0013\nI\u0002K]8ek\u000e,'+Z9vKN$\u0018J\u001c;fe\u000e,\u0007\u000f^8s\u0003u\u0001(o\u001c3vG\u0016\u0014V-];fgRLe\u000e^3sG\u0016\u0004Ho\u001c:PaR\u0004\u0013aE9v_R\f7i\\8sI&t\u0017\r^8s\u001fB$XCAA\u0005!\u0011I#.a\u0003\u0011\t\u00055\u0011qC\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005)\u0011/^8uC*\u0019\u0011Q\u0003\u0013\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0005\u00033\tyA\u0001\tRk>$\u0018mQ8pe\u0012Lg.\u0019;pe\u0006!\u0012/^8uC\u000e{wN\u001d3j]\u0006$xN](qi\u0002\n!d\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8l!>d\u0017nY=PaR,\"!!\t\u0011\t%R\u00171\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u00069\u0002\rA|G.[2z\u0013\u0011\ti#a\n\u0003/\r\u0013X-\u0019;f\u00072,8\u000f^3s\u0019&t7\u000eU8mS\u000eL\u0018aG2sK\u0006$Xm\u00117vgR,'\u000fT5oWB{G.[2z\u001fB$\b%\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003k\tI$a\u000f\u0002>\u0005}\u0012\u0011IA\"\u0003\u000b\n9%!\u0013\u0011\u0007\u0005]\u0002!D\u0001!\u0011\u0015!4\u00031\u00017\u0011\u0015)5\u00031\u0001H\u0011\u0015q5\u00031\u0001Q\u0011\u0015\u00017\u00031\u0001c\u0011\u001597\u00031\u0001j\u0011\u0015!8\u00031\u0001w\u0011\u0015Y8\u00031\u0001~\u0011%\t)a\u0005I\u0001\u0002\u0004\tI\u0001C\u0005\u0002\u001eM\u0001\n\u00111\u0001\u0002\"\u00051Q\u000f\u001d3bi\u0016$B!a\u0014\u0002VA\u0019\u0011&!\u0015\n\u0007\u0005M#F\u0001\u0003V]&$\bbBA,)\u0001\u0007\u0011\u0011L\u0001\fcV|G/Y:EK2$\u0018\r\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\ty\u0006W\u0001\u0006S6\fw-Z\u0005\u0005\u0003G\niFA\tDY&,g\u000e^)v_R\f7\u000fR3mi\u0006$b!a\u0014\u0002h\u0005e\u0004bBA5+\u0001\u0007\u00111N\u0001\u0007K:$\u0018\u000e^=\u0011\t\u00055\u0014QO\u0007\u0003\u0003_RA!!\u0005\u0002r)\u0019\u00111\u000f-\u0002\r\r|W.\\8o\u0013\u0011\t9(a\u001c\u0003#\rc\u0017.\u001a8u#V|G/Y#oi&$\u0018\u0010C\u0004\u0002|U\u0001\r!! \u0002\u0015E,x\u000e^1EK2$\u0018\r\u0005\u0003\u0002\\\u0005}\u0014\u0002BAA\u0003;\u0012\u0001c\u00117jK:$\u0018+^8uC\u0012+G\u000e^1\u0002\u001b!\fg\u000e\u001a7f\u0013B\fVo\u001c;b)\u0019\ty%a\"\u0002\u0012\"9\u0011\u0011\u0012\fA\u0002\u0005-\u0015\u0001C5q\u000b:$\u0018\u000e^=\u0011\t\u0005]\u0012QR\u0005\u0004\u0003\u001f\u0003#aC)v_R\fWI\u001c;jifDq!a\u001f\u0017\u0001\u0004\ti(A\tiC:$G.\u001a+f]\u0006tG/U;pi\u0006$b!a\u0014\u0002\u0018\u0006m\u0005bBAM/\u0001\u0007\u00111R\u0001\ri\u0016t\u0017M\u001c;F]RLG/\u001f\u0005\b\u0003w:\u0002\u0019AA?\u0003mA\u0017M\u001c3mKV\u001bXM]\"mS\u0016tG/U;pi\u0006\u001c\u0005.\u00198hKRA\u0011qJAQ\u0003K\u000bI\fC\u0004\u0002$b\u0001\r!a#\u0002\u0017E,x\u000e^1F]RLG/\u001f\u0005\b\u0003OC\u0002\u0019AAU\u0003\rYW-\u001f\t\u0005\u0003W\u000b\u0019L\u0004\u0003\u0002.\u0006=\u0006C\u0001\u001e+\u0013\r\t\tLK\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0016q\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E&\u0006C\u0004\u0002<b\u0001\r!!0\u0002\u00119,wOV1mk\u0016\u0004B!\u000b6\u0002@B\u0019\u0011&!1\n\u0007\u0005\r'F\u0001\u0004E_V\u0014G.Z\u0001\u001b\u00072LWM\u001c;Rk>$\u0018-T3uC\u0012\fG/Y'b]\u0006<WM\u001d\t\u0004\u0003oQ2C\u0001\u000e))\t\t9-A\u000eue\u0006t7OZ3s)>\u001cE.[3oiF+x\u000e^1F]RLG/\u001f\u000b\u0005\u0003#\u0014i\u0001E\u0004*\u0003'\f9.a:\n\u0007\u0005U'F\u0001\u0004UkBdWM\r\t\u0005S)\fI\u000e\u0005\u0003\u0002\\\u0006\u0005hb\u0001\u001d\u0002^&\u0019\u0011q\u001c\u0012\u0002%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\u0005\u0005\u0003G\f)O\u0001\bCCN,Wk]3s\u000b:$\u0018\u000e^=\u000b\u0007\u0005}'\u0005\u0005\u0003*U\u0006%\b\u0003BAv\u0005\u000fqA!!<\u0003\u00029!\u0011q^A\u0000\u001d\u0011\t\t0!@\u000f\t\u0005M\u00181 \b\u0005\u0003k\fIPD\u0002;\u0003oL\u0011\u0001X\u0005\u00035nK!!J-\n\u0005\rB\u0016bAA\ta&!!1\u0001B\u0003\u0003E\u0019E.[3oiF+x\u000e^1F]RLG/\u001f\u0006\u0004\u0003#\u0001\u0018\u0002\u0002B\u0005\u0005\u0017\u0011AbQ8oM&<WI\u001c;jifTAAa\u0001\u0003\u0006!9\u00111\u0015\u000fA\u0002\u0005-\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003\u0014)\"\u0011\u0011\u0002B\u000bW\t\u00119\u0002\u0005\u0003\u0003\u001a\t\rRB\u0001B\u000e\u0015\u0011\u0011iBa\b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0011U\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\"1\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0003,)\"\u0011\u0011\u0005B\u000b\u0001")
public class ClientQuotaMetadataManager
implements Logging {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final ConnectionQuotas connectionQuotas;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig;
    private final Option<AuthorizerConfig> authorizerConfigOpt;
    private final Option<FetchRequestInterceptor> fetchRequestInterceptorOpt;
    private final Option<ProduceRequestInterceptor> produceRequestInterceptorOpt;
    private final Option<QuotaCoordinator> quotaCoordinatorOpt;
    private final Option<CreateClusterLinkPolicy> createClusterLinkPolicyOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<CreateClusterLinkPolicy> $lessinit$greater$default$9() {
        return ClientQuotaMetadataManager$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<QuotaCoordinator> $lessinit$greater$default$8() {
        return ClientQuotaMetadataManager$.MODULE$.$lessinit$greater$default$8();
    }

    public static Tuple2<Option<ClientQuotaManager.BaseUserEntity>, Option<ClientQuotaEntity.ConfigEntity>> transferToClientQuotaEntity(QuotaEntity quotaEntity) {
        return ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity(quotaEntity);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClientQuotaMetadataManager clientQuotaMetadataManager = this;
        synchronized (clientQuotaMetadataManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig() {
        return this.metadataRequestMinimumThrottleConfig;
    }

    public Option<AuthorizerConfig> authorizerConfigOpt() {
        return this.authorizerConfigOpt;
    }

    public Option<FetchRequestInterceptor> fetchRequestInterceptorOpt() {
        return this.fetchRequestInterceptorOpt;
    }

    public Option<ProduceRequestInterceptor> produceRequestInterceptorOpt() {
        return this.produceRequestInterceptorOpt;
    }

    public Option<QuotaCoordinator> quotaCoordinatorOpt() {
        return this.quotaCoordinatorOpt;
    }

    public Option<CreateClusterLinkPolicy> createClusterLinkPolicyOpt() {
        return this.createClusterLinkPolicyOpt;
    }

    public void update(ClientQuotasDelta quotasDelta) {
        quotasDelta.changes().forEach((key, value) -> this.update((ClientQuotaEntity)key, (ClientQuotaDelta)value));
    }

    private void update(ClientQuotaEntity entity, ClientQuotaDelta quotaDelta) {
        if (entity.entries().containsKey("ip")) {
            Product product;
            Option<String> option = Option$.MODULE$.apply(entity.entries().get("ip"));
            if (option instanceof Some) {
                Some some = (Some)option;
                String ip = (String)some.value();
                product = new IpEntity(ip);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultIpEntity$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            DefaultIpEntity$ ipEntity = product;
            this.handleIpQuota(ipEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("confluent-tenant")) {
            Product product;
            Option<String> option = Option$.MODULE$.apply(entity.entries().get("confluent-tenant"));
            if (option instanceof Some) {
                Some some = (Some)option;
                String tenant = (String)some.value();
                product = new TenantEntity(tenant);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultTenantEntity$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            DefaultTenantEntity$ tenantEntity = product;
            this.handleTenantQuota(tenantEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("user") || entity.entries().containsKey("client-id")) {
            String userVal = entity.entries().get("user");
            String clientIdVal = entity.entries().get("client-id");
            Product userClientEntity = entity.entries().containsKey("user") && entity.entries().containsKey("client-id") ? (userVal == null && clientIdVal == null ? DefaultUserDefaultClientIdEntity$.MODULE$ : (userVal == null ? new DefaultUserExplicitClientIdEntity(clientIdVal) : (clientIdVal == null ? new ExplicitUserDefaultClientIdEntity(userVal) : new ExplicitUserExplicitClientIdEntity(userVal, clientIdVal)))) : (entity.entries().containsKey("user") ? (userVal == null ? DefaultUserEntity$.MODULE$ : new UserEntity(userVal)) : (clientIdVal == null ? DefaultClientIdEntity$.MODULE$ : new ClientIdEntity(clientIdVal)));
            quotaDelta.changes().forEach((key, value) -> this.handleUserClientQuotaChange((QuotaEntity)((Object)userClientEntity), (String)key, OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble((OptionalDouble)value))));
            return;
        }
        this.warn((Function0<String> & Serializable)() -> "Ignoring unsupported quota entity " + entity + ".");
    }

    public void handleIpQuota(QuotaEntity ipEntity, ClientQuotaDelta quotaDelta) {
        Option option;
        QuotaEntity quotaEntity = ipEntity;
        if (quotaEntity instanceof IpEntity) {
            IpEntity ipEntity2 = (IpEntity)quotaEntity;
            String ip = ipEntity2.ip();
            try {
                option = new Some<InetAddress>(InetAddress.getByName(ip));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("Unable to resolve address " + ip);
            }
        } else if (DefaultIpEntity$.MODULE$.equals(quotaEntity)) {
            option = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle IP quota entities here");
        }
        None$ inetAddress = option;
        quotaDelta.changes().forEach((key, value) -> {
            String quotaName = key;
            OptionalDouble quotaValue = value;
            if (!quotaName.equals("connection_creation_rate")) {
                this.warn((Function0<String> & Serializable)() -> "Ignoring unexpected quota key " + quotaName + " for entity " + ipEntity);
                return;
            }
            try {
                this.connectionQuotas().updateIpConnectionRateQuota(inetAddress, OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)));
            }
            catch (Throwable t) {
                this.error((Function0<String> & Serializable)() -> "Failed to update IP quota " + ipEntity, (Function0<Throwable> & Serializable)() -> t);
            }
        });
    }

    private void handleTenantQuota(QuotaEntity tenantEntity, ClientQuotaDelta quotaDelta) {
        Option option;
        QuotaEntity quotaEntity = tenantEntity;
        if (quotaEntity instanceof TenantEntity) {
            TenantEntity tenantEntity2 = (TenantEntity)quotaEntity;
            String tenant = tenantEntity2.tenant();
            option = new Some<String>(tenant);
        } else if (DefaultTenantEntity$.MODULE$.equals(quotaEntity)) {
            option = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle tenant quota entities here");
        }
        Option tenantOpt = option;
        quotaDelta.changes().entrySet().forEach(e -> {
            String quotaName = (String)e.getKey();
            OptionalDouble quotaValue = (OptionalDouble)e.getValue();
            if (quotaName.equals("connection_creation_rate")) {
                try {
                    this.connectionQuotas().updateTenantConnectionRateQuota(tenantOpt, OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)));
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("producer_id_expiration_ms")) {
                try {
                    Optional<Integer> quotaValueIntOpt = OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map(x$1 -> (int)x$1).map((Function1<Object, Integer> & Serializable)x -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$5(BoxesRunTime.unboxToInt(x)))));
                    this.info((Function0<String> & Serializable)() -> "Setting tenant-level producer ID expiration for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt)) + " to " + quotaValueIntOpt);
                    this.producerStateManagerConfig().setProducerIdExpirationMs(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt)), quotaValueIntOpt);
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("metadata_request_minimum_throttle_ms")) {
                try {
                    Option<Object> quotaValueIntOpt = OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map(x$2 -> (int)x$2);
                    this.info((Function0<String> & Serializable)() -> "Setting tenant-level metadata request minimum throttle for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt)) + " to " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(quotaValueIntOpt)));
                    this.metadataRequestMinimumThrottleConfig().setMinimumThrottle(tenantOpt, quotaValueIntOpt);
                    this.debug((Function0<String> & Serializable)() -> String.valueOf(this.metadataRequestMinimumThrottleConfig()));
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("connection_creation_count")) {
                try {
                    this.connectionQuotas().updateTenantConnectionCountQuota(tenantOpt, OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map(x$3 -> (int)x$3).map(x -> Predef$.MODULE$.Integer2int(BoxesRunTime.boxToInteger(x))));
                    this.info((Function0<String> & Serializable)() -> "Setting tenant connection count quota " + OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt)) + " to " + quotaValue);
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("acl_count")) {
                try {
                    this.authorizerConfigOpt().foreach((Function1<AuthorizerConfig, Object> & Serializable)authorizerConfig -> {
                        ClientQuotaMetadataManager.$anonfun$handleTenantQuota$19(this, tenantOpt, quotaValue, authorizerConfig);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("source_link_count") || quotaName.equals("destination_link_count")) {
                try {
                    this.createClusterLinkPolicyOpt().foreach((Function1<CreateClusterLinkPolicy, Object> & Serializable)policy -> {
                        ClientQuotaMetadataManager.$anonfun$handleTenantQuota$25(this, quotaValue, quotaName, tenantOpt, policy);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("reject_all_fetches")) {
                try {
                    tenantOpt.foreach((Function1<String, Object> & Serializable)tenant -> {
                        ClientQuotaMetadataManager.$anonfun$handleTenantQuota$32(this, quotaValue, tenant);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("reject_all_produces")) {
                try {
                    tenantOpt.foreach((Function1<String, Object> & Serializable)tenant -> {
                        ClientQuotaMetadataManager.$anonfun$handleTenantQuota$38(this, quotaValue, tenant);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("max_broker_producer_byte_rate")) {
                try {
                    this.quotaCoordinatorOpt().foreach((Function1<QuotaCoordinator, Object> & Serializable)quotaCoordinator -> {
                        ClientQuotaMetadataManager.$anonfun$handleTenantQuota$44(this, tenantOpt, quotaValue, quotaCoordinator);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to set max_broker_producer_byte_rate for tenant " + tenantOpt + " to " + quotaValue, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("max_broker_consumer_byte_rate")) {
                try {
                    this.quotaCoordinatorOpt().foreach((Function1<QuotaCoordinator, Object> & Serializable)quotaCoordinator -> {
                        ClientQuotaMetadataManager.$anonfun$handleTenantQuota$48(this, tenantOpt, quotaValue, quotaCoordinator);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to set max_broker_consumer_byte_rate for tenant " + tenantOpt + " to " + quotaValue, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            this.warn((Function0<String> & Serializable)() -> "Ignoring unexpected quota key " + quotaName + " for entity " + tenantEntity);
        });
    }

    private void handleUserClientQuotaChange(QuotaEntity quotaEntity, String key, Option<Object> newValue) {
        ClientQuotaManager clientQuotaManager;
        block9: {
            String string = key;
            switch (string == null ? 0 : string.hashCode()) {
                case -1805480786: {
                    if (!"consumer_byte_rate".equals(string)) break;
                    clientQuotaManager = this.quotaManagers().fetch();
                    break block9;
                }
                case -965904822: {
                    if (!"request_percentage".equals(string)) break;
                    clientQuotaManager = this.quotaManagers().request();
                    break block9;
                }
                case -832502454: {
                    if (!"producer_byte_rate".equals(string)) break;
                    clientQuotaManager = this.quotaManagers().produce();
                    break block9;
                }
                case -748852909: {
                    if (!"controller_mutation_rate".equals(string)) break;
                    clientQuotaManager = this.quotaManagers().controllerMutation();
                    break block9;
                }
            }
            this.warn((Function0<String> & Serializable)() -> "Ignoring unexpected quota key " + key + " for entity " + quotaEntity);
            return;
        }
        ClientQuotaManager manager = clientQuotaManager;
        Tuple2<Option<ClientQuotaManager.BaseUserEntity>, Option<ClientQuotaEntity.ConfigEntity>> tuple2 = ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option<ClientQuotaManager.BaseUserEntity> userEntity = tuple2._1();
        Option<ClientQuotaEntity.ConfigEntity> clientEntity = tuple2._2();
        Tuple2<Option<ClientQuotaManager.BaseUserEntity>, Option<ClientQuotaEntity.ConfigEntity>> tuple22 = new Tuple2<Option<ClientQuotaManager.BaseUserEntity>, Option<ClientQuotaEntity.ConfigEntity>>(userEntity, clientEntity);
        Option<ClientQuotaManager.BaseUserEntity> userEntity2 = tuple22._1();
        Option<ClientQuotaEntity.ConfigEntity> clientEntity2 = tuple22._2();
        Option<Quota> quotaValue = newValue.map((Function1<Object, Quota> & Serializable)x$7 -> ClientQuotaMetadataManager.$anonfun$handleUserClientQuotaChange$2(BoxesRunTime.unboxToDouble(x$7)));
        try {
            manager.updateQuota(userEntity2, clientEntity2, quotaValue);
        }
        catch (Throwable t) {
            this.error((Function0<String> & Serializable)() -> "Failed to update user-client quota " + quotaEntity, (Function0<Throwable> & Serializable)() -> t);
        }
    }

    public static final /* synthetic */ Integer $anonfun$handleTenantQuota$5(int x) {
        return BoxesRunTime.boxToInteger(x);
    }

    public static final /* synthetic */ Integer $anonfun$handleTenantQuota$21(int x) {
        return BoxesRunTime.boxToInteger(x);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$19(ClientQuotaMetadataManager $this, Option tenantOpt$1, OptionalDouble quotaValue$1, AuthorizerConfig authorizerConfig) {
        authorizerConfig.setTenantMaxAcls(OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)), OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue$1)).map(x$4 -> (int)x$4).map((Function1<Object, Integer> & Serializable)x -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$21(BoxesRunTime.unboxToInt(x))))));
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level max acl count limit for tenant " + OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)) + " to " + quotaValue$1);
    }

    public static final /* synthetic */ Integer $anonfun$handleTenantQuota$27(int x) {
        return BoxesRunTime.boxToInteger(x);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$25(ClientQuotaMetadataManager $this, OptionalDouble quotaValue$1, String quotaName$2, Option tenantOpt$1, CreateClusterLinkPolicy policy) {
        Option maxLinks = OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue$1)).map(x$5 -> (int)x$5).map((Function1<Object, Integer> & Serializable)x -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$27(BoxesRunTime.unboxToInt(x)));
        if (quotaName$2.equals("source_link_count")) {
            policy.setTenantMaxSourceLinks(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(maxLinks)));
            $this.info((Function0<String> & Serializable)() -> "Setting tenant-level max source link count limit for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)) + " to " + quotaValue$1);
            return;
        }
        policy.setTenantMaxDestLinks(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(maxLinks)));
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level max destination link count limit for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)) + " to " + quotaValue$1);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$33(ClientQuotaMetadataManager $this, OptionalDouble quotaValue$1, String tenant$1, FetchRequestInterceptor fetchRequestInterceptorOpt) {
        boolean quotaValueAsBool;
        boolean bl = quotaValue$1.isPresent() ? quotaValue$1.getAsDouble() == 1.0 : (quotaValueAsBool = false);
        if (quotaValueAsBool) {
            $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to intercept fetch requests from tenant " + tenant$1);
            fetchRequestInterceptorOpt.ignoreRequestsFromTenant(tenant$1);
            return;
        }
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to accept fetch requests from tenant " + tenant$1);
        fetchRequestInterceptorOpt.acceptRequestsFromTenant(tenant$1);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$32(ClientQuotaMetadataManager $this, OptionalDouble quotaValue$1, String tenant) {
        $this.fetchRequestInterceptorOpt().foreach((Function1<FetchRequestInterceptor, Object> & Serializable)fetchRequestInterceptorOpt -> {
            ClientQuotaMetadataManager.$anonfun$handleTenantQuota$33($this, quotaValue$1, tenant, fetchRequestInterceptorOpt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$39(ClientQuotaMetadataManager $this, OptionalDouble quotaValue$1, String tenant$2, ProduceRequestInterceptor produceRequestInterceptor) {
        boolean quotaValueAsBool;
        boolean bl = quotaValue$1.isPresent() ? quotaValue$1.getAsDouble() == 1.0 : (quotaValueAsBool = false);
        if (quotaValueAsBool) {
            $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to intercept produce requests from tenant " + tenant$2);
            produceRequestInterceptor.ignoreRequestsFromTenant(tenant$2);
            return;
        }
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to accept produce requests from tenant " + tenant$2);
        produceRequestInterceptor.acceptRequestsFromTenant(tenant$2);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$38(ClientQuotaMetadataManager $this, OptionalDouble quotaValue$1, String tenant) {
        $this.produceRequestInterceptorOpt().foreach((Function1<ProduceRequestInterceptor, Object> & Serializable)produceRequestInterceptor -> {
            ClientQuotaMetadataManager.$anonfun$handleTenantQuota$39($this, quotaValue$1, tenant, produceRequestInterceptor);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$44(ClientQuotaMetadataManager $this, Option tenantOpt$1, OptionalDouble quotaValue$1, QuotaCoordinator quotaCoordinator) {
        $this.info((Function0<String> & Serializable)() -> "Setting max_broker_producer_byte_rate for tenant " + tenantOpt$1 + " to " + quotaValue$1);
        quotaCoordinator.setTenantBrokerMaxProducerByteRate(tenantOpt$1, OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue$1)));
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$48(ClientQuotaMetadataManager $this, Option tenantOpt$1, OptionalDouble quotaValue$1, QuotaCoordinator quotaCoordinator) {
        $this.info((Function0<String> & Serializable)() -> "Setting max_broker_consumer_byte_rate for tenant " + tenantOpt$1 + " to " + quotaValue$1);
        quotaCoordinator.setTenantBrokerMaxConsumerByteRate(tenantOpt$1, OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue$1)));
    }

    public static final /* synthetic */ Quota $anonfun$handleUserClientQuotaChange$2(double x$7) {
        return new Quota(x$7, true);
    }

    public ClientQuotaMetadataManager(QuotaFactory.QuotaManagers quotaManagers, ConnectionQuotas connectionQuotas, ProducerStateManagerConfig producerStateManagerConfig, MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig, Option<AuthorizerConfig> authorizerConfigOpt, Option<FetchRequestInterceptor> fetchRequestInterceptorOpt, Option<ProduceRequestInterceptor> produceRequestInterceptorOpt, Option<QuotaCoordinator> quotaCoordinatorOpt, Option<CreateClusterLinkPolicy> createClusterLinkPolicyOpt) {
        this.quotaManagers = quotaManagers;
        this.connectionQuotas = connectionQuotas;
        this.producerStateManagerConfig = producerStateManagerConfig;
        this.metadataRequestMinimumThrottleConfig = metadataRequestMinimumThrottleConfig;
        this.authorizerConfigOpt = authorizerConfigOpt;
        this.fetchRequestInterceptorOpt = fetchRequestInterceptorOpt;
        this.produceRequestInterceptorOpt = produceRequestInterceptorOpt;
        this.quotaCoordinatorOpt = quotaCoordinatorOpt;
        this.createClusterLinkPolicyOpt = createClusterLinkPolicyOpt;
        Logging.$init$(this);
    }
}

