/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import kafka.utils.Logging;
import org.apache.kafka.image.ConfluentKeyValueStreamsDelta;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LoaderManifestType;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.InternalTopicType;
import org.apache.kafka.metadata.authorizer.AuthorizerExternalUpdater;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005q4A\u0001D\u0007\u0001)!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000b9\u0003A\u0011A(\t\u000bY\u0003A\u0011I,\t\u000fa\u0003\u0001\u0019!C\u00053\"9Q\f\u0001a\u0001\n\u0013q\u0006B\u00023\u0001A\u0003&!\fC\u0003f\u0001\u0011\u0005c\rC\u0003{\u0001\u0011\u00053PA\u0011D_:4G.^3oi.+\u0017PV1mk\u0016\u001cFO]3b[N\u0004VO\u00197jg\",'O\u0003\u0002\u000f\u001f\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u0011#\u000511/\u001a:wKJT\u0011AE\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001QcG\u0011\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\tar$D\u0001\u001e\u0015\tq\u0012#A\u0003vi&d7/\u0003\u0002!;\t9Aj\\4hS:<\u0007C\u0001\u0012-\u001b\u0005\u0019#B\u0001\u0013&\u0003%\u0001XO\u00197jg\",'O\u0003\u0002'O\u0005)\u0011.\\1hK*\u0011!\u0003\u000b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.G\t\tR*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u0002\r9|G-Z%e!\t1\u0002'\u0003\u00022/\t\u0019\u0011J\u001c;\u0002\u00119|G-\u001a+za\u0016\u0004\"\u0001N\u001e\u000f\u0005UJ\u0004C\u0001\u001c\u0018\u001b\u00059$B\u0001\u001d\u0014\u0003\u0019a$o\\8u}%\u0011!hF\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;/\u0005aa-Y;mi\"\u000bg\u000e\u001a7feB\u0011\u0001\tR\u0007\u0002\u0003*\u0011!iQ\u0001\u0006M\u0006,H\u000e\u001e\u0006\u0003!\u001dJ!!R!\u0003\u0019\u0019\u000bW\u000f\u001c;IC:$G.\u001a:\u0002'I\u0014\u0017m\u0019)s_ZLG-\u001a:Va\u0012\fG/\u001a:\u0011\u0005!cU\"A%\u000b\u0005)[\u0015AC1vi\"|'/\u001b>fe*\u0011abJ\u0005\u0003\u001b&\u0013\u0011$Q;uQ>\u0014\u0018N_3s\u000bb$XM\u001d8bYV\u0003H-\u0019;fe\u00061A(\u001b8jiz\"R\u0001\u0015*T)V\u0003\"!\u0015\u0001\u000e\u00035AQAL\u0003A\u0002=BQAM\u0003A\u0002MBQAP\u0003A\u0002}BQAR\u0003A\u0002\u001d\u000bAA\\1nKR\t1'\u0001\u000bd_6\u0004H.\u001a;fI&s\u0017\u000e^5bY2{\u0017\rZ\u000b\u00025B\u0011acW\u0005\u00039^\u0011qAQ8pY\u0016\fg.\u0001\rd_6\u0004H.\u001a;fI&s\u0017\u000e^5bY2{\u0017\rZ0%KF$\"a\u00182\u0011\u0005Y\u0001\u0017BA1\u0018\u0005\u0011)f.\u001b;\t\u000f\rD\u0011\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\u0002+\r|W\u000e\u001d7fi\u0016$\u0017J\\5uS\u0006dGj\\1eA\u0005\u0001rN\\'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a\u000b\u0005?\u001el'\u000fC\u0003i\u0015\u0001\u0007\u0011.A\u0003eK2$\u0018\r\u0005\u0002kW6\tQ%\u0003\u0002mK\tiQ*\u001a;bI\u0006$\u0018\rR3mi\u0006DQA\u001c\u0006A\u0002=\f\u0001B\\3x\u00136\fw-\u001a\t\u0003UBL!!]\u0013\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0011\u0015\u0019(\u00021\u0001u\u0003!i\u0017M\\5gKN$\bCA;y\u001b\u00051(BA<&\u0003\u0019aw.\u00193fe&\u0011\u0011P\u001e\u0002\u000f\u0019>\fG-\u001a:NC:Lg-Z:u\u0003\u0015\u0019Gn\\:f)\u0005y\u0006")
public class ConfluentKeyValueStreamsPublisher
implements Logging,
MetadataPublisher {
    private final int nodeId;
    private final String nodeType;
    private final FaultHandler faultHandler;
    private final AuthorizerExternalUpdater rbacProviderUpdater;
    private boolean completedInitialLoad;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public void onControllerChange(LeaderAndEpoch newLeaderAndEpoch) {
        MetadataPublisher.super.onControllerChange(newLeaderAndEpoch);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConfluentKeyValueStreamsPublisher confluentKeyValueStreamsPublisher = this;
        synchronized (confluentKeyValueStreamsPublisher) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String name() {
        return "ConfluentInternalKeyValueStreams MetadataPublisher " + this.nodeType + " id=" + this.nodeId;
    }

    private boolean completedInitialLoad() {
        return this.completedInitialLoad;
    }

    private void completedInitialLoad_$eq(boolean x$1) {
        this.completedInitialLoad = x$1;
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        String name = "MetadataUpdate up to " + newImage.offset();
        Option$.MODULE$.apply(delta.confluentKeyValueStreamsDelta()).foreach((Function1<ConfluentKeyValueStreamsDelta, Object> & Serializable)kvDelta -> {
            Serializable serializable;
            if (manifest.type().equals((Object)LoaderManifestType.SNAPSHOT)) {
                Serializable serializable2;
                try {
                    this.info((Function0<String> & Serializable)() -> "loading confluent key value snapshot at offset=" + newImage.offset() + " topicTypeOffset=" + newImage.confluentKeyValueStreams().topicTypeOffset());
                    if (!this.completedInitialLoad()) {
                        Map<String, String> map = newImage.confluentKeyValueStreams().topicTypeKv().get(BoxesRunTime.boxToShort(InternalTopicType.RBAC_AUTH.value()));
                        if (map != null) {
                            map.forEach((x0$1, x1$1) -> {
                                Tuple2<String, String> tuple2 = new Tuple2<String, String>((String)x0$1, (String)x1$1);
                                if (tuple2 != null) {
                                    String k = tuple2._1();
                                    String v = tuple2._2();
                                    $this.rbacProviderUpdater.updateAuthCacheExternally(k, v);
                                    return;
                                }
                                throw new MatchError(tuple2);
                            });
                        }
                        this.info((Function0<String> & Serializable)() -> "complete initial load for confluent provider");
                        $this.rbacProviderUpdater.completeInitialLoad();
                    }
                    this.completedInitialLoad_$eq(true);
                    serializable2 = BoxedUnit.UNIT;
                }
                catch (Throwable t) {
                    serializable2 = $this.faultHandler.handleFault("Error loading confluent key value stream snapshot in " + name, t);
                }
                return serializable2;
            }
            try {
                this.info((Function0<String> & Serializable)() -> "Updating confluent key value stream delta " + newImage.offset() + "  kvChange " + delta.confluentKeyValueStreamsDelta().keyValueStreamsChanges());
                Map<String, String> map = kvDelta.keyValueStreamsChanges().get(BoxesRunTime.boxToShort(InternalTopicType.RBAC_AUTH.value()));
                map.forEach((x0$2, x1$2) -> {
                    Tuple2<String, String> tuple2 = new Tuple2<String, String>((String)x0$2, (String)x1$2);
                    if (tuple2 != null) {
                        String k = tuple2._1();
                        String v = tuple2._2();
                        $this.rbacProviderUpdater.updateAuthCacheExternally(k, v);
                        return;
                    }
                    throw new MatchError(tuple2);
                });
                serializable = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                serializable = $this.faultHandler.handleFault("Error loading confluent key value stream changes in " + name, t);
            }
            return serializable;
        });
    }

    @Override
    public void close() {
    }

    public ConfluentKeyValueStreamsPublisher(int nodeId, String nodeType, FaultHandler faultHandler, AuthorizerExternalUpdater rbacProviderUpdater) {
        this.nodeId = nodeId;
        this.nodeType = nodeType;
        this.faultHandler = faultHandler;
        this.rbacProviderUpdater = rbacProviderUpdater;
        Logging.$init$(this);
        this.logIdent_$eq("[" + this.name() + "] ");
        this.completedInitialLoad = false;
    }
}

