/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.util.Collections;
import java.util.List;
import kafka.tier.fetcher.ReclaimableMemoryRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.storage.internals.log.AbortedTxn;

public class TierFetchResult {
    public final ReclaimableMemoryRecords records;
    public final Throwable exception;
    public final List<AbortedTxn> abortedTxns;
    public final long fetchTotalTimeNanos;

    public TierFetchResult(ReclaimableMemoryRecords records, List<AbortedTxn> abortedTxns, Throwable exception, long fetchTotalTimeNanos) {
        this.records = records;
        this.abortedTxns = abortedTxns;
        this.exception = exception;
        this.fetchTotalTimeNanos = fetchTotalTimeNanos;
    }

    public static TierFetchResult emptyFetchResult() {
        return new TierFetchResult(ReclaimableMemoryRecords.EMPTY, Collections.emptyList(), null, 0L);
    }

    public boolean isEmpty() {
        return this.records == MemoryRecords.EMPTY;
    }

    public String toString() {
        return "TierFetchResult(records: " + String.valueOf(this.records) + ", abortedTxns: " + String.valueOf(this.abortedTxns) + ", exception: " + String.valueOf(this.exception) + ", fetchTotalTimeNanos: " + this.fetchTotalTimeNanos + ")";
    }
}

