/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.store.OpaqueData;
import io.confluent.kafka.storage.tier.store.objects.FragmentLocation;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.TierSegmentUpload;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.server.ReplicaManager;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.encryption.KeySha;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;
import org.apache.kafka.common.utils.Lazy;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;

public abstract class TierObjectStore {
    private static final int EXECUTOR_THREAD_NUM = 8;
    private final Lazy<ExecutorService> executorService = new Lazy();

    public abstract String keyPrefix();

    public abstract Backend getBackend();

    public abstract BucketHealthResult checkBucketHealth();

    public abstract Map<String, List<VersionInformation>> listObject(String var1, boolean var2);

    public CompletableFuture<Map<String, List<VersionInformation>>> listObjectAsync(String keyPrefix, boolean getVersionInfo) {
        return this.asyncFutureWrapper(() -> this.listObject(keyPrefix, getVersionInfo));
    }

    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long relativeByteOffsetStart, Long relativeByteOffsetEndExclusive, VersionInformation versionInformation) throws IOException {
        TierObjectStore.validateRelativeOffsets(relativeByteOffsetStart, relativeByteOffsetEndExclusive);
        FragmentLocation fragmentLocation = objectMetadata.toFragmentLocation(this.keyPrefix(), fragmentType).orElseThrow(() -> new IllegalArgumentException(String.format("FragmentType %s is not present in the given objectMetadata%s", new Object[]{fragmentType, objectMetadata})));
        long absoluteStartOffset = fragmentLocation.toByteOffsetStartInObject(relativeByteOffsetStart);
        Long absoluteEndOffsetExclusive = fragmentLocation.toByteOffsetEndExclusiveInObject(relativeByteOffsetEndExclusive);
        if (absoluteEndOffsetExclusive != null && absoluteEndOffsetExclusive == absoluteStartOffset) {
            TierObjectAttribute objectAttributes = this.objectExists(objectMetadata, fragmentLocation.objectType());
            if (!objectAttributes.exist) {
                throw new TierObjectStoreRetriableException(String.format("Object %s not found in objectStore while attempting to check existence during fetch of empty range", fragmentLocation.objectPath()));
            }
            if (objectAttributes.size >= 0L && objectAttributes.size < absoluteStartOffset) {
                throw new TierObjectStoreRetriableException(String.format("Attempted to fetch empty range starting from invalid start offset %d from object %s. Actual object size: %d", absoluteStartOffset, fragmentLocation.objectPath(), objectAttributes.size));
            }
            return new TierObjectStoreResponse.EmptyTierObjectStoreResponse();
        }
        return this.getObject(objectMetadata, fragmentLocation.objectType(), absoluteStartOffset, absoluteEndOffsetExclusive, versionInformation);
    }

    static void validateRelativeOffsets(Long relativeByteOffsetStart, Long relativeByteOffsetEndExclusive) {
        if (relativeByteOffsetStart == null && relativeByteOffsetEndExclusive != null) {
            throw new IllegalArgumentException("Cannot specify a relativeByteOffsetEndExclusive without specifying a relativeByteOffsetStart");
        }
        if (relativeByteOffsetStart != null && relativeByteOffsetStart < 0L) {
            throw new IllegalArgumentException("relativeByteOffsetStart cannot be negative");
        }
        if (relativeByteOffsetEndExclusive != null && relativeByteOffsetEndExclusive <= 0L) {
            throw new IllegalArgumentException("relativeByteOffsetEndExclusive must be greater than 0");
        }
        if (relativeByteOffsetEndExclusive != null && relativeByteOffsetStart > relativeByteOffsetEndExclusive) {
            throw new IllegalArgumentException(String.format("relativeByteOffsetStart=%s cannot be greater than relativeByteOffsetEndExclusive=%s", relativeByteOffsetStart, relativeByteOffsetEndExclusive));
        }
    }

    private <T> CompletableFuture<T> asyncFutureWrapper(Callable<T> func) {
        ExecutorService executor = this.executorService.getOrCompute(() -> Executors.newFixedThreadPool(8));
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> {
            try {
                future.complete(func.call());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    protected abstract TierObjectStoreResponse getObject(ObjectStoreMetadata var1, ObjectType var2, Long var3, Long var4, VersionInformation var5) throws IOException;

    public CompletableFuture<TierObjectStoreResponse> getObjectStoreFragmentAsync(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long relativeByteOffsetStart, Long relativeByteOffsetEndExclusive, VersionInformation versionInformation) {
        TierObjectStore.validateRelativeOffsets(relativeByteOffsetStart, relativeByteOffsetEndExclusive);
        FragmentLocation fragmentLocation = objectMetadata.toFragmentLocation(this.keyPrefix(), fragmentType).orElseThrow(() -> new IllegalArgumentException(String.format("FragmentType %s is not present in the given objectMetadata %s", new Object[]{fragmentType, objectMetadata})));
        long absoluteStartOffset = fragmentLocation.toByteOffsetStartInObject(relativeByteOffsetStart);
        Long absoluteEndOffsetExclusive = fragmentLocation.toByteOffsetEndExclusiveInObject(relativeByteOffsetEndExclusive);
        if (absoluteEndOffsetExclusive != null && absoluteEndOffsetExclusive == absoluteStartOffset) {
            return this.objectExistsAsync(objectMetadata, fragmentLocation.objectType()).thenApply(objectAttributes -> {
                if (!objectAttributes.exist) {
                    throw new TierObjectStoreRetriableException(String.format("Object %s not found in objectStore while attempting to check existence during fetch of empty range", fragmentLocation.objectPath()));
                }
                if (objectAttributes.size >= 0L && objectAttributes.size < absoluteStartOffset) {
                    throw new TierObjectStoreRetriableException(String.format("Attempted to fetch empty range starting from invalid start offset %d from object %s. Actual object size: %d", absoluteStartOffset, fragmentLocation.objectPath(), objectAttributes.size));
                }
                return new TierObjectStoreResponse.EmptyTierObjectStoreResponse();
            });
        }
        return this.getObjectAsync(objectMetadata, fragmentLocation.objectType(), absoluteStartOffset, absoluteEndOffsetExclusive, versionInformation);
    }

    protected CompletableFuture<TierObjectStoreResponse> getObjectAsync(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        return this.asyncFutureWrapper(() -> this.getObject(objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive, versionInformation));
    }

    protected CompletableFuture<TierObjectAttribute> objectExistsAsync(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        return this.asyncFutureWrapper(() -> this.objectExists(objectMetadata, objectType));
    }

    public abstract ByteBuffer getSnapshot(ObjectStoreMetadata var1, FragmentType var2, int var3);

    public CompletableFuture<ByteBuffer> getSnapshotAsync(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        return this.asyncFutureWrapper(() -> this.getSnapshot(metadata, fragmentType, estimatedBufferSize));
    }

    public static Set<ObjectType> getObjectTypesPerSegment() {
        HashSet<ObjectType> objectTypesPerSegment = new HashSet<ObjectType>();
        objectTypesPerSegment.add(ObjectType.SEGMENT);
        objectTypesPerSegment.add(ObjectType.OFFSET_INDEX);
        objectTypesPerSegment.add(ObjectType.TIMESTAMP_INDEX);
        objectTypesPerSegment.add(ObjectType.PRODUCER_STATE);
        objectTypesPerSegment.add(ObjectType.TRANSACTION_INDEX);
        objectTypesPerSegment.add(ObjectType.EPOCH_STATE);
        return objectTypesPerSegment;
    }

    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffsetStart, Long byteOffsetEndExclusive) throws IOException {
        return this.getObjectStoreFragment(objectMetadata, fragmentType, byteOffsetStart, byteOffsetEndExclusive, null);
    }

    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffsetStart) throws IOException {
        return this.getObjectStoreFragment(objectMetadata, fragmentType, byteOffsetStart, null, null);
    }

    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType) throws IOException {
        return this.getObjectStoreFragment(objectMetadata, fragmentType, null);
    }

    public CompletableFuture<TierObjectStoreResponse> getObjectStoreFragmentAsync(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffsetStart, Long byteOffsetEndExclusive) {
        return this.getObjectStoreFragmentAsync(objectMetadata, fragmentType, byteOffsetStart, byteOffsetEndExclusive, null);
    }

    public CompletableFuture<TierObjectStoreResponse> getObjectStoreFragmentAsync(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffsetStart) {
        return this.getObjectStoreFragmentAsync(objectMetadata, fragmentType, byteOffsetStart, null, null);
    }

    public CompletableFuture<TierObjectStoreResponse> getObjectStoreFragmentAsync(ObjectStoreMetadata objectMetadata, FragmentType fragmentType) {
        return this.getObjectStoreFragmentAsync(objectMetadata, fragmentType, null);
    }

    public abstract ByokKeyHolder prepPutSegment(TopicIdPartition var1) throws TierObjectStoreRetriableException, IOException;

    public abstract String putObject(ObjectStoreMetadata var1, File var2, ObjectType var3) throws TierObjectStoreRetriableException, IOException;

    public CompletableFuture<String> putObjectAsync(ObjectStoreMetadata objectMetadata, File file, ObjectType type) {
        return this.asyncFutureWrapper(() -> this.putObject(objectMetadata, file, type));
    }

    public abstract String putBuffer(ObjectStoreMetadata var1, ByteBuffer var2, ObjectType var3) throws TierObjectStoreRetriableException, IOException;

    public CompletableFuture<String> putBufferAsync(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType type) {
        return this.asyncFutureWrapper(() -> this.putBuffer(objectMetadata, buffer, type));
    }

    public abstract void restoreObjectByCopy(ObjectMetadata var1, String var2, VersionInformation var3);

    public CompletableFuture<Void> restoreObjectByCopyAsync(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        return this.asyncFutureWrapper(() -> {
            this.restoreObjectByCopy(objectMetadata, key, lastLiveVersion);
            return null;
        });
    }

    public abstract void putSegment(TierSegmentUpload<?> var1) throws TierObjectStoreRetriableException, IOException;

    public CompletableFuture<Void> putSegmentAsync(TierSegmentUpload<?> tierSegmentUpload) {
        return this.asyncFutureWrapper(() -> {
            this.putSegment(tierSegmentUpload);
            return null;
        });
    }

    public abstract void deleteSegment(ObjectMetadata var1) throws IOException;

    public CompletableFuture<Void> deleteSegmentAsync(ObjectMetadata objectMetadata) {
        return this.asyncFutureWrapper(() -> {
            this.deleteSegment(objectMetadata);
            return null;
        });
    }

    public abstract void deleteVersions(List<KeyAndVersion> var1);

    public CompletableFuture<Void> deleteVersionsAsync(List<KeyAndVersion> keys) {
        return this.asyncFutureWrapper(() -> {
            this.deleteVersions(keys);
            return null;
        });
    }

    public abstract TierObjectAttribute objectExists(ObjectStoreMetadata var1, ObjectType var2) throws IOException;

    public void close() {
        ExecutorService executor = this.executorService.get();
        if (executor != null) {
            executor.shutdown();
        }
    }

    public abstract Optional<TenantAwareEncryptionKeyManager> initMultiTenantEncryptionSupport(MultiTenantMetadata var1, ReplicaManager var2);

    static boolean isEncryptedObject(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        return !objectMetadata.opaqueData().isEmpty() && (objectType.equals((Object)ObjectType.SEGMENT) || objectType.equals((Object)ObjectType.SEGMENT_WITH_METADATA));
    }

    public static class ByokKeyHolder {
        public final OpaqueData opaqueData;
        public final ByteBuffer encryptedDek;

        public ByokKeyHolder(OpaqueData opaqueData, ByteBuffer encryptedDek) {
            this.opaqueData = opaqueData;
            this.encryptedDek = encryptedDek;
        }

        public static ByokKeyHolder defaultByokKeyHolder() {
            return new ByokKeyHolder(OpaqueData.ZEROED, null);
        }

        public KeySha keySha() {
            return KeySha.fromRawBytes(this.opaqueData.intoByteArray());
        }

        public int hashCode() {
            return Objects.hash(this.opaqueData, this.encryptedDek);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ByokKeyHolder that = (ByokKeyHolder)obj;
            return Objects.equals(this.opaqueData, that.opaqueData) && Objects.equals(this.encryptedDek, that.encryptedDek);
        }
    }

    public static class KeyAndVersion {
        private final String key;
        private final String versionId;

        public KeyAndVersion(String key) {
            this.key = key;
            this.versionId = null;
        }

        public KeyAndVersion(String key, String versionId) {
            this.key = key;
            this.versionId = versionId;
        }

        public String key() {
            return this.key;
        }

        public String versionId() {
            return this.versionId;
        }

        public String toString() {
            String m = "Key: " + this.key();
            if (this.versionId() != null) {
                m = m + " VersionId: " + this.versionId();
            }
            return m;
        }
    }

    public static enum Backend {
        AzureBlockBlob("AzureBlockBlob"),
        GCS("GCS"),
        Mock("Mock"),
        S3("S3"),
        Test("Test");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Backend(String name) {
            this.name = name;
        }
    }
}

