/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStoreRetryPolicy;

public class TierObjectStoreLinearRetry
implements TierObjectStoreRetryPolicy {
    private int maxRetryCount;
    private long retryIntervalInMs;

    public TierObjectStoreLinearRetry(int maxRetryCount, long retryInterval) {
        this.maxRetryCount = maxRetryCount;
        this.retryIntervalInMs = retryInterval;
    }

    @Override
    public TierObjectStoreRetryPolicy.RetryInfo shouldRetry(Exception exception, int currentRetryCount) {
        if (!(exception instanceof TierObjectStoreRetriableException)) {
            return new TierObjectStoreRetryPolicy.RetryInfo(false, -1L);
        }
        if (currentRetryCount > this.maxRetryCount) {
            return new TierObjectStoreRetryPolicy.RetryInfo(false, -1L);
        }
        return new TierObjectStoreRetryPolicy.RetryInfo(true, this.retryIntervalInMs);
    }
}

