/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.TierSegmentUpload;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kafka.server.ReplicaManager;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreMetrics;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;

public class TierObjectStoreMetricsEnabled
extends TierObjectStore {
    private TierObjectStore inner;
    private TierObjectStoreMetrics tierObjectStoreMetrics;
    private Time time;

    public TierObjectStoreMetricsEnabled(TierObjectStore inner, Metrics metrics, Time time) {
        this.inner = inner;
        this.tierObjectStoreMetrics = new TierObjectStoreMetrics(metrics);
        this.time = time;
    }

    @Override
    public String keyPrefix() {
        return this.inner.keyPrefix();
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return this.inner.getBackend();
    }

    @Override
    public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
        long startTime = this.time.milliseconds();
        Map<String, List<VersionInformation>> objList = this.inner.listObject(keyPrefix, getVersionInfo);
        long endTime = this.time.milliseconds();
        this.tierObjectStoreMetrics.listLatency().record(endTime - startTime);
        return objList;
    }

    @Override
    public CompletableFuture<Map<String, List<VersionInformation>>> listObjectAsync(String keyPrefix, boolean getVersionInfo) {
        return this.inner.listObjectAsync(keyPrefix, getVersionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long relativeByteOffsetStart, Long relativeByteOffsetEndExclusive, VersionInformation versionInformation) throws IOException {
        this.recordFetchMetrics(fragmentType);
        long startTime = this.time.milliseconds();
        try {
            TierObjectStoreResponse tierObjectStoreResponse = this.inner.getObjectStoreFragment(objectMetadata, fragmentType, relativeByteOffsetStart, relativeByteOffsetEndExclusive, versionInformation);
            return tierObjectStoreResponse;
        }
        finally {
            long endTime = this.time.milliseconds();
            this.tierObjectStoreMetrics.getLatency().record(endTime - startTime);
        }
    }

    @Override
    public CompletableFuture<TierObjectStoreResponse> getObjectStoreFragmentAsync(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffset, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        this.recordFetchMetrics(fragmentType);
        return this.inner.getObjectStoreFragmentAsync(objectMetadata, fragmentType, byteOffset, byteOffsetEndExclusive, versionInformation);
    }

    private void recordFetchMetrics(FragmentType fragmentType) {
        switch (fragmentType) {
            case SEGMENT: {
                this.tierObjectStoreMetrics.segmentFetched().record();
                break;
            }
            case OFFSET_INDEX: {
                this.tierObjectStoreMetrics.offsetIndexFetched().record();
                break;
            }
            case TIMESTAMP_INDEX: {
                this.tierObjectStoreMetrics.timestampIndexFetched().record();
                break;
            }
            case TRANSACTION_INDEX: {
                this.tierObjectStoreMetrics.transactionIndexFetched().record();
                break;
            }
            case PRODUCER_STATE: {
                this.tierObjectStoreMetrics.producerStateFetched().record();
                break;
            }
            case EPOCH_STATE: {
                this.tierObjectStoreMetrics.epochStateFetched().record();
                break;
            }
            case TIER_STATE_SNAPSHOT: {
                this.tierObjectStoreMetrics.tierStateFetched().record();
            }
        }
    }

    @Override
    public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) throws IOException {
        return this.inner.getObject(objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive, versionInformation);
    }

    @Override
    public ByteBuffer getSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        return this.inner.getSnapshot(metadata, fragmentType, estimatedBufferSize);
    }

    @Override
    public CompletableFuture<ByteBuffer> getSnapshotAsync(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        return this.inner.getSnapshotAsync(metadata, fragmentType, estimatedBufferSize);
    }

    @Override
    public TierObjectStore.ByokKeyHolder prepPutSegment(TopicIdPartition topicIdPartition) throws TierObjectStoreRetriableException, IOException {
        return this.inner.prepPutSegment(topicIdPartition);
    }

    @Override
    public String putObject(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) throws TierObjectStoreRetriableException, IOException {
        return this.inner.putObject(objectMetadata, file, objectType);
    }

    @Override
    public CompletableFuture<String> putObjectAsync(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) {
        return this.inner.putObjectAsync(objectMetadata, file, objectType);
    }

    @Override
    public String putBuffer(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) throws TierObjectStoreRetriableException, IOException {
        return this.inner.putBuffer(objectMetadata, buffer, objectType);
    }

    @Override
    public CompletableFuture<String> putBufferAsync(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) {
        return this.inner.putBufferAsync(objectMetadata, buffer, objectType);
    }

    @Override
    public void restoreObjectByCopy(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        this.inner.restoreObjectByCopy(objectMetadata, key, lastLiveVersion);
    }

    @Override
    public CompletableFuture<Void> restoreObjectByCopyAsync(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        return this.inner.restoreObjectByCopyAsync(objectMetadata, key, lastLiveVersion);
    }

    @Override
    public void putSegment(TierSegmentUpload<?> tierSegmentUpload) throws TierObjectStoreRetriableException, IOException {
        long startTime = this.time.milliseconds();
        this.inner.putSegment(tierSegmentUpload);
        long endTime = this.time.milliseconds();
        this.recordUploadMetrics(endTime - startTime, tierSegmentUpload);
    }

    @Override
    public CompletableFuture<Void> putSegmentAsync(TierSegmentUpload<?> tierSegmentUpload) {
        long startTime = this.time.milliseconds();
        CompletableFuture<Void> result = this.inner.putSegmentAsync(tierSegmentUpload);
        result.thenApply(res -> {
            long endTime = this.time.milliseconds();
            this.recordUploadMetrics(endTime - startTime, tierSegmentUpload);
            return null;
        });
        return result;
    }

    private void recordUploadMetrics(long latency, TierSegmentUpload<?> tierSegmentUpload) {
        this.tierObjectStoreMetrics.putLatency().record(latency);
        int totalObjects = 0;
        switch (tierSegmentUpload.putMode()) {
            case CombinedObject: {
                totalObjects = 1;
                break;
            }
            case LegacyMultiObject: {
                totalObjects = 3;
                if (tierSegmentUpload.producerStateSnapshotOpt().isPresent()) {
                    ++totalObjects;
                }
                if (tierSegmentUpload.txnIdxOpt().isPresent()) {
                    ++totalObjects;
                }
                if (!tierSegmentUpload.epochStateOpt().isPresent()) break;
                ++totalObjects;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown segment PUT mode: " + String.valueOf((Object)tierSegmentUpload.putMode()));
            }
        }
        this.tierObjectStoreMetrics.segmentObjectsUploaded().record(totalObjects);
    }

    @Override
    public void deleteSegment(ObjectMetadata objectMetadata) throws IOException {
        long startTime = this.time.milliseconds();
        this.inner.deleteSegment(objectMetadata);
        long endTime = this.time.milliseconds();
        this.tierObjectStoreMetrics.deleteLatency().record(endTime - startTime);
    }

    @Override
    public CompletableFuture<Void> deleteSegmentAsync(ObjectMetadata objectMetadata) {
        long startTime = this.time.milliseconds();
        CompletableFuture<Void> future = this.inner.deleteSegmentAsync(objectMetadata);
        future.thenApply(res -> {
            long endTime = this.time.milliseconds();
            this.tierObjectStoreMetrics.deleteLatency().record(endTime - startTime);
            return null;
        });
        return future;
    }

    @Override
    public BucketHealthResult checkBucketHealth() {
        long startTime = this.time.milliseconds();
        BucketHealthResult result = this.inner.checkBucketHealth();
        this.tierObjectStoreMetrics.checkBucketHealthLatency().record(this.time.milliseconds() - startTime);
        return result;
    }

    @Override
    public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
        this.inner.deleteVersions(keys);
        this.tierObjectStoreMetrics.objectVersionsDeleted().record(keys.size());
    }

    @Override
    public CompletableFuture<Void> deleteVersionsAsync(List<TierObjectStore.KeyAndVersion> keys) {
        return this.inner.deleteVersionsAsync(keys);
    }

    @Override
    public TierObjectAttribute objectExists(ObjectStoreMetadata objectMetadata, ObjectType type) throws TierObjectStoreRetriableException, IOException {
        long startTime = this.time.milliseconds();
        TierObjectAttribute attr = this.inner.objectExists(objectMetadata, type);
        long endTime = this.time.milliseconds();
        this.tierObjectStoreMetrics.objectExistsLatency().record(endTime - startTime);
        return attr;
    }

    @Override
    public CompletableFuture<TierObjectAttribute> objectExistsAsync(ObjectStoreMetadata objectMetadata, ObjectType type) {
        return this.inner.objectExistsAsync(objectMetadata, type);
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public Optional<TenantAwareEncryptionKeyManager> initMultiTenantEncryptionSupport(MultiTenantMetadata multiTenantMetadata, ReplicaManager replicaManager) {
        return this.inner.initMultiTenantEncryptionSupport(multiTenantMetadata, replicaManager);
    }
}

