/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.state.TierPartitionState;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.server.ReplicaManager;
import kafka.tier.store.encryption.EncryptionKeyCacheRefiller;

public class FtpsEncryptionKeyCacheRefiller
implements EncryptionKeyCacheRefiller<Void> {
    private final ReplicaManager replicaManager;

    public FtpsEncryptionKeyCacheRefiller(ReplicaManager replicaManager) {
        this.replicaManager = replicaManager;
    }

    @Override
    public ByteBuffer get(String logicalClusterId, TopicIdPartition topicIdPartition, UUID objectId, Optional<Void> objectSpecificMetadataOpt) {
        Optional<ByteBuffer> encryptedDataKeyOpt;
        TierPartitionState tierPartitionState = (TierPartitionState)this.replicaManager.logManager().getLog(topicIdPartition.topicPartition(), false).map(AbstractLog::tierPartitionState).getOrElse(null);
        if (tierPartitionState != null && (encryptedDataKeyOpt = tierPartitionState.getEncryptedDek(objectId)).isPresent()) {
            return encryptedDataKeyOpt.get();
        }
        return null;
    }
}

