/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import com.google.common.io.BaseEncoding;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import kafka.tier.store.encryption.CleartextDataKey;

public final class KeySha {
    private static final String MESSAGE_DIGEST = "SHA-256";
    private final byte[] keySha;

    KeySha(CleartextDataKey cleartextDataKey) {
        byte[] decryptedKeyMaterial = cleartextDataKey.rawKeyMaterial();
        try {
            MessageDigest digest = MessageDigest.getInstance(MESSAGE_DIGEST);
            this.keySha = digest.digest(decryptedKeyMaterial);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("SHA-256 message digest is not available", e);
        }
    }

    KeySha(byte[] keySha) {
        this.keySha = keySha;
    }

    public String base64Encoded() {
        BaseEncoding encoding = BaseEncoding.base64();
        return encoding.encode(this.keySha);
    }

    public byte[] toRawBytes() {
        return (byte[])this.keySha.clone();
    }

    static KeySha fromBase64Encoded(String base64EncodedKeySha) {
        BaseEncoding encoding = BaseEncoding.base64();
        byte[] keySha = encoding.decode(base64EncodedKeySha);
        return new KeySha(keySha);
    }

    public static KeySha fromRawBytes(byte[] bytes) {
        return new KeySha(bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeySha keySha1 = (KeySha)o;
        return Arrays.equals(this.keySha, keySha1.keySha);
    }

    public int hashCode() {
        return Arrays.hashCode(this.keySha);
    }

    public String toString() {
        return "KeySha{keyShaBase64=" + this.base64Encoded() + "}";
    }
}

