/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import kafka.tier.TierReplicaManager;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;

public class ProactiveKeyGenerationChangeManager
implements TierReplicaManager.ChangeListener {
    private final TenantAwareEncryptionKeyManager tenantAwareEncryptionKeyManager;

    public ProactiveKeyGenerationChangeManager(TenantAwareEncryptionKeyManager tenantAwareEncryptionKeyManager) {
        this.tenantAwareEncryptionKeyManager = tenantAwareEncryptionKeyManager;
    }

    @Override
    public void onBecomeLeader(TopicIdPartition topicIdPartition, int leaderEpoch) {
        this.tenantAwareEncryptionKeyManager.scheduleProactiveKeyGenerationForTopicIdPartition(topicIdPartition, "on-leader-assignment");
    }

    @Override
    public void onBecomeFollower(TopicIdPartition topicIdPartition) {
        this.tenantAwareEncryptionKeyManager.scheduleProactiveKeyGenerationForTopicIdPartition(topicIdPartition, "on-follower-assignment");
    }

    @Override
    public void onDelete(TopicIdPartition topicIdPartition) {
    }
}

