/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import io.confluent.kafka.storage.tier.store.DataTypePathPrefix;
import io.confluent.kafka.storage.tier.store.OpaqueData;
import io.confluent.kafka.storage.tier.store.objects.FragmentLocation;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class LifecycleManagerStateMetadata
implements ObjectStoreMetadata {
    private String clusterId;

    public LifecycleManagerStateMetadata(String clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.LIFECYCLE_MANAGER_STATE) {
            throw new UnsupportedOperationException(String.format("LifecycleManagerStateMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return keyPrefix + DataTypePathPrefix.LIFECYCLE_MANAGER_STATE.prefix + "/" + this.clusterId + "." + objectType.suffix();
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("clusterId", this.clusterId());
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    public String toString() {
        return "LifecycleManagerStateMetadata(clusterId=" + this.clusterId + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }
}

