/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.TierTask;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.AbstractIterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005eh!\u0002\u0010 \u0003\u00031\u0003\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011C\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\u0006)\u0002!\t!\u0016\u0005\u0006M\u0002!\te\u001a\u0005\bA\u0001\u0001\r\u0011\"\u0003t\u0011\u001da\b\u00011A\u0005\nuDq!a\u0002\u0001A\u0003&A\u000fC\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u00111\t\u0001!\u0002\u0013\t)\u0002C\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u0011q\t\u0001!\u0002\u0013\t)\u0002\u0003\u0005\u0002J\u0001\u0001\r\u0011\"\u0003t\u0011%\tY\u0005\u0001a\u0001\n\u0013\ti\u0005C\u0004\u0002R\u0001\u0001\u000b\u0015\u0002;\t\u0011\u0005M\u0003\u0001\"\u0005 \u0003+B\u0001\"a\u0016\u0001\r#y\u0012\u0011\f\u0005\t\u0003_\u0002a\u0011C\u0010\u0002r!A\u0011\u0011\u0011\u0001\u0007\u0012}\t\u0019\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003o\u0003A\u0011AA]\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002d\u0002!\t%!:\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"9\u0011Q\u001e\u0001\u0005\n\u0005=(!\u0004+jKJ$\u0016m]6Rk\u0016,XM\u0003\u0002!C\u0005)A/Y:lg*\u0011!eI\u0001\u0005i&,'OC\u0001%\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"a\n.\u0014\t\u0001Ac\u0006\u000e\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\u001a\u0013!B;uS2\u001c\u0018BA\u001a1\u0005\u001daunZ4j]\u001e\u0004\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\t1\fgn\u001a\u0006\u0002s\u0005!!.\u0019<b\u0013\tYdGA\u0007BkR|7\t\\8tK\u0006\u0014G.Z\u0001\u0004GRD\bC\u0001 B\u001b\u0005y$B\u0001!\"\u0003\u001d1W\r^2iKJL!AQ \u0003'\r\u000bgnY3mY\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u00115\f\u0007\u0010V1tWN\u0004\"!K#\n\u0005\u0019S#aA%oi\u0006!A/[7f!\tI%+D\u0001K\u0015\t\t4J\u0003\u0002M\u001b\u000611m\\7n_:T!\u0001\n(\u000b\u0005=\u0003\u0016AB1qC\u000eDWMC\u0001R\u0003\ry'oZ\u0005\u0003'*\u0013A\u0001V5nK\u00061A(\u001b8jiz\"BAV2eKB\u0019q\u000b\u0001-\u000e\u0003}\u0001\"!\u0017.\r\u0001\u0011)1\f\u0001b\u00019\n\tA+\u0005\u0002^AB\u0011\u0011FX\u0005\u0003?*\u0012qAT8uQ&tw\rE\u0002XCbK!AY\u0010\u0003\u0011QKWM\u001d+bg.DQ\u0001\u0010\u0003A\u0002uBQa\u0011\u0003A\u0002\u0011CQa\u0012\u0003A\u0002!\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\u0005A\u0007CA5q\u001d\tQg\u000e\u0005\u0002lU5\tAN\u0003\u0002nK\u00051AH]8pizJ!a\u001c\u0016\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_**\u0012\u0001\u001e\t\u0004kjDV\"\u0001<\u000b\u0005]D\u0018!C5n[V$\u0018M\u00197f\u0015\tI(&\u0001\u0006d_2dWm\u0019;j_:L!a\u001f<\u0003\u000f1K7\u000f^*fi\u0006IA/Y:lg~#S-\u001d\u000b\u0004}\u0006\r\u0001CA\u0015\u0000\u0013\r\t\tA\u000b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0006\u001d\t\t\u00111\u0001u\u0003\rAH%M\u0001\u0007i\u0006\u001c8n\u001d\u0011)\u0007!\tY\u0001E\u0002*\u0003\u001bI1!a\u0004+\u0005!1x\u000e\\1uS2,\u0017!\u00059beRLG/[8og&sWI\u001d:peV\u0011\u0011Q\u0003\t\t\u0003/\t\t#!\n\u0002>5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\b9\u0003\u0011)H/\u001b7\n\t\u0005\r\u0012\u0011\u0004\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003BA\u0014\u0003si!!!\u000b\u000b\u0007\t\nYC\u0003\u0003\u0002.\u0005=\u0012aB:u_J\fw-\u001a\u0006\u0004I\u0005E\"\u0002BA\u001a\u0003k\t\u0011bY8oM2,XM\u001c;\u000b\u0005\u0005]\u0012AA5p\u0013\u0011\tY$!\u000b\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007cA\u0015\u0002@%\u0019\u0011\u0011\t\u0016\u0003\t1{gnZ\u0001\u0013a\u0006\u0014H/\u001b;j_:\u001c\u0018J\\#se>\u0014\b%A\u000fqCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5SKR\u0014\u0018.\u00192mK\u0016\u0013(o\u001c:t\u0003y\u0001\u0018M\u001d;ji&|gn],ji\"\u0014V\r\u001e:jC\ndW-\u0012:s_J\u001c\b%\u0001\u0006qe>\u001cWm]:j]\u001e\fa\u0002\u001d:pG\u0016\u001c8/\u001b8h?\u0012*\u0017\u000fF\u0002\u007f\u0003\u001fB\u0001\"!\u0002\u000f\u0003\u0003\u0005\r\u0001^\u0001\faJ|7-Z:tS:<\u0007%A\nfeJ|'\u000fU1si&$\u0018n\u001c8D_VtG\u000fF\u0001E\u0003%\u0019xN\u001d;UCN\\7\u000f\u0006\u0003\u0002\\\u00055\u0004#BA/\u0003OBf\u0002BA0\u0003Gr1a[A1\u0013\u0005Y\u0013bAA3U\u00059\u0001/Y2lC\u001e,\u0017\u0002BA5\u0003W\u0012A\u0001T5ti*\u0019\u0011Q\r\u0016\t\r\u0001\n\u0002\u0019AA.\u0003\u001dqWm\u001e+bg.$R\u0001WA:\u0003oBq!!\u001e\u0013\u0001\u0004\t)#\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u0011\u0011\u0010\nA\u0002\u0005m\u0014\u0001C7fi\u0006$\u0017\r^1\u0011\u0007]\u000bi(C\u0002\u0002\u0000}\u00111c\u0015;beR\u001c\u0005.\u00198hK6+G/\u00193bi\u0006\f!\"\\1z!J|7-Z:t)\u0011\t))a#\u0011\u0007%\n9)C\u0002\u0002\n*\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002zM\u0001\r!!$\u0011\u0007]\u000by)C\u0002\u0002\u0012~\u0011ab\u00115b]\u001e,W*\u001a;bI\u0006$\u0018-\u0001\u0007nCf\u0014W-\u00113e)\u0006\u001c8\u000eF\u0002\u007f\u0003/Cq!!\u001f\u0015\u0001\u0004\tY(A\bnCf\u0014WMU3n_Z,G+Y:l)\rq\u0018Q\u0014\u0005\b\u0003s*\u0002\u0019AAP!\r9\u0016\u0011U\u0005\u0004\u0003G{\"AE*u_B\u001c\u0005.\u00198hK6+G/\u00193bi\u0006\fA\u0001]8mYR\u0011\u0011\u0011\u0016\t\u0006S\u0005-\u00161L\u0005\u0004\u0003[S#AB(qi&|g.\u0001\u0003e_:,Gc\u0001@\u00024\"1\u0011QW\fA\u0002a\u000bA\u0001^1tW\u0006IA/Y:l\u0007>,h\u000e^\u000b\u0002\t\u0006aq/\u001b;i\u00032dG+Y:lgV!\u0011qXAb)\u0011\t\t-a4\u0011\u0007e\u000b\u0019\rB\u0004\u0002Ff\u0011\r!a2\u0003\u0003U\u000b2!XAe!\rI\u00131Z\u0005\u0004\u0003\u001bT#aA!os\"9\u0011\u0011[\rA\u0002\u0005M\u0017A\u00014o!\u001dI\u0013Q[Am\u0003\u0003L1!a6+\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003j\u00037D\u0016bAAoe\n\u00191+\u001a;\u0002\u000b\rdwn]3\u0015\u0003y\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002Q\u00061!/Z7pm\u0016$2A`Av\u0011\u001d\t)\b\ba\u0001\u0003K\t\u0001BZ5oIR\u000b7o\u001b\u000b\u0007\u0003c\f\u00190!>\u0011\t%\nY\u000b\u0017\u0005\b\u0003kj\u0002\u0019AA\u0013\u0011\u0019\t90\ba\u0001i\u0006)\u0011/^3vK\u0002")
public abstract class TierTaskQueue<T extends TierTask<T>>
implements Logging,
AutoCloseable {
    private final CancellationContext ctx;
    private final int maxTasks;
    private final Time time;
    private volatile ListSet<T> tasks;
    private final ConcurrentHashMap<TopicIdPartition, Object> partitionsInError;
    private final ConcurrentHashMap<TopicIdPartition, Object> partitionsWithRetriableErrors;
    private ListSet<T> processing;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierTaskQueue tierTaskQueue = this;
        synchronized (tierTaskQueue) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return this.getClass().getName();
    }

    private ListSet<T> tasks() {
        return this.tasks;
    }

    private void tasks_$eq(ListSet<T> x$1) {
        this.tasks = x$1;
    }

    private ConcurrentHashMap<TopicIdPartition, Object> partitionsInError() {
        return this.partitionsInError;
    }

    private ConcurrentHashMap<TopicIdPartition, Object> partitionsWithRetriableErrors() {
        return this.partitionsWithRetriableErrors;
    }

    private ListSet<T> processing() {
        return this.processing;
    }

    private void processing_$eq(ListSet<T> x$1) {
        this.processing = x$1;
    }

    public int errorPartitionCount() {
        return this.partitionsInError().size() + this.partitionsWithRetriableErrors().size();
    }

    public abstract List<T> sortTasks(List<T> var1);

    public abstract T newTask(TopicIdPartition var1, StartChangeMetadata var2);

    public abstract boolean mayProcess(ChangeMetadata var1);

    public void maybeAddTask(StartChangeMetadata metadata) {
        if (this.mayProcess(metadata)) {
            this.remove(metadata.topicIdPartition());
            this.tasks_$eq((ListSet)this.tasks().$plus((Object)this.newTask(metadata.topicIdPartition(), metadata)));
            return;
        }
    }

    public void maybeRemoveTask(StopChangeMetadata metadata) {
        if (this.mayProcess(metadata)) {
            this.remove(metadata.topicIdPartition());
            return;
        }
    }

    public synchronized Option<List<T>> poll() {
        Instant now = Instant.ofEpochMilli(this.time.hiResClockMs());
        int processingSpace = this.maxTasks - this.processing().size();
        this.trace((Function0<String> & Serializable)() -> "space: " + processingSpace + " maxTasks: " + $this.maxTasks + " processing: " + (processingSpace - $this.maxTasks) + " tasks: " + this.tasks().size());
        if (processingSpace > 0) {
            List<T> sorted;
            Object eligibleTasks = this.tasks().toList().filter((Function1<TierTask, Object> & Serializable)task -> BoxesRunTime.boxToBoolean(TierTaskQueue.$anonfun$poll$2(this, now, task)));
            this.trace(() -> TierTaskQueue.$anonfun$poll$4(this, (List)eligibleTasks));
            if (((AbstractIterable)eligibleTasks).nonEmpty() && (sorted = this.sortTasks((List<T>)eligibleTasks)).nonEmpty()) {
                Object tasks = sorted.take(processingSpace);
                this.debug(() -> TierTaskQueue.$anonfun$poll$5((List)tasks));
                this.processing_$eq((ListSet)this.processing().$plus$plus((IterableOnce)tasks));
                return new Some<Object>(tasks);
            }
        }
        return None$.MODULE$;
    }

    public void done(T task) {
        TierTaskQueue tierTaskQueue = this;
        synchronized (tierTaskQueue) {
            if (!this.tasks().contains(task)) {
                this.debug((Function0<String> & Serializable)() -> "Done task " + task + " is already removed");
                v0 = BoxedUnit.UNIT;
            } else {
                if (!this.processing().contains(task)) {
                    this.warn((Function0<String> & Serializable)() -> "done task " + task + " not found in processing set");
                }
                this.processing_$eq((ListSet)this.processing().$minus((Object)task));
                if (((TierTask)task).ctx().isCancelled()) {
                    this.debug((Function0<String> & Serializable)() -> "removing done task " + task + " from the task set since task is cancelled");
                    this.tasks_$eq((ListSet)this.tasks().$minus((Object)task));
                    if (((TierTask)task).isErrorState()) {
                        this.debug((Function0<String> & Serializable)() -> "adding done/cancelled task " + task + " to partitionsInError");
                        this.partitionsInError().put(((TierTask)task).topicIdPartition(), BoxesRunTime.boxToLong(this.time.milliseconds()));
                        v0 = this.partitionsWithRetriableErrors().remove(((TierTask)task).topicIdPartition());
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                } else if (((TierTask)task).isErrorState()) {
                    this.debug((Function0<String> & Serializable)() -> "adding done (non-cancelled) task " + task + " to partitionsWithRetriableErrors");
                    v0 = this.partitionsWithRetriableErrors().put(((TierTask)task).topicIdPartition(), BoxesRunTime.boxToLong(this.time.milliseconds()));
                } else {
                    v0 = this.partitionsWithRetriableErrors().remove(((TierTask)task).topicIdPartition());
                }
            }
        }
    }

    public int taskCount() {
        return this.tasks().size();
    }

    public <U> U withAllTasks(Function1<Set<T>, U> fn) {
        return fn.apply(this.tasks());
    }

    @Override
    public void close() {
        this.ctx.cancel();
    }

    public String toString() {
        return "tasks=" + this.tasks() + " processing=" + this.processing();
    }

    private synchronized void remove(TopicIdPartition topicIdPartition) {
        this.findTask(topicIdPartition, this.tasks()).foreach((Function1<TierTask, Object> & Serializable)task -> BoxesRunTime.boxToLong(TierTaskQueue.$anonfun$remove$1(this, topicIdPartition, task)));
    }

    private Option<T> findTask(TopicIdPartition topicIdPartition, ListSet<T> queue) {
        return queue.find((Function1<TierTask, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(TierTaskQueue.$anonfun$findTask$1(topicIdPartition, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$poll$2(TierTaskQueue $this, Instant now$1, TierTask task) {
        return !$this.processing().apply((Object)task) && task.pausedUntil().forall((Function1<Instant, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(now$1.isAfter(x$1))) && !$this.partitionsInError().containsKey(task.topicIdPartition());
    }

    public static final /* synthetic */ String $anonfun$poll$4(TierTaskQueue $this, List eligibleTasks$1) {
        return "eligibleTasks: " + eligibleTasks$1.size() + " partitionsInError: " + $this.partitionsInError().size();
    }

    public static final /* synthetic */ String $anonfun$poll$5(List tasks$1) {
        return "Adding sorted: " + tasks$1.mkString(",") + " \n Total tasks: " + tasks$1.mkString(",");
    }

    public static final /* synthetic */ long $anonfun$remove$1(TierTaskQueue $this, TopicIdPartition topicIdPartition$1, TierTask task) {
        task.ctx().cancel();
        $this.tasks_$eq((ListSet)$this.tasks().$minus(task));
        $this.processing_$eq((ListSet)$this.processing().$minus(task));
        $this.partitionsInError().remove(topicIdPartition$1);
        return BoxesRunTime.unboxToLong($this.partitionsWithRetriableErrors().remove(topicIdPartition$1));
    }

    public static final /* synthetic */ boolean $anonfun$findTask$1(TopicIdPartition topicIdPartition$2, TierTask x$2) {
        TopicIdPartition topicIdPartition = x$2.topicIdPartition();
        TopicIdPartition topicIdPartition2 = topicIdPartition$2;
        return !(topicIdPartition != null ? !((Object)topicIdPartition).equals(topicIdPartition2) : topicIdPartition2 != null);
    }

    public TierTaskQueue(CancellationContext ctx, int maxTasks, Time time) {
        this.ctx = ctx;
        this.maxTasks = maxTasks;
        this.time = time;
        Logging.$init$(this);
        this.tasks = (ListSet)ListSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionsInError = new ConcurrentHashMap();
        this.partitionsWithRetriableErrors = new ConcurrentHashMap();
        this.processing = (ListSet)ListSet$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

