/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.log.UploadableSegment;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.TierSegmentUploadComplete;
import io.confluent.kafka.storage.tier.domain.TierSegmentUploadInitiate;
import io.confluent.kafka.storage.tier.domain.TierTopicInitLeader;
import io.confluent.kafka.storage.tier.domain.TierUploadType;
import io.confluent.kafka.storage.tier.state.OffsetAndEpoch;
import io.confluent.kafka.storage.tier.state.TierPartitionState;
import io.confluent.kafka.storage.tier.store.OpaqueData;
import io.confluent.kafka.storage.tier.store.objects.FragmentDescriptionWrapper;
import io.confluent.kafka.storage.tier.store.objects.ThrottledSegmentUpload;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.common.NoSuchLogSegmentException;
import kafka.server.ReplicaManager;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFailedException;
import kafka.tier.exceptions.TierArchiverFatalException;
import kafka.tier.exceptions.TierArchiverFatalException$;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverFencedException$;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.jdk.CollectionConverters$;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class ArchiveTask$
implements Logging {
    public static final ArchiveTask$ MODULE$ = new ArchiveTask$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ArchiveTask$ archiveTask$ = this;
        synchronized (archiveTask$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return ArchiveTask.class.getName();
    }

    public ArchiveTask apply(CancellationContext ctx, TopicIdPartition topicIdPartition, int leaderEpoch, ArchiverMetrics archiverMetrics, int brokerId) {
        return new ArchiveTask(ctx, topicIdPartition, new BeforeLeader(leaderEpoch), archiverMetrics, brokerId);
    }

    public Future<ArchiveTaskState> checkFailedState(FailedState state, TopicIdPartition topicIdPartition, ReplicaManager replicaManager) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0<Product> & Serializable)() -> (Product)replicaManager.getLog(topicIdPartition.topicPartition()).map((Function1<AbstractLog, Product> & Serializable)log -> {
            int tierEpoch = log.tierPartitionState().tierEpoch();
            int leaderEpoch = state.leaderEpoch();
            if (log.tierPartitionState().status().hasError()) {
                throw new TierArchiverFailedException(topicIdPartition);
            }
            if (tierEpoch > leaderEpoch) {
                throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
            }
            if (tierEpoch == leaderEpoch) {
                return new BeforeUpload(leaderEpoch);
            }
            if (tierEpoch < leaderEpoch) {
                return new BeforeLeader(leaderEpoch);
            }
            throw new TierArchiverFatalException("attempted to transition from a FailedState for " + topicIdPartition + " while in non-transitionable state", TierArchiverFatalException$.MODULE$.$lessinit$greater$default$2());
        }).getOrElse((Function0<FailedState> & Serializable)() -> state)));
    }

    public Future<BeforeUpload> establishLeadership(BeforeLeader state, TopicIdPartition topicIdPartition, TierTopicAppender tierTopicAppender, int brokerId, ReplicaManager replicaManager, ExecutionContext ec) {
        return Future$.MODULE$.unit().flatMap((Function1<BoxedUnit, Future> & Serializable)x$3 -> {
            Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors error = (Errors)((Object)((Object)left.value()));
                throw new TierArchiverFencedException(topicIdPartition, (Throwable)error.exception());
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Partition partition = (Partition)right.value();
                return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(new TierTopicInitLeader(topicIdPartition, state.leaderEpoch(), UUID.randomUUID(), brokerId, OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(partition.metadataOffsetAndEpoch())))))).map((Function1<TierPartitionState.AppendResult, BeforeUpload> & Serializable)x0$1 -> {
                    TierPartitionState.AppendResult appendResult = x0$1;
                    if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)appendResult)) {
                        MODULE$.info((Function0<String> & Serializable)() -> "established leadership for " + topicIdPartition);
                        return new BeforeUpload(state.leaderEpoch());
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals((Object)appendResult)) {
                        throw new TierArchiverFailedException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals((Object)appendResult)) {
                        throw new NotTierablePartitionException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)appendResult)) {
                        throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals((Object)appendResult)) {
                        throw new TierArchiverRestoreFencedException(topicIdPartition);
                    }
                    throw new TierArchiverFatalException("Unknown AppendResult " + appendResult, TierArchiverFatalException$.MODULE$.$lessinit$greater$default$2());
                }, ec);
            }
            throw new MatchError(either);
        }, ec);
    }

    public Future<ArchiveTaskState> maybeInitiateUpload(BeforeUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0<Future> & Serializable)() -> {
            Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors error = (Errors)((Object)((Object)left.value()));
                throw new TierArchiverFencedException(topicIdPartition, (Throwable)error.exception());
            }
            if (either instanceof Right) {
                Some some;
                Tuple3 tuple3;
                Right right = (Right)either;
                Partition partition = (Partition)right.value();
                if (partition.isUncleanLeader()) {
                    throw new TierMetadataRetriableException("Backing off as " + topicIdPartition + " is undergoing unclean leader recovery");
                }
                Option option = partition.log().flatMap((Function1<AbstractLog, Option> & Serializable)log -> {
                    if (!log.tierPartitionState().isTieringEnabled()) {
                        throw new NotTierablePartitionException(topicIdPartition);
                    }
                    if (log.tierPartitionState().tierEpoch() != state.leaderEpoch()) {
                        throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
                    }
                    OffsetAndEpoch stateOffset = log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch();
                    return ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(log.tierableLogSegments()).asScala().filter((Function1<LogSegment, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(ArchiveTask$.$anonfun$maybeInitiateUpload$3(x$4)))).collectFirst(new Serializable((AbstractLog)log, stateOffset){
                        private static final long serialVersionUID = 0L;
                        private final AbstractLog log$1;
                        private final OffsetAndEpoch stateOffset$1;

                        public final <A1 extends LogSegment, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 != null) {
                                A1 A12 = A1;
                                return (B1)new Tuple3<AbstractLog, OffsetAndEpoch, A1>(this.log$1, this.stateOffset$1, A12);
                            }
                            return function1.apply(x1);
                        }

                        public final boolean isDefinedAt(LogSegment x1) {
                            LogSegment logSegment = x1;
                            return logSegment != null;
                        }
                        {
                            this.log$1 = log$1;
                            this.stateOffset$1 = stateOffset$1;
                        }
                    });
                });
                if (None$.MODULE$.equals(option)) {
                    MODULE$.debug((Function0<String> & Serializable)() -> "Retrying BeforeUpload for " + topicIdPartition + " as log has moved or no tierable segments were found");
                    return Future$.MODULE$.apply((Function0<BeforeUpload> & Serializable)() -> state, ec);
                }
                if (option instanceof Some && (tuple3 = (Tuple3)(some = (Some)option).value()) != null) {
                    AbstractLog log2 = (AbstractLog)tuple3._1();
                    OffsetAndEpoch stateOffset = (OffsetAndEpoch)tuple3._2();
                    LogSegment logSegment = (LogSegment)tuple3._3();
                    if (log2 != null) {
                        AbstractLog abstractLog = log2;
                        if (stateOffset != null) {
                            OffsetAndEpoch offsetAndEpoch = stateOffset;
                            if (logSegment != null) {
                                List<FragmentDescriptionWrapper> list;
                                LogSegment logSegment2 = logSegment;
                                ObjectRef<Object> segment = ObjectRef.create(null);
                                try {
                                    segment.elem = MODULE$.uploadableSegment(abstractLog, logSegment2, topicIdPartition);
                                }
                                catch (CorruptIndexException e) {
                                    throw new E2EChecksumInvalidException("Index associated with the segment is corrupted", (Throwable)e);
                                }
                                if (abstractLog.isDeleted() || abstractLog.isStray()) {
                                    throw new NotTierablePartitionException(topicIdPartition);
                                }
                                TierObjectStore.ByokKeyHolder byokKeyHolder = tierObjectStore.prepPutSegment(topicIdPartition);
                                OpaqueData opaqueData = byokKeyHolder.opaqueData;
                                Optional<ByteBuffer> encryptedDek = Optional.ofNullable(byokKeyHolder.encryptedDek);
                                try {
                                    list = FragmentDescriptionWrapper.createFragmentDescriptionsList(topicIdPartition, config.segmentMetadataLayoutPutMode(), logSegment2.size(), ((UploadableSegment)segment.elem).offsetIndex().length(), ((UploadableSegment)segment.elem).timeIndex().length(), BoxesRunTime.unboxToInt(((UploadableSegment)segment.elem).abortedTxnIndexOpt().map(bb -> BoxesRunTime.boxToInteger(ArchiveTask$.$anonfun$maybeInitiateUpload$6(bb))).orElse(BoxesRunTime.boxToInteger(0))), ((UploadableSegment)segment.elem).leaderEpochState().limit() - ((UploadableSegment)segment.elem).leaderEpochState().position(), BoxesRunTime.unboxToLong(((UploadableSegment)segment.elem).producerStateOpt().map(x$5 -> BoxesRunTime.boxToLong(x$5.length())).orElse(BoxesRunTime.boxToLong(0L))));
                                }
                                catch (IllegalArgumentException e) {
                                    throw new TierArchiverFatalException("TierArchiver failed while attempting to describe the metadata layout of a segment from " + topicIdPartition + ".", (Throwable)e);
                                }
                                List<FragmentDescriptionWrapper> fragmentDescriptionsList = list;
                                TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, state.leaderEpoch(), UUID.randomUUID(), Optional.empty(), logSegment2.baseOffset(), ((UploadableSegment)segment.elem).nextOffset() - 1L, logSegment2.largestTimestamp(), logSegment2.getFirstBatchTimestamp(), logSegment2.size(), true, ((UploadableSegment)segment.elem).abortedTxnIndexOpt().isPresent(), ((UploadableSegment)segment.elem).producerStateOpt().isPresent(), TierUploadType.Archive, offsetAndEpoch, opaqueData, encryptedDek, Optional.of(fragmentDescriptionsList));
                                long startTimeMs = time.milliseconds();
                                return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0<Future> & Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(uploadInitiate))))).flatMap((Function1<Future, Future> & Serializable)x -> Predef$.MODULE$.identity(x), ec).map((Function1<TierPartitionState.AppendResult, Upload> & Serializable)x0$1 -> {
                                    TierPartitionState.AppendResult appendResult = x0$1;
                                    if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)appendResult)) {
                                        MODULE$.info((Function0<String> & Serializable)() -> "Completed " + uploadInitiate + " for " + topicIdPartition + " in " + (time.milliseconds() - startTimeMs) + "ms");
                                        return new Upload(state.leaderEpoch(), uploadInitiate, (UploadableSegment)segment$1.elem);
                                    }
                                    if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals((Object)appendResult)) {
                                        throw new TierArchiverFailedException(topicIdPartition);
                                    }
                                    if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals((Object)appendResult)) {
                                        throw new NotTierablePartitionException(topicIdPartition);
                                    }
                                    if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)appendResult)) {
                                        throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
                                    }
                                    if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals((Object)appendResult)) {
                                        throw new TierArchiverRestoreFencedException(topicIdPartition);
                                    }
                                    throw new MatchError((Object)appendResult);
                                }, ec);
                            }
                        }
                    }
                }
                throw new MatchError(option);
            }
            throw new MatchError(either);
        }, ec).flatMap((Function1<Future, Future> & Serializable)x -> Predef$.MODULE$.identity(x), ec);
    }

    public Future<AfterUpload> upload(Upload state, TopicIdPartition topicIdPartition, Time time, CancellationContext ctx, TierObjectStore tierObjectStore, Option<Throttler> throttlerOpt, TierTasksConfig config, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0<AfterUpload> & Serializable)() -> {
            UploadableSegment uploadableSegment = state.uploadableSegment();
            TierSegmentUploadInitiate uploadInitiate = state.uploadInitiate();
            ObjectMetadata metadata = new ObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadableSegment.abortedTxnIndexOpt().isPresent(), uploadableSegment.producerStateOpt().isPresent(), true, uploadInitiate.opaqueData(), uploadInitiate.segmentAndMetadataLayout().orElse(null));
            return (AfterUpload)package$.MODULE$.blocking((Function0<AfterUpload> & Serializable)() -> {
                if (ctx.isCancelled()) {
                    throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
                }
                long startTimeMs = time.milliseconds();
                try {
                    ThrottledSegmentUpload segmentUpload = new ThrottledSegmentUpload(config.segmentMetadataLayoutPutMode(), metadata, uploadableSegment.logSegmentFile(), uploadableSegment.offsetIndex(), uploadableSegment.timeIndex(), uploadableSegment.producerStateOpt(), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(uploadableSegment.abortedTxnIndexOpt())).map((Function1<ByteBuffer, ByteBuffer> & Serializable)x$6 -> x$6.duplicate()))), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(new Some<ByteBuffer>(uploadableSegment.leaderEpochState().duplicate()))), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(throttlerOpt)));
                    tierObjectStore.putSegment(segmentUpload);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof Exception) {
                        Exception exception = (Exception)throwable2;
                        if (!MODULE$.segmentFilesExist(state.uploadableSegment())) {
                            throw new ArchiveTask.SegmentDeletedException("Segment " + uploadableSegment.logSegmentFile().getAbsolutePath() + " of " + topicIdPartition + " deleted when tiering", exception);
                        }
                    }
                    throw throwable;
                }
                MODULE$.info((Function0<String> & Serializable)() -> "Uploaded segment for " + topicIdPartition + " in " + (time.milliseconds() - startTimeMs) + "ms");
                return new AfterUpload(state.leaderEpoch(), uploadInitiate, state.uploadableSegment().uploadedSize());
            });
        }, ec);
    }

    public Option<Throttler> upload$default$6() {
        return None$.MODULE$;
    }

    public Future<BeforeUpload> finalizeUpload(AfterUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, Option<Meter> byteRateMetric, ExecutionContext ec) {
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(state.uploadInitiate());
        long startTimeMs = time.milliseconds();
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0<Future> & Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(uploadComplete))))).flatMap((Function1<Future, Future> & Serializable)x -> Predef$.MODULE$.identity(x), ec).map((Function1<TierPartitionState.AppendResult, BeforeUpload> & Serializable)x0$1 -> {
            TierPartitionState.AppendResult appendResult = x0$1;
            if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)appendResult)) {
                MODULE$.info((Function0<String> & Serializable)() -> "Finalized " + uploadComplete + " for " + topicIdPartition + " in " + (time.milliseconds() - startTimeMs) + " ms");
                byteRateMetric.foreach((Function1<Meter, Object> & Serializable)x$7 -> {
                    x$7.mark(state.uploadedSize());
                    return BoxedUnit.UNIT;
                });
                return new BeforeUpload(state.leaderEpoch());
            }
            if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals((Object)appendResult)) {
                throw new TierArchiverFailedException(topicIdPartition);
            }
            if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals((Object)appendResult)) {
                throw new NotTierablePartitionException(topicIdPartition);
            }
            if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)appendResult)) {
                throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
            }
            if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals((Object)appendResult)) {
                throw new TierArchiverRestoreFencedException(topicIdPartition);
            }
            throw new MatchError((Object)appendResult);
        }, ec);
    }

    public UploadableSegment uploadableSegment(AbstractLog log, LogSegment logSegment, TopicIdPartition topicIdPartition) {
        UploadableSegment uploadableSegment;
        try {
            uploadableSegment = log.createUploadableSegment(logSegment);
        }
        catch (NoSuchLogSegmentException e) {
            throw new ArchiveTask.SegmentDeletedException("Segment " + logSegment + " of " + topicIdPartition + " deleted when tiering", e);
        }
        return uploadableSegment;
    }

    private boolean segmentFilesExist(UploadableSegment uploadableSegment) {
        return uploadableSegment.allFiles().stream().allMatch(x$8 -> x$8.exists());
    }

    public static final /* synthetic */ boolean $anonfun$maybeInitiateUpload$3(LogSegment x$4) {
        return x$4.size() != 0;
    }

    public static final /* synthetic */ int $anonfun$maybeInitiateUpload$6(ByteBuffer bb) {
        return bb.limit() - bb.position();
    }

    private ArchiveTask$() {
    }
}

