/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.log.TierLogSegment;
import io.confluent.kafka.storage.tier.state.CompactStats;
import io.confluent.kafka.storage.tier.state.OffsetAndEpoch;
import java.io.Serializable;
import kafka.tier.store.TierObjectStoreLinearRetry;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.TierLogCleanerManager$;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.AbstractIterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class CompactionTask$
implements Logging {
    public static final CompactionTask$ MODULE$ = new CompactionTask$();
    private static final int DefaultMaxRetryCount;
    private static final int DefaultRetryIntervalInMs;
    private static final TierObjectStoreLinearRetry DefaultRetryPolicy;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        DefaultMaxRetryCount = 3;
        DefaultRetryIntervalInMs = 1000;
        DefaultRetryPolicy = new TierObjectStoreLinearRetry(MODULE$.DefaultMaxRetryCount(), MODULE$.DefaultRetryIntervalInMs());
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        CompactionTask$ compactionTask$ = this;
        synchronized (compactionTask$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return CompactionTask.class.getName();
    }

    public int DefaultMaxRetryCount() {
        return DefaultMaxRetryCount;
    }

    public int DefaultRetryIntervalInMs() {
        return DefaultRetryIntervalInMs;
    }

    public TierObjectStoreLinearRetry DefaultRetryPolicy() {
        return DefaultRetryPolicy;
    }

    public TierLogToClean getTierLogToClean(AbstractLog log, Time time, long now) {
        TierLogToClean tierLogToClean;
        try {
            CompactStats lastCompactStats;
            OffsetAndEpoch startingTierOffsetAndEpoch = log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch();
            Tuple2<Object, Object> tuple2 = this.dirtyRange(log, now);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long firstDirtyOffset = tuple2._1$mcJ$sp();
            long firstUncleanableDirtyOffset = tuple2._2$mcJ$sp();
            Tuple2$mcJJ$sp tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(firstDirtyOffset, firstUncleanableDirtyOffset);
            long firstDirtyOffset2 = ((Tuple2)tuple2$mcJJ$sp)._1$mcJ$sp();
            long firstUncleanableDirtyOffset2 = ((Tuple2)tuple2$mcJJ$sp)._2$mcJ$sp();
            List cleanSegs = CollectionConverters$.MODULE$.IteratorHasAsScala(log.tieredLogSegments(log.logStartOffset(), firstDirtyOffset2)).asScala().takeWhile((Function1<TierLogSegment, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(CompactionTask$.$anonfun$getTierLogToClean$1(firstDirtyOffset2, x$8))).toList();
            long cleanBytes = BoxesRunTime.unboxToLong(((AbstractIterable)cleanSegs.map((Function1<TierLogSegment, Object> & Serializable)x$9 -> BoxesRunTime.boxToLong(x$9.size()))).sum(Numeric.LongIsIntegral$.MODULE$));
            Tuple2<Object, Object> tuple22 = TierLogCleanerManager$.MODULE$.calculateCleanableDirtyBytes(log, firstDirtyOffset2, firstUncleanableDirtyOffset2);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            long cleanableBytes = tuple22._2$mcJ$sp();
            long cleanableBytes2 = cleanableBytes;
            long totalBytes = cleanBytes + cleanableBytes2;
            long uncleanableBytes = log.size() - totalBytes;
            double cleanableRatio = totalBytes == 0L ? 0.0 : (double)cleanableBytes2 / (double)totalBytes;
            Iterator<Object> firstBatchTimes = CollectionConverters$.MODULE$.IteratorHasAsScala(log.tieredLogSegments(firstDirtyOffset2, Long.MAX_VALUE)).asScala().map((Function1<TierLogSegment, Object> & Serializable)x$10 -> BoxesRunTime.boxToLong(x$10.firstBatchTimestamp())).filter(x$11 -> x$11 > 0L);
            long earliestDirtyTimestamp = firstBatchTimes.nonEmpty() ? BoxesRunTime.unboxToLong(firstBatchTimes.min(Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
            CompactStats compactStats = lastCompactStats = log.tierPartitionState().lastCompactStats();
            CompactStats compactStats2 = CompactStats.EMPTY;
            double lastReduceRatio = !(compactStats != null ? !((Object)compactStats).equals(compactStats2) : compactStats2 != null) ? 0.0 : lastCompactStats.reduceRatio();
            double expectedCompactionEfficiency = lastReduceRatio * cleanableRatio;
            TierLogToClean ltc = new TierLogToClean(log.topicIdPartition(), log, time, earliestDirtyTimestamp, firstDirtyOffset2, firstUncleanableDirtyOffset2, uncleanableBytes, cleanableBytes2, cleanBytes, totalBytes, cleanableRatio, expectedCompactionEfficiency, startingTierOffsetAndEpoch, now);
            this.debug((Function0<String> & Serializable)() -> ltc.toString());
            tierLogToClean = ltc;
        }
        catch (Throwable e) {
            throw new Exception("Failed to calculate log cleaning stats for partition " + log.topicIdPartition(), e);
        }
        return tierLogToClean;
    }

    private Tuple2<Object, Object> dirtyRange(AbstractLog log, long now) {
        long l;
        long firstDirtyOffset;
        long checkpointDirtyOffset = log.tierPartitionState().compactDirtyStartOffset();
        long logStartOffset = log.logStartOffset();
        if (checkpointDirtyOffset < 0L) {
            v0 = logStartOffset;
        } else if (checkpointDirtyOffset < logStartOffset) {
            if (!TierLogCleanerManager$.MODULE$.isCompactAndDelete(log)) {
                this.debug((Function0<String> & Serializable)() -> "Resetting first dirty offset of " + log.name() + " to log start offset " + logStartOffset + " since the checkpointed offset " + checkpointDirtyOffset + " is invalid.");
            }
            v0 = logStartOffset;
        } else if (checkpointDirtyOffset > log.tierPartitionState().endOffset() + 1L) {
            this.debug((Function0<String> & Serializable)() -> "The last checkpoint dirty offset for partition " + log.name() + " is " + checkpointDirtyOffset + ", which is larger than the log end offset " + log.logEndOffset() + ". Resetting to the log start offset " + logStartOffset + ".");
            v0 = logStartOffset;
        } else {
            v0 = firstDirtyOffset = checkpointDirtyOffset;
        }
        if (log.config().compactionLagMs() <= 0L) {
            l = log.tierPartitionState().endOffset() + 1L;
        } else {
            long cleanBeforeTime = now - log.config().compactionLagMs();
            l = BoxesRunTime.unboxToLong(CollectionConverters$.MODULE$.IteratorHasAsScala(log.tieredLogSegments(firstDirtyOffset, log.tierPartitionState().endOffset() + 1L)).asScala().find((Function1<TierLogSegment, Object> & Serializable)segment -> BoxesRunTime.boxToBoolean(CompactionTask$.$anonfun$dirtyRange$3(cleanBeforeTime, segment))).map((Function1<TierLogSegment, Object> & Serializable)segment -> BoxesRunTime.boxToLong(segment.baseOffset())).getOrElse(() -> log.tierPartitionState().endOffset() + 1L));
        }
        long firstUncleanableDirtyOffset = l;
        this.debug((Function0<String> & Serializable)() -> "Finding range of cleanable offsets for log=" + log.name() + ". checkpointDirtyOffset=" + checkpointDirtyOffset + " now=" + now + " => firstDirtyOffset=" + firstDirtyOffset + " firstUncleanableOffset=" + firstUncleanableDirtyOffset + " log.tierPartitionState.endOffset=" + log.tierPartitionState().endOffset());
        return new Tuple2$mcJJ$sp(firstDirtyOffset, package$.MODULE$.max(firstDirtyOffset, firstUncleanableDirtyOffset));
    }

    public static final /* synthetic */ boolean $anonfun$getTierLogToClean$1(long firstDirtyOffset$1, TierLogSegment x$8) {
        return x$8.endOffset() < firstDirtyOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$dirtyRange$3(long cleanBeforeTime$1, TierLogSegment segment) {
        return segment.maxTimestamp() > cleanBeforeTime$1;
    }

    private CompactionTask$() {
    }
}

