/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.yammer.metrics.core.Counter;
import io.confluent.kafka.storage.SegmentMetadataLayoutPutMode;
import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CancellationException;
import kafka.cluster.Partition;
import kafka.server.ReplicaManager;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.exceptions.TierLogCompactionFencedException$;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreLinearRetry;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.compaction.CompactionTask$;
import kafka.tier.tasks.compaction.TierCleaner;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.tier.tasks.config.CompactionTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.Cleaner;
import org.apache.kafka.storage.internals.log.CleanerStats;
import org.apache.kafka.storage.internals.log.ExtendedOffsetMap;
import org.apache.kafka.storage.internals.log.LogCleaningAbortedException;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.OffsetMapSupplier;
import org.apache.kafka.storage.internals.log.ValidateLogResult;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r5h\u0001B#G\u0005=C\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t%\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005=\"AQ\r\u0001BC\u0002\u0013\u0005c\r\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003h\u0011!!\bA!b\u0001\n\u0003)\b\"CA\u0005\u0001\t\u0005\t\u0015!\u0003w\u0011)\tY\u0001\u0001BA\u0002\u0013\u0005\u0011Q\u0002\u0005\u000b\u0007'\u0003!\u00111A\u0005\u0002\rU\u0005BCBM\u0001\t\u0005\t\u0015)\u0003\u0002\u0010!Q\u0011\u0011 \u0001\u0003\u0006\u0004%\taa'\t\u0015\ru\u0005A!A!\u0002\u0013\tY\u0010\u0003\u0006\u0003\u0004\u0001\u0011\t\u0011)A\u0005\u0005\u000bAq!a\u000f\u0001\t\u0003\u0019y\nC\u0004\u0002@\u0001!\t%!\u0011\t\u0013\r5\u0006A1A\u0005\u0002\r=\u0006\u0002CBY\u0001\u0001\u0006IAa.\t\u0013\rM\u0006\u00011A\u0005\u0002\rU\u0006\"CB]\u0001\u0001\u0007I\u0011AB^\u0011!\u0019y\f\u0001Q!\n\r]\u0006bBBe\u0001\u0011\u000511\u001a\u0005\b\u0003\u0017\u0003A\u0011IBl\u0011\u001d\u0011)\r\u0001C!\u0007':q!!\u000bG\u0011\u0003\tYC\u0002\u0004F\r\"\u0005\u0011Q\u0006\u0005\b\u0003wAB\u0011AA\u001f\u0011\u001d\ty\u0004\u0007C)\u0003\u0003B\u0011\"a\u0015\u0019\u0005\u0004%\t!!\u0016\t\u0011\u0005u\u0003\u0004)A\u0005\u0003/B\u0011\"a\u0018\u0019\u0005\u0004%\t!!\u0016\t\u0011\u0005\u0005\u0004\u0004)A\u0005\u0003/B\u0011\"a\u0019\u0019\u0005\u0004%\t!!\u001a\t\u0011\u0005M\u0004\u0004)A\u0005\u0003O2!\"!\u001e\u0019!\u0003\r\nCRA<\u0011\u001d\tI(\tD\u0001\u0003+Bq!a\u001f\"\r\u0003\ti\bC\u0004\u0002\f\u00062\t!!$\u0007\r\tU\u0001\u0004\u0011B\f\u0011)\tI(\nBK\u0002\u0013\u0005\u0011Q\u000b\u0005\u000b\u0005c)#\u0011#Q\u0001\n\u0005]\u0003B\u0003B\u001aK\tU\r\u0011\"\u0001\u00036!Q!qG\u0013\u0003\u0012\u0003\u0006I!a \t\u000f\u0005mR\u0005\"\u0001\u0003:!9\u00111P\u0013\u0005B\u0005u\u0004bBAFK\u0011\u0005#\u0011\t\u0005\b\u00057*C\u0011\u0001B/\u0011\u001d\u0011Y)\nC\u0005\u0005\u001bCqAa)&\t\u0003\u0011)\u000bC\u0004\u0003F\u0016\"\tEa2\t\u0013\t%W%!A\u0005\u0002\t-\u0007\"\u0003BiKE\u0005I\u0011\u0001Bj\u0011%\u0011I/JI\u0001\n\u0003\u0011Y\u000fC\u0005\u0003p\u0016\n\t\u0011\"\u0011\u0003r\"I1\u0011A\u0013\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0007\u0007)\u0013\u0011!C\u0001\u0007\u000bA\u0011b!\u0005&\u0003\u0003%\tea\u0005\t\u0013\r\u0005R%!A\u0005\u0002\r\r\u0002\"CB\u0014K\u0005\u0005I\u0011IB\u0015\u0011%\u0019i#JA\u0001\n\u0003\u001ay\u0003C\u0005\u00042\u0015\n\t\u0011\"\u0011\u00044\u001dI1q\u0007\r\u0002\u0002#\u00051\u0011\b\u0004\n\u0005+A\u0012\u0011!E\u0001\u0007wAq!a\u000f>\t\u0003\u0019\t\u0006C\u0005\u0003Fv\n\t\u0011\"\u0012\u0004T!I1QK\u001f\u0002\u0002\u0013\u00055q\u000b\u0005\n\u0007;j\u0014\u0011!CA\u0007?B\u0011b!\u001c>\u0003\u0003%Iaa\u001c\t\u000f\r]\u0004\u0004\"\u0001\u0004z!91\u0011\u0012\r\u0005\n\r-%AD\"p[B\f7\r^5p]R\u000b7o\u001b\u0006\u0003\u000f\"\u000b!bY8na\u0006\u001cG/[8o\u0015\tI%*A\u0003uCN\\7O\u0003\u0002L\u0019\u0006!A/[3s\u0015\u0005i\u0015!B6bM.\f7\u0001A\n\u0004\u0001A3\u0006cA)S)6\t\u0001*\u0003\u0002T\u0011\nAA+[3s)\u0006\u001c8\u000e\u0005\u0002V\u00015\ta\t\u0005\u0002X56\t\u0001L\u0003\u0002Z\u0019\u0006)Q\u000f^5mg&\u00111\f\u0017\u0002\b\u0019><w-\u001b8h\u0003\r\u0019G\u000f_\u000b\u0002=B\u0011qLY\u0007\u0002A*\u0011\u0011MS\u0001\bM\u0016$8\r[3s\u0013\t\u0019\u0007MA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/\u0001\u0003dib\u0004\u0013\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o+\u00059\u0007C\u00015r\u001b\u0005I'BA&k\u0015\tYG.A\u0004ti>\u0014\u0018mZ3\u000b\u00055k'B\u00018p\u0003%\u0019wN\u001c4mk\u0016tGOC\u0001q\u0003\tIw.\u0003\u0002sS\n\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0012i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\u0013!E8gMN,G/T1q'V\u0004\b\u000f\\5feV\ta\u000fE\u0002x\u0003\u000bi\u0011\u0001\u001f\u0006\u0003sj\f1\u0001\\8h\u0015\tYH0A\u0005j]R,'O\\1mg*\u00111. \u0006\u0003\u001bzT1a`A\u0001\u0003\u0019\t\u0007/Y2iK*\u0011\u00111A\u0001\u0004_J<\u0017bAA\u0004q\n\trJ\u001a4tKRl\u0015\r]*vaBd\u0017.\u001a:\u0002%=4gm]3u\u001b\u0006\u00048+\u001e9qY&,'\u000fI\u0001\u0006gR\fG/Z\u000b\u0003\u0003\u001f\u00012!!\u0005\"\u001d\r\t\u0019b\u0006\b\u0005\u0003+\t9C\u0004\u0003\u0002\u0018\u0005\u0015b\u0002BA\r\u0003GqA!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?q\u0015A\u0002\u001fs_>$h(C\u0001N\u0013\tYE*\u0003\u0002J\u0015&\u0011q\tS\u0001\u000f\u0007>l\u0007/Y2uS>tG+Y:l!\t)\u0006d\u0005\u0003\u0019\u0003_1\u0006\u0003BA\u0019\u0003oi!!a\r\u000b\u0005\u0005U\u0012!B:dC2\f\u0017\u0002BA\u001d\u0003g\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\b\u0006\u0002\u0002,\u0005QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001brA!a\u0012\u0002JA!\u00111DA\u001a\u0013\u0011\tY%a\r\u0002\rA\u0013X\rZ3g\u0013\u0011\ty%!\u0015\u0003\rM#(/\u001b8h\u0015\u0011\tY%a\r\u0002)\u0011+g-Y;mi6\u000b\u0007PU3uef\u001cu.\u001e8u+\t\t9\u0006\u0005\u0003\u00022\u0005e\u0013\u0002BA.\u0003g\u00111!\u00138u\u0003U!UMZ1vYRl\u0015\r\u001f*fiJL8i\\;oi\u0002\n\u0001\u0004R3gCVdGOU3uefLe\u000e^3sm\u0006d\u0017J\\'t\u0003e!UMZ1vYR\u0014V\r\u001e:z\u0013:$XM\u001d<bY&sWj\u001d\u0011\u0002%\u0011+g-Y;miJ+GO]=Q_2L7-_\u000b\u0003\u0003O\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[R\u0015!B:u_J,\u0017\u0002BA9\u0003W\u0012!\u0004V5fe>\u0013'.Z2u'R|'/\u001a'j]\u0016\f'OU3uef\f1\u0003R3gCVdGOU3uef\u0004v\u000e\\5ds\u0002\u00121cQ8na\u0006\u001cG/[8o)\u0006\u001c8n\u0015;bi\u0016\u001c2!IA\u0018\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0002\u0019\rdW-\u00198feN#\u0018\r^:\u0015\u0005\u0005}\u0004CBA\u0019\u0003\u0003\u000b))\u0003\u0003\u0002\u0004\u0006M\"AB(qi&|g\u000eE\u0002x\u0003\u000fK1!!#y\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u0003)!(/\u00198tSRLwN\u001c\u000b\u0017\u0003\u001f\u000bY+!,\u00020\u0006}\u0016qZAm\u0003O\f)0a>\u0003\u0002Q!\u0011\u0011SAQ!\u0019\t\u0019*!'\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000b\u0019$\u0001\u0006d_:\u001cWO\u001d:f]RLA!a'\u0002\u0016\n1a)\u001e;ve\u0016\u00042!a(\"\u001b\u0005A\u0002bBARI\u0001\u000f\u0011QU\u0001\u0003K\u000e\u0004B!a%\u0002(&!\u0011\u0011VAK\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003]I\u0001\u0007a\fC\u0003fI\u0001\u0007q\rC\u0004\u00022\u0012\u0002\r!a-\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB!\u0011QWA^\u001b\t\t9LC\u0002\u0002:2\u000baa]3sm\u0016\u0014\u0018\u0002BA_\u0003o\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0004\u0002B\u0012\u0002\r!a1\u0002#QLWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000f\u0005\u0003\u0002F\u0006-WBAAd\u0015\r\tIMS\u0001\u0006i>\u0004\u0018nY\u0005\u0005\u0003\u001b\f9MA\tUS\u0016\u0014Hk\u001c9jG\u0006\u0003\b/\u001a8eKJDq!!5%\u0001\u0004\t\u0019.A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f!\u0011\tI'!6\n\t\u0005]\u00171\u000e\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\"9\u00111\u001c\u0013A\u0002\u0005u\u0017AB2p]\u001aLw\r\u0005\u0003\u0002`\u0006\rXBAAq\u0015\r\tY\u000eS\u0005\u0005\u0003K\f\tOA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0011\u001d\tI\u000f\na\u0001\u0003W\f\u0011\u0002\u001e5s_R$H.\u001a:\u0011\t\u00055\u0018\u0011_\u0007\u0003\u0003_T!!\u0017>\n\t\u0005M\u0018q\u001e\u0002\n)\"\u0014x\u000e\u001e;mKJDQ\u0001\u001e\u0013A\u0002YDq!!?%\u0001\u0004\tY0A\u000buS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8NKR\u0014\u0018nY:\u0011\u0007U\u000bi0C\u0002\u0002\u0000\u001a\u0013Q\u0003V5fe\u000e{W\u000e]1di&|g.T3ue&\u001c7\u000fC\u0004\u0003\u0004\u0011\u0002\rA!\u0002\u0002\tQLW.\u001a\t\u0005\u0005\u000f\u0011y!\u0004\u0002\u0003\n)\u0019\u0011La\u0003\u000b\u0007\t5Q0\u0001\u0004d_6lwN\\\u0005\u0005\u0005#\u0011IA\u0001\u0003US6,\u0017FA\u0011&\u0005!\u0019E.Z1o\u0019><7#C\u0013\u00020\u0005u%\u0011\u0004B\u0010!\u0011\t\tDa\u0007\n\t\tu\u00111\u0007\u0002\b!J|G-^2u!\u0011\u0011\tCa\u000b\u000f\t\t\r\"q\u0005\b\u0005\u00037\u0011)#\u0003\u0002\u00026%!!\u0011FA\u001a\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\f\u00030\ta1+\u001a:jC2L'0\u00192mK*!!\u0011FA\u001a\u00031aW-\u00193fe\u0016\u0003xn\u00195!\u0003%a\u0017m\u001d;Ti\u0006$8/\u0006\u0002\u0002\u0000\u0005QA.Y:u'R\fGo\u001d\u0011\u0015\r\tm\"Q\bB !\r\ty*\n\u0005\b\u0003sR\u0003\u0019AA,\u0011\u001d\u0011\u0019D\u000ba\u0001\u0003\u007f\"bCa\u0011\u0003H\t%#1\nB'\u0005\u001f\u0012\tFa\u0015\u0003V\t]#\u0011\f\u000b\u0005\u0003#\u0013)\u0005C\u0004\u0002$2\u0002\u001d!!*\t\u000bqc\u0003\u0019\u00010\t\u000b\u0015d\u0003\u0019A4\t\u000f\u0005EF\u00061\u0001\u00024\"9\u0011\u0011\u0019\u0017A\u0002\u0005\r\u0007bBAiY\u0001\u0007\u00111\u001b\u0005\b\u00037d\u0003\u0019AAo\u0011\u001d\tI\u000f\fa\u0001\u0003WDQ\u0001\u001e\u0017A\u0002YDq!!?-\u0001\u0004\tY\u0010C\u0004\u0003\u00041\u0002\rA!\u0002\u0002\u0015\u0011|7\t\\3b]2{w\r\u0006\u000e\u0003`\t\r$Q\rB4\u0005S\u0012YG!\u001c\u0003p\t]$\u0011\u0010BC\u0005\u000f\u0013I\t\u0006\u0003\u0002\u0012\n\u0005\u0004bBAR[\u0001\u000f\u0011Q\u0015\u0005\u000696\u0002\rA\u0018\u0005\b\u0003\u0003l\u0003\u0019AAb\u0011\u001d\tI(\fa\u0001\u0003/BQ!Z\u0017A\u0002\u001dDq!!-.\u0001\u0004\t\u0019\fC\u0003u[\u0001\u0007a\u000fC\u0004\u0002\\6\u0002\rA!\u001d\u0011\t\u0005}'1O\u0005\u0005\u0005k\n\tOA\u000bD_6\u0004\u0018m\u0019;j_:$\u0016m]6t\u0007>tg-[4\t\u000f\u0005EW\u00061\u0001\u0002T\"9!1P\u0017A\u0002\tu\u0014a\u00029vi6{G-\u001a\t\u0005\u0005\u007f\u0012\t)D\u0001k\u0013\r\u0011\u0019I\u001b\u0002\u001d'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uC2\u000b\u0017p\\;u!V$Xj\u001c3f\u0011\u001d\tI0\fa\u0001\u0003wDq!!;.\u0001\u0004\tY\u000fC\u0004\u0003\u00045\u0002\rA!\u0002\u0002AMDw.\u001e7e\t>$U/\u00197D_6\u0004\u0018m\u0019;j_:4\u0016\r\\5eCRLwN\u001c\u000b\u0007\u0005\u001f\u0013)J!)\u0011\t\u0005E\"\u0011S\u0005\u0005\u0005'\u000b\u0019DA\u0004C_>dW-\u00198\t\ret\u0003\u0019\u0001BL!\u0011\u0011IJ!(\u000e\u0005\tm%BA=k\u0013\u0011\u0011yJa'\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\b\u00037t\u0003\u0019\u0001B9\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\t\u001d&Q\u0016BY\u0005g\u0013iL!1\u0011\t\u0005E\"\u0011V\u0005\u0005\u0005W\u000b\u0019D\u0001\u0003V]&$\bb\u0002BX_\u0001\u0007\u00111I\u0001\u0005i\u0006\u001c8\u000eC\u0003f_\u0001\u0007q\rC\u0004\u00036>\u0002\rAa.\u0002\t\u0019\u0014x.\u001c\t\u0005\u0003c\u0011I,\u0003\u0003\u0003<\u0006M\"\u0001\u0002'p]\u001eDqAa00\u0001\u0004\u00119,\u0001\u0002u_\"9!1Y\u0018A\u0002\u0005\u0015\u0015!B:uCR\u001c\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0013\u0001B2paf$bAa\u000f\u0003N\n=\u0007\"CA=cA\u0005\t\u0019AA,\u0011%\u0011\u0019$\rI\u0001\u0002\u0004\ty(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tU'\u0006BA,\u0005/\\#A!7\u0011\t\tm'Q]\u0007\u0003\u0005;TAAa8\u0003b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005G\f\u0019$\u0001\u0006b]:|G/\u0019;j_:LAAa:\u0003^\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u001e\u0016\u0005\u0003\u007f\u00129.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005g\u0004BA!>\u0003\u00006\u0011!q\u001f\u0006\u0005\u0005s\u0014Y0\u0001\u0003mC:<'B\u0001B\u007f\u0003\u0011Q\u0017M^1\n\t\u0005=#q_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u00199a!\u0004\u0011\t\u0005E2\u0011B\u0005\u0005\u0007\u0017\t\u0019DA\u0002B]fD\u0011ba\u00047\u0003\u0003\u0005\r!a\u0016\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019)\u0002\u0005\u0004\u0004\u0018\ru1qA\u0007\u0003\u00073QAaa\u0007\u00024\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r}1\u0011\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0010\u000e\u0015\u0002\"CB\bq\u0005\u0005\t\u0019AB\u0004\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\tM81\u0006\u0005\n\u0007\u001fI\u0014\u0011!a\u0001\u0003/\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003/\na!Z9vC2\u001cH\u0003\u0002BH\u0007kA\u0011ba\u0004<\u0003\u0003\u0005\raa\u0002\u0002\u0011\rcW-\u00198M_\u001e\u00042!a(>'\u0015i4QHB%!)\u0019yd!\u0012\u0002X\u0005}$1H\u0007\u0003\u0007\u0003RAaa\u0011\u00024\u00059!/\u001e8uS6,\u0017\u0002BB$\u0007\u0003\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u0019Yea\u0014\u000e\u0005\r5#b\u00019\u0003|&!!QFB')\t\u0019I\u0004\u0006\u0002\u0003t\u0006)\u0011\r\u001d9msR1!1HB-\u00077Bq!!\u001fA\u0001\u0004\t9\u0006C\u0004\u00034\u0001\u0003\r!a \u0002\u000fUt\u0017\r\u001d9msR!1\u0011MB5!\u0019\t\t$!!\u0004dAA\u0011\u0011GB3\u0003/\ny(\u0003\u0003\u0004h\u0005M\"A\u0002+va2,'\u0007C\u0005\u0004l\u0005\u000b\t\u00111\u0001\u0003<\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\rE\u0004\u0003\u0002B{\u0007gJAa!\u001e\u0003x\n1qJ\u00196fGR\f\u0011cZ3u)&,'\u000fT8h)>\u001cE.Z1o)!\u0019Yh!!\u0004\u0004\u000e\u0015\u0005cA+\u0004~%\u00191q\u0010$\u0003\u001dQKWM\u001d'pOR{7\t\\3b]\"1\u0011p\u0011a\u0001\u0005/CqAa\u0001D\u0001\u0004\u0011)\u0001C\u0004\u0004\b\u000e\u0003\rAa.\u0002\u00079|w/\u0001\u0006eSJ$\u0018PU1oO\u0016$ba!$\u0004\u0010\u000eE\u0005\u0003CA\u0019\u0007K\u00129La.\t\re$\u0005\u0019\u0001BL\u0011\u001d\u00199\t\u0012a\u0001\u0005o\u000b\u0011b\u001d;bi\u0016|F%Z9\u0015\t\t\u001d6q\u0013\u0005\n\u0007\u001fA\u0011\u0011!a\u0001\u0003\u001f\taa\u001d;bi\u0016\u0004SCAA~\u0003Y!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:lU\r\u001e:jGN\u0004C#\u0004+\u0004\"\u000e\r6QUBT\u0007S\u001bY\u000bC\u0003]\u001b\u0001\u0007a\fC\u0003f\u001b\u0001\u0007q\rC\u0003u\u001b\u0001\u0007a\u000fC\u0004\u0002\f5\u0001\r!a\u0004\t\u000f\u0005eX\u00021\u0001\u0002|\"9!1A\u0007A\u0002\t\u0015\u0011\u0001\u0005;bg.\u001c%/Z1uS>tG+[7f+\t\u00119,A\tuCN\\7I]3bi&|g\u000eV5nK\u0002\n!\u0002\\8h)>\u001cE.Z1o+\t\u00199\f\u0005\u0004\u00022\u0005\u000551P\u0001\u000fY><Gk\\\"mK\u0006tw\fJ3r)\u0011\u00119k!0\t\u0013\r=!#!AA\u0002\r]\u0016a\u00037pOR{7\t\\3b]\u0002B3aEBb!\u0011\t\td!2\n\t\r\u001d\u00171\u0007\u0002\tm>d\u0017\r^5mK\u0006)R.Y=cKV\u0003H-\u0019;f\u0019><Gk\\\"mK\u0006tG\u0003CB\\\u0007\u001b\u001cyma5\t\u000f\u0005EF\u00031\u0001\u00024\"91\u0011\u001b\u000bA\u0002\t]\u0016!\u00038po6KG\u000e\\5t\u0011\u001d\u0019)\u000e\u0006a\u0001\u0005o\u000ba\"\u001e9eCR,\u0017J\u001c;feZ\fG\u000e\u0006\b\u0004Z\u000e}7\u0011]Br\u0007K\u001c9o!;\u0015\t\rm7Q\u001c\t\u0006\u0003'\u000bI\n\u0016\u0005\b\u0003G+\u00029AAS\u0011\u001d\u0011\u0019!\u0006a\u0001\u0005\u000bAq!!1\u0016\u0001\u0004\t\u0019\rC\u0004\u0002RV\u0001\r!a5\t\u000f\u0005EV\u00031\u0001\u00024\"9\u00111\\\u000bA\u0002\u0005u\u0007bBAu+\u0001\u000711\u001e\t\u0007\u0003c\t\t)a;")
public final class CompactionTask
extends TierTask<CompactionTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private final OffsetMapSupplier offsetMapSupplier;
    private CompactionTaskState state;
    private final TierCompactionMetrics tierCompactionMetrics;
    private final Time time;
    private final long taskCreationTime;
    private volatile Option<TierLogToClean> logToClean;

    public static TierLogToClean getTierLogToClean(AbstractLog log, Time time, long now) {
        return CompactionTask$.MODULE$.getTierLogToClean(log, time, now);
    }

    public static TierObjectStoreLinearRetry DefaultRetryPolicy() {
        return CompactionTask$.MODULE$.DefaultRetryPolicy();
    }

    public static int DefaultRetryIntervalInMs() {
        return CompactionTask$.MODULE$.DefaultRetryIntervalInMs();
    }

    public static int DefaultMaxRetryCount() {
        return CompactionTask$.MODULE$.DefaultMaxRetryCount();
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public OffsetMapSupplier offsetMapSupplier() {
        return this.offsetMapSupplier;
    }

    public CompactionTaskState state() {
        return this.state;
    }

    public void state_$eq(CompactionTaskState x$1) {
        this.state = x$1;
    }

    public TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    @Override
    public String loggerName() {
        return CompactionTask.class.getName();
    }

    public long taskCreationTime() {
        return this.taskCreationTime;
    }

    public Option<TierLogToClean> logToClean() {
        return this.logToClean;
    }

    public void logToClean_$eq(Option<TierLogToClean> x$1) {
        this.logToClean = x$1;
    }

    public Option<TierLogToClean> maybeUpdateLogToClean(ReplicaManager replicaManager, long nowMillis, long updateInterval) {
        CompactionTaskState compactionTaskState = this.state();
        None$ optLog = compactionTaskState instanceof CleanLog ? replicaManager.getLog(this.topicPartition()).filter((Function1<AbstractLog, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isTierCompactable())) : None$.MODULE$;
        Option<TierLogToClean> updatedNextLogToClean = optLog.flatMap((Function1<AbstractLog, Option> & Serializable)log -> {
            if (this.logToClean().isEmpty() || this.logToClean().exists((Function1<TierLogToClean, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.stale(log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), updateInterval)))) {
                return new Some<TierLogToClean>(CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, $this.time, nowMillis));
            }
            return this.logToClean();
        });
        this.logToClean_$eq(updatedNextLogToClean);
        return updatedNextLogToClean;
    }

    @Override
    public Future<CompactionTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, Option<Throttler> throttler, ExecutionContext ec) {
        Future<CompactionTaskState> newState = this.ctx().isCancelled() ? Future$.MODULE$.successful(this.state()) : this.state().transition(this.ctx(), this.topicIdPartition(), replicaManager, tierTopicAppender, tierObjectStore, config, throttler.get(), this.offsetMapSupplier(), this.tierCompactionMetrics(), time, ec);
        return newState.map((Function1<CompactionTaskState, CompactionTask> & Serializable)result -> {
            this.onSuccessfulTransition();
            this.debug((Function0<String> & Serializable)() -> "Transitioned " + this.topicIdPartition() + " from " + this.state() + " to " + result);
            this.state_$eq((CompactionTaskState)result);
            return this;
        }, ec).recover(new Serializable(this, config, time){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactionTask $outer;
            private final TierTasksConfig config$1;
            private final Time time$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TierMetadataRetriableException) {
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)A1;
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), tierMetadataRetriableException);
                    return (B1)this.$outer;
                }
                if (A1 instanceof TierObjectStoreRetriableException) {
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)A1;
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), tierObjectStoreRetriableException);
                    return (B1)this.$outer;
                }
                if (A1 instanceof LogCleaningAbortedException) {
                    LogCleaningAbortedException logCleaningAbortedException = (LogCleaningAbortedException)A1;
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + ": compaction operation was aborted.", (Function0<Throwable>)(Function0<LogCleaningAbortedException> & Serializable)() -> logCleaningAbortedException);
                    return (B1)this.$outer;
                }
                if (A1 instanceof E2EChecksumInvalidException) {
                    E2EChecksumInvalidException e2EChecksumInvalidException = (E2EChecksumInvalidException)A1;
                    this.$outer.tierCompactionMetrics().e2eChecksumInvalidCount().foreach((Function1<Counter, Object> & Serializable)x$3 -> {
                        $anonfun$transition$3.$anonfun$applyOrElse$3(x$3);
                        return BoxedUnit.UNIT;
                    });
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + ": checksum mismatch while uploading new segment.", (Function0<Throwable>)(Function0<E2EChecksumInvalidException> & Serializable)() -> e2EChecksumInvalidException);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), e2EChecksumInvalidException);
                    return (B1)this.$outer;
                }
                if (A1 instanceof TierLogCompactionFencedException) {
                    TierLogCompactionFencedException tierLogCompactionFencedException = (TierLogCompactionFencedException)A1;
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " was fenced, stopping compaction process", (Function0<Throwable>)(Function0<TierLogCompactionFencedException> & Serializable)() -> tierLogCompactionFencedException);
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (A1 instanceof CancellationException) {
                    CancellationException cancellationException = (CancellationException)A1;
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " was fenced by cancellation context, stopping compaction process", (Function0<Throwable>)(Function0<CancellationException> & Serializable)() -> cancellationException);
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (A1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)A1;
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " is not tierable and cannot use tier compaction", (Function0<Throwable>)(Function0<NotTierablePartitionException> & Serializable)() -> notTierablePartitionException);
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.error((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + ": unhandled exception in CompactionTask. Moving task to error state", (Function0<Throwable> & Serializable)() -> A12);
                    this.$outer.cancelAndSetErrorState(A12);
                    return (B1)this.$outer;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof TierMetadataRetriableException) {
                    return true;
                }
                if (throwable instanceof TierObjectStoreRetriableException) {
                    return true;
                }
                if (throwable instanceof LogCleaningAbortedException) {
                    return true;
                }
                if (throwable instanceof E2EChecksumInvalidException) {
                    return true;
                }
                if (throwable instanceof TierLogCompactionFencedException) {
                    return true;
                }
                if (throwable instanceof CancellationException) {
                    return true;
                }
                if (throwable instanceof NotTierablePartitionException) {
                    return true;
                }
                return throwable != null;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(Counter x$3) {
                x$3.inc();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.time$1 = time$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$10(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$11(kafka.tier.exceptions.NotTierablePartitionException ), $anonfun$applyOrElse$12(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$13(java.lang.Throwable ), $anonfun$applyOrElse$2(org.apache.kafka.storage.internals.log.LogCleaningAbortedException ), $anonfun$applyOrElse$3$adapted(com.yammer.metrics.core.Counter ), $anonfun$applyOrElse$4(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$5(kafka.tier.exceptions.E2EChecksumInvalidException ), $anonfun$applyOrElse$6(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$7(kafka.tier.exceptions.TierLogCompactionFencedException ), $anonfun$applyOrElse$8(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$9(java.util.concurrent.CancellationException )}, serializedLambda);
            }
        }, ec);
    }

    public String toString() {
        return "CompactionTask(" + this.topicIdPartition() + ", state=" + this.state().getClass().getName() + ", cancelled=" + this.ctx().isCancelled() + ")";
    }

    public CompactionTask(CancellationContext ctx, TopicIdPartition topicIdPartition, OffsetMapSupplier offsetMapSupplier, CompactionTaskState state, TierCompactionMetrics tierCompactionMetrics, Time time) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.offsetMapSupplier = offsetMapSupplier;
        this.state = state;
        this.tierCompactionMetrics = tierCompactionMetrics;
        this.time = time;
        super(tierCompactionMetrics.retryRateOpt());
        this.taskCreationTime = time.milliseconds();
        this.logToClean = None$.MODULE$;
    }

    public static class CleanLog
    implements CompactionTaskState,
    Product,
    Serializable {
        private final int leaderEpoch;
        private final Option<CleanerStats> lastStats;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        @Override
        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public Option<CleanerStats> lastStats() {
            return this.lastStats;
        }

        @Override
        public Option<CleanerStats> cleanerStats() {
            return this.lastStats();
        }

        @Override
        public Future<CompactionTaskState> transition(CancellationContext ctx, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, TierTasksConfig config, Throttler throttler, OffsetMapSupplier offsetMapSupplier, TierCompactionMetrics tierCompactionMetrics, Time time, ExecutionContext ec) {
            CompactionTask$.MODULE$.info((Function0<String> & Serializable)() -> "Starting tier log compaction for " + topicIdPartition);
            if (config.compactionTaskConfig().isEmpty()) {
                throw new IllegalArgumentException("Compaction task config was unexpectedly empty");
            }
            return this.doCleanLog(ctx, tierTopicAppender, this.leaderEpoch(), topicIdPartition, replicaManager, offsetMapSupplier, config.compactionTaskConfig().get(), tierObjectStore, config.segmentMetadataLayoutPutMode(), tierCompactionMetrics, throttler, time, ec).map((Function1<CompactionTaskState, CompactionTaskState> & Serializable)state -> {
                CompactionTask$.MODULE$.info((Function0<String> & Serializable)() -> "Completed tier log compaction for " + topicIdPartition);
                return state;
            }, ec);
        }

        public Future<CompactionTaskState> doCleanLog(CancellationContext ctx, TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, OffsetMapSupplier offsetMapSupplier, CompactionTasksConfig config, TierObjectStore tierObjectStore, SegmentMetadataLayoutPutMode putMode, TierCompactionMetrics tierCompactionMetrics, Throttler throttler, Time time, ExecutionContext ec) {
            return Future$.MODULE$.apply((Function0<CompactionTaskState> & Serializable)() -> {
                Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Errors error = (Errors)((Object)((Object)left.value()));
                    throw new TierLogCompactionFencedException(topicIdPartition, (Throwable)error.exception());
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Partition partition = (Partition)right.value();
                    return (CompactionTaskState)partition.log().map((Function1<AbstractLog, CleanLog> & Serializable)log -> {
                        Option<CleanerStats> stats;
                        block32: {
                            OffsetMap offsetMap;
                            int tierEpoch = log.tierPartitionState().tierEpoch();
                            if (tierEpoch > leaderEpoch) {
                                throw new TierLogCompactionFencedException(topicIdPartition, TierLogCompactionFencedException$.MODULE$.$lessinit$greater$default$2());
                            }
                            if (tierEpoch < leaderEpoch) {
                                throw new TierMetadataRetriableException("Leadership not established for " + topicIdPartition + ". Backing off.");
                            }
                            if (partition.isUncleanLeader()) {
                                throw new TierMetadataRetriableException(topicIdPartition + " undergoing unclean leader recovery. Backing off.");
                            }
                            if (log.isTierMetadataStateRecovering()) {
                                throw new TierMetadataRetriableException(topicIdPartition + " undergoing tier metadata recovery. Backing off.");
                            }
                            if (log.isFrozenLogStartOffsetState()) {
                                throw new TierMetadataRetriableException(topicIdPartition + " undergoing tiered data recovery. Backing off.");
                            }
                            try {
                                offsetMap = offsetMapSupplier.getOffsetMap();
                            }
                            catch (Exception e) {
                                throw new TierMetadataRetriableException(topicIdPartition + " unable to borrow offset map from object pool. Backing off.", e);
                            }
                            OffsetMap offsetMap2 = offsetMap;
                            stats = this.lastStats();
                            try {
                                Tuple2<Long, CleanerStats> tuple2;
                                if (!log.isTierCompactable()) {
                                    CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Log for " + topicIdPartition + " is not tier compact enabled, but is attempting to clean tiered segments");
                                    break block32;
                                }
                                if (!log.tieredLogSegments().hasNext()) {
                                    CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Log for " + topicIdPartition + " was scheduled in tier CompactionTask but has no eligible tiered segments for compaction");
                                    throw new TierMetadataRetriableException("Log for " + topicIdPartition + " has no eligible tiered segments for tier compaction");
                                }
                                TierLogToClean cleanable = CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, time, time.milliseconds());
                                Function1<TopicPartition, Object> & Serializable checkDone = (Function1<TopicPartition, Object> & Serializable)x$4 -> {
                                    CleanLog.$anonfun$doCleanLog$5(ctx, x$4);
                                    return BoxedUnit.UNIT;
                                };
                                TierObjectStoreLinearRetry retryPolicy = CompactionTask$.MODULE$.DefaultRetryPolicy();
                                TierCleaner cleaner = new TierCleaner(offsetMap2, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, tierCompactionMetrics, time, tierObjectStore, putMode, tierTopicAppender, leaderEpoch, ctx, (Function1<TopicPartition, BoxedUnit>)checkDone, retryPolicy);
                                Optional<Long> lockedOffset = log.lockOffsetFromDeletion();
                                if (lockedOffset.isEmpty()) {
                                    CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Log for " + topicIdPartition + " is still locked by previous compaction round. Abort current operation and will be retried.");
                                    throw new LogCleaningAbortedException();
                                }
                                cleanable.firstCleanableOffset_$eq(Predef$.MODULE$.Long2long(lockedOffset.get()));
                                try {
                                    long tierEndOffset = log.tierPartitionState().endOffset();
                                    if (this.shouldDoDualCompactionValidation((AbstractLog)log, config) && cleanable.firstCleanableOffset() >= log.localLogStartOffset() && cleanable.firstCleanableOffset() <= tierEndOffset && !log.tierableLogSegments().iterator().hasNext()) {
                                        OffsetMap localOffsetMap = CleanLog.liftedTree1$1(offsetMapSupplier, topicIdPartition);
                                        try {
                                            CompactionTask$.MODULE$.info((Function0<String> & Serializable)() -> "Starting dual compaction validation for " + topicIdPartition + " for offset range [" + cleanable.firstCleanableOffset() + ", end offset=" + tierEndOffset + "]");
                                            ExtendedOffsetMap baseOffsetMap = new ExtendedOffsetMap(localOffsetMap);
                                            Cleaner localCleaner = new Cleaner(-1, localOffsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, time, tp -> checkDone.apply(tp), tierCompactionMetrics.cleanerMetrics());
                                            CleanerStats stats2 = new CleanerStats(time, tierCompactionMetrics.cleanerMetrics());
                                            Tuple2 tuple22 = CleanLog.liftedTree2$1(localCleaner, log, cleanable, tierEndOffset, baseOffsetMap, stats2, localOffsetMap);
                                            if (tuple22 == null) {
                                                throw new MatchError(tuple22);
                                            }
                                            boolean offsetMapSuccess = tuple22._1$mcZ$sp();
                                            String failReason = (String)tuple22._2();
                                            Tuple2<Boolean, String> tuple23 = new Tuple2<Boolean, String>(BoxesRunTime.boxToBoolean(offsetMapSuccess), failReason);
                                            boolean offsetMapSuccess2 = tuple23._1$mcZ$sp();
                                            String failReason2 = tuple23._2();
                                            if (!offsetMapSuccess2) {
                                                CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Abort dual compaction validation for " + log + ". " + failReason2);
                                                stats2.validationAborted();
                                            } else if (log.tierPartitionState().endOffset() != tierEndOffset) {
                                                CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Abort dual compaction validation for " + log + " because tierEndOffset changed. old tierEndOffset: " + tierEndOffset + ", new tierEndOffset: " + log.tierPartitionState().endOffset() + ".");
                                                stats2.validationAborted();
                                            } else {
                                                ValidateLogResult validateLogResult = cleaner.validateLog((AbstractLog)log, cleanable.firstCleanableOffset(), tierEndOffset + 1L, baseOffsetMap, stats2);
                                                if (((Object)((Object)ValidateLogResult.Passed)).equals((Object)validateLogResult)) {
                                                    CompactionTask$.MODULE$.info((Function0<String> & Serializable)() -> "Dual compaction validation for " + topicIdPartition + " passed");
                                                    stats2.validationPassed();
                                                } else if (((Object)((Object)ValidateLogResult.Failed)).equals((Object)validateLogResult)) {
                                                    CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Dual compaction validation for " + log + " failed");
                                                    stats2.validationFailed();
                                                } else if (((Object)((Object)ValidateLogResult.Aborted)).equals((Object)validateLogResult)) {
                                                    CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Dual compaction validation is not able to complete for " + log + ".");
                                                    stats2.validationAborted();
                                                }
                                            }
                                        }
                                        finally {
                                            offsetMapSupplier.reclaimOffsetMap(localOffsetMap);
                                        }
                                    }
                                    Map.Entry<Long, CleanerStats> cleanResult = cleaner.clean(cleanable);
                                    tuple2 = new Tuple2<Long, CleanerStats>(cleanResult.getKey(), cleanResult.getValue());
                                }
                                finally {
                                    log.unlockOffsetFromDeletion(cleanable.firstCleanableOffset());
                                }
                                Tuple2<Long, CleanerStats> tuple24 = tuple2;
                                if (tuple24 == null) {
                                    throw new MatchError(tuple24);
                                }
                                Long nextDirtyOffset = tuple24._1();
                                CleanerStats cleanerStats = tuple24._2();
                                Tuple2<Long, CleanerStats> tuple25 = new Tuple2<Long, CleanerStats>(nextDirtyOffset, cleanerStats);
                                Long nextDirtyOffset2 = tuple25._1();
                                CleanerStats cleanerStats2 = tuple25._2();
                                if (!BoxesRunTime.equalsNumObject(nextDirtyOffset2, BoxesRunTime.boxToInteger(-1))) {
                                    this.recordStats(this.toString(), topicIdPartition, cleanable.firstDirtyOffset(), Predef$.MODULE$.Long2long(nextDirtyOffset2), cleanerStats2);
                                }
                                stats = new Some<CleanerStats>(cleanerStats2);
                            }
                            finally {
                                offsetMapSupplier.reclaimOffsetMap(offsetMap2);
                            }
                        }
                        return new CleanLog(leaderEpoch, stats);
                    }).getOrElse((Function0<CleanLog> & Serializable)() -> this);
                }
                throw new MatchError(either);
            }, ec);
        }

        private boolean shouldDoDualCompactionValidation(AbstractLog log, CompactionTasksConfig config) {
            return log.config().confluentLogConfig().tierCleanerDualCompaction && config.dualCompactionValidationPercent() > 0 && log.tierPartitionState().totalSize() <= config.dualCompactionValidationMaxBytes() && new Random().nextInt(100) < config.dualCompactionValidationPercent();
        }

        public void recordStats(String task, TopicIdPartition topicIdPartition, long from, long to, CleanerStats stats) {
            String message = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tier Compaction Task: %s cleaned log %s (dirty section = [%d, %d))%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{task, topicIdPartition.toString(), BoxesRunTime.boxToLong(from), BoxesRunTime.boxToLong(to)})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble(stats.elapsedSecs()), BoxesRunTime.boxToDouble(CleanLog.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tAverage key size for records observed during this compaction run is %.2f bytes%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble((double)stats.keyBytesRead() / (double)stats.messagesRead())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble(stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble((double)100 * stats.bufferUtilization())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble(stats.elapsedSecs() - stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tThrottled time: %,.1f seconds (%.1f%% of total time)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(stats.throttledSecs()), BoxesRunTime.boxToDouble((double)100 * stats.throttledSecs() / stats.elapsedSecs())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong(stats.messagesRead())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong(stats.messagesWritten())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead())), BoxesRunTime.boxToDouble(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead()))}));
            CompactionTask$.MODULE$.info((Function0<String> & Serializable)() -> message);
            if (stats.invalidMessagesRead() > 0L) {
                CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(stats.invalidMessagesRead())})));
                return;
            }
        }

        public String toString() {
            return "CleanLog(leaderEpoch=" + this.leaderEpoch() + ")";
        }

        public CleanLog copy(int leaderEpoch, Option<CleanerStats> lastStats) {
            return new CleanLog(leaderEpoch, lastStats);
        }

        public int copy$default$1() {
            return this.leaderEpoch();
        }

        public Option<CleanerStats> copy$default$2() {
            return this.lastStats();
        }

        @Override
        public String productPrefix() {
            return "CleanLog";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger(this.leaderEpoch());
                }
                case 1: {
                    return this.lastStats();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof CleanLog;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "leaderEpoch";
                }
                case 1: {
                    return "lastStats";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.leaderEpoch());
            n = Statics.mix(n, Statics.anyHash(this.lastStats()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CleanLog)) return false;
            boolean bl = true;
            if (!bl) return false;
            CleanLog cleanLog = (CleanLog)x$1;
            if (this.leaderEpoch() != cleanLog.leaderEpoch()) return false;
            Option<CleanerStats> option = this.lastStats();
            Option<CleanerStats> option2 = cleanLog.lastStats();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!cleanLog.canEqual(this)) return false;
            return true;
        }

        public static final /* synthetic */ void $anonfun$doCleanLog$5(CancellationContext ctx$1, TopicPartition x$4) {
            if (ctx$1.isCancelled()) {
                throw new CancellationException("Operation cancelled");
            }
        }

        private static final /* synthetic */ OffsetMap liftedTree1$1(OffsetMapSupplier offsetMapSupplier$1, TopicIdPartition topicIdPartition$2) {
            OffsetMap offsetMap;
            try {
                offsetMap = offsetMapSupplier$1.getOffsetMap();
            }
            catch (Exception e) {
                throw new TierMetadataRetriableException(topicIdPartition$2 + " unable to borrow offset map from object pool for dual compaction validation. Backing off.", e);
            }
            return offsetMap;
        }

        private static final /* synthetic */ Tuple2 liftedTree2$1(Cleaner localCleaner$1, AbstractLog log$2, TierLogToClean cleanable$1, long tierEndOffset$1, ExtendedOffsetMap baseOffsetMap$1, CleanerStats stats$1, OffsetMap localOffsetMap$1) {
            Tuple2<Boolean, CallSite> tuple2;
            block3: {
                try {
                    if (localCleaner$1.buildOffsetMap(log$2, cleanable$1.firstCleanableOffset(), tierEndOffset$1 + 1L, baseOffsetMap$1, stats$1)) {
                        tuple2 = new Tuple2<Boolean, CallSite>(BoxesRunTime.boxToBoolean(false), (CallSite)((Object)("offset map is too small for storing all keys in offset range [" + cleanable$1.firstCleanableOffset() + ", " + tierEndOffset$1 + "]. Offset map memory: " + localOffsetMap$1.memory() + ", slots: " + localOffsetMap$1.slots() + ".")));
                        break block3;
                    }
                    tuple2 = new Tuple2<Boolean, String>(BoxesRunTime.boxToBoolean(true), "");
                }
                catch (Throwable e) {
                    tuple2 = new Tuple2<Boolean, CallSite>(BoxesRunTime.boxToBoolean(false), (CallSite)((Object)("exception encountered when building offset map for local data in offset range [" + cleanable$1.firstCleanableOffset() + ", " + tierEndOffset$1 + "]. " + e)));
                }
            }
            return tuple2;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanLog(int leaderEpoch, Option<CleanerStats> lastStats) {
            this.leaderEpoch = leaderEpoch;
            this.lastStats = lastStats;
            Product.$init$(this);
        }
    }

    public static interface CompactionTaskState {
        public int leaderEpoch();

        public Option<CleanerStats> cleanerStats();

        public Future<CompactionTaskState> transition(CancellationContext var1, TopicIdPartition var2, ReplicaManager var3, TierTopicAppender var4, TierObjectStore var5, TierTasksConfig var6, Throttler var7, OffsetMapSupplier var8, TierCompactionMetrics var9, Time var10, ExecutionContext var11);
    }
}

