/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.SegmentMetadataLayoutPutMode;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.log.CleanParams;
import io.confluent.kafka.storage.log.TierLogSegment;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.TierCompactionCommitAndSwap;
import io.confluent.kafka.storage.tier.domain.TierSegmentUploadInitiate;
import io.confluent.kafka.storage.tier.domain.TierUploadType;
import io.confluent.kafka.storage.tier.state.CompactStats;
import io.confluent.kafka.storage.tier.store.OpaqueData;
import io.confluent.kafka.storage.tier.store.objects.FragmentDescriptionWrapper;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import kafka.tier.exceptions.TierLogCompactionFatalException;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreRetryPolicy;
import kafka.tier.store.objects.CompactedSegmentUpload;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogCompactionUtils$;
import kafka.tier.tasks.compaction.TierLogSegmentReadAdapter;
import kafka.tier.tasks.compaction.TierLogSegmentReadAdapter$;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.CleanedTransactionMetadata;
import org.apache.kafka.storage.internals.log.Cleaner;
import org.apache.kafka.storage.internals.log.CleanerStats;
import org.apache.kafka.storage.internals.log.LastRecord;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.LogSegmentReadAdapter;
import org.apache.kafka.storage.internals.log.MergedLogUtils;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tmd\u0001\u0002\r\u001a\u0001\tB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%Q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011M\u0003!\u0011!Q\u0001\nQC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"AQ\u000e\u0001B\u0001B\u0003%a\u000e\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003>\u0011!)\bA!A!\u0002\u00131\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B?\t\u0015\u0005=\u0001A!A!\u0002\u0013\t\t\u0002C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005e\u0002\u0001\"\u0015\u0002<!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u0003S\u0003A\u0011BAV\u0011\u001d\tY\f\u0001C\u0005\u0003{C\u0001Ba\u0003\u0001\t\u0003I\"Q\u0002\u0005\b\u0005\u0017\u0002A\u0011\tB'\u0011\u001d\u0011)\u0007\u0001C!\u0005O\u00121\u0002V5fe\u000ecW-\u00198fe*\u0011!dG\u0001\u000bG>l\u0007/Y2uS>t'B\u0001\u000f\u001e\u0003\u0015!\u0018m]6t\u0015\tqr$\u0001\u0003uS\u0016\u0014(\"\u0001\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001a\t\u001a\u0011\u0005\u0011\u0002T\"A\u0013\u000b\u0005\u0019:\u0013a\u00017pO*\u0011\u0001&K\u0001\nS:$XM\u001d8bYNT!AK\u0016\u0002\u000fM$xN]1hK*\u0011\u0001\u0005\f\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014x-\u0003\u00022K\t91\t\\3b]\u0016\u0014\bCA\u001a7\u001b\u0005!$BA\u001b \u0003\u0015)H/\u001b7t\u0013\t9DGA\u0004M_\u001e<\u0017N\\4\u0002\u0013=4gm]3u\u001b\u0006\u0004\bC\u0001\u0013;\u0013\tYTEA\u0005PM\u001a\u001cX\r^'ba\u0006a\u0011n\u001c\"vM\u001a,'oU5{KB\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t\u0019\u0011J\u001c;\u0002\u001f5\f\u00070S8Ck\u001a4WM]*ju\u0016\f1\u0003Z;q\u0005V4g-\u001a:M_\u0006$g)Y2u_J\u0004\"A\u0010$\n\u0005\u001d{$A\u0002#pk\ndW-A\u0005uQJ|G\u000f\u001e7feB\u0011!\nT\u0007\u0002\u0017*\u0011QgJ\u0005\u0003\u001b.\u0013\u0011\u0002\u00165s_R$H.\u001a:\u0002+QLWM]\"p[B\f7\r^5p]6+GO]5dgB\u0011\u0001+U\u0007\u00023%\u0011!+\u0007\u0002\u0016)&,'oQ8na\u0006\u001cG/[8o\u001b\u0016$(/[2t\u0003\u0011!\u0018.\\3\u0011\u0005UKV\"\u0001,\u000b\u0005U:&B\u0001-,\u0003\u0019\u0019w.\\7p]&\u0011!L\u0016\u0002\u0005)&lW-A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f!\ti\u0006-D\u0001_\u0015\tyV$A\u0003ti>\u0014X-\u0003\u0002b=\nyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\u0004qkRlu\u000eZ3\u0011\u0005\u0011\\W\"A3\u000b\u0005)2'B\u0001\u0011h\u0015\tA\u0017.A\u0005d_:4G.^3oi*\t!.\u0001\u0002j_&\u0011A.\u001a\u0002\u001d'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uC2\u000b\u0017p\\;u!V$Xj\u001c3f\u0003E!\u0018.\u001a:U_BL7-\u00119qK:$WM\u001d\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cv\tQ\u0001^8qS\u000eL!a\u001d9\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'/A\u0006mK\u0006$WM]#q_\u000eD\u0017aA2uqB\u0011qO_\u0007\u0002q*\u0011\u00110H\u0001\bM\u0016$8\r[3s\u0013\tY\bPA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/A\u0005dQ\u0016\u001c7\u000eR8oKB1aH`A\u0001\u0003\u0013I!a` \u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\u0002\u0003\u000bi\u0011aV\u0005\u0004\u0003\u000f9&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004}\u0005-\u0011bAA\u0007\u007f\t!QK\\5u\u0003-\u0011X\r\u001e:z!>d\u0017nY=\u0011\u0007u\u000b\u0019\"C\u0002\u0002\u0016y\u0013!\u0004V5fe>\u0013'.Z2u'R|'/\u001a*fiJL\bk\u001c7jGf\fa\u0001P5oSRtDCHA\u000e\u0003;\ty\"!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\u00022\u0005M\u0012QGA\u001c!\t\u0001\u0006\u0001C\u00039\u001f\u0001\u0007\u0011\bC\u0003=\u001f\u0001\u0007Q\bC\u0003D\u001f\u0001\u0007Q\bC\u0003E\u001f\u0001\u0007Q\tC\u0003I\u001f\u0001\u0007\u0011\nC\u0003O\u001f\u0001\u0007q\nC\u0003T\u001f\u0001\u0007A\u000bC\u0003\\\u001f\u0001\u0007A\fC\u0003c\u001f\u0001\u00071\rC\u0003n\u001f\u0001\u0007a\u000eC\u0003u\u001f\u0001\u0007Q\bC\u0003v\u001f\u0001\u0007a\u000fC\u0003}\u001f\u0001\u0007Q\u0010C\u0004\u0002\u0010=\u0001\r!!\u0005\u0002\u00151|wmZ3s\u001d\u0006lW-\u0006\u0002\u0002>A!\u0011qHA'\u001d\u0011\t\t%!\u0013\u0011\u0007\u0005\rs(\u0004\u0002\u0002F)\u0019\u0011qI\u0011\u0002\rq\u0012xn\u001c;?\u0013\r\tYeP\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0013\u0011\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-s(A\u0003dY\u0016\fg\u000e\u0006\u0003\u0002X\u0005\u0015\u0005\u0003CA-\u0003[\n\u0019(a \u000f\t\u0005m\u0013q\r\b\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002f\u0005}\u0013\u0001B;uS2LA!!\u001b\u0002l\u0005\u0019Q*\u00199\u000b\t\u0005\u0015\u0014qL\u0005\u0005\u0003_\n\tHA\u0003F]R\u0014\u0018P\u0003\u0003\u0002j\u0005-\u0004\u0003BA;\u0003wj!!a\u001e\u000b\t\u0005e\u0014qL\u0001\u0005Y\u0006tw-\u0003\u0003\u0002~\u0005]$\u0001\u0002'p]\u001e\u00042\u0001JAA\u0013\r\t\u0019)\n\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\b\u0003\u000f\u000b\u0002\u0019AAE\u0003%\u0019G.Z1oC\ndW\r\u0005\u0003\u0002\f\u0006=UBAAG\u0015\t1S-\u0003\u0003\u0002\u0012\u00065%aC\"mK\u0006t\u0007+\u0019:b[N\f1\u0002Z8US\u0016\u00148\t\\3b]R1\u0011qSAQ\u0003K\u0003rAPAM\u0003;\u000by(C\u0002\u0002\u001c~\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001 \u0002 &\u0019\u0011QP \t\u000f\u0005\r&\u00031\u0001\u0002\n\u0006Y1\r\\3b]B\u000b'/Y7t\u0011\u001d\t9K\u0005a\u0001\u0003;\u000b1bY;se\u0016tG\u000fV5nK\u00061R\u000f\u001d3bi\u0016$G*Y:u\u00072,\u0017M\\(gMN,G\u000f\u0006\u0004\u0002\u001e\u00065\u0016\u0011\u0017\u0005\b\u0003_\u001b\u0002\u0019AAO\u00039\u0001(o\u001c9pg\u0016$wJ\u001a4tKRDq!a-\u0014\u0001\u0004\t),\u0001\td_6\u0004\u0018m\u0019;D_6\u0004H.\u001a;fIB\u0019a(a.\n\u0007\u0005evHA\u0004C_>dW-\u00198\u00027\r\u0014X-\u0019;f\u0003:$wK]5uK\u000e{W.\\5u\u0003:$7k^1q)Q\tI!a0\u0002H\u0006U\u0017\u0011\\Ao\u0003?\f)Pa\u0001\u0003\b!1a\u0005\u0006a\u0001\u0003\u0003\u0004B!a#\u0002D&!\u0011QYAG\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u000f\u0005%G\u00031\u0001\u0002L\u0006\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003\u001b\f\t.\u0004\u0002\u0002P*\u0011a$Z\u0005\u0005\u0003'\fyM\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"1\u0011q\u001b\u000bA\u0002u\n\u0011\u0002^5fe\u0016\u0003xn\u00195\t\u000f\u0005mG\u00031\u0001\u0002\u0000\u0005)1\u000f^1ug\"9\u00111\u0017\u000bA\u0002\u0005U\u0006bBAq)\u0001\u0007\u00111]\u0001\u000fg>,(oY3TK\u001elWM\u001c;t!\u0019\t)/a;\u0002p6\u0011\u0011q\u001d\u0006\u0004\u0003S|\u0014AC2pY2,7\r^5p]&!\u0011Q^At\u0005!IE/\u001a:bE2,\u0007\u0003BAF\u0003cLA!a=\u0002\u000e\nqA+[3s\u0019><7+Z4nK:$\bbBA|)\u0001\u0007\u0011\u0011`\u0001\u0015I\u0016\u001cH/\u001b8bi&|gn\u00142kK\u000e$\u0018\nZ:\u0011\r\u0005\u0015\u00181^A~!\u0011\ti0a@\u000e\u0005\u0005-\u0014\u0002\u0002B\u0001\u0003W\u0012A!V+J\t\"9!Q\u0001\u000bA\u0002\u0005u\u0015\u0001\u00054jeN$8\t\\3b]>3gm]3u\u0011\u001d\u0011I\u0001\u0006a\u0001\u0003;\u000bq\u0002\\1ti\u000ecW-\u00198PM\u001a\u001cX\r^\u0001\u000eG2,\u0017M\\*fO6,g\u000e^:\u0015)\t=!1\u0005B\u0013\u0005_\u0011\u0019D!\u000e\u00038\t\u0005#Q\tB%!\u001dq\u0014\u0011\u0014B\t\u0005;\u0001bAa\u0005\u0003\u001a\u0005=XB\u0001B\u000b\u0015\u0011\u00119\"a:\u0002\u000f5,H/\u00192mK&!!1\u0004B\u000b\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0004I\t}\u0011b\u0001B\u0011K\tQAj\\4TK\u001elWM\u001c;\t\r\u0019*\u0002\u0019AAa\u0011\u001d\u00119#\u0006a\u0001\u0005S\t\u0001b]3h[\u0016tGo\u001d\t\u0007\u0005'\u0011Y#a<\n\t\t5\"Q\u0003\u0002\u0006#V,W/\u001a\u0005\u0007\u0005c)\u0002\u0019A\u001d\u0002\u00075\f\u0007\u000fC\u0004\u0002(V\u0001\r!!(\t\u000f\u0005mW\u00031\u0001\u0002\u0000!9!\u0011H\u000bA\u0002\tm\u0012a\u0005;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007c\u0001\u0013\u0003>%\u0019!qH\u0013\u00035\rcW-\u00198fIR\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\t\u000f\t\rS\u00031\u0001\u0002\u001e\u0006)B.Z4bGf$U\r\\3uK\"{'/\u001b>p]6\u001b\bb\u0002B$+\u0001\u0007\u0011QT\u0001 kB\u0004XM\u001d\"pk:$wJ\u001a4tKR|em\u00117fC:Lgn\u001a*pk:$\u0007bBAe+\u0001\u0007\u00111Z\u0001\fY><7+Z4nK:$8\u000f\u0006\u0005\u0003P\tm#Q\fB1!\u0019\tiP!\u0015\u0003V%!!1KA6\u0005\u0011a\u0015n\u001d;\u0011\u0007\u0011\u00129&C\u0002\u0003Z\u0015\u0012Q\u0003T8h'\u0016<W.\u001a8u%\u0016\fG-\u00113baR,'\u000f\u0003\u0004'-\u0001\u0007\u0011\u0011\u0019\u0005\b\u0005?2\u0002\u0019AAO\u0003\u00111'o\\7\t\u000f\t\rd\u00031\u0001\u0002\u001e\u0006\u0011Ao\\\u0001\u001bG>dG.Z2u\u0003\n|'\u000f^3e)J\fgn]1di&|gn\u001d\u000b\t\u0005S\u0012\tHa\u001d\u0003xA1\u0011Q B)\u0005W\u00022\u0001\nB7\u0013\r\u0011y'\n\u0002\u000b\u0003\n|'\u000f^3e)bt\u0007B\u0002\u0014\u0018\u0001\u0004\t\t\rC\u0004\u0003v]\u0001\r!!(\u0002\u000bM$\u0018M\u001d;\t\u000f\tet\u00031\u0001\u0002\u001e\u0006\u0019QM\u001c3")
public class TierCleaner
extends Cleaner
implements Logging {
    private final OffsetMap offsetMap;
    private final TierCompactionMetrics tierCompactionMetrics;
    private final Time time;
    private final TierObjectStore tierObjectStore;
    private final SegmentMetadataLayoutPutMode putMode;
    private final TierTopicAppender tierTopicAppender;
    private final int leaderEpoch;
    private final CancellationContext ctx;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private final TierObjectStoreRetryPolicy retryPolicy;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierCleaner tierCleaner = this;
        synchronized (tierCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return TierCleaner.class.getName();
    }

    @Override
    public Map.Entry<Long, CleanerStats> clean(CleanParams cleanable) {
        this.checkDone.apply(cleanable.log().topicPartition());
        Tuple2<Object, CleanerStats> tuple2 = this.doTierClean(cleanable, this.time.milliseconds());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        CleanerStats cleanerStats = tuple2._2();
        Tuple2<Long, CleanerStats> tuple22 = new Tuple2<Long, CleanerStats>(BoxesRunTime.boxToLong(nextDirtyOffset), cleanerStats);
        long nextDirtyOffset2 = tuple22._1$mcJ$sp();
        CleanerStats cleanerStats2 = tuple22._2();
        double bytesShrinkageRatio = 1.0 - (double)cleanerStats2.bytesWritten() / (double)cleanerStats2.bytesRead();
        cleanable.log().updateLastShrinkageRatio(bytesShrinkageRatio);
        return Map.entry(Predef$.MODULE$.long2Long(nextDirtyOffset2), cleanerStats2);
    }

    private Tuple2<Object, CleanerStats> doTierClean(CleanParams cleanParams, long currentTime) {
        long l;
        this.info((Function0<String> & Serializable)() -> "Beginning cleaning of log " + cleanParams.log().name() + " with " + cleanParams);
        Option option = CollectionConverters$.MODULE$.CollectionHasAsScala(cleanParams.log().localLogSegments(0L, cleanParams.firstDirtyOffset())).asScala().lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            LogSegment seg = (LogSegment)some.value();
            l = seg.lastModified() - cleanParams.log().config().deleteRetentionMs;
        } else {
            throw new MatchError(option);
        }
        long legacyDeleteHorizonMs = l;
        if (cleanParams.topicIdPartition().isEmpty()) {
            throw new IllegalArgumentException("CleanParams for tiered compactions must have a valid topic id partition " + cleanParams);
        }
        AbstractLog log = cleanParams.log();
        TopicIdPartition topicIdPartition = cleanParams.topicIdPartition().get();
        CleanerStats stats = new CleanerStats(this.time, this.tierCompactionMetrics.cleanerMetrics());
        long firstDirtyOffset = cleanParams.firstDirtyOffset();
        long upperBoundOffset = cleanParams.firstUncleanableOffset();
        boolean isOffsetMapFull = this.buildOffsetMap(log, firstDirtyOffset, upperBoundOffset, this.offsetMap, stats);
        if (this.offsetMap.latestOffset() == -1L) {
            this.info((Function0<String> & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset map for %s has latest offset of -1, no offsets to compact"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{log.name()})));
            return new Tuple2<Object, CleanerStats>(BoxesRunTime.boxToLong(-1L), stats);
        }
        long endOffset = this.offsetMap.latestOffset() + 1L;
        stats.indexDone(isOffsetMapFull);
        this.debug((Function0<String> & Serializable)() -> "CompactionTask for " + topicIdPartition + " endOffset: " + endOffset + " upperBoundOffset: " + upperBoundOffset);
        Queue tieredSegments = (Queue)new Queue<TierLogSegment>(Queue$.MODULE$.$lessinit$greater$default$1()).$plus$plus$eq(CollectionConverters$.MODULE$.IteratorHasAsScala(log.tieredLogSegments(cleanParams.startOffset(), endOffset)).asScala());
        long cleanableHorizonMs = BoxesRunTime.unboxToLong(tieredSegments.lastOption().map((Function1<TierLogSegment, Object> & Serializable)x$13 -> BoxesRunTime.boxToLong(x$13.maxTimestamp())).getOrElse(() -> 0L));
        this.info((Function0<String> & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)..."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(legacyDeleteHorizonMs)})));
        this.debug((Function0<String> & Serializable)() -> "Cleaning log tiered segments for cleaning " + tieredSegments.map((Function1<TierLogSegment, ObjectMetadata> & Serializable)x$14 -> x$14.metadata()) + " vs " + log.tieredLogSegments());
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        while (tieredSegments.nonEmpty()) {
            Tuple2<ListBuffer<TierLogSegment>, LogSegment> tuple2 = this.cleanSegments(log, tieredSegments, this.offsetMap, currentTime, stats, transactionMetadata, legacyDeleteHorizonMs, upperBoundOffset, topicIdPartition);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ListBuffer<TierLogSegment> segmentsUsed = tuple2._1();
            LogSegment cleanedSegment = tuple2._2();
            Tuple2<ListBuffer<TierLogSegment>, LogSegment> tuple22 = new Tuple2<ListBuffer<TierLogSegment>, LogSegment>(segmentsUsed, cleanedSegment);
            ListBuffer<TierLogSegment> segmentsUsed2 = tuple22._1();
            LogSegment cleanedSegment2 = tuple22._2();
            this.debug((Function0<String> & Serializable)() -> "Cleaning " + topicIdPartition + ", after cleanSegments we have used " + segmentsUsed2 + " with " + tieredSegments + " left");
            try {
                java.util.List<FragmentDescriptionWrapper> list;
                if (segmentsUsed2.isEmpty()) {
                    transactionMetadata = new CleanedTransactionMetadata();
                    this.info((Function0<String> & Serializable)() -> topicIdPartition + ": cleanSegments cleaned no segment because some source segments are deleted. Continue to clean next source segment");
                    continue;
                }
                if (cleanedSegment2.size() == 0) {
                    boolean compactCompleted = true;
                    long firstCleanOffset = cleanParams.startOffset();
                    long lastCleanOffset = this.updatedLastCleanOffset(segmentsUsed2.last().endOffset(), compactCompleted);
                    this.info((Function0<String> & Serializable)() -> "Fully deleting all segments for " + topicIdPartition + " due to empty generated segment source source segments " + segmentsUsed2);
                    this.createAndWriteCommitAndSwap(log, topicIdPartition, this.leaderEpoch, stats, compactCompleted, segmentsUsed2, Nil$.MODULE$, firstCleanOffset, lastCleanOffset);
                    continue;
                }
                Option<ByteBuffer> producerStateOpt = TierLogCompactionUtils$.MODULE$.fetchProducerState(this.tierObjectStore, segmentsUsed2.last(), this.ctx, this.retryPolicy);
                Option<ByteBuffer> epochStateOpt = TierLogCompactionUtils$.MODULE$.fetchEpochState(this.tierObjectStore, segmentsUsed2.last(), this.ctx, this.retryPolicy);
                long nextOffset = segmentsUsed2.last().endOffset() + 1L;
                java.util.List<AbortedTxn> completedAbortedTxns = cleanedSegment2.collectAbortedTxns((long)cleanedSegment2.baseOffset(), (long)nextOffset, (boolean)true).abortedTransactions;
                java.util.List ongoingAbortedTxns = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(transactionMetadata.ongoingAbortedTxns().values()).asScala().filter((Function1<CleanedTransactionMetadata.AbortedTransactionMetadata, Object> & Serializable)x$16 -> BoxesRunTime.boxToBoolean(x$16.lastRetainedBatchOffset.isPresent()))).map((Function1<CleanedTransactionMetadata.AbortedTransactionMetadata, AbortedTxn> & Serializable)x$17 -> x$17.abortedTxn)).toList().sortBy((Function1<AbortedTxn, Object> & Serializable)x$18 -> BoxesRunTime.boxToLong(x$18.lastOffset()), (Ordering)Ordering.Long$.MODULE$)).asJava();
                ArrayList<AbortedTxn> abortedTxns = new ArrayList<AbortedTxn>(completedAbortedTxns.size() + ongoingAbortedTxns.size());
                abortedTxns.addAll(completedAbortedTxns);
                abortedTxns.addAll(ongoingAbortedTxns);
                Optional<ByteBuffer> abortedTxnsBytes = AbortedTxn.serialize(abortedTxns);
                TierObjectStore.ByokKeyHolder byokKeyHolder = this.tierObjectStore.prepPutSegment(topicIdPartition);
                OpaqueData opaqueData = byokKeyHolder.opaqueData;
                Optional<ByteBuffer> encryptedDek = Optional.ofNullable(byokKeyHolder.encryptedDek);
                try {
                    list = FragmentDescriptionWrapper.createFragmentDescriptionsList(topicIdPartition, this.putMode, cleanedSegment2.size(), cleanedSegment2.offsetIndex().length(), cleanedSegment2.timeIndex().length(), BoxesRunTime.unboxToInt(OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(abortedTxnsBytes)).map((Function1<ByteBuffer, Object> & Serializable)bb -> BoxesRunTime.boxToInteger(TierCleaner.$anonfun$doTierClean$15(bb))).getOrElse(() -> 0)), BoxesRunTime.unboxToInt(epochStateOpt.map((Function1<ByteBuffer, Object> & Serializable)bb -> BoxesRunTime.boxToInteger(TierCleaner.$anonfun$doTierClean$17(bb))).getOrElse(() -> 0)), BoxesRunTime.unboxToInt(producerStateOpt.map((Function1<ByteBuffer, Object> & Serializable)bb -> BoxesRunTime.boxToInteger(TierCleaner.$anonfun$doTierClean$19(bb))).getOrElse(() -> 0)));
                }
                catch (IllegalArgumentException e) {
                    throw new TierLogCompactionFatalException("CompactionTask failed while attempting to describe the metadata layout of a segment from " + topicIdPartition + ".", (Throwable)e);
                }
                java.util.List<FragmentDescriptionWrapper> fragmentDescriptionsList = list;
                TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, this.leaderEpoch, UUID.randomUUID(), Optional.empty(), cleanedSegment2.baseOffset(), cleanedSegment2.readNextOffset() - 1L, cleanedSegment2.largestTimestamp(), cleanedSegment2.getFirstBatchTimestamp(), cleanedSegment2.size(), epochStateOpt.isDefined(), abortedTxnsBytes.isPresent(), producerStateOpt.isDefined(), TierUploadType.Compaction, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), opaqueData, encryptedDek, Optional.of(fragmentDescriptionsList));
                TierLogCompactionUtils$.MODULE$.writeUploadInitiateMarker(uploadInitiate, topicIdPartition, this.time, this.tierTopicAppender);
                ObjectMetadata objectStoreMetadata = new ObjectMetadata(topicIdPartition, uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), uploadInitiate.hasEpochState(), opaqueData, uploadInitiate.segmentAndMetadataLayout().orElse(null));
                this.tierObjectStore.putSegment(new CompactedSegmentUpload(this.putMode, objectStoreMetadata, cleanedSegment2.log().file(), cleanedSegment2.offsetIndex().file(), cleanedSegment2.timeIndex().file(), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(producerStateOpt)), abortedTxnsBytes, OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(epochStateOpt))));
                boolean compactCompleted = tieredSegments.isEmpty();
                long firstCleanOffset = cleanParams.startOffset();
                long lastCleanOffset = this.updatedLastCleanOffset(uploadInitiate.endOffset(), compactCompleted);
                this.createAndWriteCommitAndSwap(log, topicIdPartition, this.leaderEpoch, stats, compactCompleted, segmentsUsed2, new $colon$colon<Nothing$>((Nothing$)((Object)uploadInitiate.objectId()), Nil$.MODULE$), firstCleanOffset, lastCleanOffset);
            }
            finally {
                if (cleanedSegment2 == null) continue;
                cleanedSegment2.deleteIfExists();
            }
        }
        stats.setBufferUtilization(this.offsetMap.utilization());
        stats.allDone();
        return new Tuple2<Object, CleanerStats>(BoxesRunTime.boxToLong(endOffset), stats);
    }

    private long updatedLastCleanOffset(long proposedOffset, boolean compactCompleted) {
        if (proposedOffset >= this.offsetMap.latestOffset()) {
            return this.offsetMap.latestOffset();
        }
        if (compactCompleted) {
            return this.offsetMap.latestOffset();
        }
        return proposedOffset;
    }

    private void createAndWriteCommitAndSwap(AbstractLog log, TopicIdPartition topicIdPartition, int tierEpoch, CleanerStats stats, boolean compactCompleted, Iterable<TierLogSegment> sourceSegments, Iterable<UUID> destinationObjectIds, long firstCleanOffset, long lastCleanOffset) {
        Set<UUID> sourceObjectIds = CollectionConverters$.MODULE$.SetHasAsJava(((IterableOnceOps)sourceSegments.map((Function1<TierLogSegment, UUID> & Serializable)x$19 -> x$19.metadata().objectId())).toSet()).asJava();
        CompactStats compactStats = compactCompleted ? new CompactStats(stats.bytesRead(), stats.bytesWritten(), stats.mapBytesRead()) : CompactStats.EMPTY;
        TierCompactionCommitAndSwap commitAndSwap = new TierCompactionCommitAndSwap(topicIdPartition, tierEpoch, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), UUID.randomUUID(), sourceObjectIds, CollectionConverters$.MODULE$.SetHasAsJava(destinationObjectIds.toSet()).asJava(), firstCleanOffset, lastCleanOffset, compactStats);
        TierLogCompactionUtils$.MODULE$.writeCommitAndSwapMarker(commitAndSwap, topicIdPartition, this.time, this.tierTopicAppender);
    }

    public Tuple2<ListBuffer<TierLogSegment>, LogSegment> cleanSegments(AbstractLog log, Queue<TierLogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs, long upperBoundOffsetOfCleaningRound, TopicIdPartition topicIdPartition) {
        this.info((Function0<String> & Serializable)() -> "Cleaning log " + log.name() + " cleanSegments tiered segments " + segments);
        ListBuffer<TierLogSegment> segmentsUsed = new ListBuffer<TierLogSegment>();
        ChecksumParams checksumParams = new ChecksumParams(log.checksumParams().checksumStoreOpt(), log.checksumParams().e2eChecksumEnabledForTopic(), false);
        LogSegment cleanedSegment = MergedLogUtils.createNewCleanedSegment(log.dir(), log.config(), ((TierLogSegment)segments.head()).baseOffset(), true, checksumParams);
        transactionMetadata.setCleanedIndex(Optional.ofNullable(cleanedSegment.txnIndex()));
        Map<Long, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
        boolean cleanedSegmentDone = false;
        int targetSegmentSize = log.config().segmentSize();
        int minSegmentSize = log.config().confluentLogConfig().tierCleanerCompactSegmentMinBytes;
        int maxSegmentSize = Integer.MAX_VALUE;
        while (segments.nonEmpty() && !cleanedSegmentDone) {
            TierLogSegment currentSegment = (TierLogSegment)segments.head();
            cleanedSegmentDone = !TierLogCompactionUtils$.MODULE$.shouldCompactNextSourceSegmentIntoDestSegment(topicIdPartition, cleanedSegment, currentSegment, targetSegmentSize, minSegmentSize, maxSegmentSize);
            if (cleanedSegmentDone) continue;
            List<AbortedTxn> abortedTransactions = TierLogCompactionUtils$.MODULE$.fetchAbortedTransactions(this.tierObjectStore, currentSegment, this.ctx, this.retryPolicy);
            transactionMetadata.addAbortedTransactions(CollectionConverters$.MODULE$.SeqHasAsJava(abortedTransactions).asJava());
            boolean retainLegacyDeletesAndTxnMarkers = currentSegment.maxTimestamp() > legacyDeleteHorizonMs;
            try {
                this.info((Function0<String> & Serializable)() -> topicIdPartition + ": cleaning " + currentSegment + " into " + cleanedSegment.baseOffset() + " with upper bound deleteHorizonMs=" + legacyDeleteHorizonMs + ", retainDeletesAndTxnMarkers=" + retainLegacyDeletesAndTxnMarkers + ".");
                segments.dequeue();
                if (currentSegment.endOffset() < log.logStartOffset()) {
                    this.info((Function0<String> & Serializable)() -> topicIdPartition + ": end offset of segment " + currentSegment + " is smaller than log start offset " + log.logStartOffset() + ". Discard current result and continue to clean next segments.");
                    segmentsUsed.clear();
                    cleanedSegmentDone = true;
                    continue;
                }
                segmentsUsed.$plus$eq(currentSegment);
                TierLogSegmentReadAdapter segmentAdapter = TierLogSegmentReadAdapter$.MODULE$.apply(currentSegment, this.tierObjectStore, this.ctx, this.retryPolicy);
                this.cleanInto(log.topicPartition(), segmentAdapter, cleanedSegment, map, retainLegacyDeletesAndTxnMarkers, log.config().deleteRetentionMs, log.config().maxMessageSize(), transactionMetadata, lastOffsetOfActiveProducers, upperBoundOffsetOfCleaningRound, stats, currentTime, log.config().confluentLogConfig().logCleanerTimestampValidationEnable);
            }
            catch (LogSegmentOffsetOverflowException e) {
                this.error((Function0<String> & Serializable)() -> topicIdPartition + ": LogSegmentOffsetOverflowException cause to abort, " + e.getCause());
                try {
                    try {
                        cleanedSegment.deleteIfExists();
                    }
                    catch (Exception deleteException) {
                        e.addSuppressed(deleteException);
                    }
                }
                finally {
                    throw new TierLogCompactionFencedException(topicIdPartition, e.getCause());
                }
            }
        }
        cleanedSegment.onBecomeInactiveSegment();
        return new Tuple2<ListBuffer<TierLogSegment>, LogSegment>(segmentsUsed, cleanedSegment);
    }

    @Override
    public java.util.List<LogSegmentReadAdapter> logSegments(AbstractLog log, long from, long to) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(CollectionConverters$.MODULE$.IteratorHasAsScala(log.tieredLogSegments(from, to)).asScala().map((Function1<TierLogSegment, TierLogSegmentReadAdapter> & Serializable)x$20 -> TierLogSegmentReadAdapter$.MODULE$.apply((TierLogSegment)x$20, $this.tierObjectStore, $this.ctx, $this.retryPolicy)).dropWhile((Function1<TierLogSegmentReadAdapter, Object> & Serializable)x$21 -> BoxesRunTime.boxToBoolean(TierCleaner.$anonfun$logSegments$2(from, x$21))).toList()).asJava();
    }

    @Override
    public java.util.List<AbortedTxn> collectAbortedTransactions(AbstractLog log, long start, long end) {
        Iterator<TierLogSegment> tieredSegments = CollectionConverters$.MODULE$.IteratorHasAsScala(log.tieredLogSegments(start, end)).asScala();
        HashSet abortedTxnSet = new HashSet();
        tieredSegments.foreach((Function1<TierLogSegment, HashSet> & Serializable)segment -> {
            List<AbortedTxn> abortedTransactions = TierLogCompactionUtils$.MODULE$.fetchAbortedTransactions($this.tierObjectStore, (TierLogSegment)segment, $this.ctx, $this.retryPolicy);
            return (HashSet)abortedTxnSet.$plus$plus$eq(abortedTransactions);
        });
        return CollectionConverters$.MODULE$.SeqHasAsJava(abortedTxnSet.toList()).asJava();
    }

    public static final /* synthetic */ int $anonfun$doTierClean$15(ByteBuffer bb) {
        return bb.limit() - bb.position();
    }

    public static final /* synthetic */ int $anonfun$doTierClean$17(ByteBuffer bb) {
        return bb.limit() - bb.position();
    }

    public static final /* synthetic */ int $anonfun$doTierClean$19(ByteBuffer bb) {
        return bb.limit() - bb.position();
    }

    public static final /* synthetic */ boolean $anonfun$logSegments$2(long from$1, TierLogSegmentReadAdapter x$21) {
        return x$21.endOffset() < from$1;
    }

    public TierCleaner(OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, TierCompactionMetrics tierCompactionMetrics, Time time, TierObjectStore tierObjectStore, SegmentMetadataLayoutPutMode putMode, TierTopicAppender tierTopicAppender, int leaderEpoch, CancellationContext ctx, Function1<TopicPartition, BoxedUnit> checkDone, TierObjectStoreRetryPolicy retryPolicy) {
        this.offsetMap = offsetMap;
        this.tierCompactionMetrics = tierCompactionMetrics;
        this.time = time;
        this.tierObjectStore = tierObjectStore;
        this.putMode = putMode;
        this.tierTopicAppender = tierTopicAppender;
        this.leaderEpoch = leaderEpoch;
        this.ctx = ctx;
        this.checkDone = checkDone;
        this.retryPolicy = retryPolicy;
        super(-1, offsetMap, ioBufferSize, maxIoBufferSize, dupBufferLoadFactor, throttler, time, new Consumer<TopicPartition>(checkDone){
            private final Function1 checkDone$2;

            public Consumer<TopicPartition> andThen(Consumer<? super TopicPartition> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public final void accept(TopicPartition x$1) {
                this.checkDone$2.apply(x$1);
            }
            {
                this.checkDone$2 = checkDone$2;
            }
        }, tierCompactionMetrics.cleanerMetrics());
        Logging.$init$(this);
        this.logIdent_$eq("TierCleaner " + this.id + ": ");
    }
}

