/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.Serializable;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StartPartitionDeletion;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.delete.DeletionMetrics;
import kafka.tier.tasks.delete.DeletionTask;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a!B\u0006\r\u00011!\u0002\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0003F\u0001\u0011\u0005a\t\u0003\u0004N\u0001\u0011EcB\u0014\u0005\u00079\u0002!\tFD/\t\rE\u0004A\u0011\u000b\bs\u0011\u0015Y\b\u0001\"\u0003}\u0005E!U\r\\3uS>tG+Y:l#V,W/\u001a\u0006\u0003\u001b9\ta\u0001Z3mKR,'BA\b\u0011\u0003\u0015!\u0018m]6t\u0015\t\t\"#\u0001\u0003uS\u0016\u0014(\"A\n\u0002\u000b-\fgm[1\u0014\u0005\u0001)\u0002c\u0001\f\u001835\ta\"\u0003\u0002\u0019\u001d\tiA+[3s)\u0006\u001c8.U;fk\u0016\u0004\"AG\u000e\u000e\u00031I!\u0001\b\u0007\u0003\u0019\u0011+G.\u001a;j_:$\u0016m]6\u0002\u0007\r$\bp\u0001\u0001\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\u0002\u0012a\u00024fi\u000eDWM]\u0005\u0003I\u0005\u00121cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqR\f\u0001\"\\1y)\u0006\u001c8n\u001d\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0004\u0013:$\u0018\u0001\u0002;j[\u0016\u0004\"A\f\u001d\u000e\u0003=R!\u0001M\u0019\u0002\u000bU$\u0018\u000e\\:\u000b\u0005I\u001a\u0014AB2p[6|gN\u0003\u0002\u0014i)\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h\u0013\tItF\u0001\u0003US6,\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003y}j\u0011!\u0010\u0006\u0003}I\taa]3sm\u0016\u0014\u0018B\u0001!>\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fq\u0002Z3mKRLwN\\'fiJL7m\u001d\t\u00035\rK!\u0001\u0012\u0007\u0003\u001f\u0011+G.\u001a;j_:lU\r\u001e:jGN\fa\u0001P5oSRtDCB$I\u0013*[E\n\u0005\u0002\u001b\u0001!)QD\u0002a\u0001?!)QE\u0002a\u0001M!)AF\u0002a\u0001[!)!H\u0002a\u0001w!)\u0011I\u0002a\u0001\u0005\u0006I1o\u001c:u)\u0006\u001c8n\u001d\u000b\u0003\u001fn\u00032\u0001\u0015-\u001a\u001d\t\tfK\u0004\u0002S+6\t1K\u0003\u0002U=\u00051AH]8pizJ\u0011!K\u0005\u0003/\"\nq\u0001]1dW\u0006<W-\u0003\u0002Z5\n!A*[:u\u0015\t9\u0006\u0006C\u0003\u0010\u000f\u0001\u0007q*A\u0004oK^$\u0016m]6\u0015\u0007eqF\u000eC\u0003`\u0011\u0001\u0007\u0001-\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B\u0011\u0011M[\u0007\u0002E*\u0011\u0011c\u0019\u0006\u0003I\u0016\fqa\u001d;pe\u0006<WM\u0003\u0002\u0014M*\u0011q\r[\u0001\nG>tg\r\\;f]RT\u0011![\u0001\u0003S>L!a\u001b2\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\"B7\t\u0001\u0004q\u0017AB2iC:<W\r\u0005\u0002\u0017_&\u0011\u0001O\u0004\u0002\u0014'R\f'\u000f^\"iC:<W-T3uC\u0012\fG/Y\u0001\u000b[\u0006L\bK]8dKN\u001cHCA:w!\t9C/\u0003\u0002vQ\t9!i\\8mK\u0006t\u0007\"B<\n\u0001\u0004A\u0018\u0001C7fi\u0006$\u0017\r^1\u0011\u0005YI\u0018B\u0001>\u000f\u00059\u0019\u0005.\u00198hK6+G/\u00193bi\u0006\fA\u0002^1tWB\u0013\u0018n\u001c:jif$2!`A\u0001!\t9c0\u0003\u0002\u0000Q\t!Aj\u001c8h\u0011\u0019\t\u0019A\u0003a\u00013\u0005!A/Y:l\u0001")
public class DeletionTaskQueue
extends TierTaskQueue<DeletionTask> {
    private final CancellationContext ctx;
    private final ReplicaManager replicaManager;
    private final DeletionMetrics deletionMetrics;

    @Override
    public List<DeletionTask> sortTasks(List<DeletionTask> tasks) {
        return (List)tasks.sortBy((Function1<DeletionTask, Object> & Serializable)task -> BoxesRunTime.boxToLong(this.taskPriority(task)), (Ordering)Ordering.Long$.MODULE$);
    }

    @Override
    public DeletionTask newTask(TopicIdPartition topicIdPartition, StartChangeMetadata change) {
        Product product;
        StartChangeMetadata startChangeMetadata = change;
        if (startChangeMetadata instanceof StartLeadership) {
            StartLeadership startLeadership = (StartLeadership)startChangeMetadata;
            product = new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager, startLeadership.leaderEpoch());
        } else if (startChangeMetadata instanceof StartPartitionDeletion) {
            StartPartitionDeletion startPartitionDeletion = (StartPartitionDeletion)startChangeMetadata;
            product = new DeletionTask.DeletedPartitionMetadata(startPartitionDeletion.tieredObjects());
        } else {
            throw new MatchError(startChangeMetadata);
        }
        Product stateMetadata = product;
        return new DeletionTask(this.ctx.subContext(), topicIdPartition, new DeletionTask.CollectDeletableObjects((DeletionTask.StateMetadata)((Object)stateMetadata)), this.deletionMetrics);
    }

    @Override
    public boolean mayProcess(ChangeMetadata metadata) {
        return true;
    }

    private long taskPriority(DeletionTask task) {
        DeletionTask.State state = task.state();
        if (state instanceof DeletionTask.CollectDeletableObjects) {
            return BoxesRunTime.unboxToLong(task.lastProcessedMs().getOrElse(() -> 0L));
        }
        if (state instanceof DeletionTask.FailedState) {
            return -2L;
        }
        return -1L;
    }

    public DeletionTaskQueue(CancellationContext ctx, int maxTasks, Time time, ReplicaManager replicaManager, DeletionMetrics deletionMetrics) {
        this.ctx = ctx;
        this.replicaManager = replicaManager;
        this.deletionMetrics = deletionMetrics;
        super(ctx, maxTasks, time);
    }
}

