/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.snapshot;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import io.confluent.kafka.storage.tier.state.FileTierPartitionStateSnapshotObject;
import io.confluent.kafka.storage.tier.state.Header;
import io.confluent.kafka.storage.tier.state.TierPartitionState;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierSnapshotFailedException;
import kafka.tier.exceptions.TierSnapshotFailedException$;
import kafka.tier.exceptions.TierSnapshotFencedException;
import kafka.tier.exceptions.TierSnapshotFencedException$;
import kafka.tier.exceptions.TierSnapshotLastTakenSnapshotNotPresentAtObjectStoreException;
import kafka.tier.exceptions.TierSnapshotLastTakenSnapshotNotPresentAtObjectStoreException$;
import kafka.tier.exceptions.TierSnapshotMostRecentSnapshotNotYetCommitted;
import kafka.tier.exceptions.TierSnapshotMostRecentSnapshotNotYetCommitted$;
import kafka.tier.exceptions.TierSnapshotRestoreFencedException;
import kafka.tier.exceptions.TierSnapshotRestoreFencedException$;
import kafka.tier.exceptions.TierSnapshotUnexpectedFileInSnapshotsDirException;
import kafka.tier.exceptions.TierSnapshotUnexpectedFileInSnapshotsDirException$;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.metadata.TierPartitionStateSnapshotMetadata;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class MetadataSnapshotTask$
implements Logging {
    public static final MetadataSnapshotTask$ MODULE$ = new MetadataSnapshotTask$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        MetadataSnapshotTask$ metadataSnapshotTask$ = this;
        synchronized (metadataSnapshotTask$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return MetadataSnapshotTask.class.getName();
    }

    public MetadataSnapshotTask.MetadataSnapshotTaskState garbageCollectOlderSnapshots(TopicIdPartition topicIdPartition, int leaderEpoch, AbstractLog log, TierObjectStore tierObjectStore, Time time, TierTasksConfig config) {
        UUID lastCommittedSnapshotId;
        block8: {
            block7: {
                lastCommittedSnapshotId = log.tierPartitionState().lastCommittedSnapshotId();
                if (lastCommittedSnapshotId == null) break block7;
                UUID uUID = lastCommittedSnapshotId;
                UUID uUID2 = Header.SNAPSHOT_ID_EMPTY;
                if (uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null) break block8;
            }
            this.info((Function0<String> & Serializable)() -> "No committed snapshots available for deletion for " + topicIdPartition);
            return new MetadataSnapshotTask.BeforeMetadataSnapshotState(leaderEpoch);
        }
        UUID lastTakenSnapshotId = log.tierPartitionState().lastSnapshotId();
        if (!lastCommittedSnapshotId.equals(lastTakenSnapshotId)) {
            String errorMsg = "Last taken snapshot " + lastTakenSnapshotId + " has not yet been committed; garbage clean-up should not commence until ID of last taken FTPS snapshot has been flushed to disk.";
            throw new TierSnapshotMostRecentSnapshotNotYetCommitted(errorMsg, TierSnapshotMostRecentSnapshotNotYetCommitted$.MODULE$.$lessinit$greater$default$2());
        }
        String snapshotPrefix = TierPartitionStateSnapshotMetadata.pathPrefix("", topicIdPartition);
        Map<String, List<VersionInformation>> allSnapshotPaths = tierObjectStore.listObject(snapshotPrefix, false);
        List snapshotObjects = allSnapshotPaths.keySet().stream().map(snapshotPath -> {
            String snapshotName = TierPartitionStateSnapshotMetadata.extractEncodedName(snapshotPath);
            return FileTierPartitionStateSnapshotObject.decodeSnapshotName(snapshotName);
        }).collect(Collectors.toList());
        this.debug((Function0<String> & Serializable)() -> topicIdPartition + " Tier metadata snapshot objects List: " + snapshotObjects);
        Optional<FileTierPartitionStateSnapshotObject> lastCommittedSnapshotInfo = snapshotObjects.stream().filter(x$8 -> {
            UUID uUID = x$8.snapshotId();
            UUID uUID2 = lastCommittedSnapshotId;
            return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
        }).findFirst();
        if (!lastCommittedSnapshotInfo.isPresent()) {
            String errorMsg = "Committed snapshot " + lastCommittedSnapshotId.toString() + " for " + topicIdPartition + " is not present at object store";
            throw new TierSnapshotLastTakenSnapshotNotPresentAtObjectStoreException(errorMsg, TierSnapshotLastTakenSnapshotNotPresentAtObjectStoreException$.MODULE$.$lessinit$greater$default$2());
        }
        long timeMs = time.milliseconds();
        long retentionMs = TimeUnit.DAYS.toMillis(config.snapshotTaskConfig().get().retentionDays().apply$mcI$sp());
        long retentionCutoffTimeMs = timeMs - retentionMs;
        this.debug((Function0<String> & Serializable)() -> topicIdPartition + " retentionCutoffTimeMs: " + retentionCutoffTimeMs + " currentTime: " + timeMs + " retentionMs: " + retentionMs);
        List<TierObjectStore.KeyAndVersion> snapshotsToDelete = snapshotObjects.stream().filter(snapshotObject -> snapshotObject.snapshotTimestampMs() < ((FileTierPartitionStateSnapshotObject)lastCommittedSnapshotInfo.get()).snapshotTimestampMs() && snapshotObject.snapshotTimestampMs() < retentionCutoffTimeMs).map(s -> {
            TierPartitionStateSnapshotMetadata metadata = new TierPartitionStateSnapshotMetadata(topicIdPartition, (FileTierPartitionStateSnapshotObject)s);
            return new TierObjectStore.KeyAndVersion(metadata.toFragmentLocation("", FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT).get().objectPath());
        }).collect(Collectors.toList());
        if (snapshotsToDelete.isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "No snapshots to be deleted for " + topicIdPartition);
        } else {
            StringBuilder sb = new StringBuilder("Following snapshots are to be deleted for " + topicIdPartition + "\n");
            snapshotsToDelete.forEach(kv -> sb.append(kv.key()).append(" "));
            this.info((Function0<String> & Serializable)() -> sb.toString());
            tierObjectStore.deleteVersions(snapshotsToDelete);
        }
        return new MetadataSnapshotTask.BeforeMetadataSnapshotState(leaderEpoch);
    }

    public Future<BoxedUnit> kafka$tier$tasks$snapshot$MetadataSnapshotTask$$writeEvent(TierTopicAppender tierTopicAppender, AbstractTierMetadata event, Time time, ExecutionContext ec) {
        Future<BoxedUnit> future;
        long startTimeMs = time.milliseconds();
        this.info((Function0<String> & Serializable)() -> event.topicIdPartition() + " appending " + event);
        try {
            future = FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(event))).map((Function1<TierPartitionState.AppendResult, Object> & Serializable)appendResult -> {
                MetadataSnapshotTask$.$anonfun$writeEvent$2(event, time, startTimeMs, appendResult);
                return BoxedUnit.UNIT;
            }, ec);
        }
        catch (Throwable t) {
            future = Future$.MODULE$.failed(t);
        }
        return future;
    }

    public Option<Tuple2<Path, FileTierPartitionStateSnapshotObject>> searchSnapshotByUuid(UUID snapshotId, Path snapshotsDir) {
        LongRef earliestTimestampMs = LongRef.create(Long.MAX_VALUE);
        ObjectRef<None$> earliestSnapshot = ObjectRef.create(None$.MODULE$);
        try (DirectoryStream<Path> filesStream = FilesWrapper.newDirectoryStream(snapshotsDir);){
            filesStream.forEach(path -> {
                String fileName = ((Object)path.getFileName()).toString();
                if (FileTierPartitionStateSnapshotObject.isSnapshotFile(fileName)) {
                    FileTierPartitionStateSnapshotObject metadata = FileTierPartitionStateSnapshotObject.decodeSnapshotName(((Object)path.getFileName()).toString());
                    UUID uUID = metadata.snapshotId();
                    UUID uUID2 = snapshotId;
                    if (!(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null) && metadata.snapshotTimestampMs() < earliestTimestampMs$1.elem) {
                        earliestTimestampMs$1.elem = metadata.snapshotTimestampMs();
                        earliestSnapshot$1.elem = new Some<Tuple2<Path, FileTierPartitionStateSnapshotObject>>(new Tuple2<Path, FileTierPartitionStateSnapshotObject>((Path)path, metadata));
                        return;
                    }
                    return;
                }
            });
        }
        return (Option)earliestSnapshot.elem;
    }

    public void deleteMostRecentSnapshotAndCleanSnapshotsDir(Path mostRecentSnapshotPath) {
        FilesWrapper.deleteIfExists(mostRecentSnapshotPath);
        Path snapshotsDir = mostRecentSnapshotPath.getParent();
        try (DirectoryStream<Path> filesStream = FilesWrapper.newDirectoryStream(snapshotsDir);){
            filesStream.forEach(path -> {
                String fileName = ((Object)path.getFileName()).toString();
                if (FileTierPartitionStateSnapshotObject.isSnapshotFile(fileName)) {
                    MODULE$.warn((Function0<String> & Serializable)() -> "Found stray snapshot file " + path + " while deleting most recent snapshot. Deleting stray snapshot file.");
                    FilesWrapper.deleteIfExists(path);
                    return;
                }
                throw new TierSnapshotUnexpectedFileInSnapshotsDirException("Unexpected non-snapshot file " + path + " found while deleting most recent snapshot. Snapshots dir should only contain snapshot files.", TierSnapshotUnexpectedFileInSnapshotsDirException$.MODULE$.$lessinit$greater$default$2());
            });
        }
    }

    public Path kafka$tier$tasks$snapshot$MetadataSnapshotTask$$snapshotsDir(Path logDir) {
        return logDir.resolve("snapshots");
    }

    public static final /* synthetic */ void $anonfun$writeEvent$2(AbstractTierMetadata event$1, Time time$5, long startTimeMs$2, TierPartitionState.AppendResult appendResult) {
        TierPartitionState.AppendResult appendResult2 = appendResult;
        if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)appendResult2)) {
            MODULE$.info((Function0<String> & Serializable)() -> event$1.topicIdPartition() + " completed " + event$1 + " in " + (time$5.milliseconds() - startTimeMs$2) + "ms");
            return;
        }
        if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals((Object)appendResult2)) {
            MODULE$.warn((Function0<String> & Serializable)() -> event$1.topicIdPartition() + " Stopping state machine as attempt to transition failed");
            throw new TierSnapshotFailedException(event$1.topicIdPartition() + " appendResult: " + appendResult + ", moving to failed state", TierSnapshotFailedException$.MODULE$.$lessinit$greater$default$2());
        }
        if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals((Object)appendResult2)) {
            throw new NotTierablePartitionException(event$1.topicIdPartition());
        }
        if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)appendResult2)) {
            MODULE$.info((Function0<String> & Serializable)() -> event$1.topicIdPartition() + " Stopping state machine as attempt to transition was fenced");
            throw new TierSnapshotFencedException(event$1.topicIdPartition() + " appendResult: " + appendResult, TierSnapshotFencedException$.MODULE$.$lessinit$greater$default$2());
        }
        if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals((Object)appendResult2)) {
            MODULE$.info((Function0<String> & Serializable)() -> event$1.topicIdPartition() + " Stopping state machine as attempt to transition was fenced due to restore");
            throw new TierSnapshotRestoreFencedException(event$1.topicIdPartition() + " appendResult: " + appendResult, TierSnapshotRestoreFencedException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new IllegalStateException(event$1.topicIdPartition() + " unexpected appendResult: " + appendResult);
    }

    private MetadataSnapshotTask$() {
    }
}

