/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.snapshot;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.Serializable;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.LeadershipChange;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.snapshot.MetadataSnapshotMetrics;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q4Qa\u0003\u0007\u0001\u001dQA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u000b\u0019\u0003A\u0011A$\t\r=\u0003A\u0011\u000b\bQ\u0011\u0019q\u0006\u0001\"\u0015\u000f?\"11\u000f\u0001C)\u001dQ\u0014\u0011$T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;UCN\\\u0017+^3vK*\u0011QBD\u0001\tg:\f\u0007o\u001d5pi*\u0011q\u0002E\u0001\u0006i\u0006\u001c8n\u001d\u0006\u0003#I\tA\u0001^5fe*\t1#A\u0003lC\u001a\\\u0017m\u0005\u0002\u0001+A\u0019acF\r\u000e\u00039I!\u0001\u0007\b\u0003\u001bQKWM\u001d+bg.\fV/Z;f!\tQ2$D\u0001\r\u0013\taBB\u0001\u000bNKR\fG-\u0019;b':\f\u0007o\u001d5piR\u000b7o[\u0001\u0004GRD8\u0001\u0001\t\u0003A\rj\u0011!\t\u0006\u0003EA\tqAZ3uG\",'/\u0003\u0002%C\t\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0006AQ.\u0019=UCN\\7\u000f\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003FA\u0002J]R\fA\u0001^5nKB\u0011a\u0006O\u0007\u0002_)\u0011\u0001'M\u0001\u0006kRLGn\u001d\u0006\u0003eM\naaY8n[>t'BA\n5\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\n\u0005ez#\u0001\u0002+j[\u0016\fQ\u0001\\1h\r:\u0004Ba\n\u001f\u001a}%\u0011Q\b\u000b\u0002\n\rVt7\r^5p]F\u0002\"aJ \n\u0005\u0001C#\u0001\u0002'p]\u001e\fqb\u001d8baNDw\u000e^'fiJL7m\u001d\t\u00035\rK!\u0001\u0012\u0007\u0003/5+G/\u00193bi\u0006\u001cf.\u00199tQ>$X*\u001a;sS\u000e\u001c\u0018\u0001\u00032s_.,'/\u00133\u0002\rqJg.\u001b;?)\u001dA\u0015JS&M\u001b:\u0003\"A\u0007\u0001\t\u000bu9\u0001\u0019A\u0010\t\u000b\u0015:\u0001\u0019\u0001\u0014\t\u000b1:\u0001\u0019A\u0017\t\u000bi:\u0001\u0019A\u001e\t\u000b\u0005;\u0001\u0019\u0001\"\t\u000b\u0015;\u0001\u0019\u0001\u0014\u0002\u0013M|'\u000f\u001e+bg.\u001cHCA)^!\r\u0011&,\u0007\b\u0003'bs!\u0001V,\u000e\u0003US!A\u0016\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013BA-)\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0017/\u0003\t1K7\u000f\u001e\u0006\u00033\"BQa\u0004\u0005A\u0002E\u000bqA\\3x)\u0006\u001c8\u000eF\u0002\u001aA:DQ!Y\u0005A\u0002\t\f\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0011\u0005\rdW\"\u00013\u000b\u0005E)'B\u00014h\u0003\u001d\u0019Ho\u001c:bO\u0016T!a\u00055\u000b\u0005%T\u0017!C2p]\u001adW/\u001a8u\u0015\u0005Y\u0017AA5p\u0013\tiGM\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\")q.\u0003a\u0001a\u0006AQ.\u001a;bI\u0006$\u0018\r\u0005\u0002\u0017c&\u0011!O\u0004\u0002\u0014'R\f'\u000f^\"iC:<W-T3uC\u0012\fG/Y\u0001\u000b[\u0006L\bK]8dKN\u001cHCA;y!\t9c/\u0003\u0002xQ\t9!i\\8mK\u0006t\u0007\"B8\u000b\u0001\u0004I\bC\u0001\f{\u0013\tYhB\u0001\bDQ\u0006tw-Z'fi\u0006$\u0017\r^1")
public class MetadataSnapshotTaskQueue
extends TierTaskQueue<MetadataSnapshotTask> {
    private final CancellationContext ctx;
    private final Function1<MetadataSnapshotTask, Object> lagFn;
    private final MetadataSnapshotMetrics snapshotMetrics;
    private final int brokerId;

    @Override
    public List<MetadataSnapshotTask> sortTasks(List<MetadataSnapshotTask> tasks) {
        return (List)tasks.sortBy(this.lagFn, (Ordering)Ordering.Long$.MODULE$);
    }

    @Override
    public MetadataSnapshotTask newTask(TopicIdPartition topicIdPartition, StartChangeMetadata metadata) {
        this.debug((Function0<String> & Serializable)() -> topicIdPartition + " Processing new task: " + metadata);
        StartChangeMetadata startChangeMetadata = metadata;
        if (startChangeMetadata instanceof StartLeadership) {
            StartLeadership startLeadership = (StartLeadership)startChangeMetadata;
            return new MetadataSnapshotTask(this.ctx.subContext(), topicIdPartition, new MetadataSnapshotTask.BeforeLeaderSnapshotState(startLeadership.leaderEpoch()), this.snapshotMetrics, this.brokerId);
        }
        throw new IllegalStateException("Unexpected change " + startChangeMetadata + " for " + topicIdPartition);
    }

    @Override
    public boolean mayProcess(ChangeMetadata metadata) {
        ChangeMetadata changeMetadata = metadata;
        return changeMetadata instanceof LeadershipChange;
    }

    public MetadataSnapshotTaskQueue(CancellationContext ctx, int maxTasks, Time time, Function1<MetadataSnapshotTask, Object> lagFn, MetadataSnapshotMetrics snapshotMetrics, int brokerId) {
        this.ctx = ctx;
        this.lagFn = lagFn;
        this.snapshotMetrics = snapshotMetrics;
        this.brokerId = brokerId;
        super(ctx, maxTasks, time);
    }
}

