/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.checksum.CheckedFileIO;
import io.confluent.kafka.storage.tier.domain.TierObjectMetadata;
import io.confluent.kafka.storage.tier.state.Header;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.tools.RecoveryUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.MergedLogUtils;

public class DumpTierPartitionState {
    private static final String DIR_ARG = "directory";
    private static final String PRINT_CHECKSUM_ARG = RecoveryUtils.makeArgument("print-checksum");
    private static final String PRINT_HEADERS_ARG = RecoveryUtils.makeArgument("print-headers");
    private static final String VALIDATE_CHECKSUM_ARG = RecoveryUtils.makeArgument("validate-checksum");

    public static void main(String[] args) throws Exception {
        Namespace parsedArgs = DumpTierPartitionState.parseArgs(DumpTierPartitionState.createArgParser(), args);
        if (parsedArgs == null) {
            return;
        }
        boolean hasPrintChecksum = parsedArgs.getBoolean(PRINT_CHECKSUM_ARG);
        boolean hasPrintHeaderOnly = parsedArgs.getBoolean(PRINT_HEADERS_ARG);
        boolean hasValidateChecksum = parsedArgs.getBoolean(VALIDATE_CHECKSUM_ARG);
        String path = ((String)parsedArgs.getList(DIR_ARG).get(0)).trim();
        File dir = new File(path);
        DumpTierPartitionState.checkDirectory(dir);
        if (hasPrintHeaderOnly) {
            int errors;
            if (hasPrintChecksum) {
                System.err.println(String.format("%s is not supported when %s is supplied", PRINT_CHECKSUM_ARG, PRINT_HEADERS_ARG));
                System.exit(1);
            }
            if ((errors = DumpTierPartitionState.dumpTierStateHeaders(dir)) > 0) {
                System.err.println(String.format("ERROR: Could not print the headers for %d file(s)!", errors));
                System.exit(1);
            }
        } else {
            TopicPartition topicPartition = MergedLogUtils.parseTopicPartitionName(dir);
            System.out.println("Reading tier partition state for " + String.valueOf(topicPartition));
            DumpTierPartitionState.dumpTierStates(topicPartition, dir, hasPrintHeaderOnly, hasPrintChecksum, hasValidateChecksum);
        }
    }

    private static Namespace parseArgs(ArgumentParser parser, String[] args) throws ArgumentParserException {
        try {
            return parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            if (e instanceof HelpScreenException) {
                return null;
            }
            throw e;
        }
    }

    private static void checkDirectory(File dir) {
        if (!dir.isDirectory()) {
            System.err.println(String.format("ERROR! The provided path: %s is not a valid directory.", dir));
            System.exit(1);
        }
        if (!dir.exists()) {
            System.err.println(String.format("ERROR! The provided directory: %s does not exist.", dir));
            System.exit(1);
        }
    }

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(DumpTierPartitionState.class.getName()).defaultHelp(true).description("Dumps tier partition state files to standard out.");
        parser.addArgument(DIR_ARG).nargs(1).type(String.class).required(true).help(String.format("The topic-partition log directory containing tier state files, or the root log directory if %s is supplied.", PRINT_HEADERS_ARG));
        parser.addArgument(PRINT_CHECKSUM_ARG).dest(PRINT_CHECKSUM_ARG).required(false).action(Arguments.storeTrue()).help("Print details related to the checksum of the tier partition state file.");
        parser.addArgument(PRINT_HEADERS_ARG).dest(PRINT_HEADERS_ARG).required(false).action(Arguments.storeTrue()).help("Print only the header of every tier partition state file in the provided root log directory.");
        parser.addArgument(VALIDATE_CHECKSUM_ARG).dest(VALIDATE_CHECKSUM_ARG).required(false).action(Arguments.storeTrue()).help("Validate the checksum of the tier partition state file in the provided root log directory.");
        return parser;
    }

    private static int dumpTierStateHeaders(File rootDir) {
        System.out.print("[");
        File[] dirs = rootDir.listFiles();
        ArrayList<String> tierStates = new ArrayList<String>();
        int errors = 0;
        for (File dir : dirs) {
            TopicPartition topicPartition;
            if (!dir.isDirectory()) continue;
            try {
                topicPartition = MergedLogUtils.parseTopicPartitionName(dir);
            }
            catch (Exception e) {
                System.err.println(String.format("WARN: Skipping sub-directory with invalid topic partition: %s", dir.getAbsolutePath()));
                continue;
            }
            for (File ftpsFile : dir.listFiles()) {
                Optional<Header> headerOpt;
                if (!ftpsFile.isFile() || !MergedLogUtils.isTierStateFile(ftpsFile)) continue;
                try (CheckedFileIO fileChannel = CheckedFileIO.open(ftpsFile.toPath(), StandardOpenOption.READ);){
                    headerOpt = FileTierPartitionState.readHeader(fileChannel);
                }
                catch (IOException e) {
                    ++errors;
                    System.err.println("ERROR: Could not get the header due to an error for file: " + String.valueOf(ftpsFile));
                    e.printStackTrace();
                    continue;
                }
                if (headerOpt.isPresent()) {
                    tierStates.add(String.format("{\"topicPartition\": \"%s\", \"path\": \"%s\", \"header\": %s}", topicPartition, ftpsFile.getAbsolutePath(), headerOpt.get().toJson()));
                    continue;
                }
                ++errors;
                System.err.println("ERROR: Empty header found in file " + String.valueOf(ftpsFile));
            }
        }
        System.out.print(String.join((CharSequence)",", tierStates));
        System.out.print("]");
        return errors;
    }

    private static void dumpTierStates(TopicPartition topicPartition, File dir, boolean headerOnly, boolean printChecksum, boolean validateChecksum) {
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            if (!file.isFile() || !MergedLogUtils.isTierStateFile(file)) continue;
            System.out.println("Dumping state in file " + String.valueOf(file));
            DumpTierPartitionState.dumpTierState(topicPartition, file, headerOnly, printChecksum, validateChecksum);
        }
    }

    public static void dumpTierState(TopicPartition topicPartition, File ftpsFile, boolean headerOnly, boolean printChecksum, boolean validateChecksum) {
        try (CheckedFileIO fileChannel = CheckedFileIO.open(ftpsFile.toPath(), StandardOpenOption.READ);){
            Optional<Header> headerOpt;
            if (printChecksum) {
                System.out.println(fileChannel);
            }
            if (validateChecksum) {
                if (fileChannel.validate()) {
                    System.out.println("Valid checksum for file: " + String.valueOf(ftpsFile));
                } else {
                    System.err.println("Invalid checksum for file: " + String.valueOf(ftpsFile));
                }
            }
            if (!(headerOpt = FileTierPartitionState.readHeader(fileChannel)).isPresent()) {
                System.out.println("Empty header");
                return;
            }
            System.out.println(headerOpt.get());
            if (headerOnly) {
                return;
            }
            Optional<FileTierPartitionIterator> iteratorOpt = FileTierPartitionState.iterator(topicPartition, fileChannel);
            if (!iteratorOpt.isPresent()) {
                System.out.println("Empty file");
                return;
            }
            while (iteratorOpt.get().hasNext()) {
                TierObjectMetadata metadata = (TierObjectMetadata)iteratorOpt.get().next();
                ObjectMetadata objectMetadata = new ObjectMetadata(metadata);
                System.out.println(String.valueOf(metadata) + " => " + objectMetadata.toFragmentLocation("", FragmentType.SEGMENT).get().objectPath());
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            System.err.println("ERROR: Caught exception for file " + String.valueOf(ftpsFile));
            e.printStackTrace();
        }
    }
}

