/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.tier.tools.ForceRollSegmentsOrchestrator;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import kafka.tier.tools.TierToolsUtils;
import kafka.tier.tools.commands.ForceRollSegmentsCommandResponse;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.utils.Exit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceRollSegments {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForceRollSegments.class);
    private static final String LOGICAL_CLUSTER_ID = "logical-cluster-id";
    private static final String LOGICAL_CLUSTER_ID_DOC = "The logical cluster ID of the tenant whose segments we want to roll.";

    public static void main(String[] args) throws Exception {
        LOGGER.debug("Received cmdline args: " + Arrays.toString(args));
        ArgumentParser cliParser = ForceRollSegments.createParser();
        Namespace namespace = cliParser.parseArgs(args);
        String bootstrapServers = namespace.getString("bootstrap-servers");
        String adminConfig = namespace.getString("admin.config");
        Integer restServerPort = namespace.getInt("rest-server-port-override");
        AdminClient adminClient = TierToolsUtils.getAdminClient(adminConfig, bootstrapServers);
        ForceRollSegmentsOrchestrator orchestrator = new ForceRollSegmentsOrchestrator(adminClient, restServerPort);
        String logicalClusterId = namespace.getString(LOGICAL_CLUSTER_ID);
        if (!logicalClusterId.startsWith("lkc-")) {
            LOGGER.error("Received malformed logical cluster id which does not start with {}: {}", (Object)"lkc-", (Object)logicalClusterId);
            Exit.exit(1);
        }
        ForceRollSegmentsCommandResponse response = new ForceRollSegmentsCommandResponse();
        if (namespace.getBoolean("all-brokers").booleanValue()) {
            response = orchestrator.forceRollSegmentsForCluster(logicalClusterId);
        } else if (namespace.getString("broker-ids") != null) {
            Set<Integer> brokers = TierMetadataRecoveryUtils.getBrokerList(namespace);
            ArrayList<ForceRollSegmentsCommandResponse.BrokerDetail> successBrokers = new ArrayList<ForceRollSegmentsCommandResponse.BrokerDetail>();
            ArrayList<ForceRollSegmentsCommandResponse.BrokerDetail> failedBrokers = new ArrayList<ForceRollSegmentsCommandResponse.BrokerDetail>();
            for (Integer broker : brokers) {
                ForceRollSegmentsCommandResponse brokerRes = orchestrator.forceRollSegmentsForBroker(logicalClusterId, broker);
                successBrokers.addAll(brokerRes.getSuccess());
                failedBrokers.addAll(brokerRes.getFailed());
            }
            response.setSuccess(successBrokers);
            response.setFailed(failedBrokers);
        } else {
            throw new IllegalArgumentException(String.format("Either --%s OR --%s must be provided when running segment force roller.", "all-brokers", "broker-ids"));
        }
        if (response.getFailed().isEmpty()) {
            Exit.exit(0);
        } else {
            String failedBrokers = response.getFailed().stream().map(ForceRollSegmentsCommandResponse.BrokerDetail::toString).collect(Collectors.joining(","));
            LOGGER.error("Failed to force roll segments for logical cluster: {} with failed brokers: {}.", (Object)logicalClusterId, (Object)failedBrokers);
            Exit.exit(1);
        }
    }

    private static ArgumentParser createParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(ForceRollSegments.class.getName()).defaultHelp(true).description("Force roll segments for a provided tenant.");
        parser.addArgument(RecoveryUtils.makeArgument("admin.config")).dest("admin.config").required(false).type(String.class).action(Arguments.store()).help("path to admin client configs");
        parser.addArgument(RecoveryUtils.makeArgument("bootstrap-servers")).dest("bootstrap-servers").required(true).type(String.class).metavar("HOST1:PORT1[,HOST2:PORT2[...]]").action(Arguments.store()).help("Comma-separated list of broker urls (host:port) to connect to. This is required for all commands.");
        MutuallyExclusiveGroup runScopeGroup = parser.addMutuallyExclusiveGroup().required(true);
        runScopeGroup.addArgument(RecoveryUtils.makeArgument("broker-ids")).dest("broker-ids").action(Arguments.store()).type(String.class).help("Runs the operation only on the specified brokers supplied as a comma-separated list. (i.e., 0,1,2,3)");
        runScopeGroup.addArgument(RecoveryUtils.makeArgument("all-brokers")).dest("all-brokers").action(Arguments.storeTrue()).help("Runs the operation for all brokers in the cluster");
        parser.addArgument(RecoveryUtils.makeArgument(LOGICAL_CLUSTER_ID)).dest(LOGICAL_CLUSTER_ID).action(Arguments.store()).type(String.class).help(LOGICAL_CLUSTER_ID_DOC);
        parser.addArgument(RecoveryUtils.makeArgument("rest-server-port-override")).dest("rest-server-port-override").type(Integer.class).action(Arguments.store()).setDefault(TierToolsUtils.DEFAULT_REST_SERVER_PORT_OVERRIDE).help(TierToolsUtils.REST_SERVER_PORT_OVERRIDE_DOC);
        return parser;
    }
}

