/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierMetadataRecoveryOrchestrator;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import kafka.tier.tools.TierToolsUtils;
import kafka.tier.tools.commands.GetTierRecoveryDataUploadJobResultCommandResponse;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public final class GetTierRecoveryDataUploadResultCommand {
    static final String COMMAND = "get-tier-recovery-data-upload-result";
    private static final String JOB_ID = "job-id";
    private static final String JOB_ID_DOC = "The unique identifier for the upload job whose result we want to obtain.";
    private static final String BROKER_ID = "broker-id";
    private static final String BROKER_ID_DOC = "The integer ID of the broker which had initiated this upload.";

    static void addCommand(Subparsers subparsers) {
        Subparser getTierRecoveryDataUploadResult = subparsers.addParser(COMMAND).help("Get the result of the previously initiated recovery upload job.");
        getTierRecoveryDataUploadResult.addArgument(RecoveryUtils.makeArgument("rest-server-port-override")).dest("rest-server-port-override").action(Arguments.store()).type(Integer.class).setDefault(TierToolsUtils.DEFAULT_REST_SERVER_PORT_OVERRIDE).help(TierToolsUtils.REST_SERVER_PORT_OVERRIDE_DOC);
        getTierRecoveryDataUploadResult.addArgument(RecoveryUtils.makeArgument(JOB_ID)).required(true).dest(JOB_ID).action(Arguments.store()).type(String.class).help(JOB_ID_DOC);
        getTierRecoveryDataUploadResult.addArgument(RecoveryUtils.makeArgument(BROKER_ID)).required(true).dest(BROKER_ID).action(Arguments.store()).type(Integer.class).help(BROKER_ID_DOC);
    }

    static int execute(Namespace namespace) throws ExecutionException, InterruptedException, IOException {
        String bootstrapServers = namespace.getString("bootstrap-servers");
        String adminConfig = namespace.getString("admin.config");
        Integer restServerPort = namespace.getInt("rest-server-port-override");
        int brokerId = namespace.getInt(BROKER_ID);
        String jobId = namespace.getString(JOB_ID);
        TierMetadataRecoveryOrchestrator orchestrator = TierMetadataRecoveryUtils.getTierMetadataRecoveryOrchestrator(adminConfig, bootstrapServers, restServerPort);
        GetTierRecoveryDataUploadJobResultCommandResponse response = orchestrator.getTierRecoveryDataUploadJobResultForBroker(brokerId, UUID.fromString(jobId));
        if (response.getFailed().isEmpty()) {
            GetTierRecoveryDataUploadJobResultCommandResponse.BrokerDetail completed = response.getCompleted().get(0);
            System.out.println(completed.result().printReport(completed.jobId(), completed.broker()));
            return 0;
        }
        GetTierRecoveryDataUploadJobResultCommandResponse.BrokerDetail failed = response.getFailed().get(0);
        System.err.printf("Failed to obtain result of the upload job for broker %s with job id %s. Received: %s\n\n", failed.broker(), failed.jobId(), failed.result());
        return 1;
    }
}

