/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.Node;
import org.slf4j.Logger;

public class TierOrchestratorUtils {
    private static final String HTTP_PREFIX = "http://";

    private static String getBrokerUrl(String host, Integer restServerPort) {
        return HTTP_PREFIX + host + ":" + restServerPort;
    }

    public static Map<Integer, String> getBrokerToUrlMap(AdminClient adminClient, Integer restServerPort, Logger logger) throws ExecutionException, InterruptedException {
        logger.info("Attempting to get list of brokers in the cluster...");
        DescribeClusterResult describeClusterResult = adminClient.describeCluster();
        HashMap<Integer, String> brokerToUrlMap = new HashMap<Integer, String>();
        for (Node node : describeClusterResult.nodes().get()) {
            brokerToUrlMap.put(node.id(), TierOrchestratorUtils.getBrokerUrl(node.host(), restServerPort));
        }
        logger.info("Found {} brokers in the cluster.", (Object)brokerToUrlMap.size());
        return brokerToUrlMap;
    }

    public static String getBrokerUrlIfBrokerExists(AdminClient adminClient, Integer restServerPort, Integer brokerId, Logger logger) throws ExecutionException, InterruptedException {
        Map<Integer, String> brokerToUrlMap = TierOrchestratorUtils.getBrokerToUrlMap(adminClient, restServerPort, logger);
        if (!brokerToUrlMap.containsKey(brokerId)) {
            throw new IllegalArgumentException("Broker " + brokerId + " not found in the cluster");
        }
        return brokerToUrlMap.get(brokerId);
    }

    public static <T> String prettyPrint(ObjectMapper objectMapper, T reqOrRes) throws JsonProcessingException {
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(reqOrRes);
    }
}

