/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools.commands;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.confluent.rest.ForceRollSegmentsHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import kafka.tier.common.RestServerRequest;
import org.apache.http.client.utils.URIBuilder;

public class ForceRollSegmentsCommandRequest
implements RestServerRequest {
    private final String brokerUrl;
    private final ForceRollSegmentsHandler.ForceRollSegmentsRequest request;

    public ForceRollSegmentsCommandRequest(String brokerUrl, ForceRollSegmentsHandler.ForceRollSegmentsRequest request) {
        this.brokerUrl = brokerUrl;
        this.request = request;
    }

    public ForceRollSegmentsHandler.ForceRollSegmentsRequest request() {
        return this.request;
    }

    @Override
    public RestServerRequest.RestRequestType requestType() {
        return RestServerRequest.RestRequestType.POST;
    }

    @Override
    public String requestBodyAsJson() throws JsonProcessingException {
        return ForceRollSegmentsHandler.OBJECT_MAPPER.writeValueAsString(this.request);
    }

    @Override
    public String brokerUrl() {
        return this.brokerUrl;
    }

    @Override
    public String requestName() {
        return ForceRollSegmentsCommandRequest.class.getName();
    }

    @Override
    public URI uri() throws URISyntaxException {
        return new URIBuilder(this.brokerUrl + "/v1/tiertools/forcerollsegments").build();
    }

    public int hashCode() {
        return Objects.hash(this.brokerUrl, this.request);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForceRollSegmentsCommandRequest that = (ForceRollSegmentsCommandRequest)o;
        return Objects.equals(this.brokerUrl, that.brokerUrl) && Objects.equals(this.request, that.request);
    }
}

