/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import io.confluent.kafka.storage.tier.domain.TierRecordType;
import io.confluent.kafka.storage.tier.state.TierPartitionState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.tier.exceptions.TierMetadataFatalException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

class TierTopicListeners {
    private final Map<TopicIdPartition, Map<MaterializationKey, CompletableFuture<TierPartitionState.AppendResult>>> results = new HashMap<TopicIdPartition, Map<MaterializationKey, CompletableFuture<TierPartitionState.AppendResult>>>();
    private final Time time;

    TierTopicListeners(Time time) {
        this.time = time;
    }

    synchronized Optional<CompletableFuture<TierPartitionState.AppendResult>> getAndRemoveTracked(AbstractTierMetadata metadata) {
        Map<MaterializationKey, CompletableFuture<TierPartitionState.AppendResult>> entries = this.results.get(metadata.topicIdPartition());
        if (entries != null) {
            CompletableFuture<TierPartitionState.AppendResult> future = entries.remove(new MaterializationKey(metadata.type(), metadata.messageId(), -1L));
            if (entries.size() == 0) {
                this.results.remove(metadata.topicIdPartition());
            }
            return Optional.ofNullable(future);
        }
        return Optional.empty();
    }

    synchronized Collection<CompletableFuture<TierPartitionState.AppendResult>> getAndRemoveAll(TopicIdPartition topicIdPartition) {
        Map<MaterializationKey, CompletableFuture<TierPartitionState.AppendResult>> entries = this.results.remove(topicIdPartition);
        return entries == null ? new ArrayList() : entries.values();
    }

    synchronized void addTracked(AbstractTierMetadata metadata, CompletableFuture<TierPartitionState.AppendResult> future) {
        this.results.putIfAbsent(metadata.topicIdPartition(), new HashMap());
        Map<MaterializationKey, CompletableFuture<TierPartitionState.AppendResult>> entries = this.results.get(metadata.topicIdPartition());
        MaterializationKey key = new MaterializationKey(metadata.type(), metadata.messageId(), this.time.nanoseconds());
        CompletableFuture<TierPartitionState.AppendResult> previous = entries.put(key, future);
        if (previous != null) {
            previous.completeExceptionally(new TierMetadataFatalException("A new index entry is being tracked " + String.valueOf(key) + " obsoleting this request."));
        }
    }

    synchronized Optional<Long> maxListenerTimeNanos() {
        return this.results.values().stream().map(m -> m.keySet().stream().map(MaterializationKey::startTimeNs).min(Long::compareTo)).filter(Optional::isPresent).map(Optional::get).min(Long::compare).map(t -> this.time.nanoseconds() - t);
    }

    synchronized long numListeners() {
        return this.results.values().stream().mapToLong(Map::size).sum();
    }

    synchronized void completeAllExceptionally(Exception e) {
        this.results.values().forEach(entries -> entries.values().forEach(future -> future.completeExceptionally(e)));
        this.results.clear();
    }

    synchronized void shutdown() {
        this.completeAllExceptionally(new CancellationException("TierTopicListeners shutting down"));
    }

    private class MaterializationKey {
        TierRecordType type;
        UUID messageId;
        long startTimeNs;

        MaterializationKey(TierRecordType type, UUID messageId, long startTimeNs) {
            this.type = type;
            this.messageId = messageId;
            this.startTimeNs = startTimeNs;
        }

        public long startTimeNs() {
            return this.startTimeNs;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.messageId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MaterializationKey other = (MaterializationKey)obj;
            return this.type.equals((Object)other.type) && this.messageId.equals(other.messageId);
        }

        public String toString() {
            long ageMs = TimeUnit.NANOSECONDS.toMillis(TierTopicListeners.this.time.nanoseconds() - this.startTimeNs);
            return "MaterializationKey: type(" + String.valueOf((Object)this.type) + ") uuid(" + String.valueOf(this.messageId) + ") uuidAsBase64(" + Utils.uuidToBase64(this.messageId) + ") ageMs(" + ageMs + ")";
        }
    }
}

