/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.Utils;

public class TierTopicPartitioner {
    private int numPartitions;

    public TierTopicPartitioner(int numPartitions) {
        this.numPartitions = numPartitions;
    }

    public int partitionId(TopicIdPartition topicIdPartition) {
        ByteBuffer buffer = ByteBuffer.allocate(20);
        buffer.putLong(topicIdPartition.topicId().getMostSignificantBits());
        buffer.putLong(topicIdPartition.topicId().getLeastSignificantBits());
        buffer.putInt(topicIdPartition.partition());
        return Utils.toPositive(Utils.murmur2(buffer.array())) % this.numPartitions;
    }
}

