/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import kafka.tier.tools.DumpTierPartitionState;
import kafka.tools.DumpLogSegments;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.KRaftVersionRecordJsonConverter;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.message.LeaderChangeMessageJsonConverter;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotFooterRecordJsonConverter;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecordJsonConverter;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.message.VotersRecordJsonConverter;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.ControlRecordUtils;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.BatchMetadata;
import org.apache.kafka.storage.internals.log.CorruptSnapshotException;
import org.apache.kafka.storage.internals.log.MergedLogUtils;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class DumpLogSegments$ {
    public static final DumpLogSegments$ MODULE$ = new DumpLogSegments$();
    private static final String RecordIndent = "|";

    public String RecordIndent() {
        return RecordIndent;
    }

    public void main(String[] args) {
        DumpLogSegments.DumpLogSegmentsOptions opts = new DumpLogSegments.DumpLogSegmentsOptions(args);
        CommandLineUtils.maybePrintHelpOrVersion(opts, "This tool helps to parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        opts.checkArgs();
        Map misMatchesForIndexFilesMap = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        Map nonConsecutivePairsForLogFilesMap = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(opts.files()), (Function1<String, Object> & Serializable)arg -> {
            DumpLogSegments$.$anonfun$main$1(opts, nonConsecutivePairsForLogFilesMap, misMatchesForIndexFilesMap, timeIndexDumpErrors, arg);
            return BoxedUnit.UNIT;
        });
        misMatchesForIndexFilesMap.foreachEntry((Function2<String, List, Object> & Serializable)(fileName, listOfMismatches) -> {
            DumpLogSegments$.$anonfun$main$2(fileName, listOfMismatches);
            return BoxedUnit.UNIT;
        });
        timeIndexDumpErrors.printErrors();
        nonConsecutivePairsForLogFilesMap.foreachEntry((Function2<String, List, Object> & Serializable)(fileName, listOfNonConsecutivePairs) -> {
            DumpLogSegments$.$anonfun$main$4(fileName, listOfNonConsecutivePairs);
            return BoxedUnit.UNIT;
        });
    }

    private void dumpTierState(File file) {
        TopicPartition tp = MergedLogUtils.parseTopicPartitionName(file.getAbsoluteFile().getParentFile());
        DumpTierPartitionState.dumpTierState(tp, file, false, true, false);
    }

    private void dumpTxnIndex(File file) {
        TransactionIndex index = new TransactionIndex(MergedLogUtils.offsetFromFile(file), file, true);
        CollectionConverters$.MODULE$.ListHasAsScala(index.allAbortedTxns()).asScala().foreach((Function1<AbortedTxn, Object> & Serializable)abortedTxn -> {
            Predef$.MODULE$.println("version: " + abortedTxn.version() + " producerId: " + abortedTxn.producerId() + " firstOffset: " + abortedTxn.firstOffset() + " lastOffset: " + abortedTxn.lastOffset() + " lastStableOffset: " + abortedTxn.lastStableOffset());
            return BoxedUnit.UNIT;
        });
    }

    private void dumpProducerIdSnapshot(File file) {
        try {
            ProducerStateManager.readSnapshot(file).forEach(entry -> {
                Predef$.MODULE$.print("producerId: " + entry.producerId() + " producerEpoch: " + entry.producerEpoch() + " coordinatorEpoch: " + entry.coordinatorEpoch() + " currentTxnFirstOffset: " + entry.currentTxnFirstOffset() + " lastTimestamp: " + entry.lastTimestamp() + " ");
                CollectionConverters$.MODULE$.CollectionHasAsScala(entry.batchMetadata()).asScala().headOption().foreach((Function1<BatchMetadata, Object> & Serializable)metadata -> {
                    Predef$.MODULE$.print("firstSequence: " + metadata.firstSeq() + " lastSequence: " + metadata.lastSeq + " lastOffset: " + metadata.lastOffset + " offsetDelta: " + metadata.offsetDelta + " timestamp: " + metadata.timestamp);
                    return BoxedUnit.UNIT;
                });
                Predef$.MODULE$.println();
            });
        }
        catch (CorruptSnapshotException e) {
            System.err.println(e.getMessage());
        }
    }

    public void dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, Map<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        Object object = new Object();
        try {
            long startOffset = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0]));
            File logFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + ".log");
            FileRecords fileRecords = FileRecords.open(logFile, false);
            OffsetIndex index = new OffsetIndex(file, startOffset, -1, true, false, ChecksumParams.EMPTY);
            if (index.entries() == 0) {
                Predef$.MODULE$.println(file + " is empty.");
                return;
            }
            if (indexSanityOnly) {
                index.sanityCheck();
                Predef$.MODULE$.println(file + " passed sanity check.");
                return;
            }
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp(i -> {
                OffsetPosition entry = index.entry(i);
                if (entry.offset == index.baseOffset() && i > 0) {
                    throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                }
                FileRecords slice = fileRecords.slice(entry.position, maxMessageSize);
                long firstBatchLastOffset = ((RecordBatch)slice.batches().iterator().next()).lastOffset();
                if (firstBatchLastOffset != entry.offset) {
                    List<Tuple2$mcJJ$sp> misMatchesSeq = (List<Tuple2$mcJJ$sp>)misMatchesForIndexFilesMap.getOrElse(file.getAbsolutePath(), (Function0<List> & Serializable)() -> Nil$.MODULE$);
                    misMatchesSeq = misMatchesSeq.$colon$colon(new Tuple2$mcJJ$sp(entry.offset, firstBatchLastOffset));
                    v0 = misMatchesForIndexFilesMap.put(file.getAbsolutePath(), misMatchesSeq);
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                if (!verifyOnly) {
                    Predef$.MODULE$.println("offset: " + entry.offset + " position: " + entry.position);
                    return;
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public void dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors) {
        block8: {
            Object object = new Object();
            try {
                block7: {
                    long startOffset = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0]));
                    File logFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + ".log");
                    FileRecords fileRecords = FileRecords.open(logFile, false);
                    File indexFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + ".index");
                    OffsetIndex index = new OffsetIndex(indexFile, startOffset, -1, true, false, ChecksumParams.EMPTY);
                    TimeIndex timeIndex = new TimeIndex(file, startOffset, -1, true, false, ChecksumParams.EMPTY);
                    try {
                        if (indexSanityOnly) {
                            timeIndex.sanityCheck();
                            Predef$.MODULE$.println(file + " passed sanity check.");
                            break block7;
                        }
                        LongRef prevTimestamp = LongRef.create(-1L);
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), timeIndex.entries()).foreach$mVc$sp(arg_0 -> DumpLogSegments$.$anonfun$dumpTimeIndex$1(timeIndex, object, index, fileRecords, timeIndexDumpErrors, file, prevTimestamp, verifyOnly, arg_0));
                        break block8;
                    }
                    finally {
                        fileRecords.closeHandlers();
                        index.closeHandler();
                        timeIndex.closeHandler();
                    }
                }
                return;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    ex.value$mcV$sp();
                }
                throw ex;
            }
        }
    }

    private void dumpLog(File file, boolean printContents, Map<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, DumpLogSegments.MessageParser<?, ?> parser, boolean skipRecordMetadata, int maxBytes) {
        if (file.getName().endsWith(".log")) {
            long startOffset = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0]));
            Predef$.MODULE$.println("Log starting offset: " + startOffset);
        } else if (file.getName().endsWith(".checkpoint")) {
            String string = file.getName();
            String string2 = "bootstrap.checkpoint";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Predef$.MODULE$.println("KRaft bootstrap snapshot");
            } else {
                SnapshotPath path = Snapshots.parse(file.toPath()).get();
                Predef$.MODULE$.println("Snapshot end offset: " + path.snapshotId().offset() + ", epoch: " + path.snapshotId().epoch());
            }
        }
        FileRecords fileRecords = FileRecords.open(file, false).slice(0, maxBytes);
        try {
            LongRef validBytes = LongRef.create(0L);
            LongRef lastOffset = LongRef.create(-1L);
            CollectionConverters$.MODULE$.IterableHasAsScala(fileRecords.batches()).asScala().foreach((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable)batch -> {
                DumpLogSegments$.$anonfun$dumpLog$1(validBytes, isDeepIteration, lastOffset, nonConsecutivePairsForLogFilesMap, file, skipRecordMetadata, printContents, parser, batch);
                return BoxedUnit.UNIT;
            });
            long trailingBytes = (long)fileRecords.sizeInBytes() - validBytes.elem;
            if (trailingBytes > 0L && maxBytes == Integer.MAX_VALUE) {
                Predef$.MODULE$.println("Found " + trailingBytes + " invalid bytes at the end of " + file.getName());
            }
        }
        finally {
            fileRecords.closeHandlers();
        }
    }

    private void printControlRecord(Record record) {
        short controlTypeId = ControlRecordType.parseTypeId(record.key());
        ControlRecordType controlRecordType = ControlRecordType.fromTypeId(controlTypeId);
        if (((Object)((Object)ControlRecordType.ABORT)).equals((Object)controlRecordType) ? true : ((Object)((Object)ControlRecordType.COMMIT)).equals((Object)controlRecordType)) {
            EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize(record);
            Predef$.MODULE$.print(" endTxnMarker: " + endTxnMarker.controlType() + " coordinatorEpoch: " + endTxnMarker.coordinatorEpoch());
            return;
        }
        if (((Object)((Object)ControlRecordType.LEADER_CHANGE)).equals((Object)controlRecordType)) {
            LeaderChangeMessage leaderChangeMessage = ControlRecordUtils.deserializeLeaderChangeMessage(record);
            Predef$.MODULE$.print(" LeaderChange: " + LeaderChangeMessageJsonConverter.write(leaderChangeMessage, leaderChangeMessage.version()));
            return;
        }
        if (((Object)((Object)ControlRecordType.SNAPSHOT_HEADER)).equals((Object)controlRecordType)) {
            SnapshotHeaderRecord header = ControlRecordUtils.deserializeSnapshotHeaderRecord(record);
            Predef$.MODULE$.print(" SnapshotHeader " + SnapshotHeaderRecordJsonConverter.write(header, header.version()));
            return;
        }
        if (((Object)((Object)ControlRecordType.SNAPSHOT_FOOTER)).equals((Object)controlRecordType)) {
            SnapshotFooterRecord footer = ControlRecordUtils.deserializeSnapshotFooterRecord(record);
            Predef$.MODULE$.print(" SnapshotFooter " + SnapshotFooterRecordJsonConverter.write(footer, footer.version()));
            return;
        }
        if (((Object)((Object)ControlRecordType.KRAFT_VERSION)).equals((Object)controlRecordType)) {
            KRaftVersionRecord kraftVersion = ControlRecordUtils.deserializeKRaftVersionRecord(record);
            Predef$.MODULE$.print(" KRaftVersion " + KRaftVersionRecordJsonConverter.write(kraftVersion, kraftVersion.version()));
            return;
        }
        if (((Object)((Object)ControlRecordType.KRAFT_VOTERS)).equals((Object)controlRecordType)) {
            VotersRecord voters = ControlRecordUtils.deserializeVotersRecord(record);
            Predef$.MODULE$.print(" KRaftVoters " + VotersRecordJsonConverter.write(voters, voters.version()));
            return;
        }
        Predef$.MODULE$.print(" controlType: " + controlRecordType + "(" + controlTypeId + ")");
    }

    private void printBatchLevel(FileLogInputStream.FileChannelRecordBatch batch, long accumulativeBytes) {
        if (batch.magic() >= 2) {
            Predef$.MODULE$.print("baseOffset: " + batch.baseOffset() + " lastOffset: " + batch.lastOffset() + " count: " + batch.countOrNull() + " baseSequence: " + batch.baseSequence() + " lastSequence: " + batch.lastSequence() + " producerId: " + batch.producerId() + " producerEpoch: " + batch.producerEpoch() + " partitionLeaderEpoch: " + batch.partitionLeaderEpoch() + " isTransactional: " + batch.isTransactional() + " isControl: " + batch.isControlBatch() + " deleteHorizonMs: " + batch.deleteHorizonMs());
        } else {
            Predef$.MODULE$.print("offset: " + batch.lastOffset());
        }
        Predef$.MODULE$.println(" position: " + accumulativeBytes + " " + batch.timestampType() + ": " + batch.maxTimestamp() + " size: " + batch.sizeInBytes() + " magic: " + batch.magic() + " compresscodec: " + batch.compressionType().name + " crc: " + batch.checksum() + " isvalid: " + batch.isValid());
    }

    public static final /* synthetic */ void $anonfun$main$1(DumpLogSegments.DumpLogSegmentsOptions opts$1, Map nonConsecutivePairsForLogFilesMap$1, Map misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, String arg) {
        block13: {
            String filename;
            File file;
            block12: {
                String suffix;
                file = new File(arg);
                Predef$.MODULE$.println("Dumping " + file);
                filename = file.getName();
                String string = suffix = filename.substring(filename.lastIndexOf("."));
                switch (string == null ? 0 : string.hashCode()) {
                    case -1558154186: {
                        if (".checkpoint".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case -1253652494: {
                        if (!".snapshot".equals(string)) break block12;
                        MODULE$.dumpProducerIdSnapshot(file);
                        break block13;
                    }
                    case -403971657: {
                        if (!".timeindex".equals(string)) break block12;
                        MODULE$.dumpTimeIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), timeIndexDumpErrors$1);
                        break block13;
                    }
                    case 1477718: {
                        if (".log".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case 1139821270: {
                        if (!".txnindex".equals(string)) break block12;
                        MODULE$.dumpTxnIndex(file);
                        break block13;
                    }
                    case 1417287012: {
                        if (!".index".equals(string)) break block12;
                        MODULE$.dumpIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), misMatchesForIndexFilesMap$1, opts$1.maxMessageSize());
                        break block13;
                    }
                    default: {
                        break block12;
                    }
                }
                MODULE$.dumpLog(file, opts$1.shouldPrintDataLog(), nonConsecutivePairsForLogFilesMap$1, opts$1.isDeepIteration(), opts$1.messageParser(), opts$1.skipRecordMetadata(), opts$1.maxBytes());
                break block13;
            }
            if (filename.contains(".tierstate")) {
                MODULE$.dumpTierState(file);
            } else {
                System.err.println("Ignoring unknown file " + file);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$main$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long indexOffset = tuple2._1$mcJ$sp();
            long logOffset = tuple2._2$mcJ$sp();
            System.err.println("  Index offset: " + indexOffset + ", log offset: " + logOffset);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$2(String fileName, List listOfMismatches) {
        System.err.println("Mismatches in :" + fileName);
        listOfMismatches.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            DumpLogSegments$.$anonfun$main$3(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$main$5(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long first = tuple2._1$mcJ$sp();
            long second = tuple2._2$mcJ$sp();
            System.err.println("  " + first + " is followed by " + second);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$4(String fileName, List listOfNonConsecutivePairs) {
        System.err.println("Non-consecutive offsets in " + fileName);
        listOfNonConsecutivePairs.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            DumpLogSegments$.$anonfun$main$5(x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$dumpTimeIndex$2(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return x$1.lastOffset() >= entry$1.offset;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$dumpTimeIndex$1(TimeIndex timeIndex$1, Object nonLocalReturnKey2$1, OffsetIndex index$2, FileRecords fileRecords$2, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2, File file$2, LongRef prevTimestamp$1, boolean verifyOnly$2, int i) {
        block9: {
            block8: {
                entry = timeIndex$1.entry(i);
                if (entry.offset == timeIndex$1.baseOffset() && i > 0) {
                    throw new NonLocalReturnControl$mcV$sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
                }
                position = index$2.lookup((long)entry.offset).position;
                partialFileRecords = fileRecords$2.slice(position, 0x7FFFFFFF);
                batches = CollectionConverters$.MODULE$.IterableHasAsScala(partialFileRecords.batches()).asScala();
                maxTimestamp = LongRef.create(-1L);
                var15_14 = false;
                var16_15 = null;
                var17_16 = batches.find((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$2$adapted(org.apache.kafka.storage.internals.log.TimestampOffset org.apache.kafka.common.record.FileLogInputStream$FileChannelRecordBatch ), (Lorg/apache/kafka/common/record/FileLogInputStream$FileChannelRecordBatch;)Ljava/lang/Object;)((TimestampOffset)entry));
                if (!None$.MODULE$.equals(var17_16)) break block8;
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset, -1L);
                break block9;
            }
            if (!(var17_16 instanceof Some)) ** GOTO lbl-1000
            var15_14 = true;
            var16_15 = (Some)var17_16;
            batch = (FileLogInputStream.FileChannelRecordBatch)var16_15.value();
            if (batch.lastOffset() != entry.offset) {
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset, batch.lastOffset());
            } else if (var15_14) {
                batch = (FileLogInputStream.FileChannelRecordBatch)var16_15.value();
                CollectionConverters$.MODULE$.IterableHasAsScala(batch).asScala().foreach((Function1<Record, Object> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$3$adapted(scala.runtime.LongRef org.apache.kafka.common.record.Record ), (Lorg/apache/kafka/common/record/Record;)Ljava/lang/Object;)((LongRef)maxTimestamp));
                if (maxTimestamp.elem != entry.timestamp) {
                    timeIndexDumpErrors$2.recordMismatchTimeIndex(file$2, entry.timestamp, maxTimestamp.elem);
                }
                if (prevTimestamp$1.elem >= entry.timestamp) {
                    timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(file$2, entry.timestamp, prevTimestamp$1.elem);
                }
            } else {
                throw new MatchError(var17_16);
            }
        }
        if (!verifyOnly$2) {
            Predef$.MODULE$.println("timestamp: " + entry.timestamp + " offset: " + entry.offset);
        }
        prevTimestamp$1.elem = entry.timestamp;
    }

    public static final /* synthetic */ void $anonfun$dumpLog$5(ObjectRef prefix$1, Object key) {
        Predef$.MODULE$.print((String)prefix$1.elem + "key: " + key);
        prefix$1.elem = " ";
    }

    public static final /* synthetic */ void $anonfun$dumpLog$2(LongRef lastOffset$1, Map nonConsecutivePairsForLogFilesMap$2, File file$3, boolean skipRecordMetadata$1, FileLogInputStream.FileChannelRecordBatch batch$1, boolean printContents$1, DumpLogSegments.MessageParser parser$1, Record record) {
        if (lastOffset$1.elem == -1L) {
            lastOffset$1.elem = record.offset();
            v0 = BoxedUnit.UNIT;
        } else if (record.offset() != lastOffset$1.elem + 1L) {
            List<Tuple2$mcJJ$sp> nonConsecutivePairsSeq = (List<Tuple2$mcJJ$sp>)nonConsecutivePairsForLogFilesMap$2.getOrElse(file$3.getAbsolutePath(), (Function0<List> & Serializable)() -> Nil$.MODULE$);
            nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon(new Tuple2$mcJJ$sp(lastOffset$1.elem, record.offset()));
            v0 = nonConsecutivePairsForLogFilesMap$2.put(file$3.getAbsolutePath(), nonConsecutivePairsSeq);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        lastOffset$1.elem = record.offset();
        ObjectRef<CallSite> prefix = ObjectRef.create(MODULE$.RecordIndent() + " ");
        if (!skipRecordMetadata$1) {
            Record record2;
            Predef$.MODULE$.print((String)prefix.elem + "offset: " + record.offset() + " " + batch$1.timestampType() + ": " + record.timestamp() + " keySize: " + record.keySize() + " valueSize: " + record.valueSize());
            prefix.elem = " ";
            if (batch$1.magic() >= 2) {
                Predef$.MODULE$.print(" sequence: " + record.sequence() + " headerKeys: " + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(record.headers()), (Function1<Header, String> & Serializable)x$2 -> x$2.key(), ClassTag$.MODULE$.apply(String.class))).mkString("[", ",", "]"));
            }
            if ((record2 = record) instanceof AbstractLegacyRecordBatch) {
                AbstractLegacyRecordBatch abstractLegacyRecordBatch = (AbstractLegacyRecordBatch)record2;
                Predef$.MODULE$.print(" isValid: " + abstractLegacyRecordBatch.isValid() + " crc: " + abstractLegacyRecordBatch.checksum() + "}");
            }
            if (batch$1.isControlBatch()) {
                MODULE$.printControlRecord(record);
            }
        }
        if (printContents$1 && !batch$1.isControlBatch()) {
            Tuple2 tuple2 = parser$1.parse(record);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option key2 = tuple2._1();
            Option payload2 = tuple2._2();
            Tuple2 tuple22 = new Tuple2(key2, payload2);
            Option key3 = tuple22._1();
            Option payload3 = tuple22._2();
            key3.foreach((Function1<Object, Object> & Serializable)key -> {
                DumpLogSegments$.$anonfun$dumpLog$5(prefix, key);
                return BoxedUnit.UNIT;
            });
            payload3.foreach((Function1<Object, Object> & Serializable)payload -> {
                Predef$.MODULE$.print(" payload: " + payload);
                return BoxedUnit.UNIT;
            });
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$1(LongRef validBytes$1, boolean isDeepIteration$1, LongRef lastOffset$1, Map nonConsecutivePairsForLogFilesMap$2, File file$3, boolean skipRecordMetadata$1, boolean printContents$1, DumpLogSegments.MessageParser parser$1, FileLogInputStream.FileChannelRecordBatch batch) {
        MODULE$.printBatchLevel(batch, validBytes$1.elem);
        if (isDeepIteration$1) {
            CollectionConverters$.MODULE$.IterableHasAsScala(batch).asScala().foreach((Function1<Record, Object> & Serializable)record -> {
                DumpLogSegments$.$anonfun$dumpLog$2(lastOffset$1, nonConsecutivePairsForLogFilesMap$2, file$3, skipRecordMetadata$1, batch, printContents$1, parser$1, record);
                return BoxedUnit.UNIT;
            });
        }
        validBytes$1.elem += (long)batch.sizeInBytes();
    }

    private DumpLogSegments$() {
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$2$adapted(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return BoxesRunTime.boxToBoolean(DumpLogSegments$.$anonfun$dumpTimeIndex$2(entry$1, x$1));
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$3$adapted(LongRef maxTimestamp$1, Record record) {
        maxTimestamp$1.elem = package$.MODULE$.max(maxTimestamp$1.elem, record.timestamp());
        return BoxedUnit.UNIT;
    }
}

