/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiRequestHandler;
import kafka.server.RequestLogger;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.common.RequestLocal;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\b\u0010\u0001QA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015Q\b\u0001\"\u0003|\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!a\u0002\u0001\t\u0013\tI\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016!1\u0001\r\u0001C\u0005\u00033\u0011a\u0003V3tiJ\u000bg\r\u001e*fcV,7\u000f\u001e%b]\u0012dWM\u001d\u0006\u0003!E\tQ\u0001^8pYNT\u0011AE\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001QcG\u0011\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\tar$D\u0001\u001e\u0015\tq\u0012#\u0001\u0004tKJ4XM]\u0005\u0003Au\u0011\u0011#\u00119j%\u0016\fX/Z:u\u0011\u0006tG\r\\3s!\t\u0011S%D\u0001$\u0015\t!\u0013#A\u0003vi&d7/\u0003\u0002'G\t9Aj\\4hS:<\u0017a\u0003:bMRl\u0015M\\1hKJ\u0004$!K\u0019\u0011\u0007)js&D\u0001,\u0015\ta\u0013#\u0001\u0003sC\u001a$\u0018B\u0001\u0018,\u0005-\u0011\u0016M\u001a;NC:\fw-\u001a:\u0011\u0005A\nD\u0002\u0001\u0003\ne\u0005\t\t\u0011!A\u0003\u0002M\u00121a\u0018\u00132#\t!t\u0007\u0005\u0002\u0017k%\u0011ag\u0006\u0002\b\u001d>$\b.\u001b8h!\t1\u0002(\u0003\u0002:/\t\u0019\u0011I\\=\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u0011AhP\u0007\u0002{)\u0011a(E\u0001\b]\u0016$xo\u001c:l\u0013\t\u0001UH\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002\tQLW.\u001a\t\u0003\u00072k\u0011\u0001\u0012\u0006\u0003I\u0015S!AR$\u0002\r\r|W.\\8o\u0015\t\u0011\u0002J\u0003\u0002J\u0015\u00061\u0011\r]1dQ\u0016T\u0011aS\u0001\u0004_J<\u0017BA'E\u0005\u0011!\u0016.\\3\u0002#\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'\u000f\u0005\u0002Q%6\t\u0011K\u0003\u0002\u001f\u000f&\u00111+\u0015\u0002\u0012\u0003BLg+\u001a:tS>tW*\u00198bO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003W1vsv\f\u0005\u0002X\u00015\tq\u0002C\u0003(\u000b\u0001\u0007\u0011\f\r\u0002[9B\u0019!&L.\u0011\u0005AbF!\u0003\u001aY\u0003\u0003\u0005\tQ!\u00014\u0011\u0015QT\u00011\u0001<\u0011\u0015\tU\u00011\u0001C\u0011\u0015qU\u00011\u0001P\u0003\u0019A\u0017M\u001c3mKR!!-\u001a8t!\t12-\u0003\u0002e/\t!QK\\5u\u0011\u00151g\u00011\u0001h\u0003\u001d\u0011X-];fgR\u0004\"\u0001[6\u000f\u0005qJ\u0017B\u00016>\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!\u0001\\7\u0003\u000fI+\u0017/^3ti*\u0011!.\u0010\u0005\u0006_\u001a\u0001\r\u0001]\u0001\u000ee\u0016\fX/Z:u\u0019><w-\u001a:\u0011\u0005q\t\u0018B\u0001:\u001e\u00055\u0011V-];fgRdunZ4fe\")AO\u0002a\u0001k\u0006a!/Z9vKN$Hj\\2bYB\u0011a\u000f_\u0007\u0002o*\u0011a)U\u0005\u0003s^\u0014ABU3rk\u0016\u001cH\u000fT8dC2\f\u0011\u0003[1oI2,\u0017\t]5WKJ\u001c\u0018n\u001c8t)\t\u0011G\u0010C\u0003g\u000f\u0001\u0007q-\u0001\u0006iC:$G.\u001a,pi\u0016$\"AY@\t\u000b\u0019D\u0001\u0019A4\u0002-!\fg\u000e\u001a7f\u0005\u0016<\u0017N\\)v_J,X.\u00129pG\"$2AYA\u0003\u0011\u00151\u0017\u00021\u0001h\u0003QA\u0017M\u001c3mK\u0016sG-U;peVlW\t]8dQR\u0019!-a\u0003\t\u000b\u0019T\u0001\u0019A4\u0002\u0017!\fg\u000e\u001a7f\r\u0016$8\r\u001b\u000b\u0004E\u0006E\u0001\"\u00024\f\u0001\u00049\u0017a\u00055b]\u0012dWMR3uG\"\u001cf.\u00199tQ>$Hc\u00012\u0002\u0018!)a\r\u0004a\u0001OR)!-a\u0007\u0002\u001e!)a-\u0004a\u0001O\"9\u0011qD\u0007A\u0002\u0005\u0005\u0012!\u00042vS2$'+Z:q_:\u001cX\rE\u0004\u0017\u0003G\t9#a\r\n\u0007\u0005\u0015rCA\u0005Gk:\u001cG/[8ocA!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.\u0015\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003c\tYC\u0001\u0006Ba&lUm]:bO\u0016\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003s)\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u0005u\u0012q\u0007\u0002\u0011\u0003\n\u001cHO]1diJ+7\u000f]8og\u0016\u0004")
public class TestRaftRequestHandler
implements ApiRequestHandler,
Logging {
    private final RaftManager<?> raftManager;
    private final RequestChannel requestChannel;
    private final Time time;
    private final ApiVersionManager apiVersionManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TestRaftRequestHandler testRaftRequestHandler = this;
        synchronized (testRaftRequestHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLogger requestLogger, RequestLocal requestLocal) {
        block13: {
            try {
                try {
                    this.trace((Function0<String> & Serializable)() -> "Handling request:" + request.requestDesc(true) + " with context " + request.context());
                    ApiKeys apiKeys = request.header().apiKey();
                    if (((Object)((Object)ApiKeys.API_VERSIONS)).equals((Object)apiKeys)) {
                        this.handleApiVersions(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.VOTE)).equals((Object)apiKeys)) {
                        this.handleVote(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.BEGIN_QUORUM_EPOCH)).equals((Object)apiKeys)) {
                        this.handleBeginQuorumEpoch(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.END_QUORUM_EPOCH)).equals((Object)apiKeys)) {
                        this.handleEndQuorumEpoch(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.FETCH)).equals((Object)apiKeys)) {
                        this.handleFetch(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.FETCH_SNAPSHOT)).equals((Object)apiKeys)) {
                        this.handleFetchSnapshot(request);
                        break block13;
                    }
                    throw new IllegalArgumentException("Unsupported api key: " + request.header().apiKey());
                }
                catch (FatalExitError e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.error((Function0<String> & Serializable)() -> "Unexpected error handling request " + request.requestDesc(true) + " with context " + request.context(), (Function0<Throwable> & Serializable)() -> e);
                    AbstractResponse errorResponse = ((AbstractRequest)request.body(ClassTag$.MODULE$.apply(AbstractRequest.class))).getErrorResponse(e);
                    this.requestChannel.sendResponse(request, errorResponse, None$.MODULE$);
                }
            }
            finally {
                if (request.apiLocalCompleteTimeNanos() < 0L) {
                    request.apiLocalCompleteTimeNanos_$eq(this.time.nanoseconds());
                }
            }
        }
    }

    private void handleApiVersions(RequestChannel.Request request) {
        this.requestChannel.sendResponse(request, this.apiVersionManager.apiVersionResponse(0, request.header().apiVersion() < 4), None$.MODULE$);
    }

    private void handleVote(RequestChannel.Request request) {
        this.handle(request, (Function1<ApiMessage, AbstractResponse>)(Function1<ApiMessage, VoteResponse> & Serializable)response -> new VoteResponse((VoteResponseData)response));
    }

    private void handleBeginQuorumEpoch(RequestChannel.Request request) {
        this.handle(request, (Function1<ApiMessage, AbstractResponse>)(Function1<ApiMessage, BeginQuorumEpochResponse> & Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response));
    }

    private void handleEndQuorumEpoch(RequestChannel.Request request) {
        this.handle(request, (Function1<ApiMessage, AbstractResponse>)(Function1<ApiMessage, EndQuorumEpochResponse> & Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response));
    }

    private void handleFetch(RequestChannel.Request request) {
        this.handle(request, (Function1<ApiMessage, AbstractResponse>)(Function1<ApiMessage, FetchResponse> & Serializable)response -> FetchResponse.of((FetchResponseData)response));
    }

    private void handleFetchSnapshot(RequestChannel.Request request) {
        this.handle(request, (Function1<ApiMessage, AbstractResponse>)(Function1<ApiMessage, FetchSnapshotResponse> & Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response));
    }

    private void handle(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        CompletableFuture<ApiMessage> future = this.raftManager.handleRequest(request.context(), request.header(), requestBody.data(), this.time.milliseconds());
        future.whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? requestBody.getErrorResponse((Throwable)exception) : (AbstractResponse)buildResponse.apply((ApiMessage)response);
            $this.requestChannel.sendResponse(request, res, None$.MODULE$);
        });
    }

    public TestRaftRequestHandler(RaftManager<?> raftManager, RequestChannel requestChannel, Time time, ApiVersionManager apiVersionManager) {
        this.raftManager = raftManager;
        this.requestChannel = requestChannel;
        this.time = time;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
    }
}

