/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.utils.Logging;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.network.SocketServerConfigs;
import org.apache.kafka.server.util.Csv;
import org.slf4j.event.Level;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class CoreUtils$ {
    public static final CoreUtils$ MODULE$ = new CoreUtils$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());
    private static final InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();

    private Logger logger() {
        return logger;
    }

    private InetAddressValidator inetAddressValidator() {
        return inetAddressValidator;
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable e) {
            Level level = logLevel;
            if (((Object)((Object)Level.ERROR)).equals((Object)level)) {
                logging.error((Function0<String> & Serializable)() -> e.getMessage(), (Function0<Throwable> & Serializable)() -> e);
            }
            if (((Object)((Object)Level.WARN)).equals((Object)level)) {
                logging.warn((Function0<String> & Serializable)() -> e.getMessage(), (Function0<Throwable> & Serializable)() -> e);
            }
            if (((Object)((Object)Level.INFO)).equals((Object)level)) {
                logging.info((Function0<String> & Serializable)() -> e.getMessage(), (Function0<Throwable> & Serializable)() -> e);
            }
            if (((Object)((Object)Level.DEBUG)).equals((Object)level)) {
                logging.debug((Function0<String> & Serializable)() -> e.getMessage(), (Function0<Throwable> & Serializable)() -> e);
            }
            if (((Object)((Object)Level.TRACE)).equals((Object)level)) {
                logging.trace((Function0<String> & Serializable)() -> e.getMessage(), (Function0<Throwable> & Serializable)() -> e);
            }
            throw new MatchError((Object)level);
        }
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(List<String> files) {
        files.forEach(f -> Utils.delete(new File((String)f)));
    }

    public void tryAll(Seq<Function0<BoxedUnit>> all) {
        ObjectRef<Object> exception = ObjectRef.create(null);
        all.foreach((Function1<Function0, Object> & Serializable)element -> {
            CoreUtils$.$anonfun$tryAll$1(exception, element);
            return BoxedUnit.UNIT;
        });
        if ((Throwable)exception.elem != null) {
            throw (Throwable)exception.elem;
        }
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to register Mbean " + name, e);
                v2 = BoxedUnit.UNIT;
            } else {
                v2 = BoxedUnit.UNIT;
            }
            bl = false;
        }
        return bl;
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        T t;
        boolean locked = true;
        try {
            lock.lock();
            try {
                t = fun.apply();
            }
            finally {
                lock.unlock();
                locked = false;
            }
        }
        catch (Exception e) {
            if (locked) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Potential lock issue: exception before unlocking lock " + lock + ":", e);
                    v1 = BoxedUnit.UNIT;
                } else {
                    v1 = BoxedUnit.UNIT;
                }
            } else {
                v1 = BoxedUnit.UNIT;
            }
            throw e;
        }
        return t;
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        return this.inLock(lock.readLock(), fun);
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        T t;
        block7: {
            boolean wasAlreadyHoldingWriteLock = CoreUtils$.isWriteLockedByCurrentThread$1(lock);
            try {
                t = this.inLock(lock.writeLock(), fun);
            }
            catch (Throwable throwable) {
                if (wasAlreadyHoldingWriteLock != CoreUtils$.isWriteLockedByCurrentThread$1(lock)) {
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Potential lock issue: write lock / unlock didn't restore lock " + lock.writeLock() + " into holding=" + wasAlreadyHoldingWriteLock + "\n\tat " + Predef$.MODULE$.wrapRefArray((Object[])Thread.currentThread().getStackTrace()).mkString("\n\tat "));
                        v1 = BoxedUnit.UNIT;
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
            if (wasAlreadyHoldingWriteLock == CoreUtils$.isWriteLockedByCurrentThread$1(lock)) break block7;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Potential lock issue: write lock / unlock didn't restore lock " + lock.writeLock() + " into holding=" + wasAlreadyHoldingWriteLock + "\n\tat " + Predef$.MODULE$.wrapRefArray((Object[])Thread.currentThread().getStackTrace()).mkString("\n\tat "));
                v2 = BoxedUnit.UNIT;
            } else {
                v2 = BoxedUnit.UNIT;
            }
        }
        return t;
    }

    public Seq<Endpoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        return this.listenerListToEndPoints(listeners, securityProtocolMap, true);
    }

    public scala.collection.immutable.Map<String, String> clusterLinkLocalReverseConnectionListenerMap(String listenerToListenerConfigVal, Seq<ListenerName> listeners) {
        Set listenersSet = ((IterableOnceOps)listeners.map((Function1<ListenerName, String> & Serializable)x$1 -> x$1.value())).toSet();
        if (listenerToListenerConfigVal != null) {
            scala.collection.immutable.Map<String, String> listenerToListener = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(Csv.parseCsvList(listenerToListenerConfigVal)).asScala().map((Function1<String, Tuple2> & Serializable)listenerToListenerStr -> {
                String key = listenerToListenerStr.substring(0, listenerToListenerStr.lastIndexOf(":")).trim();
                String value = listenerToListenerStr.substring(listenerToListenerStr.lastIndexOf(":") + 1).trim();
                if (listenersSet.contains(key) && !listenersSet.contains(value)) {
                    throw new IllegalArgumentException("Listener " + value + " does not exist in the brokers configured listeners " + listenersSet);
                }
                return new Tuple2<String, String>(key, value);
            })).toMap($less$colon$less$.MODULE$.refl());
            listenersSet.foreach((Function1<String, Object> & Serializable)l -> {
                CoreUtils$.$anonfun$clusterLinkLocalReverseConnectionListenerMap$3(listenerToListener, listenerToListenerConfigVal, l);
                return BoxedUnit.UNIT;
            });
            return listenerToListener;
        }
        return ((IterableOnceOps)listeners.map((Function1<ListenerName, Tuple2> & Serializable)l -> new Tuple2<String, String>(l.value(), l.value()))).toMap($less$colon$less$.MODULE$.refl());
    }

    private void checkDuplicateListenerPorts(Seq<Endpoint> endpoints, String listeners) {
        Seq distinctPorts = (Seq)((SeqOps)endpoints.map((Function1<Endpoint, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.port()))).distinct();
        Predef$.MODULE$.require(distinctPorts.size() == ((SeqOps)endpoints.map((Function1<Endpoint, Object> & Serializable)x$3 -> BoxesRunTime.boxToInteger(x$3.port()))).size(), (Function0<Object>)(Function0<String> & Serializable)() -> "Each listener must have a different port, listeners: " + listeners);
    }

    public Seq<Endpoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap, boolean requireDistinctPorts) {
        Buffer<Endpoint> buffer;
        try {
            buffer = CollectionConverters$.MODULE$.ListHasAsScala(SocketServerConfigs.listenerListToEndPoints(listeners, securityProtocolMap)).asScala();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating broker listeners from '" + listeners + "': " + e.getMessage(), e);
        }
        Buffer<Endpoint> endPoints = buffer;
        this.validate$1(endPoints, listeners, requireDistinctPorts);
        return endPoints;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return Utils.uuidToBase64(uuid);
    }

    public UUID toJavaUUID(Uuid uuid) {
        return new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public Uuid toKafkaUuidFromJavaUUIDString(String id) {
        return Utils.toKafkaUuid(UUID.fromString(id));
    }

    public String toJavaUUIDStringFromKafkaUuidString(String id) {
        return this.toJavaUUID(Uuid.fromString(id)).toString();
    }

    public byte[] md5hash(ByteBuffer buf) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buf.duplicate());
        return md5.digest();
    }

    public String toBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public Properties propsWith(String key, String value) {
        return this.propsWith(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, String>(key, value)}));
    }

    public Properties propsWith(scala.collection.immutable.Seq<Tuple2<String, String>> props) {
        Properties properties = new Properties();
        props.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return properties.put(k, v);
            }
            throw new MatchError(tuple2);
        });
        return properties;
    }

    public static final /* synthetic */ void $anonfun$tryAll$1(ObjectRef exception$1, Function0 element) {
        block3: {
            try {
                element.apply$mcV$sp();
            }
            catch (Throwable e) {
                if ((Throwable)exception$1.elem != null) {
                    ((Throwable)exception$1.elem).addSuppressed(e);
                    break block3;
                }
                exception$1.elem = e;
            }
        }
    }

    private static final boolean isWriteLockedByCurrentThread$1(ReadWriteLock lock$1) {
        return lock$1 instanceof ReentrantReadWriteLock && ((ReentrantReadWriteLock)lock$1).isWriteLockedByCurrentThread();
    }

    public static final /* synthetic */ void $anonfun$clusterLinkLocalReverseConnectionListenerMap$3(scala.collection.immutable.Map listenerToListener$1, String listenerToListenerConfigVal$1, String l) {
        if (!listenerToListener$1.contains(l)) {
            throw new IllegalArgumentException(listenerToListenerConfigVal$1 + " does not contain a mapping for listener " + l + ".");
        }
    }

    private final boolean validateOneIsIpv4AndOtherIpv6$1(String first, String second) {
        return this.inetAddressValidator().isValidInet4Address(first) && this.inetAddressValidator().isValidInet6Address(second) || this.inetAddressValidator().isValidInet6Address(first) && this.inetAddressValidator().isValidInet4Address(second);
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$3(Endpoint ep) {
        return ep.port() != 0;
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$5(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq endpoints = (Seq)tuple2._2();
            return endpoints.size() > 1;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$7(Endpoint ep) {
        return ep.host() != null && MODULE$.inetAddressValidator().isValid(ep.host());
    }

    public static final /* synthetic */ void $anonfun$listenerListToEndPoints$8(CoreUtils$ $this, boolean requireDistinctPorts$1, String listeners$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            int port = tuple2._1$mcI$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                SeqOps seqOps;
                Seq seq;
                Seq duplicatesWithIpHosts = (Seq)tuple22._1();
                Seq duplicatesWithoutIpHosts = (Seq)tuple22._2();
                if (requireDistinctPorts$1) {
                    MODULE$.checkDuplicateListenerPorts(duplicatesWithoutIpHosts, listeners$2);
                }
                if ((seq = duplicatesWithIpHosts).isEmpty()) {
                } else if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                    Endpoint ep1 = (Endpoint)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    Endpoint ep2 = (Endpoint)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    if (requireDistinctPorts$1) {
                        String errorMessage = "If you have two listeners on the same port then one needs to be IPv4 and the other IPv6, listeners: " + listeners$2 + ", port: " + port;
                        Predef$.MODULE$.require($this.validateOneIsIpv4AndOtherIpv6$1(ep1.host(), ep2.host()), (Function0<Object>)(Function0<String> & Serializable)() -> errorMessage);
                        if (duplicatesWithoutIpHosts.nonEmpty()) {
                            throw new IllegalArgumentException(errorMessage);
                        }
                    }
                } else if (requireDistinctPorts$1) {
                    throw new IllegalArgumentException("Each listener must have a different port unless exactly one listener has an IPv4 address and the other IPv6 address, listeners: " + listeners$2 + ", port: " + port);
                }
                return;
            }
        }
        throw new MatchError(tuple2);
    }

    private final void validate$1(Seq endPoints, String listeners$2, boolean requireDistinctPorts$1) {
        Seq distinctListenerNames = (Seq)((SeqOps)endPoints.map((Function1<Endpoint, String> & Serializable)x$4 -> x$4.listener())).distinct();
        Predef$.MODULE$.require(distinctListenerNames.size() == endPoints.size(), (Function0<Object>)(Function0<String> & Serializable)() -> "Each listener must have a different name, listeners: " + listeners$2);
        Tuple2 tuple2 = ((IterableOps)endPoints.filter((Function1<Endpoint, Object> & Serializable)ep -> BoxesRunTime.boxToBoolean(CoreUtils$.$anonfun$listenerListToEndPoints$3(ep)))).groupBy((Function1<Endpoint, Object> & Serializable)x$5 -> BoxesRunTime.boxToInteger(x$5.port())).partition((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(CoreUtils$.$anonfun$listenerListToEndPoints$5(x0$1)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map duplicatePorts = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map duplicatePorts2 = duplicatePorts;
        scala.collection.immutable.Map duplicatePortsPartitionedByValidIps = (scala.collection.immutable.Map)duplicatePorts2.map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int port = tuple2._1$mcI$sp();
                Seq eps = (Seq)tuple2._2();
                return new Tuple2(BoxesRunTime.boxToInteger(port), eps.partition((Function1<Endpoint, Object> & Serializable)ep -> BoxesRunTime.boxToBoolean(CoreUtils$.$anonfun$listenerListToEndPoints$7(ep))));
            }
            throw new MatchError(tuple2);
        });
        duplicatePortsPartitionedByValidIps.foreach((Function1<Tuple2, Object> & Serializable)x0$3 -> {
            CoreUtils$.$anonfun$listenerListToEndPoints$8(this, requireDistinctPorts$1, listeners$2, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private CoreUtils$() {
    }
}

