/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import io.kubernetes.client.Exec;
import io.kubernetes.client.openapi.ApiException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Kube {
    private static final Logger log = LoggerFactory.getLogger(Kube.class);
    private static final int DEFAULT_TIMEOUT_MIN = 3;

    public static boolean execute(String namespace, String podName, String[] commands, Integer timeoutMinutes, Exec exec, boolean allowFailure) throws IOException, ApiException, InterruptedException {
        Exec e = exec != null ? exec : new Exec();
        int timeout = timeoutMinutes != null ? timeoutMinutes : 3;
        String commandString = String.join((CharSequence)" ", commands);
        log.info("Running command `{}` in {}/{}", new Object[]{commandString, namespace, podName});
        Process process = e.exec(namespace, podName, commands, false, false);
        try (BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            boolean bl;
            try (BufferedReader stderrReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String stdout = stdoutReader.lines().collect(Collectors.joining("\n"));
                String stderr = stderrReader.lines().collect(Collectors.joining("\n"));
                boolean result = process.waitFor(timeout, TimeUnit.MINUTES);
                if (!result && !allowFailure) {
                    throw new RuntimeException(String.format("Couldn't run command `%s`;\nexit status:%s\nstdout: %s\nstderr: %s", commandString, process.exitValue(), stdout, stderr));
                }
                if (log.isTraceEnabled()) {
                    log.trace("Finished running command: {}\nsuccess:\n{}\nexit status:\n{}\nstdout:\n{}\nstderr:\n{}", new Object[]{commandString, result, process.exitValue(), stdout, stderr});
                } else {
                    log.info("Finished running command `{}` success? {}", (Object)commandString, (Object)result);
                }
                bl = result;
            }
            return bl;
        }
    }
}

