/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Random;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.workload.PayloadGenerator;

public class RandomStringPayloadGenerator
implements PayloadGenerator {
    private final String prefix;
    private final int keySuffixLength;
    private final int cardinality;
    private final long seed;
    private final Random random = new Random();

    @JsonCreator
    public RandomStringPayloadGenerator(@JsonProperty(value="cardinality") int cardinality, @JsonProperty(value="seed") long seed, @JsonProperty(value="prefix") String prefix) {
        this.cardinality = cardinality;
        if (this.cardinality <= 1) {
            throw new RuntimeException("Invalid value " + cardinality + " for cardinality: the desired number of unique values must be greater than 1");
        }
        this.seed = seed == -1L ? Time.SYSTEM.milliseconds() : seed;
        this.prefix = prefix == null ? "" : prefix;
        String largestPossibleKeySuffix = Integer.toString(cardinality - 1);
        this.keySuffixLength = largestPossibleKeySuffix.length();
    }

    @JsonProperty
    public int cardinality() {
        return this.cardinality;
    }

    @JsonProperty
    public long seed() {
        return this.seed;
    }

    @JsonProperty
    public String prefix() {
        return this.prefix;
    }

    @Override
    public synchronized byte[] generate(long position) {
        this.random.setSeed(this.seed + position);
        int randomSuffix = this.random.nextInt(0, this.cardinality);
        String key = String.format(this.prefix + "%0" + this.keySuffixLength + "d", randomSuffix);
        return key.getBytes();
    }
}

