/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.SchemaRegistryWorkloadSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryWorker.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Time TIME = Time.SYSTEM;
    private final String id;
    private final SchemaRegistryWorkloadSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Future<?> statusUpdaterFuture;
    private ExecutorService workerExecutor;
    private ScheduledExecutorService statusUpdaterExecutor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;
    private Platform platform;
    private Set<Integer> skippedIdentifiers;
    private AtomicLong totalCalls;
    private AtomicLong totalFailedCalls;
    private AtomicLong startTimeMs;

    public SchemaRegistryWorker(String id, SchemaRegistryWorkloadSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("SchemaRegistryWorker is already running");
        }
        this.totalCalls = new AtomicLong(0L);
        this.totalFailedCalls = new AtomicLong(0L);
        this.startTimeMs = new AtomicLong(TIME.milliseconds());
        this.skippedIdentifiers = ConcurrentHashMap.newKeySet();
        log.info("{}: Activating SchemaRegistryWorker.", (Object)this.id);
        try {
            this.platform = platform;
            this.status = status;
            this.doneFuture = doneFuture;
            this.validateConfigs();
            this.workerExecutor = Executors.newFixedThreadPool(1, ThreadUtils.createThreadFactory((String)"SchemaRegistryWorker%d", (boolean)false));
            this.workerExecutor.submit(new Worker());
            this.statusUpdaterExecutor = Executors.newScheduledThreadPool(1, ThreadUtils.createThreadFactory((String)"StatusUpdaterWorkerThread%d", (boolean)false));
            this.statusUpdaterFuture = this.statusUpdaterExecutor.scheduleAtFixedRate(new StatusUpdater(), 30L, 30L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            WorkerUtils.abort(log, "SchemaRegistryWorker", e, doneFuture);
        }
    }

    private void validateConfigs() {
        if (this.spec.targetCallsPerSec() <= 0) {
            throw new ConfigException("Can't have targetCallsPerSec <= 0.");
        }
        if (this.spec.schemaRegistryUrl() == null || this.spec.schemaRegistryUrl().length() == 0) {
            throw new ConfigException("schemaRegistryUrl can't be empty.");
        }
        if (this.spec.numSchemas() <= 0) {
            throw new ConfigException("Can't have numSchemas <= 0.");
        }
    }

    private String registerSchema(int subjectIdentifier) throws Throwable {
        String url = String.format("%s/subjects/test-subject-%d/versions", this.spec.schemaRegistryUrl(), subjectIdentifier);
        log.info("Registering new schema to test-subject-{} at {}", (Object)subjectIdentifier, (Object)url);
        Map<String, String> schemaParams = Collections.singletonMap("schema", String.format("{\"type\": \"record\", \"name\": \"test%d\", \"fields\": [{\"type\": \"string\", \"name\": \"f%d\"}]}", subjectIdentifier, subjectIdentifier));
        String[] command = new String[]{"curl", "-X", "POST", "-H", "Content-Type:application/vnd.schemaregistry.v1+json", "--data", OBJECT_MAPPER.writeValueAsString(schemaParams), url};
        return this.platform.runCommand(command);
    }

    private String deleteSchema(int subjectIdentifier) throws Throwable {
        String url = String.format("%s/subjects/test-subject-%d/versions/1", this.spec.schemaRegistryUrl(), subjectIdentifier);
        log.info("Deleting new schema to test-subject-{} at {}", (Object)subjectIdentifier, (Object)url);
        String[] command = new String[]{"curl", "-X", "DELETE", url};
        return this.platform.runCommand(command);
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("SchemaRegistryWorker is not running.");
        }
        log.info("{}: Deactivating SchemaRegistryWorker", (Object)this.id);
        this.doneFuture.complete((Object)"");
        this.statusUpdaterFuture.cancel(false);
        this.statusUpdaterExecutor.shutdown();
        this.statusUpdaterExecutor.awaitTermination(1L, TimeUnit.DAYS);
        this.statusUpdaterExecutor = null;
        this.workerExecutor.shutdownNow();
        this.workerExecutor.awaitTermination(1L, TimeUnit.DAYS);
        new StatusUpdater().run();
        this.workerExecutor = null;
        this.doneFuture = null;
        log.info("{}: Deactivated SchemaRegistryWorker.", (Object)this.id);
    }

    class Worker
    implements Runnable {
        Worker() {
        }

        @Override
        public void run() {
            try {
                int identifier;
                for (identifier = 0; identifier < SchemaRegistryWorker.this.spec.numSchemas(); ++identifier) {
                    String output = SchemaRegistryWorker.this.registerSchema(identifier);
                    boolean success = true;
                    log.info(output);
                    if (SchemaRegistryWorker.this.spec.parseResult()) {
                        try {
                            log.info("ID is {}", (Object)((RegisterSchemaResponse)OBJECT_MAPPER.readValue(output, RegisterSchemaResponse.class)).getId());
                        }
                        catch (Exception e) {
                            SchemaRegistryWorker.this.skippedIdentifiers.add(identifier);
                            success = false;
                        }
                    }
                    SchemaRegistryWorker.this.totalCalls.getAndIncrement();
                    if (success) continue;
                    SchemaRegistryWorker.this.totalFailedCalls.getAndIncrement();
                }
                for (identifier = 0; identifier < SchemaRegistryWorker.this.spec.numSchemas(); ++identifier) {
                    if (SchemaRegistryWorker.this.skippedIdentifiers.contains(identifier)) continue;
                    boolean success = true;
                    String output = SchemaRegistryWorker.this.deleteSchema(identifier);
                    log.info(output);
                    if (SchemaRegistryWorker.this.spec.parseResult()) {
                        try {
                            Integer.parseInt(output);
                        }
                        catch (Exception e) {
                            success = false;
                        }
                    }
                    SchemaRegistryWorker.this.totalCalls.getAndIncrement();
                    if (success) continue;
                    SchemaRegistryWorker.this.totalFailedCalls.getAndIncrement();
                }
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, "RegisterSchemas", e, SchemaRegistryWorker.this.doneFuture);
            }
            SchemaRegistryWorker.this.doneFuture.complete((Object)"");
        }
    }

    private class StatusUpdater
    implements Runnable {
        private StatusUpdater() {
        }

        @Override
        public void run() {
            try {
                long lastTimeMs = Time.SYSTEM.milliseconds();
                JsonNode node = JsonUtil.JSON_SERDE.valueToTree((Object)new StatusData(SchemaRegistryWorker.this.spec.schemaRegistryUrl(), SchemaRegistryWorker.this.totalCalls.get(), SchemaRegistryWorker.this.totalFailedCalls.get(), (double)SchemaRegistryWorker.this.totalCalls.get() * 1000.0 / (double)(lastTimeMs - SchemaRegistryWorker.this.startTimeMs.get())));
                SchemaRegistryWorker.this.status.update(node);
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "StatusUpdater", e, SchemaRegistryWorker.this.doneFuture);
            }
        }
    }

    private static class RegisterSchemaResponse {
        private int id;

        @JsonCreator
        public RegisterSchemaResponse(@JsonProperty(value="id") int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }

    public static class StatusData {
        private final long totalCalls;
        private final long totalFailedCalls;
        private final double callsPerSec;
        private final String schemaRegistryUrl;

        @JsonCreator
        StatusData(@JsonProperty(value="schemaRegistryUrl") String schemaRegistryUrl, @JsonProperty(value="totalCalls") long totalCalls, @JsonProperty(value="totalFailedCalls") long totalFailedCalls, @JsonProperty(value="callsPerSec") double callsPerSec) {
            this.schemaRegistryUrl = schemaRegistryUrl;
            this.totalCalls = totalCalls;
            this.totalFailedCalls = totalFailedCalls;
            this.callsPerSec = callsPerSec;
        }

        @JsonProperty
        public String schemaRegistryUrl() {
            return this.schemaRegistryUrl;
        }

        @JsonProperty
        public long totalCalls() {
            return this.totalCalls;
        }

        @JsonProperty
        public long totalFailedCalls() {
            return this.totalFailedCalls;
        }

        @JsonProperty
        public double callsPecSec() {
            return this.callsPerSec;
        }
    }
}

