/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.ThroughputGenerator;
import org.apache.kafka.trogdor.workload.TopicCreationWorker;
import org.apache.kafka.trogdor.workload.TopicsSpec;

public final class TopicCreationSpec
extends TaskSpec {
    private final String producerNode;
    private final String bootstrapServers;
    private final ThroughputGenerator throughputGenerator;
    private final Map<String, String> adminClientConf;
    private final Map<String, String> commonClientConf;
    private final Collection<TopicsSpec> topicBatchSpecs;

    @JsonCreator
    public TopicCreationSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="producerNode") String producerNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="throughputGenerator") ThroughputGenerator throughputGenerator, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="topicBatchSpecs") Collection<TopicsSpec> topicBatchSpecs) {
        super(startMs, durationMs);
        this.producerNode = producerNode == null ? "" : producerNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.throughputGenerator = throughputGenerator;
        this.commonClientConf = TopicCreationSpec.configOrEmptyMap(commonClientConf);
        this.adminClientConf = TopicCreationSpec.configOrEmptyMap(adminClientConf);
        this.topicBatchSpecs = topicBatchSpecs;
    }

    @JsonProperty
    public String producerNode() {
        return this.producerNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public ThroughputGenerator throughputGenerator() {
        return this.throughputGenerator;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public Collection<TopicsSpec> topicBatchSpecs() {
        return this.topicBatchSpecs;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.producerNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new TopicCreationWorker(id, this);
    }
}

