/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.Histogram;
import org.apache.kafka.trogdor.workload.PartitionsSpec;
import org.apache.kafka.trogdor.workload.TopicCreationSpec;
import org.apache.kafka.trogdor.workload.TopicsSpec;
import org.slf4j.LoggerFactory;

public class TopicCreationWorker
implements TaskWorker {
    private final TopicCreationSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ScheduledExecutorService executor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;

    public TopicCreationWorker(String id, TopicCreationSpec spec) {
        this.spec = spec;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> haltFuture) throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("TopicCreationWorker is already running.");
        }
        this.status = status;
        this.doneFuture = haltFuture;
        this.executor = Executors.newScheduledThreadPool(2, ThreadUtils.createThreadFactory((String)"TopicCreationWorkerThread%d", (boolean)false));
        this.executor.submit(new CreateTopics());
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("TopicCreationWorker is not running.");
        }
        this.doneFuture.complete((Object)"");
        this.executor.shutdownNow();
        this.executor = null;
        this.status = null;
        this.doneFuture = null;
    }

    public class CreateTopics
    implements Callable<Void> {
        private final Histogram histogram;
        private final Future<?> statusUpdaterFuture;
        private final Admin adminClient;
        private final AtomicLong successfulTopics;
        private final AtomicLong totalSent;

        CreateTopics() {
            this.adminClient = WorkerUtils.createAdminClient(TopicCreationWorker.this.spec.bootstrapServers(), TopicCreationWorker.this.spec.commonClientConf(), TopicCreationWorker.this.spec.adminClientConf());
            this.histogram = new Histogram(60000);
            this.successfulTopics = new AtomicLong();
            this.totalSent = new AtomicLong();
            this.statusUpdaterFuture = TopicCreationWorker.this.executor.scheduleWithFixedDelay(new StatusUpdater(this.histogram, this.successfulTopics, this.totalSent), 5L, 5L, TimeUnit.SECONDS);
        }

        @Override
        public Void call() throws RuntimeException {
            KafkaFuture allTopicFutures = KafkaFuture.completedFuture(null);
            try {
                for (TopicsSpec topicSpec : TopicCreationWorker.this.spec.topicBatchSpecs()) {
                    Map<String, PartitionsSpec> topicPartitionMap = topicSpec.materialize();
                    ArrayList<NewTopic> batch = new ArrayList<NewTopic>();
                    topicPartitionMap.forEach((name, partition) -> batch.add(partition.newTopic((String)name)));
                    KafkaFuture<Void> newTopicFuture = this.createTopicsRequest(batch);
                    allTopicFutures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{allTopicFutures, newTopicFuture});
                    TopicCreationWorker.this.spec.throughputGenerator().throttle();
                }
                allTopicFutures.get(TopicCreationWorker.this.spec.durationMs(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.statusUpdaterFuture.cancel(false);
                StatusData statusData = new StatusUpdater(this.histogram, this.successfulTopics, this.totalSent).update();
            }
            TopicCreationWorker.this.doneFuture.complete((Object)"");
            return null;
        }

        public KafkaFuture<Void> createTopicsRequest(Collection<NewTopic> topics) {
            KafkaFuture batchTopicFutures = KafkaFuture.completedFuture(null);
            CreateTopicsCallback callback = new CreateTopicsCallback(this, Instant.now());
            CreateTopicsResult result = this.adminClient.createTopics(topics);
            for (KafkaFuture future : result.values().values()) {
                future.whenComplete(callback::onCompletion);
                batchTopicFutures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{batchTopicFutures, future});
            }
            return batchTopicFutures;
        }

        void topicDuration(long durationMs) {
            this.histogram.add(durationMs);
        }
    }

    public static class StatusData {
        static final float[] PERCENTILES = new float[]{0.5f, 0.95f, 0.99f};

        @JsonCreator
        StatusData(@JsonProperty(value="totalSent") long totalSent, @JsonProperty(value="averageLatencyMs") float averageLatencyMs, @JsonProperty(value="p50LatencyMs") int p50latencyMs, @JsonProperty(value="p95LatencyMs") int p95latencyMs, @JsonProperty(value="p99LatencyMs") int p99latencyMs, @JsonProperty(value="successfulTopics") long successfulTopics) {
        }
    }

    public class StatusUpdater
    implements Runnable {
        private final Histogram histogram;
        private final AtomicLong successfulTopics;
        private final AtomicLong totalSent;

        StatusUpdater(Histogram histogram, AtomicLong successfulTopics, AtomicLong totalSent) {
            this.histogram = histogram;
            this.successfulTopics = successfulTopics;
            this.totalSent = totalSent;
        }

        @Override
        public void run() {
            try {
                this.update();
            }
            catch (Exception e) {
                WorkerUtils.abort(LoggerFactory.getLogger(TopicCreationWorker.class), "StatusUpdater", e, TopicCreationWorker.this.doneFuture);
            }
        }

        StatusData update() {
            Histogram.Summary summary = this.histogram.summarize(StatusData.PERCENTILES);
            StatusData statusData = new StatusData(this.totalSent.get(), summary.average(), summary.percentiles().get(0).value(), summary.percentiles().get(1).value(), summary.percentiles().get(2).value(), this.successfulTopics.get());
            TopicCreationWorker.this.status.update(JsonUtil.JSON_SERDE.valueToTree((Object)statusData));
            return statusData;
        }
    }

    private static class CreateTopicsCallback {
        private final CreateTopics createTopics;
        private final Instant start;

        CreateTopicsCallback(CreateTopics createTopics, Instant start) {
            this.start = start;
            this.createTopics = createTopics;
            this.createTopics.totalSent.getAndIncrement();
        }

        public void onCompletion(Void result, Throwable exception) {
            Duration duration = Duration.between(this.start, Instant.now());
            if (exception != null) {
                throw new RuntimeException(exception);
            }
            this.createTopics.topicDuration(duration.toMillis());
            this.createTopics.successfulTopics.getAndIncrement();
        }
    }
}

