/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.Histogram;
import org.apache.kafka.trogdor.workload.TopicDeletionSpec;
import org.slf4j.LoggerFactory;

public class TopicDeletionWorker
implements TaskWorker {
    private final TopicDeletionSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ScheduledExecutorService executor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;

    public TopicDeletionWorker(String id, TopicDeletionSpec spec) {
        this.spec = spec;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> haltFuture) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("TopicDeletionWorker is already running.");
        }
        this.status = status;
        this.doneFuture = haltFuture;
        this.executor = Executors.newScheduledThreadPool(2, ThreadUtils.createThreadFactory((String)"TopicDeletionWorkerThread%d", (boolean)false));
        this.executor.submit(new DeleteTopics());
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("TopicDeletionWorker is not running.");
        }
        this.doneFuture.complete((Object)"");
        this.executor.shutdownNow();
        this.executor = null;
        this.status = null;
        this.doneFuture = null;
    }

    public class DeleteTopics
    implements Callable<Void> {
        private final Histogram histogram;
        private final Future<?> statusUpdaterFuture;
        private final Admin adminClient;
        private final AtomicLong successfulTopics;
        private final AtomicLong totalSent;

        DeleteTopics() {
            this.adminClient = WorkerUtils.createAdminClient(TopicDeletionWorker.this.spec.bootstrapServers(), TopicDeletionWorker.this.spec.commonClientConf(), TopicDeletionWorker.this.spec.adminClientConf());
            this.histogram = new Histogram(60000);
            this.successfulTopics = new AtomicLong();
            this.totalSent = new AtomicLong();
            this.statusUpdaterFuture = TopicDeletionWorker.this.executor.scheduleWithFixedDelay(new StatusUpdater(this.histogram, this.successfulTopics, this.totalSent), 5L, 5L, TimeUnit.SECONDS);
        }

        @Override
        public Void call() throws Exception {
            ArrayList<String> matched;
            KafkaFuture allTopicFutures = KafkaFuture.completedFuture(null);
            Stack<String> regexStack = new Stack<String>();
            regexStack.addAll(TopicDeletionWorker.this.spec.regexDeleteList());
            boolean topicsRemaining = true;
            try {
                while (topicsRemaining) {
                    matched = this.foundMatchedTopics((String)regexStack.peek());
                    if (matched.isEmpty()) {
                        regexStack.pop();
                    }
                    topicsRemaining = !matched.isEmpty() || !regexStack.empty();
                    allTopicFutures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{allTopicFutures, this.processMatchedTopics(matched)});
                }
                allTopicFutures.get(TopicDeletionWorker.this.spec.durationMs(), TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            finally {
                this.statusUpdaterFuture.cancel(false);
                matched = new StatusUpdater(this.histogram, this.successfulTopics, this.totalSent).update();
            }
            TopicDeletionWorker.this.doneFuture.complete((Object)"");
            return null;
        }

        KafkaFuture<Void> processMatchedTopics(ArrayList<String> matched) throws Throwable {
            KafkaFuture matchedTopicsFutures = KafkaFuture.completedFuture(null);
            List<String> batch = matched.stream().limit(TopicDeletionWorker.this.spec.deletionBatchSize()).toList();
            matched.removeAll(batch);
            KafkaFuture<Void> newTopicFuture = this.deleteTopicRequest(batch);
            matchedTopicsFutures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{matchedTopicsFutures, newTopicFuture});
            TopicDeletionWorker.this.spec.throughputGenerator().throttle();
            return matchedTopicsFutures;
        }

        ArrayList<String> foundMatchedTopics(String regex) throws ExecutionException, InterruptedException {
            ListTopicsResult topicsList = this.adminClient.listTopics();
            Set names = (Set)topicsList.names().get();
            List<String> matches = names.stream().filter(name -> name.matches(regex)).toList();
            return new ArrayList<String>(matches);
        }

        private KafkaFuture<Void> deleteTopicRequest(Collection<String> topicsToDelete) {
            KafkaFuture batchDeleteFutures = KafkaFuture.completedFuture(null);
            DeleteTopicsCallback callback = new DeleteTopicsCallback(this, Instant.now());
            DeleteTopicsResult result = this.adminClient.deleteTopics(topicsToDelete);
            for (KafkaFuture future : result.topicNameValues().values()) {
                future.whenComplete(callback::onCompletion);
                batchDeleteFutures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{batchDeleteFutures, future});
            }
            return batchDeleteFutures;
        }

        void deletionDuration(Long durationMs) {
            this.histogram.add(durationMs);
        }
    }

    public static class StatusData {
        static final float[] PERCENTILES = new float[]{0.5f, 0.95f, 0.99f};

        @JsonCreator
        StatusData(@JsonProperty(value="totalSent") long totalSent, @JsonProperty(value="averageLatencyMs") float averageLatencyMs, @JsonProperty(value="p50LatencyMs") int p50latencyMs, @JsonProperty(value="p95LatencyMs") int p95latencyMs, @JsonProperty(value="p99LatencyMs") int p99latencyMs, @JsonProperty(value="successfulTopics") long successfulTopics) {
        }
    }

    public class StatusUpdater
    implements Runnable {
        private final Histogram histogram;
        private final AtomicLong successfulTopics;
        private final AtomicLong totalSent;

        StatusUpdater(Histogram histogram, AtomicLong successfulTopics, AtomicLong totalSent) {
            this.histogram = histogram;
            this.successfulTopics = successfulTopics;
            this.totalSent = totalSent;
        }

        @Override
        public void run() {
            try {
                this.update();
            }
            catch (Exception e) {
                WorkerUtils.abort(LoggerFactory.getLogger(TopicDeletionWorker.class), "StatusUpdater", e, TopicDeletionWorker.this.doneFuture);
            }
        }

        StatusData update() {
            Histogram.Summary summary = this.histogram.summarize(StatusData.PERCENTILES);
            StatusData statusData = new StatusData(this.totalSent.get(), summary.average(), summary.percentiles().get(0).value(), summary.percentiles().get(1).value(), summary.percentiles().get(2).value(), this.successfulTopics.get());
            TopicDeletionWorker.this.status.update(JsonUtil.JSON_SERDE.valueToTree((Object)statusData));
            return statusData;
        }
    }

    private static class DeleteTopicsCallback {
        private final DeleteTopics deleteTopics;
        private final Instant start;

        DeleteTopicsCallback(DeleteTopics deleteTopics, Instant start) {
            this.start = start;
            this.deleteTopics = deleteTopics;
            this.deleteTopics.totalSent.getAndIncrement();
        }

        public void onCompletion(Void result, Throwable exception) {
            Duration duration = Duration.between(this.start, Instant.now());
            if (exception != null) {
                throw new RuntimeException(exception);
            }
            this.deleteTopics.deletionDuration(duration.toMillis());
            this.deleteTopics.successfulTopics.getAndIncrement();
        }
    }
}

