/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.model.Entity;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AggregationOptions<E extends Entity> {
    private final float minValidEntityRatio;
    private final float minValidEntityGroupRatio;
    private final int minValidWindows;
    private final int maxAllowedExtrapolationsPerEntity;
    private final Set<E> interestedEntities;
    private final Granularity granularity;
    private final boolean includeInvalidEntities;
    private final String reason;
    private final Set<String> interestedEntityGroups;

    public AggregationOptions(double minValidEntityRatio, double minValidEntityGroupRatio, int minValidWindows, int maxAllowedExtrapolationsPerEntity, Set<E> interestedEntities, Granularity granularity, boolean includeInvalidEntities) {
        this(minValidEntityRatio, minValidEntityGroupRatio, minValidWindows, maxAllowedExtrapolationsPerEntity, interestedEntities, granularity, includeInvalidEntities, "");
    }

    public AggregationOptions(double minValidEntityRatio, double minValidEntityGroupRatio, int minValidWindows, int maxAllowedExtrapolationsPerEntity, Set<E> interestedEntities, Granularity granularity, boolean includeInvalidEntities, String reason) {
        if (minValidWindows < 1) {
            throw new IllegalArgumentException("The minimum valid windows must be at least 1");
        }
        this.minValidEntityRatio = (float)minValidEntityRatio;
        this.minValidEntityGroupRatio = (float)minValidEntityGroupRatio;
        this.minValidWindows = minValidWindows;
        this.maxAllowedExtrapolationsPerEntity = maxAllowedExtrapolationsPerEntity;
        this.interestedEntities = interestedEntities == null ? Collections.emptySet() : interestedEntities;
        this.granularity = granularity == null ? Granularity.ENTITY : granularity;
        this.includeInvalidEntities = includeInvalidEntities;
        this.interestedEntityGroups = new HashSet<String>();
        this.interestedEntities.forEach(entity -> this.interestedEntityGroups.add(entity.group()));
        this.reason = reason;
    }

    public double minValidEntityRatio() {
        return this.minValidEntityRatio;
    }

    public double minValidEntityGroupRatio() {
        return this.minValidEntityGroupRatio;
    }

    public int minValidWindows() {
        return this.minValidWindows;
    }

    public int maxAllowedExtrapolationsPerEntity() {
        return this.maxAllowedExtrapolationsPerEntity;
    }

    public Set<E> interestedEntities() {
        return Collections.unmodifiableSet(this.interestedEntities);
    }

    public Granularity granularity() {
        return this.granularity;
    }

    public boolean includeInvalidEntities() {
        return this.includeInvalidEntities;
    }

    public Set<String> interestedEntityGroups() {
        return Collections.unmodifiableSet(this.interestedEntityGroups);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Float.valueOf(this.minValidEntityRatio), Float.valueOf(this.minValidEntityGroupRatio), this.minValidWindows, this.granularity, this.interestedEntities.size()});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationOptions)) {
            return false;
        }
        AggregationOptions other = (AggregationOptions)obj;
        if ((double)this.minValidEntityRatio != other.minValidEntityRatio()) {
            return false;
        }
        if ((double)this.minValidEntityGroupRatio != other.minValidEntityGroupRatio()) {
            return false;
        }
        if (this.minValidWindows != other.minValidWindows()) {
            return false;
        }
        if (this.granularity != other.granularity()) {
            return false;
        }
        if (this.maxAllowedExtrapolationsPerEntity != other.maxAllowedExtrapolationsPerEntity()) {
            return false;
        }
        if (this.interestedEntities.size() != other.interestedEntities().size()) {
            return false;
        }
        return this.interestedEntities.containsAll(other.interestedEntities());
    }

    public String toString() {
        return String.format("(reason=%s, minValidEntityRatio=%.2f, minValidEntityGroupRatio=%.2f, minValidWindows=%d, numEntitiesToInclude=%d, granularity=%s)", new Object[]{this.reason, Float.valueOf(this.minValidEntityRatio), Float.valueOf(this.minValidEntityGroupRatio), this.minValidWindows, this.interestedEntities.size(), this.granularity});
    }

    public static enum Granularity {
        ENTITY,
        ENTITY_GROUP;

    }
}

