/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlContext;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlOperationMetricsTracker;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.PlanComputationOptions;
import com.linkedin.kafka.cruisecontrol.RebalanceResult;
import com.linkedin.kafka.cruisecontrol.analyzer.GoalOptimizer;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.analyzer.TopicPartitionMovementTracker;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.client.BlockingSendClient;
import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.common.SbkAdminUtils;
import com.linkedin.kafka.cruisecontrol.config.ConfigSupplier;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfigDelta;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcConfig;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetector;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.executor.Executor;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorReservationHandle;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.view.ClusterModelCellView;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalCallback;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalFuture;
import com.linkedin.kafka.cruisecontrol.operation.MultiBrokerAdditionOperation;
import com.linkedin.kafka.cruisecontrol.plan.PlanComputable;
import com.linkedin.kafka.cruisecontrol.plan.PlanComputationUtils;
import com.linkedin.kafka.cruisecontrol.server.BrokerShutdownManager;
import com.linkedin.kafka.cruisecontrol.statemachine.BrokerRemovalTask;
import com.linkedin.kafka.cruisecontrol.statemachine.StateMachineProcessor;
import io.confluent.databalancer.BrokerChangeEvent;
import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import io.confluent.databalancer.operation.BalanceOpExecutionCompletionCallback;
import io.confluent.databalancer.operation.BrokerAdditionStateMachine;
import io.confluent.databalancer.operation.BrokerAdditionV2StateManager;
import io.confluent.databalancer.operation.EvenClusterLoadStateMachine;
import io.confluent.databalancer.operation.EvenClusterLoadStateManager;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.kafka.clients.CloudAdmin;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BalanceCannotBeImprovedException;
import org.apache.kafka.common.errors.BalancerOperationFailedException;
import org.apache.kafka.common.errors.InsufficientDataForCellLoadComputationException;
import org.apache.kafka.common.errors.RebalancePlanComputationException;
import org.apache.kafka.common.protocol.BalancerOperationOverriddenException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaCruiseControl {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaCruiseControl.class);
    private static final Integer MD_MAX_REFRESH_ATTEMPTS = 100;
    private static final long DEAD_TASK_CHECK_TIMEOUT_MS = 300000L;
    protected KafkaCruiseControlContext kafkaCruiseControlContext;
    private KafkaCruiseControlContext.KafkaCruiseControlContextBuilder kafkaCruiseControlContextBuilder;
    private AnomalyDetector anomalyDetector;
    @Nonnull
    private StateMachineProcessor stateMachineProcessor;
    private final GeneralSBCMetricsRegistry metricRegistry;
    private final CellOverloadMetrics cellOverloadMetrics;
    private final KafkaCruiseControlOperationMetricsTracker operationMetricsTracker;
    private final BlockingSendClient.Builder blockingSendClientBuilder;
    private final UpdatableSbcConfig updatableSbcConfig;
    private final TopicPartitionMovementTracker movementsTracker;
    @Nonnull
    private GoalOptimizer goalOptimizer;
    @Nonnull
    private LoadMonitor loadMonitor;
    @Nonnull
    private Executor executor;
    @Nonnull
    private ApiStatePersistenceStore persistenceStore;
    MetadataClient metadataClient;

    public KafkaCruiseControl(Integer brokerId, KafkaCruiseControlConfig config, GeneralSBCMetricsRegistry metricRegistry, CellOverloadMetrics cellOverloadMetrics, BlockingSendClient.Builder blockingSendClientBuilder, CcStartupMode startupMode) {
        Time time = Time.SYSTEM;
        this.kafkaCruiseControlContextBuilder = KafkaCruiseControlContext.KafkaCruiseControlContextBuilder.of(brokerId, config, time, startupMode);
        this.metricRegistry = metricRegistry;
        this.cellOverloadMetrics = cellOverloadMetrics;
        this.operationMetricsTracker = new KafkaCruiseControlOperationMetricsTracker(metricRegistry);
        this.blockingSendClientBuilder = blockingSendClientBuilder;
        this.updatableSbcConfig = config.updatableSbcConfig();
        this.movementsTracker = new TopicPartitionMovementTracker(time, config.getLong("topic.partition.movement.expiration.ms"), config.getLong("topic.partition.suspension.ms"), config.getInt("topic.partition.maximum.movements"), config.getInt("topic.partition.movements.history.limit"));
    }

    public KafkaCruiseControl(Integer brokerId, KafkaCruiseControlConfig config, LoadMonitor loadMonitor, GoalOptimizer goalOptimizer, Executor executor, AnomalyDetector anomalyDetector, BrokerShutdownManager shutdownManager, StateMachineProcessor stateMachineProcessor, ConfluentAdmin adminClient, Time time, CcStartupMode startupMode, EvenClusterLoadStateManager activeEvenClusterLoadStateManager, GeneralSBCMetricsRegistry metricsRegistry, CellOverloadMetrics cellOverloadMetrics, ApiStatePersistenceStore persistenceStore, TopicPartitionMovementTracker movementsTracker) {
        this.blockingSendClientBuilder = null;
        this.metricRegistry = metricsRegistry;
        this.cellOverloadMetrics = cellOverloadMetrics;
        this.operationMetricsTracker = new KafkaCruiseControlOperationMetricsTracker(metricsRegistry);
        this.anomalyDetector = anomalyDetector;
        this.stateMachineProcessor = stateMachineProcessor;
        this.goalOptimizer = goalOptimizer;
        this.loadMonitor = loadMonitor;
        this.executor = executor;
        this.persistenceStore = persistenceStore;
        this.updatableSbcConfig = config.updatableSbcConfig();
        this.movementsTracker = movementsTracker;
        this.kafkaCruiseControlContext = KafkaCruiseControlContext.KafkaCruiseControlContextBuilder.of(brokerId, config, time, startupMode).loadMonitor(loadMonitor).executor(executor).brokerShutdownManager(shutdownManager).defaultPlanComputationOptions(new PlanComputationOptions(config.getBoolean("anomaly.detection.allow.capacity.estimation"), config.getBoolean("broker.failure.exclude.recently.removed.brokers"))).computationUtils(new PlanComputationUtils(config, time)).adminClient(adminClient).sbkAdminUtils(new SbkAdminUtils(adminClient, config)).evenClusterLoadStateManagers(activeEvenClusterLoadStateManager).build();
    }

    private void init(BrokerAdditionV2StateManager brokerAdditionV2StateManager) throws ExecutionException, InterruptedException {
        KafkaCruiseControlConfig ccConfig = this.kafkaCruiseControlContextBuilder.config();
        KCCConfigSupplier configSupplier = new KCCConfigSupplier(ccConfig);
        Time ccTime = this.kafkaCruiseControlContextBuilder.time();
        LOG.info("Initializing DataBalancer with goals {}", (Object)this.updatableSbcConfig.updatableSbcGoalsConfig());
        CloudAdmin adminClient = KafkaCruiseControlUtils.createAdmin(ccConfig.originals());
        this.initMetadataClient(configSupplier, adminClient);
        SbkAdminUtils sbkAdminUtils = new SbkAdminUtils((ConfluentAdmin)adminClient, ccConfig);
        this.loadMonitor = new LoadMonitor(configSupplier, this.metadataClient, ccTime, this.metricRegistry, this.updatableSbcConfig.updatableSbcGoalsConfig());
        long removalHistoryRetentionTimeMs = ccConfig.getLong("removal.history.retention.time.ms");
        this.anomalyDetector = new AnomalyDetector(configSupplier, adminClient, this.loadMonitor, this, ccTime, this.metricRegistry, this.cellOverloadMetrics, this.persistenceStore, this.updatableSbcConfig);
        this.executor = new Executor(this.movementsTracker, ccConfig, ccTime, this.metricRegistry, this.metadataClient, removalHistoryRetentionTimeMs, 300000L, null, this.anomalyDetector, (ConfluentAdmin)adminClient, null);
        EvenClusterLoadStateManager clusterLoadStateManager = this.anomalyDetector.init(this.kafkaCruiseControlContextBuilder.brokerId(), this.kafkaCruiseControlContextBuilder.startupMode(), brokerAdditionV2StateManager, this.operationMetricsTracker, this.executor);
        BrokerShutdownManager brokerShutdownManager = new BrokerShutdownManager(sbkAdminUtils, ccConfig, this.blockingSendClientBuilder, ccTime);
        this.stateMachineProcessor = new StateMachineProcessor();
        this.goalOptimizer = new GoalOptimizer(ccConfig, this.metricRegistry, this.updatableSbcConfig);
        this.kafkaCruiseControlContext = this.kafkaCruiseControlContextBuilder.adminClient((ConfluentAdmin)adminClient).sbkAdminUtils(sbkAdminUtils).computationUtils(new PlanComputationUtils(ccConfig, ccTime)).loadMonitor(this.loadMonitor).executor(this.executor).brokerShutdownManager(brokerShutdownManager).defaultPlanComputationOptions(new PlanComputationOptions(ccConfig.getBoolean("anomaly.detection.allow.capacity.estimation"), ccConfig.getBoolean("broker.failure.exclude.recently.removed.brokers"))).evenClusterLoadStateManagers(clusterLoadStateManager).build();
        this.persistenceStore.getCellOverloadOccurrence().kafkaCruiseControlContext(this.kafkaCruiseControlContext);
        configSupplier.initContext(this.kafkaCruiseControlContext);
    }

    void initMetadataClient(ConfigSupplier configSupplier, CloudAdmin adminClient) {
        MetadataClient.Builder metadataClientBuilder = new MetadataClient.Builder(configSupplier, Time.SYSTEM, this.updatableSbcConfig.updatableSbcGoalsConfig());
        this.metadataClient = metadataClientBuilder.build(adminClient);
    }

    public void startUp(ApiStatePersistenceStore persistenceStore, BrokerAdditionV2StateManager brokerAdditionV2StateManager) throws ExecutionException, InterruptedException {
        try {
            LOG.info("Starting Kafka Cruise Control...");
            this.persistenceStore = persistenceStore;
            this.init(brokerAdditionV2StateManager);
            this.executor.startUp();
            this.loadMonitor.startUp();
            this.anomalyDetector.startDetection();
            LOG.info("Kafka Cruise Control started.");
        }
        catch (Exception e) {
            LOG.error("Failed starting up Kafka Cruise Control due to", (Throwable)e);
            throw e;
        }
    }

    public void shutdown() {
        LOG.info("Shutting down Kafka Cruise Control...");
        KafkaCruiseControlUtils.executeSilently(this.stateMachineProcessor, StateMachineProcessor::shutdown);
        KafkaCruiseControlUtils.executeSilently(this.context().evenClusterLoadStateManager(), stateManager -> stateManager.maybeRegisterEvent(EvenClusterLoadStateMachine.EvenClusterLoadEvent.STOPPED, (Exception)new BalancerOperationFailedException("Self healing stopped due to balancer shutting down.")));
        KafkaCruiseControlUtils.executeSilently(this.context().loadMonitor(), LoadMonitor::shutdown);
        KafkaCruiseControlUtils.executeSilently(this.anomalyDetector, AnomalyDetector::shutdown);
        KafkaCruiseControlUtils.executeSilently(this.executor, Executor::shutdown);
        KafkaCruiseControlUtils.executeSilently(this.context().adminClient(), confluentAdmin -> confluentAdmin.close(Duration.ofSeconds(0L)));
        LOG.info("Kafka Cruise Control shutdown completed.");
    }

    public AnomalyDetector getAnomalyDetector() {
        return this.anomalyDetector;
    }

    public OptimizerResult fixBrokerFailures(Set<Integer> removedBrokers, GoalsConfig goalConfig, String uuid, PlanComputationOptions opts) throws Exception {
        OperationProgress operationProgress = new OperationProgress();
        this.sanityCheckDryRun(false);
        OptimizerResult result = this.generateRemoveBrokerPlan(removedBrokers, goalConfig, operationProgress, opts, this.context(), "compute broker failure detector remove broker plan", false);
        BalanceOpExecutionCompletionCallback completionCallback = (success, ex) -> this.operationMetricsTracker.completeOperation(KafkaCruiseControlOperationMetricsTracker.Operation.BROKER_REMOVAL);
        this.operationMetricsTracker.beginOperation(KafkaCruiseControlOperationMetricsTracker.Operation.BROKER_REMOVAL);
        KafkaCruiseControl.executeRemoval(result.goalProposals(), removedBrokers, uuid, completionCallback, this.context());
        return result;
    }

    public BrokerRemovalFuture removeBrokers(Map<Integer, Optional<Long>> brokersToRemoveAndEpochs, boolean shouldShutdown, @Nonnull BalanceOpExecutionCompletionCallback executionCompletionCallback, @Nonnull BrokerRemovalCallback progressCallback, String uuid) {
        BrokerRemovalTask task = new BrokerRemovalTask(uuid, this, this.context(), this.updatableSbcConfig.updatableSbcGoalsConfig().config().effectiveRebalancingGoals(), shouldShutdown, brokersToRemoveAndEpochs, this.operationMetricsTracker, executionCompletionCallback, progressCallback);
        this.stateMachineProcessor.scheduleTaskForExecution(task);
        return task.brokerRemovalFuture();
    }

    private BalanceOpExecutionCompletionCallback composeAdditionExecutionCompletionCallbacks(@Nonnull BalanceOpExecutionCompletionCallback executionCompletionCallback, @Nonnull MultiBrokerAdditionOperation progressCallback) {
        return (success, ex) -> {
            try {
                if (ex == null) {
                    progressCallback.registerEvent(BrokerAdditionStateMachine.BrokerAdditionEvent.REASSIGNMENT_FINISHED);
                    LOG.info("Successfully completed the broker addition operation for brokers {}", progressCallback.brokerIds());
                } else {
                    Exception exc = ex instanceof Exception ? (Exception)ex : new Exception(ex);
                    progressCallback.registerEvent(BrokerAdditionStateMachine.BrokerAdditionEvent.UNEXPECTED_ERROR, exc);
                    LOG.info("The broker addition operation for brokers {} failed due to an unexpected exception while executing the proposals.", progressCallback.brokerIds(), (Object)ex);
                }
                executionCompletionCallback.accept(success, ex);
            }
            catch (Exception e) {
                LOG.error("Unexpected error in BrokerAddition Execution Completion for addition of brokers {}", progressCallback.brokerIds(), (Object)e);
                throw e;
            }
            finally {
                this.operationMetricsTracker.completeOperation(KafkaCruiseControlOperationMetricsTracker.Operation.BROKER_ADDITION);
            }
        };
    }

    public OptimizerResult generateRemoveBrokerPlan(Set<Integer> removedBrokers, GoalsConfig goalConfig, OperationProgress operationProgress, PlanComputationOptions options, KafkaCruiseControlContext context, String planDescription, boolean isPlanGenerationRetriable) throws Exception {
        List brokerIdsList = removedBrokers.stream().map(Object::toString).collect(Collectors.toList());
        PlanComputable generateProposalLambda = () -> {
            try (LoadMonitor.ClusterModelGenerator clusterModelGenerator = this.loadMonitor.acquireForModelGeneration(operationProgress);){
                LOG.trace("Refreshing metadata");
                this.loadMonitor.forceRefreshClusterAndGeneration();
                LOG.trace("Computing a remove brokers plan");
                ClusterModel clusterModel = clusterModelGenerator.createLatestClusterModel(goalConfig.requirements(), operationProgress, removedBrokers.stream().collect(Collectors.toMap(id -> id, id -> Broker.Strategy.DEAD)));
                OptimizerResult optimizerResult = this.getProposals(clusterModel, goalConfig, options.toAllowCapacityEstimation(), options.toExcludeRecentlyRemovedBrokers());
                return optimizerResult;
            }
        };
        String planDescriptionWithBrokerInfo = planDescription + String.format(" for brokers %s", String.join((CharSequence)",", brokerIdsList));
        if (isPlanGenerationRetriable) {
            try {
                return this.context().computationUtils().generatePlanWithRetries(generateProposalLambda, planDescriptionWithBrokerInfo);
            }
            catch (org.apache.kafka.common.errors.TimeoutException te) {
                throw new RebalancePlanComputationException(te.getMessage() + " This could be due to not having sufficient metricsto compute the plan or because partition reassignment being in progress while trying to compute the plan.");
            }
        }
        return this.context().computationUtils().generatePlan(generateProposalLambda, goalConfig, context, planDescriptionWithBrokerInfo);
    }

    public static void sanityCheckCapacityEstimation(boolean allowCapacityEstimation, Map<Integer, String> capacityEstimationInfoByBrokerId) {
        if (!allowCapacityEstimation && !capacityEstimationInfoByBrokerId.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Allow capacity estimation or fix dependencies to capture broker capacities.%n", new Object[0]));
            for (Map.Entry<Integer, String> entry : capacityEstimationInfoByBrokerId.entrySet()) {
                sb.append(String.format("Broker: %d: info: %s%n", entry.getKey(), entry.getValue()));
            }
            throw new IllegalStateException(sb.toString());
        }
    }

    private void sanityCheckDryRun(boolean dryRun) {
        if (dryRun) {
            return;
        }
        if (this.executor.hasOngoingExecution()) {
            throw new IllegalStateException("Cannot execute new proposals while there is an ongoing execution.");
        }
        if (this.executor.hasOngoingPartitionReassignments()) {
            throw new IllegalStateException("Cannot execute new proposals while there are ongoing partition reassignments.");
        }
        if (this.executorIsReserved()) {
            throw new IllegalStateException("Cannot execute new proposals while the Executor is reserved.");
        }
    }

    public RebalanceResult triggerEvenClusterLoadTask(List<String> goalList, String uuid) throws KafkaCruiseControlException {
        return this.triggerEvenClusterLoadTask(goalList, uuid, false);
    }

    public RebalanceResult computeEvenClusterLoadPlan(List<String> goalList, String uuid) throws KafkaCruiseControlException {
        return this.triggerEvenClusterLoadTask(goalList, uuid, true);
    }

    private RebalanceResult triggerEvenClusterLoadTask(List<String> goalList, String uuid, boolean dryRun) throws KafkaCruiseControlException {
        KafkaCruiseControlConfig ccConfig = this.kafkaCruiseControlContext.config();
        boolean allowCapacityEstimation = ccConfig.getBoolean("anomaly.detection.allow.capacity.estimation");
        boolean excludeRecentlyRemovedBrokers = ccConfig.getBoolean("goal.violation.exclude.recently.removed.brokers");
        GoalsConfig goalConfig = this.updatableSbcConfig.updatableSbcGoalsConfig().config().effectiveRebalancingGoals();
        if (!goalList.isEmpty()) {
            List<Goal> goals = ccConfig.getConfiguredInstances(goalList, Goal.class, Collections.emptyMap());
            goalConfig = new GoalsConfig(goals);
        }
        return this.rebalanceForEvenClusterLoad(goalConfig, dryRun, null, new OperationProgress(), allowCapacityEstimation, uuid, excludeRecentlyRemovedBrokers, Collections.emptyList());
    }

    public RebalanceResult rebalanceForEvenClusterLoad(GoalsConfig goalConfig, boolean dryRun, ModelCompletenessRequirements requirements, OperationProgress operationProgress, boolean allowCapacityEstimation, String uuid, boolean excludeRecentlyRemovedBrokers, Collection<String> goalsToImprove) throws KafkaCruiseControlException {
        this.sanityCheckDryRun(dryRun);
        OptimizerResult plan = this.getProposals(goalConfig, requirements, operationProgress, allowCapacityEstimation, excludeRecentlyRemovedBrokers);
        OptimizationResult optimizationResult = new OptimizationResult(plan);
        String logPrefix = String.format("[%s]:", uuid);
        if (dryRun) {
            LOG.info("{} Computed an even cluster load plan {}", (Object)logPrefix, (Object)optimizationResult.proposalSummary("even cluster load task"));
            return new RebalanceResult(plan, false);
        }
        EvenClusterLoadStateManager evenClusterLoadStateManager = this.context().evenClusterLoadStateManager();
        evenClusterLoadStateManager.startRebalancing();
        if (plan.isStale()) {
            LOG.info("{} Computed but not executing the plan for the even cluster load task as the cluster model is stale.", (Object)logPrefix);
            return new RebalanceResult(plan, false);
        }
        if (!KafkaCruiseControl.goalViolationsHaveImproved(plan, goalsToImprove)) {
            LOG.info("{} Computed plan for the even cluster load task that cannot improve imbalance {}", (Object)logPrefix, (Object)optimizationResult.proposalSummary("even cluster load task"));
            evenClusterLoadStateManager.registerEvent(EvenClusterLoadStateMachine.EvenClusterLoadEvent.BALANCING_FAILED, (Exception)new BalanceCannotBeImprovedException("SBC detected imbalance but is not able to find reassignments to improve the balance."));
            return new RebalanceResult(plan, false);
        }
        BalanceOpExecutionCompletionCallback onRebalanceCompleteCallback = (operationSuccess, error) -> {
            this.operationMetricsTracker.completeOperation(KafkaCruiseControlOperationMetricsTracker.Operation.SELF_HEALING);
            if (operationSuccess) {
                evenClusterLoadStateManager.registerEvent(EvenClusterLoadStateMachine.EvenClusterLoadEvent.BALANCING_SUCCESS);
            } else {
                this.handleRebalanceFailure(error);
            }
        };
        LOG.info("{} Computed and about to execute the plan for the even cluster load task {}", (Object)logPrefix, (Object)optimizationResult.proposalSummary("even cluster load task"));
        try {
            Map<Integer, Long> brokersWithOfflineReplicas = this.persistenceStore.getFailedBrokerIds(this.loadMonitor.maybeRefreshClusterAndGeneration().cluster());
            if (!brokersWithOfflineReplicas.isEmpty()) {
                KafkaCruiseControlUtils.preventExecutionWithDeadBroker(uuid, brokersWithOfflineReplicas.keySet(), this.anomalyDetector.isSelfHealingEnabled(AnomalyType.BROKER_FAILURE));
            }
            this.operationMetricsTracker.beginOperation(KafkaCruiseControlOperationMetricsTracker.Operation.SELF_HEALING);
            boolean wasExecuted = this.executeProposals(plan.goalProposals(), Collections.emptySet(), uuid, onRebalanceCompleteCallback);
            return new RebalanceResult(plan, wasExecuted);
        }
        catch (Exception e) {
            this.handleRebalanceFailure(e);
            throw e;
        }
    }

    private void handleRebalanceFailure(Throwable error) {
        Object rebalanceException = error instanceof ApiException ? (ApiException)error : new BalancerOperationFailedException("Unknown failure when performing even cluster load balancing.", error);
        this.context().evenClusterLoadStateManager().registerEvent(EvenClusterLoadStateMachine.EvenClusterLoadEvent.BALANCING_FAILED, (Exception)rebalanceException);
    }

    public OptimizerResult addBrokers(MultiBrokerAdditionOperation additionCallback, @Nonnull BalanceOpExecutionCompletionCallback completionCallback, String uid) throws Exception {
        Objects.requireNonNull(completionCallback);
        long mdWaitMs = this.context().config().getLong("metadata.ttl") / 2L;
        long mdMaxWaitMs = this.context().config().getLong("metadata.ttl") * 2L;
        this.context().evenClusterLoadStateManager().maybeRegisterEvent(EvenClusterLoadStateMachine.EvenClusterLoadEvent.ADD_BROKER_TRIGGERED, (Exception)new BalancerOperationOverriddenException("Even cluster load balancing operation was aborted by a higher priority 'Add Broker' operation."));
        ExecutorReservationHandle ignored = this.executor.reserveAndAbortOngoingExecutions(Duration.ofSeconds(300L), false, String.format("An add broker operation %s overrides the existing execution", uid));
        try {
            KafkaCruiseControlUtils.backoff(() -> this.brokersAreKnown(additionCallback.brokerIds()), MD_MAX_REFRESH_ATTEMPTS, mdWaitMs, mdMaxWaitMs, this.context().time());
            this.executor.dropRecentlyRemovedBrokers(additionCallback.brokerIds());
            OptimizerResult rebalancePlan = this.generateAddBrokerPlan(additionCallback.brokerIds(), this.updatableSbcConfig.updatableSbcGoalsConfig().config().rebalancingGoals());
            OptimizationResult optimizationResult = new OptimizationResult(rebalancePlan);
            LOG.info("Computed plan for broker addition operation {} {}", (Object)uid, (Object)optimizationResult.proposalSummary("broker addition"));
            additionCallback.registerEvent(BrokerAdditionStateMachine.BrokerAdditionEvent.PLAN_COMPUTED);
            this.operationMetricsTracker.beginOperation(KafkaCruiseControlOperationMetricsTracker.Operation.BROKER_ADDITION);
            this.executeProposals(rebalancePlan.goalProposals(), Collections.emptySet(), uid, this.composeAdditionExecutionCompletionCallbacks(completionCallback, additionCallback));
            OptimizerResult optimizerResult = rebalancePlan;
            if (ignored != null) {
                ignored.close();
            }
            return optimizerResult;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                throw this.handleAdditionFailure(e, additionCallback);
            }
        }
    }

    public void cancelOngoingReassignments(String reason, boolean shouldInvalidateMetrics) throws TimeoutException {
        ExecutorReservationHandle reservation = this.executor.reserveAndAbortOngoingExecutions(Duration.ofSeconds(300L), shouldInvalidateMetrics, reason);
        reservation.close();
    }

    private Exception handleAdditionFailure(Exception e, MultiBrokerAdditionOperation additionCallback) {
        Object apiException = e instanceof ApiException ? (ApiException)e : new BalancerOperationFailedException(String.format("The broker addition Confluent Balancer operation for brokers %s failed for some reason. See the broker logs for more details.", additionCallback.brokerIds().stream().map(Object::toString).collect(Collectors.joining(","))), (Throwable)e);
        LOG.error("AddBroker operation for brokers {} failed with exception", additionCallback.brokerIds(), apiException);
        additionCallback.registerEvent(BrokerAdditionStateMachine.BrokerAdditionEvent.UNEXPECTED_ERROR, (Exception)apiException);
        return e;
    }

    public void notifyBrokerChange(Set<Integer> changedBrokers, BrokerChangeEvent changeEvent) {
        switch (changeEvent) {
            case ONLINE_NORMAL_BROKER: {
                this.anomalyDetector.notifyNewlyOnlineBrokers(changedBrokers);
                break;
            }
            case ONLINE_ADDING_BROKER: {
                this.anomalyDetector.notifyNewAddingBrokers(changedBrokers);
                break;
            }
            case DEAD_BROKER: {
                this.anomalyDetector.notifyDeadBrokers(changedBrokers);
                break;
            }
            case EXCLUDED_FOR_REPLICA_PLACEMENT: {
                LOG.info("Notified of new replica exclusions were placed on brokers {}. Stopping any on-going reassignments in the Executor", changedBrokers);
                this.executor.triggerStopExecution(String.format("New replica exclusions were placed on brokers %s", changedBrokers));
                break;
            }
            case REMOVED_REPLICA_EXCLUSION: {
                LOG.info("Notified of removed replica exclusions for brokers {}", changedBrokers);
                break;
            }
            case DEMOTED: {
                LOG.info("Notified of new leader demotions placed on brokers {}. Stopping any on-going reassignments in the Executor", changedBrokers);
                this.executor.triggerStopExecution(String.format("New leader demotions were placed on brokers %s", changedBrokers));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Cannot process broker change event %s", new Object[]{changeEvent}));
            }
        }
    }

    private OptimizerResult generateAddBrokerPlan(Set<Integer> brokerIds, GoalsConfig goalConfig) throws Exception {
        OperationProgress operationProgress = new OperationProgress();
        PlanComputationOptions planComputationOptions = this.context().defaultPlanComputationOptions();
        List brokerIdsList = brokerIds.stream().map(Object::toString).collect(Collectors.toList());
        try {
            return this.context().computationUtils().generatePlanWithRetries(() -> {
                try (LoadMonitor.ClusterModelGenerator clusterModelGenerator = this.loadMonitor.acquireForModelGeneration(operationProgress);){
                    ClusterModel clusterModel = clusterModelGenerator.createLatestClusterModel(goalConfig.requirements(), operationProgress, brokerIds.stream().collect(Collectors.toMap(id -> id, id -> Broker.Strategy.NEW)));
                    OptimizerResult optimizerResult = this.getProposals(clusterModel, goalConfig, planComputationOptions.toAllowCapacityEstimation(), planComputationOptions.toExcludeRecentlyRemovedBrokers());
                    return optimizerResult;
                }
            }, String.format("compute add broker plan for brokers %s", String.join((CharSequence)",", brokerIdsList)));
        }
        catch (org.apache.kafka.common.errors.TimeoutException te) {
            throw new RebalancePlanComputationException(te.getMessage() + " This could be due to not having sufficient metrics to compute the plan or there being reassigning partitions while trying to compute the plan.");
        }
    }

    public OptimizerResult getProposals(GoalsConfig goalConfig, ModelCompletenessRequirements requirements, OperationProgress operationProgress, boolean allowCapacityEstimation, boolean excludeRecentlyRemovedBrokers) throws KafkaCruiseControlException {
        ModelCompletenessRequirements completenessRequirements = goalConfig.requirements().weaker(requirements);
        LoadMonitor.ClusterModelGenerator clusterModelGenerator = this.loadMonitor.acquireForModelGeneration(operationProgress);
        try {
            ClusterModel clusterModel = clusterModelGenerator.createLatestClusterModel(completenessRequirements, operationProgress);
            OptimizerResult optimizerResult = this.getProposals(clusterModel, goalConfig, allowCapacityEstimation, excludeRecentlyRemovedBrokers);
            ClusterModel newClusterModel = clusterModelGenerator.createLatestClusterModel(completenessRequirements, operationProgress);
            Set aliveBrokersBefore = clusterModel.aliveBrokers().stream().map(Broker::id).collect(Collectors.toSet());
            Set aliveBrokersAfter = newClusterModel.aliveBrokers().stream().map(Broker::id).collect(Collectors.toSet());
            if (!aliveBrokersAfter.equals(aliveBrokersBefore)) {
                optimizerResult.markAsStale();
                LOG.info("Alive brokers before optimization: {}", aliveBrokersBefore);
                LOG.info("Alive brokers after optimization: {}", aliveBrokersAfter);
                LOG.info("Marked OptimizerResult as stale.");
            }
            OptimizerResult optimizerResult2 = optimizerResult;
            if (clusterModelGenerator != null) {
                clusterModelGenerator.close();
            }
            return optimizerResult2;
        }
        catch (Throwable throwable) {
            try {
                if (clusterModelGenerator != null) {
                    try {
                        clusterModelGenerator.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (KafkaCruiseControlException | ApiException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KafkaCruiseControlException(e);
            }
        }
    }

    public static Set<Integer> recentlyRemovedBrokers(KafkaCruiseControlContext context) {
        return context.executor().recentlyRemovedBrokers();
    }

    private OptimizerResult getProposals(ClusterModel clusterModel, GoalsConfig goalsConfig, boolean allowCapacityEstimation, boolean excludeRecentlyRemovedBrokers) throws KafkaCruiseControlException {
        KafkaCruiseControl.sanityCheckCapacityEstimation(allowCapacityEstimation, clusterModel.capacityEstimationInfoByBrokerId());
        Pattern excludedTopicsPattern = this.context().excludedTopicsPattern();
        Set<String> excludedTopics = clusterModel.topics().stream().filter(topic -> excludedTopicsPattern.matcher((CharSequence)topic).matches()).collect(Collectors.toSet());
        OptimizationOptions.Builder builder = new OptimizationOptions.Builder().triggeredByGoalViolation(false).excludedTopics(excludedTopics).oscillatingTopicPartitionMovements(this.movementsTracker.oscillatingTopicPartitionMovements());
        if (excludeRecentlyRemovedBrokers) {
            builder = builder.excludedBrokersForReplicaMove(KafkaCruiseControl.recentlyRemovedBrokers(this.kafkaCruiseControlContext));
        }
        LOG.debug("Topics excluded from partition movement: {}", excludedTopics);
        return this.goalOptimizer.optimizations(clusterModel, goalsConfig, builder.build());
    }

    public KafkaCruiseControlContext context() {
        return this.kafkaCruiseControlContext;
    }

    private static boolean hasProposalsToExecute(Collection<PartitionProposal> proposals, String uuid) {
        if (proposals.isEmpty()) {
            LOG.info("Goals used in proposal generation for UUID {} are already satisfied.", (Object)uuid);
            return false;
        }
        return true;
    }

    private static boolean goalViolationsHaveImproved(OptimizerResult optimizerResult, Collection<String> goalsToImprove) {
        Set originalViolatedGoalsOfConcern = optimizerResult.violatedGoalsBeforeOptimization().stream().filter(goalsToImprove::contains).collect(Collectors.toSet());
        Set postOptimizationViolatedGoals = optimizerResult.violatedGoalsAfterOptimization().stream().filter(goalsToImprove::contains).collect(Collectors.toSet());
        if (originalViolatedGoalsOfConcern.isEmpty()) {
            return postOptimizationViolatedGoals.isEmpty();
        }
        return !postOptimizationViolatedGoals.containsAll(originalViolatedGoalsOfConcern);
    }

    private boolean executeProposals(Set<PartitionProposal> proposals, Set<Integer> unthrottledBrokers, String uuid, @Nonnull BalanceOpExecutionCompletionCallback completionCallback) {
        Objects.requireNonNull(completionCallback, "Null completion callback passed unexpectedly to KafkaCruiseControl#executeProposals");
        if (KafkaCruiseControl.hasProposalsToExecute(proposals, uuid)) {
            this.executor.executeProposals(proposals, unthrottledBrokers, null, this.loadMonitor, uuid, completionCallback);
            return true;
        }
        LOG.warn("Not executing any proposals for operation {} since none were generated.", (Object)uuid);
        completionCallback.accept(true, null);
        return false;
    }

    public static Future<?> executeRemoval(Set<PartitionProposal> proposals, Set<Integer> removedBrokers, String uuid, @Nonnull BalanceOpExecutionCompletionCallback completionCallback, KafkaCruiseControlContext context) {
        Objects.requireNonNull(completionCallback, "Null completion callback unexpectedly passed to KafkaCruiseControl#executeRemoval");
        if (KafkaCruiseControl.hasProposalsToExecute(proposals, uuid)) {
            return context.executor().executeProposals(proposals, removedBrokers, removedBrokers, context.loadMonitor(), uuid, completionCallback);
        }
        LOG.info("Not executing any proposals for removal operation {} since none were generated.", (Object)uuid);
        completionCallback.accept(true, null);
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerStopExecution(String reason) {
        Class<KafkaCruiseControl> clazz = KafkaCruiseControl.class;
        synchronized (KafkaCruiseControl.class) {
            this.executor.triggerStopExecution(reason);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ExecutorState.State executionState() {
        return this.executor.state().state();
    }

    public boolean executorIsReserved() {
        return this.executor.isReservedByOther();
    }

    public CompletenessRequirementCheck meetCompletenessRequirements(List<Goal> goals, Set<Integer> failedBrokerIds) {
        HashMap<String, List<String>> goalsByFailedReasons = new HashMap<String, List<String>>();
        MetadataClient.ClusterAndGeneration clusterAndGeneration = this.loadMonitor.maybeRefreshClusterAndGeneration();
        boolean meetRequirements = true;
        for (Goal g : goals) {
            LoadMonitor.CompletenessCheck goalCheck = this.loadMonitor.meetCompletenessRequirements(clusterAndGeneration, g.clusterModelCompletenessRequirements(), failedBrokerIds);
            if (goalCheck.meetsRequirements) continue;
            meetRequirements = false;
            goalsByFailedReasons.computeIfAbsent(goalCheck.reason, __ -> new ArrayList()).add(g.name());
        }
        return new CompletenessRequirementCheck(meetRequirements, goalsByFailedReasons);
    }

    boolean brokersAreKnown(Set<Integer> brokerIds) {
        Cluster cluster = this.loadMonitor.maybeRefreshClusterAndGeneration().cluster();
        Set invalidBrokerIds = brokerIds.stream().filter(id -> cluster.nodeById(id.intValue()) == null).collect(Collectors.toSet());
        boolean allValid = invalidBrokerIds.isEmpty();
        if (!allValid) {
            LOG.info("Search for brokers {} has invalid brokers {}", brokerIds, invalidBrokerIds);
        }
        return allValid;
    }

    public void updateThrottle(long newThrottle) {
        if (!this.executor.updateThrottle(newThrottle)) {
            LOG.warn("Throttle was not updated. This could be either because the set throttle isthe same as the initially configured one or because the throttle in ZooKeeperis equal to the requested throttle");
        }
    }

    public void setGoalViolationSelfHealing(boolean selfHealingEnabled) {
        this.context().selfHealingEnabled(selfHealingEnabled);
        if (this.anomalyDetector.setSelfHealingFor(AnomalyType.GOAL_VIOLATION, selfHealingEnabled) != selfHealingEnabled) {
            LOG.info("Goal Violation self-healing changed to {}", (Object)(selfHealingEnabled ? "enabled" : "disabled"));
            if (selfHealingEnabled) {
                this.context().evenClusterLoadStateManager().maybeUpdateStateOnSelfHealingEnabled();
            }
        } else {
            LOG.info("Goal violation self-healing left {} (no change)", (Object)(selfHealingEnabled ? "enabled" : "disabled"));
        }
    }

    public void updateConfig(String configKey, Object configValue) {
        KafkaCruiseControlConfig newConfig = this.context().config().clone(configKey, configValue);
        this.context().config(newConfig);
        if (this.updatableSbcConfig.updatableBalancingConstraint().isUpdatableConfig(configKey)) {
            this.updatableSbcConfig.updatableBalancingConstraint().update(newConfig);
        }
        LOG.info("Config {} updated to {}", (Object)configKey, configValue);
    }

    public void updateConfig(SbcGoalsConfigDelta sbcGoalsConfigDelta) {
        KafkaCruiseControlConfig oldConfig = this.context().config();
        KafkaCruiseControlConfig newConfig = sbcGoalsConfigDelta.apply(oldConfig);
        List rebalancingGoals = newConfig.getList("goals");
        List triggeringGoals = newConfig.getList("anomaly.detection.goals");
        Boolean incrementalBalancingEnabled = newConfig.getBoolean("incremental.balancing.enabled");
        List incrementalBalancingGoals = newConfig.getList("incremental.balancing.goals");
        SbcGoalsConfig goalsConfig = SbcGoalsConfig.builder().rebalancingGoals(rebalancingGoals).triggeringGoals(triggeringGoals).incrementalBalancingEnabled(incrementalBalancingEnabled).incrementalBalancingGoals(incrementalBalancingGoals).build(newConfig);
        this.context().config(newConfig);
        this.updatableSbcConfig.updatableSbcGoalsConfig().update(goalsConfig);
        LOG.info("Goal configs successfully updated to {}", (Object)goalsConfig);
    }

    public List<CellLoad> cellLoad(List<Integer> cellIds) throws Exception {
        Long maxReplicasPerBroker = this.context().config().getLong("max.replicas");
        Double minValidPartitionRatio = this.context().config().getDouble("min.valid.partition.ratio");
        OperationProgress opProgress = new OperationProgress();
        LoadMonitor.ClusterModelGenerator clusterModelGenerator = this.loadMonitor.acquireForModelGeneration(opProgress);
        try {
            ModelCompletenessRequirements completenessRequirements = new ModelCompletenessRequirements(1, minValidPartitionRatio, true);
            ClusterModel clusterModel = clusterModelGenerator.createLatestClusterModel(completenessRequirements, opProgress);
            ClusterModelCellView cellView = new ClusterModelCellView(clusterModel);
            List<CellLoad> list = cellView.cellLoadStats(maxReplicasPerBroker, cellIds);
            if (clusterModelGenerator != null) {
                clusterModelGenerator.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (clusterModelGenerator != null) {
                    try {
                        clusterModelGenerator.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NotEnoughValidWindowsException e) {
                throw new InsufficientDataForCellLoadComputationException("Unable to compute cell load because there are not enough valid windows.", (Throwable)e);
            }
        }
    }

    public UpdatableSbcGoalsConfig updatableSbcGoalsConfig() {
        return this.updatableSbcConfig.updatableSbcGoalsConfig();
    }

    public static enum CcStartupMode {
        ON_FAILOVER,
        ON_ENABLE;

    }

    private static class KCCConfigSupplier
    implements ConfigSupplier {
        private final KafkaCruiseControlConfig originalConfig;
        private KafkaCruiseControlContext kccContext;

        public KCCConfigSupplier(KafkaCruiseControlConfig originalConfig) {
            this.originalConfig = originalConfig;
        }

        public void initContext(KafkaCruiseControlContext kccContext) {
            this.kccContext = kccContext;
        }

        @Override
        public KafkaCruiseControlConfig getConfig() {
            return this.kccContext == null ? this.originalConfig : this.kccContext.config();
        }
    }

    @Immutable
    public static class CompletenessRequirementCheck {
        private final boolean meetsRequirements;
        private final String failureReason;

        public CompletenessRequirementCheck(boolean meetsRequirements, Map<String, List<String>> failedGoalsByRequirements) {
            this.meetsRequirements = meetsRequirements;
            StringBuilder failureReason = new StringBuilder();
            for (Map.Entry<String, List<String>> reasonGoalEntry : failedGoalsByRequirements.entrySet()) {
                failureReason.append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)reasonGoalEntry.getValue())).append(" failed to meet the following completeness requirements : <").append(reasonGoalEntry.getKey()).append(">. ");
            }
            this.failureReason = failureReason.toString();
        }

        public boolean meetsRequirements() {
            return this.meetsRequirements;
        }

        public String failureReason() {
            return this.failureReason;
        }
    }
}

