/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BalancingConstraint {
    private static final Resource[] RESOURCES = Resource.values();
    private final Map<Resource, Double> resourceBalancePercentage;
    private final Double replicaBalancePercentage;
    private final Double leaderReplicaBalancePercentage;
    private final Double topicBalancingBalanceThresholdMultiplier;
    private final Double topicBalancingTriggeringThresholdMultiplier;
    private final Integer topicBalancingMaxReassignmentsPerIteration;
    private final Double topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger;
    private final Double topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold;
    private final Double topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold;
    private final Boolean topicBalancingITRDGRunWithHardGoalsEnabled;
    private final Double goalViolationDistributionThresholdMultiplier;
    private final Map<Resource, Double> capacityThreshold;
    private final Map<Resource, Double> capacityThresholdUpperLimit;
    private final double capacityBalanceDeltaThreshold;
    private final Map<Resource, Double> lowUtilizationRatio;
    private final double defaultCpuLowUtilizationThreshold;
    private final double cpuLowUtilizationThresholdForBrokerAddition;
    private final boolean shouldCpuGoalWorkAsCapacityGoal;
    private final Long maxReplicasPerBroker;
    private final Integer minFreeDiskSpaceGbPerBroker;
    private Double minFreeDiskSpaceMiBPerBroker;
    private final Double minFreeDiskSpaceLowerLimitMiBPerBroker;
    private final Double hotPartitionResourceThresholdPercentage;
    private final boolean shouldBalanceFFFTraffic;

    public BalancingConstraint(KafkaCruiseControlConfig config) {
        this.resourceBalancePercentage = new HashMap<Resource, Double>(RESOURCES.length);
        this.capacityThreshold = new HashMap<Resource, Double>(RESOURCES.length);
        this.capacityThresholdUpperLimit = new HashMap<Resource, Double>(RESOURCES.length);
        this.lowUtilizationRatio = new HashMap<Resource, Double>(RESOURCES.length);
        this.capacityBalanceDeltaThreshold = config.getDouble("max.capacity.balancing.delta.percentage");
        this.resourceBalancePercentage.put(Resource.DISK, config.getDouble("disk.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.CPU, config.getDouble("cpu.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.NW_IN, config.getDouble("network.inbound.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.PRODUCE_IN, config.getDouble("network.inbound.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.MIRROR_IN, config.getDouble("network.inbound.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.REPLICATION_IN, config.getDouble("network.inbound.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.CONSUME_OUT, config.getDouble("network.outbound.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.RACK_BASED_CONSUME_OUT, config.getDouble("network.outbound.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.RACK_LESS_CONSUME_OUT, config.getDouble("network.outbound.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.NW_OUT, config.getDouble("network.outbound.balance.threshold"));
        this.capacityThreshold.put(Resource.DISK, config.getDouble("disk.max.load"));
        this.capacityThreshold.put(Resource.CPU, config.getDouble("cpu.capacity.threshold"));
        this.capacityThreshold.put(Resource.NW_IN, config.getDouble("network.inbound.capacity.threshold"));
        this.capacityThreshold.put(Resource.PRODUCE_IN, config.getDouble("producer.inbound.capacity.threshold"));
        this.capacityThreshold.put(Resource.MIRROR_IN, config.getDouble("producer.inbound.capacity.threshold"));
        this.capacityThreshold.put(Resource.CONSUME_OUT, config.getDouble("consumer.outbound.capacity.threshold"));
        this.capacityThreshold.put(Resource.RACK_BASED_CONSUME_OUT, config.getDouble("consumer.outbound.capacity.threshold"));
        this.capacityThreshold.put(Resource.RACK_LESS_CONSUME_OUT, config.getDouble("consumer.outbound.capacity.threshold"));
        this.capacityThreshold.put(Resource.NW_OUT, config.getDouble("network.outbound.capacity.threshold"));
        this.capacityThreshold.put(Resource.REPLICATION_IN, config.getDouble("replication.inbound.capacity.threshold"));
        double capacityThresholdUpperLimit = config.getDouble("capacity.threshold.upper.limit");
        for (Resource resource : RESOURCES) {
            double upperLimit = Math.max(capacityThresholdUpperLimit, this.capacityThreshold.get((Object)resource));
            this.capacityThresholdUpperLimit.put(resource, upperLimit);
        }
        this.lowUtilizationRatio.put(Resource.DISK, config.getDouble("disk.low.utilization.threshold"));
        this.lowUtilizationRatio.put(Resource.CPU, config.getDouble("cpu.low.utilization.threshold"));
        this.lowUtilizationRatio.put(Resource.NW_IN, config.getDouble("network.inbound.low.utilization.threshold"));
        this.lowUtilizationRatio.put(Resource.PRODUCE_IN, config.getDouble("network.inbound.low.utilization.threshold"));
        this.lowUtilizationRatio.put(Resource.MIRROR_IN, config.getDouble("network.inbound.low.utilization.threshold"));
        this.lowUtilizationRatio.put(Resource.CONSUME_OUT, config.getDouble("network.outbound.low.utilization.threshold"));
        this.lowUtilizationRatio.put(Resource.RACK_BASED_CONSUME_OUT, config.getDouble("network.outbound.low.utilization.threshold"));
        this.lowUtilizationRatio.put(Resource.RACK_LESS_CONSUME_OUT, config.getDouble("network.outbound.low.utilization.threshold"));
        this.lowUtilizationRatio.put(Resource.NW_OUT, config.getDouble("network.outbound.low.utilization.threshold"));
        this.defaultCpuLowUtilizationThreshold = config.getDouble("cpu.low.utilization.threshold");
        this.cpuLowUtilizationThresholdForBrokerAddition = config.getDouble("cpu.low.utilization.threshold.for.broker.addition");
        this.shouldCpuGoalWorkAsCapacityGoal = config.getBoolean("cpu.goal.act.as.capacity.goal");
        this.maxReplicasPerBroker = config.getLong("max.replicas");
        this.replicaBalancePercentage = config.getDouble("replica.count.balance.threshold");
        this.leaderReplicaBalancePercentage = config.getDouble("leader.replica.count.balance.threshold");
        this.topicBalancingBalanceThresholdMultiplier = config.getDouble("topic.balancing.balance.threshold.multiplier");
        this.topicBalancingTriggeringThresholdMultiplier = config.getDouble("topic.balancing.trigger.threshold.multiplier");
        this.topicBalancingMaxReassignmentsPerIteration = config.getInt("topic.balancing.max.reassignments.per.iteration");
        this.topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger = config.getDouble("topic.balancing.slightly.imbalanced.topics.percentage.trigger");
        this.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold = config.getDouble("topic.balancing.slightly.imbalanced.topic.imbalance.score.threshold");
        this.topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold = config.getDouble("topic.balancing.badly.imbalanced.topic.imbalance.score.threshold");
        this.topicBalancingITRDGRunWithHardGoalsEnabled = config.getBoolean("topic.balancing.itrdg.with.hard.goals.enabled");
        this.goalViolationDistributionThresholdMultiplier = config.getDouble("goal.violation.distribution.threshold.multiplier");
        this.hotPartitionResourceThresholdPercentage = config.getDouble("hot.partition.capacity.utilization.threshold");
        this.minFreeDiskSpaceGbPerBroker = config.getInt("disk.min.free.space.gb");
        this.minFreeDiskSpaceMiBPerBroker = KafkaCruiseControlUtils.gigabytesToMebibytes(this.minFreeDiskSpaceGbPerBroker.intValue());
        Integer minFreeDiskSpaceLowerLimitGbPerBroker = config.getInt("disk.min.free.space.lower.limit.gb");
        this.minFreeDiskSpaceLowerLimitMiBPerBroker = minFreeDiskSpaceLowerLimitGbPerBroker.equals(KafkaCruiseControlConfig.DEFAULT_DISK_CAPACITY_MIN_FREE_SPACE_LOWER_LIMIT) ? this.minFreeDiskSpaceMiBPerBroker : Math.min(this.minFreeDiskSpaceMiBPerBroker, KafkaCruiseControlUtils.gigabytesToMebibytes(minFreeDiskSpaceLowerLimitGbPerBroker.intValue()));
        this.shouldBalanceFFFTraffic = config.getBoolean("consume.out.bound.should.balance.FFF.traffic");
    }

    public BalancingConstraint(BalancingConstraint original) {
        this.resourceBalancePercentage = new HashMap<Resource, Double>(original.resourceBalancePercentage);
        this.replicaBalancePercentage = original.replicaBalancePercentage;
        this.capacityBalanceDeltaThreshold = original.capacityBalanceDeltaThreshold;
        this.leaderReplicaBalancePercentage = original.leaderReplicaBalancePercentage;
        this.topicBalancingBalanceThresholdMultiplier = original.topicBalancingBalanceThresholdMultiplier;
        this.topicBalancingTriggeringThresholdMultiplier = original.topicBalancingTriggeringThresholdMultiplier;
        this.topicBalancingMaxReassignmentsPerIteration = original.topicBalancingMaxReassignmentsPerIteration;
        this.topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger = original.topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger;
        this.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold = original.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold;
        this.topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold = original.topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold;
        this.topicBalancingITRDGRunWithHardGoalsEnabled = original.topicBalancingITRDGRunWithHardGoalsEnabled;
        this.goalViolationDistributionThresholdMultiplier = original.goalViolationDistributionThresholdMultiplier;
        this.capacityThreshold = new HashMap<Resource, Double>(original.capacityThreshold);
        this.capacityThresholdUpperLimit = new HashMap<Resource, Double>(original.capacityThresholdUpperLimit);
        this.lowUtilizationRatio = new HashMap<Resource, Double>(original.lowUtilizationRatio);
        this.defaultCpuLowUtilizationThreshold = original.defaultCpuLowUtilizationThreshold;
        this.cpuLowUtilizationThresholdForBrokerAddition = original.cpuLowUtilizationThresholdForBrokerAddition;
        this.shouldCpuGoalWorkAsCapacityGoal = original.shouldCpuGoalWorkAsCapacityGoal;
        this.maxReplicasPerBroker = original.maxReplicasPerBroker;
        this.hotPartitionResourceThresholdPercentage = original.hotPartitionResourceThresholdPercentage;
        this.minFreeDiskSpaceGbPerBroker = original.minFreeDiskSpaceGbPerBroker;
        this.minFreeDiskSpaceMiBPerBroker = original.minFreeDiskSpaceMiBPerBroker;
        this.minFreeDiskSpaceLowerLimitMiBPerBroker = original.minFreeDiskSpaceLowerLimitMiBPerBroker;
        this.shouldBalanceFFFTraffic = original.shouldBalanceFFFTraffic;
    }

    public Properties setProps(Properties props) {
        props.put("disk.balance.threshold", this.resourceBalancePercentage.get((Object)Resource.DISK).toString());
        props.put("cpu.balance.threshold", this.resourceBalancePercentage.get((Object)Resource.CPU).toString());
        props.put("network.inbound.balance.threshold", this.resourceBalancePercentage.get((Object)Resource.NW_IN).toString());
        props.put("network.outbound.balance.threshold", this.resourceBalancePercentage.get((Object)Resource.NW_OUT).toString());
        props.put("disk.max.load", this.capacityThreshold.get((Object)Resource.DISK).toString());
        props.put("cpu.capacity.threshold", this.capacityThreshold.get((Object)Resource.CPU).toString());
        props.put("network.inbound.capacity.threshold", this.capacityThreshold.get((Object)Resource.NW_IN).toString());
        props.put("network.outbound.capacity.threshold", this.capacityThreshold.get((Object)Resource.NW_OUT).toString());
        props.put("producer.inbound.capacity.threshold", this.capacityThreshold.get((Object)Resource.PRODUCE_IN).toString());
        props.put("consumer.outbound.capacity.threshold", this.capacityThreshold.get((Object)Resource.CONSUME_OUT).toString());
        props.put("replication.inbound.capacity.threshold", this.capacityThreshold.get((Object)Resource.REPLICATION_IN).toString());
        props.put("disk.min.free.space.gb", this.minFreeDiskSpaceGbPerBroker.toString());
        props.put("disk.low.utilization.threshold", this.lowUtilizationRatio.get((Object)Resource.DISK).toString());
        props.put("cpu.low.utilization.threshold", this.lowUtilizationRatio.get((Object)Resource.CPU).toString());
        props.put("network.inbound.low.utilization.threshold", this.lowUtilizationRatio.get((Object)Resource.NW_IN).toString());
        props.put("network.outbound.low.utilization.threshold", this.lowUtilizationRatio.get((Object)Resource.NW_OUT).toString());
        props.put("max.capacity.balancing.delta.percentage", Double.toString(this.capacityBalanceDeltaThreshold));
        props.put("max.replicas", this.maxReplicasPerBroker.toString());
        props.put("replica.count.balance.threshold", this.replicaBalancePercentage.toString());
        props.put("leader.replica.count.balance.threshold", this.leaderReplicaBalancePercentage.toString());
        props.put("topic.balancing.balance.threshold.multiplier", this.topicBalancingBalanceThresholdMultiplier.toString());
        props.put("topic.balancing.trigger.threshold.multiplier", this.topicBalancingTriggeringThresholdMultiplier.toString());
        props.put("topic.balancing.max.reassignments.per.iteration", this.topicBalancingMaxReassignmentsPerIteration.toString());
        props.put("topic.balancing.slightly.imbalanced.topics.percentage.trigger", this.topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger.toString());
        props.put("topic.balancing.slightly.imbalanced.topic.imbalance.score.threshold", this.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold.toString());
        props.put("topic.balancing.badly.imbalanced.topic.imbalance.score.threshold", this.topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold.toString());
        props.put("topic.balancing.itrdg.with.hard.goals.enabled", this.topicBalancingITRDGRunWithHardGoalsEnabled.toString());
        props.put("goal.violation.distribution.threshold.multiplier", this.goalViolationDistributionThresholdMultiplier.toString());
        props.put("hot.partition.capacity.utilization.threshold", this.hotPartitionResourceThresholdPercentage.toString());
        props.put("consume.out.bound.should.balance.FFF.traffic", Boolean.toString(this.shouldBalanceFFFTraffic));
        return props;
    }

    public List<Resource> resources() {
        return Arrays.asList(RESOURCES);
    }

    public Long maxReplicasPerBroker() {
        return this.maxReplicasPerBroker;
    }

    public Double replicaBalancePercentage() {
        return this.replicaBalancePercentage;
    }

    public Double leaderReplicaBalancePercentage() {
        return this.leaderReplicaBalancePercentage;
    }

    public Double topicBalancingBalanceThresholdMultiplier() {
        return this.topicBalancingBalanceThresholdMultiplier;
    }

    public Double topicBalancingTriggeringThresholdMultiplier() {
        return this.topicBalancingTriggeringThresholdMultiplier;
    }

    public Integer topicBalancingMaxReassignmentsPerIteration() {
        return this.topicBalancingMaxReassignmentsPerIteration == -1 ? Integer.MAX_VALUE : this.topicBalancingMaxReassignmentsPerIteration;
    }

    public Double topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger() {
        return this.topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger;
    }

    public Double topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold() {
        return this.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold;
    }

    public Double topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold() {
        return this.topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold;
    }

    public Boolean topicBalancingITRDGRunWithHardGoalsEnabled() {
        return this.topicBalancingITRDGRunWithHardGoalsEnabled;
    }

    public boolean workAsCapacityGoal(Resource resource) {
        return resource == Resource.CPU && this.shouldCpuGoalWorkAsCapacityGoal;
    }

    public Double goalViolationDistributionThresholdMultiplier() {
        return this.goalViolationDistributionThresholdMultiplier;
    }

    public double resourceBalancePercentage(Resource resource) {
        return this.resourceBalancePercentage.get((Object)resource);
    }

    public double allowedCapacityForBroker(Resource resource, Capacity capacity) {
        return this.allowedCapacityForBroker(resource, capacity.totalCapacityFor(resource));
    }

    public double allowedCapacityForBroker(Resource resource, double totalCapacity) {
        if (totalCapacity <= 0.0) {
            return totalCapacity;
        }
        if (resource == Resource.DISK) {
            return this.allowedDiskCapacityForBroker(totalCapacity);
        }
        return this.allowedCapacity(resource, totalCapacity);
    }

    public double desiredUtilizationLimitForBroker(Resource resource, Capacity capacity) {
        double allowedCapacity = this.allowedCapacityForBroker(resource, capacity);
        if (allowedCapacity <= 0.0) {
            return allowedCapacity;
        }
        double totalCapacity = capacity.totalCapacityFor(resource);
        double desiredDelta = this.capacityBalanceDeltaThreshold * totalCapacity;
        double desiredUtilization = allowedCapacity - desiredDelta;
        if (desiredUtilization < 0.0) {
            String errMsg = String.format("The computed desired utilization cannot be negative but was computed as such - %,.2f (total capacity: %,.2f allowed capacity: %,.2f desired balance delta: %,.2f (%,.2f %%)))", desiredUtilization, totalCapacity, allowedCapacity, desiredDelta, this.capacityBalanceDeltaThreshold * 100.0);
            throw new IllegalArgumentException(errMsg);
        }
        return desiredUtilization;
    }

    public double lowUtilizationRatio(Resource resource) {
        return this.lowUtilizationRatio.get((Object)resource);
    }

    public double defaultCpuLowUtilizationThreshold() {
        return this.defaultCpuLowUtilizationThreshold;
    }

    public double cpuLowUtilizationThresholdForBrokerAddition() {
        return this.cpuLowUtilizationThresholdForBrokerAddition;
    }

    public double hotPartitionUtilizationThreshold() {
        return this.hotPartitionResourceThresholdPercentage;
    }

    private void setBalancePercentageFor(Resource resource, double balancePercentage) {
        if (balancePercentage < 1.0) {
            throw new IllegalArgumentException("Balance Percentage cannot be less than 1.0");
        }
        this.resourceBalancePercentage.put(resource, balancePercentage);
    }

    public void setResourceBalancePercentage(double resourceBalancePercentage) {
        for (Resource resource : RESOURCES) {
            this.setBalancePercentageFor(resource, resourceBalancePercentage);
        }
    }

    public boolean canCapacityThresholdBeRelaxed(Resource resource) {
        if (Resource.DISK.equals((Object)resource)) {
            return this.minFreeDiskSpaceMiBPerBroker > this.minFreeDiskSpaceLowerLimitMiBPerBroker;
        }
        return this.capacityThreshold(resource) < this.capacityThresholdUpperLimit.get((Object)resource);
    }

    public boolean updateCapacityThreshold(Resource resource) {
        if (this.canCapacityThresholdBeRelaxed(resource)) {
            if (Resource.DISK.equals((Object)resource)) {
                this.minFreeDiskSpaceMiBPerBroker = this.minFreeDiskSpaceLowerLimitMiBPerBroker;
            } else {
                this.setCapacityThresholdFor(resource, this.capacityThresholdUpperLimit.get((Object)resource));
            }
            return true;
        }
        return false;
    }

    private void setCapacityThresholdFor(Resource resource, double capacityThreshold) {
        if (capacityThreshold <= 0.0 || capacityThreshold > 1.0) {
            throw new IllegalArgumentException("Capacity Threshold must be in (0, 1]. Failed to set to capacity: " + capacityThreshold);
        }
        this.capacityThreshold.put(resource, capacityThreshold);
    }

    public void setCapacityThreshold(double capacityThreshold) {
        for (Resource resource : RESOURCES) {
            this.setCapacityThresholdFor(resource, capacityThreshold);
        }
    }

    public void setCapacityThresholdUpperLimit(Resource resource, double capacityThresholdUpperLimit) {
        this.capacityThresholdUpperLimit.put(resource, capacityThresholdUpperLimit);
    }

    void setLowUtilizationThresholdFor(Resource resource, double lowUtilizationRatio) {
        if (lowUtilizationRatio < 0.0 || lowUtilizationRatio > 1.0) {
            throw new IllegalArgumentException("Low utilization threshold must be in [0, 1].");
        }
        this.lowUtilizationRatio.put(resource, lowUtilizationRatio);
    }

    private double allowedDiskCapacityForBroker(double totalDiskCapacityMiB) {
        double maxUtilizedDiskSpaceMiB = totalDiskCapacityMiB - this.minFreeDiskSpaceMiBPerBroker;
        if (maxUtilizedDiskSpaceMiB < 0.0) {
            String errMsg = String.format("Total capacity %f MiB is less than the minimum amount of free space %f MiB.", totalDiskCapacityMiB, this.minFreeDiskSpaceMiBPerBroker);
            throw new IllegalArgumentException(errMsg);
        }
        return Math.min(this.allowedCapacity(Resource.DISK, totalDiskCapacityMiB), maxUtilizedDiskSpaceMiB);
    }

    private double allowedCapacity(Resource resource, double totalCapacity) {
        return totalCapacity * this.capacityThreshold(resource);
    }

    private double capacityThreshold(Resource resource) {
        return this.capacityThreshold.get((Object)resource);
    }

    public boolean shouldBalanceFFFTraffic() {
        return this.shouldBalanceFFFTraffic;
    }

    public String toString() {
        String balancePercentageStr = String.format("cpuBalancePercentage=%.4f,diskBalancePercentage=%.4f,inboundNwBalancePercentage=%.4f,inboundProducerBalancePercentage=%.4f,inboundMirrorBalancePercentage=%.4f,outboundNwBalancePercentage=%.4f,outboundConsumerBalancePercentage=%.4f,rackBasedOutboundConsumerBalancePercentage=%.4f,rackLessOutboundConsumerBalancePercentage=%.4f,replicationInboundBalancePercentage=%.4f", this.resourceBalancePercentage.get((Object)Resource.CPU), this.resourceBalancePercentage.get((Object)Resource.DISK), this.resourceBalancePercentage.get((Object)Resource.NW_IN), this.resourceBalancePercentage.get((Object)Resource.PRODUCE_IN), this.resourceBalancePercentage.get((Object)Resource.MIRROR_IN), this.resourceBalancePercentage.get((Object)Resource.NW_OUT), this.resourceBalancePercentage.get((Object)Resource.CONSUME_OUT), this.resourceBalancePercentage.get((Object)Resource.RACK_BASED_CONSUME_OUT), this.resourceBalancePercentage.get((Object)Resource.RACK_LESS_CONSUME_OUT), this.resourceBalancePercentage.get((Object)Resource.REPLICATION_IN));
        String capacityThresholdStr = String.format("cpuCapacityThreshold=%.4f,diskCapacityThreshold=%.4f,inboundNwCapacityThreshold=%.4f,inboundProducerCapacityThreshold=%.4f,inboundMirrorCapacityThreshold=%.4f,outboundNwCapacityThreshold=%.4f,outboundConsumerCapacityThreshold=%.4f,rackBasedOutboundConsumerCapacityThreshold=%.4f,rackLessOutboundConsumerCapacityThreshold=%.4f,replicationInboundCapacityThreshold=%.4f", this.capacityThreshold.get((Object)Resource.CPU), this.capacityThreshold.get((Object)Resource.DISK), this.capacityThreshold.get((Object)Resource.NW_IN), this.capacityThreshold.get((Object)Resource.PRODUCE_IN), this.capacityThreshold.get((Object)Resource.MIRROR_IN), this.capacityThreshold.get((Object)Resource.NW_OUT), this.capacityThreshold.get((Object)Resource.CONSUME_OUT), this.capacityThreshold.get((Object)Resource.RACK_BASED_CONSUME_OUT), this.capacityThreshold.get((Object)Resource.RACK_LESS_CONSUME_OUT), this.capacityThreshold.get((Object)Resource.REPLICATION_IN));
        String lowUsageThresholdStr = String.format("lowCpuUsageThreshold=%.4f,lowDiskUsageThreshold=%.4f,lowInboundNwUsageThreshold=%.4f,lowInboundProducerUsageThreshold=%.4f,lowInboundMirrorUsageThreshold=%.4f,lowOutboundNwUsageThreshold=%.4f,lowOutboundConsumerUsageThreshold=%.4f,lowOutboundRackBasedConsumerUsageThreshold=%.4f,lowOutboundRackLessConsumerUsageThreshold=%.4f,lowInboundReplicationUsageThreshold=%.4f,defaultCpuLowUtilizationThreshold=%.4f,cpuLowUtilizationThresholdForBrokerAddition=%.4f", this.lowUtilizationRatio.get((Object)Resource.CPU), this.lowUtilizationRatio.get((Object)Resource.DISK), this.lowUtilizationRatio.get((Object)Resource.NW_IN), this.lowUtilizationRatio.get((Object)Resource.PRODUCE_IN), this.lowUtilizationRatio.get((Object)Resource.MIRROR_IN), this.lowUtilizationRatio.get((Object)Resource.NW_OUT), this.lowUtilizationRatio.get((Object)Resource.CONSUME_OUT), this.lowUtilizationRatio.get((Object)Resource.RACK_BASED_CONSUME_OUT), this.lowUtilizationRatio.get((Object)Resource.RACK_LESS_CONSUME_OUT), this.lowUtilizationRatio.get((Object)Resource.REPLICATION_IN), this.defaultCpuLowUtilizationThreshold, this.cpuLowUtilizationThresholdForBrokerAddition);
        String miscellaneousThresholdStr = String.format("maxReplicasPerBroker=%d,replicaBalancePercentage=%.4f,leaderReplicaBalancePercentage=%.4f,topicBalancingBalanceThresholdMultiplier=%.4f,topicBalancingTriggeringThresholdMultiplier=%.4f,topicBalancingMaxReassignmentsPerIteration=%d,topicBalancingSlightlyImbalanceTopicsPercentageGoalTrigger=%.4f,topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold=%.4f,topicBalancingSlightlyImbalanceTopicImbalanceScoreThreshold=%.4f,topicBalancingBadlyImbalanceTopicImbalanceScoreThreshold=.4f,goalViolationDistributionThresholdMultiplier=%.4f,", this.maxReplicasPerBroker, this.replicaBalancePercentage, this.leaderReplicaBalancePercentage, this.topicBalancingBalanceThresholdMultiplier, this.topicBalancingTriggeringThresholdMultiplier, this.topicBalancingMaxReassignmentsPerIteration, this.topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger, this.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold, this.topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold, this.goalViolationDistributionThresholdMultiplier);
        return String.format("BalancingConstraint[%s,%s,%s,%s]", balancePercentageStr, capacityThresholdStr, miscellaneousThresholdStr, lowUsageThresholdStr);
    }
}

