/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingActionsLog;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.TopicPartitionMovement;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractTopicGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.CellsTopicStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ClusterTopicStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.TopicStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.DetailedProposal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.TopicImbalanceScoreType;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import io.confluent.databalancer.DatabalancerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalTopicReplicaDistributionGoal
extends AbstractTopicGoal {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalTopicReplicaDistributionGoal.class);
    private TopicStats topicStats;
    private Boolean shouldTrigger = false;
    private int numProposedReassignments = 0;
    private Mode runMode = Mode.DEFAULT;
    private Set<String> eligibleReplicaMoves = Collections.emptySet();

    public IncrementalTopicReplicaDistributionGoal() {
    }

    public IncrementalTopicReplicaDistributionGoal(BalancingConstraint balancingConstraint) {
        this();
        this.balancingConstraint = balancingConstraint;
    }

    private boolean isSuspended(Replica replica, ActionType actionType, OptimizationOptions optimizationOptions) {
        return !replica.isCurrentOffline() && optimizationOptions.oscillatingTopicPartitionMovements().contains(new TopicPartitionMovement(replica.topicPartition(), actionType));
    }

    @Override
    protected Broker maybeApplyBalancingAction(ClusterModel clusterModel, Replica replica, Collection<Broker> candidateBrokers, ActionType action, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, DetailedProposal.DetailedReasonBuilder detailedReasonBuilder, Optional<DetailedProposal.Builder> detailedProposalOptional, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        if (this.isSuspended(replica, action, optimizationOptions)) {
            LOG.trace("Did not apply action {} to Replica {} since it is suspended from movement", (Object)action, (Object)replica);
            this.proposalStatsBuilder.trackProposalSuspended();
            return null;
        }
        return super.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, action, optimizedGoals, optimizationOptions, detailedReasonBuilder, detailedProposalOptional, balancingActionsLogOpt);
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String sourceTopic = action.topic();
        Replica sourceReplica = sourceBroker.replica(action.topicPartition());
        if (sourceReplica == null) {
            throw new IllegalStateException("Failed to find the replica that's being moved.");
        }
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_MOVEMENT: {
                return this.isReplicaCountUnderBalanceUpperLimitAfterChange(sourceTopic, sourceReplica, destinationBroker, ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(sourceTopic, sourceReplica, sourceBroker, ReplicaDistributionAbstractGoal.ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_SWAP: {
                return ActionAcceptance.REPLICA_REJECT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + String.valueOf((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    private boolean isReplicaCountUnderBalanceUpperLimitAfterChange(String topic, Replica replica, Broker broker, ReplicaDistributionAbstractGoal.ChangeType changeType) {
        int brokerFollowerBalanceUpperLimit;
        int numTopicLeaders = broker.numLeaderReplicasOfTopicInBroker(topic);
        int numTopicFollowers = broker.numFollowerReplicasOfTopicInBroker(topic);
        int brokerLeaderBalanceUpperLimit = broker.isAlive() ? this.leadersForBrokerForTopicUpperLimit(topic, broker) : 0;
        int n = brokerFollowerBalanceUpperLimit = broker.isAlive() ? this.followersForBrokerForTopicUpperLimit(topic, broker) : 0;
        if (changeType == ReplicaDistributionAbstractGoal.ChangeType.ADD) {
            if (replica.isLeader()) {
                return numTopicLeaders + 1 <= brokerLeaderBalanceUpperLimit;
            }
            return numTopicFollowers + 1 <= brokerFollowerBalanceUpperLimit;
        }
        return true;
    }

    private boolean isReplicaCountAboveBalanceLowerLimitAfterChange(String topic, Replica replica, Broker broker, ReplicaDistributionAbstractGoal.ChangeType changeType) {
        int brokerFollowerBalanceLowerLimit;
        int numTopicLeaders = broker.numLeaderReplicasOfTopicInBroker(topic);
        int numTopicFollowers = broker.numFollowerReplicasOfTopicInBroker(topic);
        int brokerLeaderBalanceLowerLimit = broker.isAlive() ? this.leadersForBrokerForTopicLowerLimit(topic, broker) : 0;
        int n = brokerFollowerBalanceLowerLimit = broker.isAlive() ? this.followersForBrokerForTopicLowerLimit(topic, broker) : 0;
        if (changeType == ReplicaDistributionAbstractGoal.ChangeType.REMOVE) {
            if (replica.isLeader()) {
                return numTopicLeaders - 1 >= brokerLeaderBalanceLowerLimit;
            }
            return numTopicFollowers - 1 >= brokerFollowerBalanceLowerLimit;
        }
        return true;
    }

    @Override
    public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new TopicReplicaDistributionGoalStatsComparator();
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    public String name() {
        return IncrementalTopicReplicaDistributionGoal.class.getSimpleName();
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    public boolean runWithHardGoal() {
        return this.balancingConstraint.topicBalancingITRDGRunWithHardGoalsEnabled();
    }

    private SortedSet<Broker> brokersToBalanceForAllTopics(ClusterModel clusterModel) {
        return clusterModel.eligibleSourceOrDestinationBrokers();
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) {
        this.initializeRunMode(optimizationOptions);
        this.topicStats = this.getTopicStats(clusterModel);
        this.initializeShouldTrigger(clusterModel, optimizationOptions);
        this.topicStats.initializeTopicsToRebalanceInitialScores(clusterModel, TopicImbalanceScoreType.REPLICA_DISTRIBUTION_BASED);
        this.initializeAverageLeaderAndFollowerReplica(clusterModel);
        this.topicStats.initializeBrokersCountPerRack(clusterModel);
        if (LOG.isDebugEnabled()) {
            this.logTopicDistributions(arg_0 -> ((Logger)LOG).debug(arg_0), clusterModel, "PRE-BALANCING");
        }
        this.numProposedReassignments = 0;
    }

    TopicStats getTopicStats(ClusterModel clusterModel) {
        if (clusterModel.isCellEnabled()) {
            LOG.debug("Using CellsTopicStats for topic distribution goal.");
            return new CellsTopicStats(clusterModel);
        }
        LOG.debug("Using ClusterTopicStats for topic distribution goal.");
        return new ClusterTopicStats();
    }

    private void initializeRunMode(OptimizationOptions optimizationOptions) {
        this.runMode = this.runWithHardGoal() && optimizationOptions.wereProposalsGeneratedByHardGoals() ? Mode.HARD_GOAL_TRIGGERED : Mode.DEFAULT;
        LOG.info("iTRDG will run in {} mode", (Object)this.runMode);
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String sourceRackId = sourceBroker.rack().id();
        String destinationRackId = destinationBroker.rack().id();
        if (!this.runMode.isReplicaActionAllowed(action, this.eligibleReplicaMoves)) {
            LOG.trace("rejecting replica movement {}, run mode: {}", (Object)action, (Object)this.runMode);
            return false;
        }
        if (!Objects.equals(sourceRackId, destinationRackId) && sourceBroker.replica(action.topicPartition()).isLeader()) {
            return this.interRackActionSelfSatisfy(clusterModel, action);
        }
        if (sourceBroker.replica(action.topicPartition()).isLeader()) {
            return this.leaderActionSelfSatisfy(clusterModel, action);
        }
        return this.followerActionSelfSatisfy(clusterModel, action);
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return false;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        if (this.shouldTrigger.booleanValue()) {
            if (LOG.isDebugEnabled()) {
                this.logTopicDistributions(arg_0 -> ((Logger)LOG).debug(arg_0), clusterModel, "POST-BALANCING");
            }
            Set balancedTopics = this.topicStats.getEligibleTopicsForRebalance().stream().filter(topic -> this.topicStats.getTopicImbalanceScore((String)topic, clusterModel) == 0.0).collect(Collectors.toSet());
            Set<String> improvedTopics = this.topicStats.getEligibleTopicsForRebalance().stream().filter(topic -> this.topicStats.getTopicImbalanceScore((String)topic, clusterModel) < this.topicStats.getEligibleTopicsForRebalanceInitialScore((String)topic)).collect(Collectors.toSet());
            Set unimprovedTopics = this.topicStats.getEligibleTopicsForRebalance().stream().filter(topic -> !improvedTopics.contains(topic) && !balancedTopics.contains(topic)).collect(Collectors.toSet());
            LOG.info("The topic distribution goal managed to improve the following topics {} (out of which the following are even considered completely balanced {}), but it couldn't improve {}", new Object[]{improvedTopics, balancedTopics, unimprovedTopics});
            improvedTopics.forEach(topic -> this.topicStats.logChangeInTopicImbalanceScore((String)topic, clusterModel));
            this.optimizationResultBuilder.markSuccessfulOptimization();
            OptimizationOptions options = new OptimizationOptions.Builder().triggeredByGoalViolation(true).build();
            boolean stopsBeingTriggering = !this.initializeShouldTrigger(clusterModel, options);
            LOG.info("Topic distribution goal will stop triggering from the next round: {}", (Object)stopsBeingTriggering);
            boolean hasMoreToRebalance = this.numProposedReassignments >= this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration();
            LOG.info("Topic distribution goal can do {} more reassignments which means it has more work for the next round: {}", (Object)this.numProposedReassignments, (Object)hasMoreToRebalance);
            if (this.runMode.shouldMarkAsInProgress(stopsBeingTriggering, hasMoreToRebalance)) {
                LOG.info("The topic distribution goal will not be triggering in the next self-healing round, marking the goal as 'in progress'");
                this.optimizationResultBuilder.markInProgressOptimization();
            }
        }
        this.finish();
    }

    private Set<Broker> getTopicHostBrokers(String topic, ClusterModel clusterModel) {
        if (clusterModel.isCellEnabled()) {
            try {
                List<Cell> tenantCells = DatabalancerUtils.expectedCellsForTenantTopic(clusterModel, topic);
                if (!tenantCells.isEmpty()) {
                    Set tenantCellIds = tenantCells.stream().map(Cell::id).collect(Collectors.toSet());
                    return clusterModel.aliveBrokers().stream().filter(broker -> tenantCellIds.contains(broker.cell().id())).collect(Collectors.toSet());
                }
            }
            catch (OptimizationFailureException e) {
                LOG.info("Received exception while getting expected cells for topic {}. Returning all brokers in the cluster as topic host brokers.", (Object)topic, (Object)e);
            }
        }
        return clusterModel.aliveBrokers();
    }

    private void logTopicDistributions(Consumer<String> logConsumer, ClusterModel clusterModel, String logPrefix) {
        this.topicStats.getEligibleTopicsForRebalance().forEach(topic -> {
            LinkedHashMap leaderReplicas = new LinkedHashMap();
            Set<Broker> topicHostBrokers = this.getTopicHostBrokers((String)topic, clusterModel);
            topicHostBrokers.forEach(broker -> leaderReplicas.put(broker.id(), broker.leaderReplicasOfTopicInBroker((String)topic).size()));
            int maxLeaders = Integer.MIN_VALUE;
            int maxAllowedLeadersForBrokerWithMaxLeaders = Integer.MIN_VALUE;
            int minLeaders = Integer.MAX_VALUE;
            int minRequiredLeadersForBrokerWithMinLeaders = Integer.MAX_VALUE;
            for (Map.Entry entry : leaderReplicas.entrySet()) {
                int currentLeaders = (Integer)entry.getValue();
                int currentMaxLeaders = this.leadersForBrokerForTopicUpperLimit((String)topic, clusterModel.broker((Integer)entry.getKey()));
                int currentMinLeaders = this.leadersForBrokerForTopicLowerLimit((String)topic, clusterModel.broker((Integer)entry.getKey()));
                if (currentMaxLeaders == Integer.MAX_VALUE) continue;
                if (currentLeaders >= maxLeaders) {
                    if (currentLeaders == maxLeaders && currentMaxLeaders < maxAllowedLeadersForBrokerWithMaxLeaders) {
                        maxAllowedLeadersForBrokerWithMaxLeaders = currentMaxLeaders;
                    } else if (currentLeaders > maxLeaders) {
                        maxLeaders = currentLeaders;
                        maxAllowedLeadersForBrokerWithMaxLeaders = currentMaxLeaders;
                    }
                }
                if (currentLeaders > minLeaders) continue;
                if (currentLeaders == minLeaders && currentMinLeaders > minRequiredLeadersForBrokerWithMinLeaders) {
                    minRequiredLeadersForBrokerWithMinLeaders = currentMinLeaders;
                    continue;
                }
                if (currentLeaders >= minLeaders) continue;
                minLeaders = currentLeaders;
                minRequiredLeadersForBrokerWithMinLeaders = currentMinLeaders;
            }
            LinkedHashMap followerReplicas = new LinkedHashMap();
            topicHostBrokers.forEach(broker -> followerReplicas.put(broker.id(), broker.followerReplicasOfTopicInBroker((String)topic).size()));
            int maxFollowers = Integer.MIN_VALUE;
            int maxAllowedFollowersForBrokerWithMaxFollowers = Integer.MIN_VALUE;
            int minFollowers = Integer.MAX_VALUE;
            int minRequiredFollowersForBrokerWithMinFollowers = Integer.MAX_VALUE;
            for (Map.Entry entry : followerReplicas.entrySet()) {
                int currentFollowers = (Integer)entry.getValue();
                int currentMaxFollowers = this.followersForBrokerForTopicUpperLimit((String)topic, clusterModel.broker((Integer)entry.getKey()));
                int currentMinFollowers = this.followersForBrokerForTopicLowerLimit((String)topic, clusterModel.broker((Integer)entry.getKey()));
                if (currentMaxFollowers == Integer.MAX_VALUE) continue;
                if (currentFollowers >= maxFollowers) {
                    if (currentFollowers == maxFollowers && currentMaxFollowers < maxAllowedFollowersForBrokerWithMaxFollowers) {
                        maxAllowedFollowersForBrokerWithMaxFollowers = currentMaxFollowers;
                    } else if (currentFollowers > maxFollowers) {
                        maxFollowers = currentFollowers;
                        maxAllowedFollowersForBrokerWithMaxFollowers = currentMaxFollowers;
                    }
                }
                if (currentFollowers > minFollowers) continue;
                if (currentFollowers == minFollowers && currentMinFollowers > minRequiredFollowersForBrokerWithMinFollowers) {
                    minRequiredFollowersForBrokerWithMinFollowers = currentMinFollowers;
                    continue;
                }
                if (currentFollowers >= minFollowers) continue;
                minFollowers = currentFollowers;
                minRequiredFollowersForBrokerWithMinFollowers = currentMinFollowers;
            }
            logConsumer.accept(String.format("%s> Distributions for topic '%s': \nLeader difference: %d; \nFollower difference: %d; \nLeader: \n(%s); \nFollower: \n(%s)", logPrefix, topic, maxLeaders - minLeaders, maxFollowers - minFollowers, leaderReplicas.entrySet().stream().map(e -> String.format("{\"%d\": %d}", e.getKey(), e.getValue())).collect(Collectors.joining(", \n")), followerReplicas.entrySet().stream().map(e -> String.format("{\"%d\": %d}", e.getKey(), e.getValue())).collect(Collectors.joining(", \n"))));
            if (minLeaders < minRequiredLeadersForBrokerWithMinLeaders || maxLeaders > maxAllowedLeadersForBrokerWithMaxLeaders || minFollowers < minRequiredFollowersForBrokerWithMinFollowers || maxFollowers > maxAllowedFollowersForBrokerWithMaxFollowers) {
                logConsumer.accept(String.format("Topic %s is imbalanced, it has leaders count [%d, %d] for leader bounds [%d, %d], and followers count [%d, %d] for follower bounds [%d, %d], imbalance score: %f", topic, minLeaders, maxLeaders, minRequiredLeadersForBrokerWithMinLeaders, maxAllowedLeadersForBrokerWithMaxLeaders, minFollowers, maxFollowers, minRequiredFollowersForBrokerWithMinFollowers, maxAllowedFollowersForBrokerWithMaxFollowers, this.topicStats.getTopicImbalanceScore((String)topic, clusterModel)));
            }
        });
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    protected double getTopicImbalanceScore(String topic, ClusterModel clusterModel) {
        return clusterModel.topicImbalanceScore(topic, TopicImbalanceScoreType.REPLICA_DISTRIBUTION_BASED);
    }

    @Override
    public void rebalanceForTopic(String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        LOG.debug("Rebalancing topic {}.", (Object)topic);
        if (this.runMode.shouldSkipRebalance(this.shouldTrigger, this.numProposedReassignments, this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration())) {
            LOG.debug("Skipping rebalance for topic {} because the goal is not triggering or the maximum number of reassignments is reached.", (Object)topic);
            return;
        }
        double initialTopicImbalanceScore = this.topicStats.getTopicImbalanceScore(topic, clusterModel);
        int initialNumProposedReassignments = this.numProposedReassignments;
        Optional<BalancingActionsLog> balancingActionsLogOpt = Optional.of(new BalancingActionsLog());
        this.rebalanceRackLeaderReplicaDistribution(clusterModel, optimizedGoals, optimizationOptions, balancingActionsLogOpt, topic);
        this.rebalanceTopicReplicaDistribution(topic, clusterModel, optimizedGoals, optimizationOptions, balancingActionsLogOpt);
        double finalTopicImbalanceScore = this.topicStats.getTopicImbalanceScore(topic, clusterModel);
        this.revertMovementsIfImbalanceScoreIncreases(balancingActionsLogOpt, clusterModel, initialTopicImbalanceScore, finalTopicImbalanceScore, initialNumProposedReassignments, topic, optimizedGoals, optimizationOptions);
    }

    @Override
    protected List<String> topicsToRebalance(ClusterModel clusterModel, Set<String> excludedTopics) {
        List<String> defaultTopicsToRebalance = super.topicsToRebalance(clusterModel, excludedTopics);
        TopicSelectionResult topicSelectionResult = this.runMode.topicsToRebalance(clusterModel, defaultTopicsToRebalance);
        this.eligibleReplicaMoves = topicSelectionResult.eligibleReplicaMoves();
        return topicSelectionResult.topicsToRebalance();
    }

    private void revertMovementsIfImbalanceScoreIncreases(Optional<BalancingActionsLog> balancingActionsLogOpt, ClusterModel clusterModel, double initialTopicImbalanceScore, double finalTopicImbalanceScore, int initialNumProposedReassignments, String topic, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts) {
        balancingActionsLogOpt.ifPresent(balancingActionsLog -> {
            if (finalTopicImbalanceScore > initialTopicImbalanceScore) {
                LOG.warn("Topic {} imbalance score increased from {} to {} after the rebalance.", new Object[]{topic, initialTopicImbalanceScore, finalTopicImbalanceScore});
                balancingActionsLog.revertActions(clusterModel);
                balancingActionsLog.revertAcceptedProposals(this.proposalStatsBuilder, null, Optional.of(this.name()));
                this.numProposedReassignments = initialNumProposedReassignments;
                this.rebalanceTopicReplicaDistribution(topic, clusterModel, optimizedGoals, optimizationOpts, Optional.empty());
            }
            if (this.numProposedReassignments == 0) {
                this.optimizationResultBuilder.removeReplicaChange(this.name());
            }
        });
    }

    private void rebalanceRackLeaderReplicaDistribution(ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, Optional<BalancingActionsLog> balancingActionsLogOpt, String topic) {
        int eligibleBrokersCount = clusterModel.eligibleDestinationBrokers().size();
        if (eligibleBrokersCount == 0) {
            LOG.debug("No eligible brokers to move leaders for topic '{}'", (Object)topic);
            return;
        }
        this.topicStats.initializeRackRelatedTopicLeaderDistribution(clusterModel, topic);
        List rackIds = clusterModel.aliveRackIds().stream().sorted(Comparator.comparingInt(r -> clusterModel.rack((String)r).numLeaderReplicas()).reversed()).collect(Collectors.toList());
        for (String rack : rackIds) {
            LOG.debug("Rebalancing leader replica distribution for rack {} for topic '{}'", (Object)rack, (Object)topic);
            boolean hasMoreLeadersForTopic = this.topicStats.hasMoreTopicLeadersForRack(rack);
            boolean hasLessLeadersForTopic = this.topicStats.hasLessTopicLeadersForRack(rack);
            if (hasMoreLeadersForTopic) {
                this.rebalanceByMovingRackLeaderReplicasOut(rack, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
            }
            if (!hasLessLeadersForTopic) continue;
            this.rebalanceByMovingRackLeaderReplicasIn(rack, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
        }
    }

    private void rebalanceByMovingRackLeaderReplicasOut(String rack, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        PriorityQueue candidateRacks = clusterModel.aliveRackIds().stream().filter(r -> !r.equals(rack)).filter(r -> this.topicStats.canAccommodateMoreTopicLeadersForRack((String)r)).collect(Collectors.toCollection(() -> new PriorityQueue<Object>(Comparator.comparingInt(r -> this.topicStats.numTopicLeadersThatCanBeMovedToRack((String)r) * -1).thenComparingInt(r -> clusterModel.rack((String)r).numLeaderReplicas()).thenComparingInt(r -> clusterModel.rack((String)r).numReplicas()))));
        while (!candidateRacks.isEmpty()) {
            String destinationRack = (String)candidateRacks.poll();
            Optional<InterRackMovement> interRackMovement = this.doInterRackLeaderMovement(clusterModel, topic, rack, destinationRack, optimizedGoals, optimizationOptions, balancingActionsLogOpt);
            if (interRackMovement.isEmpty()) continue;
            ++this.numProposedReassignments;
            this.topicStats.incrementCurrentTopicLeadersPerRack(destinationRack, interRackMovement.get().destinationBroker, 1);
            this.topicStats.decrementCurrentTopicLeadersPerRack(rack, interRackMovement.get().sourceBroker, 1);
            if (this.topicStats.metRackTopicLeadersUpperBound(rack)) {
                LOG.debug("Rack {} successfully met the leaders upper bound for topic {} by moving out extra replicas.", (Object)rack, (Object)topic);
                return;
            }
            if (!this.topicStats.canAccommodateMoreTopicLeadersForRack(destinationRack)) continue;
            candidateRacks.add(destinationRack);
        }
    }

    private void rebalanceByMovingRackLeaderReplicasIn(String rack, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        PriorityQueue candidateRacks = clusterModel.aliveRackIds().stream().filter(r -> !r.equals(rack)).filter(r -> this.topicStats.canReleaseMoreTopicLeadersForRack((String)r)).collect(Collectors.toCollection(() -> new PriorityQueue<Object>(Comparator.comparingInt(r -> this.topicStats.numTopicLeadersThatCanBeMovedFromRack((String)r)).reversed())));
        while (!candidateRacks.isEmpty()) {
            String sourceRack = (String)candidateRacks.poll();
            Optional<InterRackMovement> interRackMovement = this.doInterRackLeaderMovement(clusterModel, topic, sourceRack, rack, optimizedGoals, optimizationOptions, balancingActionsLogOpt);
            if (interRackMovement.isEmpty()) continue;
            ++this.numProposedReassignments;
            this.topicStats.incrementCurrentTopicLeadersPerRack(rack, interRackMovement.get().destinationBroker, 1);
            this.topicStats.decrementCurrentTopicLeadersPerRack(sourceRack, interRackMovement.get().sourceBroker, 1);
            if (this.topicStats.metRackTopicLeadersLowerBound(rack)) {
                LOG.debug("Rack {} successfully met the leaders lower bound for topic {} by moving out extra replicas.", (Object)rack, (Object)topic);
                return;
            }
            if (!this.topicStats.canReleaseMoreTopicLeadersForRack(sourceRack)) continue;
            candidateRacks.add(sourceRack);
        }
    }

    private Optional<InterRackMovement> doInterRackLeaderMovement(ClusterModel clusterModel, String topic, String sourceRack, String destinationRack, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        List candidateSourceBrokers = clusterModel.eligibleSourceBrokers().stream().filter(b -> b.rack().id().equals(sourceRack)).filter(b -> this.topicStats.canReleaseMoreTopicLeadersForRack(sourceRack, (Broker)b)).filter(b -> b.numLeaderReplicasOfTopicInBroker(topic) > 0).sorted(Comparator.comparingInt(b -> b.numLeaderReplicasOfTopicInBroker(topic)).reversed()).collect(Collectors.toList());
        LOG.debug("Doing inter-rack leadership movement for sourceRack {} and destination rack {} and source brokers are: {}", new Object[]{sourceRack, destinationRack, candidateSourceBrokers});
        for (Broker sourceBroker : candidateSourceBrokers) {
            Collection<Replica> replicasToMove = sourceBroker.leaderReplicasOfTopicInBroker(topic);
            for (Replica replica : replicasToMove) {
                Collection destinationBrokers = this.topicStats.getEligibleDestinationBrokers(clusterModel, sourceBroker).stream().filter(b -> b.rack().id().equals(destinationRack)).filter(b -> this.topicStats.canAccommodateMoreTopicLeadersForRack(destinationRack, (Broker)b)).collect(Collectors.toList());
                LOG.debug("Trying moving replica {} from  source broker {} to destination brokers {}", new Object[]{replica, sourceBroker, destinationBrokers});
                Broker destinationBroker = this.maybeApplyBalancingActions(clusterModel, replica, destinationBrokers, Arrays.asList(ActionType.LEADERSHIP_MOVEMENT, ActionType.INTER_BROKER_REPLICA_MOVEMENT), optimizedGoals, optimizationOptions, Optional.empty(), balancingActionsLogOpt);
                if (destinationBroker == null) continue;
                LOG.debug("Successfully did inter-rack leadership movement for leader replica {} from rack {} to rack {} with source broker {} and destination broker {}", new Object[]{replica, sourceRack, destinationRack, sourceBroker, destinationBroker});
                return Optional.of(new InterRackMovement(replica, sourceBroker, destinationBroker));
            }
        }
        return Optional.empty();
    }

    private void rebalanceTopicReplicaDistribution(String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        this.rebalanceLeaderReplicaDistribution(clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt, topic);
        this.rebalanceFollowerReplicaDistribution(clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt, topic);
    }

    private void rebalanceFollowerReplicaDistribution(ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, Optional<BalancingActionsLog> balancingActionsLogOpt, String topic) {
        SortedSet<Broker> brokersToBalance = this.brokersToBalanceForAllTopics(clusterModel);
        for (Broker broker : brokersToBalance) {
            boolean requireMoreFollowers;
            LOG.debug("Rebalancing follower replica distribution for broker {} for topic '{}'", (Object)broker, (Object)topic);
            Collection<Replica> replicas = broker.followerReplicasOfTopicInBroker(topic);
            int numFollowerReplicas = replicas.size();
            boolean hasMoreFollowersForTopic = numFollowerReplicas > this.followersForBrokerForTopicUpperLimit(topic, broker) || numFollowerReplicas == this.followersForBrokerForTopicUpperLimit(topic, broker) && this.followersForBrokerForTopicUpperLimit(topic, broker) > this.followersForBrokerForTopicLowerLimit(topic, broker);
            boolean hasLessFollowersForTopic = numFollowerReplicas < this.followersForBrokerForTopicLowerLimit(topic, broker);
            boolean requireLessFollowers = broker.isEligibleSource() && hasMoreFollowersForTopic;
            boolean bl = requireMoreFollowers = broker.isEligibleDestination() && hasLessFollowersForTopic;
            if (requireLessFollowers) {
                this.rebalanceByMovingFollowerReplicasOut(broker, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
            }
            if (!requireMoreFollowers) continue;
            this.rebalanceByMovingFollowerReplicasIn(broker, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
        }
    }

    private void rebalanceLeaderReplicaDistribution(ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, Optional<BalancingActionsLog> balancingActionsLogOpt, String topic) {
        SortedSet<Broker> brokersToBalance = this.brokersToBalanceForAllTopics(clusterModel);
        for (Broker broker : brokersToBalance) {
            boolean requireMoreLeaders;
            LOG.debug("Rebalancing leader replica distribution for broker {} for topic '{}'", (Object)broker, (Object)topic);
            Collection<Replica> topicLeaderReplicas = broker.leaderReplicasOfTopicInBroker(topic);
            boolean hasMoreLeadersForTopic = topicLeaderReplicas.size() > this.leadersForBrokerForTopicUpperLimit(topic, broker) || topicLeaderReplicas.size() == this.leadersForBrokerForTopicUpperLimit(topic, broker) && this.leadersForBrokerForTopicUpperLimit(topic, broker) > this.leadersForBrokerForTopicLowerLimit(topic, broker);
            boolean hasLessLeadersForTopic = topicLeaderReplicas.size() < this.leadersForBrokerForTopicLowerLimit(topic, broker);
            boolean requireLessLeaders = broker.isEligibleSource() && hasMoreLeadersForTopic;
            boolean bl = requireMoreLeaders = broker.isEligibleDestination() && hasLessLeadersForTopic;
            if (requireLessLeaders) {
                this.rebalanceByMovingLeaderReplicasOut(broker, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
            }
            if (!requireMoreLeaders) continue;
            this.rebalanceByMovingLeaderReplicasIn(broker, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
        }
    }

    void rebalanceByMovingFollowerReplicasOut(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        TreeSet<Broker> destinationBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.numFollowerReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id));
        this.topicStats.getEligibleDestinationBrokers(clusterModel, broker).stream().filter(b -> b.numFollowerReplicasOfTopicInBroker(topic) < this.followersForBrokerForTopicUpperLimit(topic, (Broker)b)).collect(Collectors.toCollection(() -> destinationBrokers));
        Collection<Replica> followerReplicasOfTopicInBroker = broker.followerReplicasOfTopicInBroker(topic);
        int followerReplicasOfTopicInBrokerCount = followerReplicasOfTopicInBroker.size();
        for (Replica replica : followerReplicasOfTopicInBroker) {
            boolean metTopicUpperBound;
            LOG.debug("Trying to move follower replica out {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, broker, destinationBrokers});
            Broker newHostBroker = this.maybeApplyBalancingAction(clusterModel, replica, destinationBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty(), balancingActionsLogOpt);
            boolean movementSuccessful = newHostBroker != null;
            if (!movementSuccessful) continue;
            LOG.debug("Successfully moved follower replica out {} from broker {} to broker {}", new Object[]{replica, broker, newHostBroker});
            ++this.numProposedReassignments;
            boolean bl = metTopicUpperBound = --followerReplicasOfTopicInBrokerCount < this.followersForBrokerForTopicUpperLimit(topic, broker) || followerReplicasOfTopicInBrokerCount == this.followersForBrokerForTopicUpperLimit(topic, broker) && this.followersForBrokerForTopicUpperLimit(topic, broker) == this.followersForBrokerForTopicLowerLimit(topic, broker);
            if (metTopicUpperBound) {
                LOG.debug("Broker {} successfully met the followers upper bound for topic {} by moving out extra replicas.", (Object)broker, (Object)topic);
                return;
            }
            destinationBrokers.removeIf(b -> b.equals(newHostBroker));
            boolean candidateCanTakeMoreTopicReplicas = newHostBroker.numFollowerReplicasOfTopicInBroker(topic) < this.followersForBrokerForTopicUpperLimit(topic, newHostBroker);
            if (!candidateCanTakeMoreTopicReplicas) continue;
            destinationBrokers.add(newHostBroker);
        }
    }

    void rebalanceByMovingFollowerReplicasIn(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        PriorityQueue<Broker> sourceBrokers = new PriorityQueue<Broker>(Comparator.comparingInt(b -> b.numFollowerReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id).reversed());
        this.topicStats.getEligibleSourceBrokers(clusterModel, broker).stream().filter(b -> b.numFollowerReplicasOfTopicInBroker(topic) > this.followersForBrokerForTopicLowerLimit(topic, (Broker)b)).collect(Collectors.toCollection(() -> sourceBrokers));
        Collection<Replica> followerReplicasOfTopicInBroker = broker.followerReplicasOfTopicInBroker(topic);
        int numFollowerReplicasOfTopicInBroker = followerReplicasOfTopicInBroker.size();
        Set<Broker> candidateBrokers = Collections.singleton(broker);
        block0: while (!sourceBrokers.isEmpty()) {
            Broker sourceBroker = sourceBrokers.poll();
            Collection<Replica> sourceBrokerReplicasForTopic = sourceBroker.followerReplicasOfTopicInBroker(topic);
            for (Replica replica : sourceBrokerReplicasForTopic) {
                boolean metTopicLowerBound;
                LOG.debug("Trying to move follower replica in {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, sourceBroker, candidateBrokers});
                Broker newHostBroker = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty(), balancingActionsLogOpt);
                boolean movementSuccessful = newHostBroker != null;
                if (!movementSuccessful) continue;
                LOG.debug("Successfully moved follower replica in {} from broker {} to broker {}", new Object[]{replica, sourceBroker, newHostBroker});
                ++this.numProposedReassignments;
                boolean bl = metTopicLowerBound = ++numFollowerReplicasOfTopicInBroker >= this.followersForBrokerForTopicLowerLimit(topic, broker);
                if (metTopicLowerBound) {
                    LOG.debug("Broker {} successfully met the followers lower bound for topic {} by accepting additional replicas.", (Object)broker, (Object)topic);
                    return;
                }
                if (sourceBroker.numFollowerReplicasOfTopicInBroker(topic) <= this.followersForBrokerForTopicLowerLimit(topic, sourceBroker)) continue block0;
                boolean sourceShouldBeReplaced = !sourceBrokers.isEmpty() && sourceBroker.numFollowerReplicasOfTopicInBroker(topic) < sourceBrokers.peek().numFollowerReplicasOfTopicInBroker(topic);
                if (!sourceShouldBeReplaced) continue;
                sourceBrokers.add(sourceBroker);
                continue block0;
            }
        }
    }

    void rebalanceByMovingLeaderReplicasOut(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        TreeSet<Broker> destinationBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.numLeaderReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numLeaderReplicas).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id));
        this.topicStats.getEligibleDestinationBrokers(clusterModel, broker).stream().filter(b -> b.rack() == broker.rack()).filter(b -> b.numLeaderReplicasOfTopicInBroker(topic) < this.leadersForBrokerForTopicUpperLimit(topic, (Broker)b)).collect(Collectors.toCollection(() -> destinationBrokers));
        Collection<Replica> replicasToMove = broker.leaderReplicasOfTopicInBroker(topic);
        int numLeaderReplicasInBroker = replicasToMove.size();
        for (Replica replica : replicasToMove) {
            boolean metTopicLeadersUpperBound;
            boolean movementSuccessful;
            LOG.debug("Trying to move leader replica out {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, broker, destinationBrokers});
            Broker newHostBroker = this.maybeApplyBalancingActions(clusterModel, replica, destinationBrokers, Arrays.asList(ActionType.INTER_BROKER_REPLICA_MOVEMENT, ActionType.LEADERSHIP_MOVEMENT), optimizedGoals, optimizationOptions, Optional.empty(), balancingActionsLogOpt);
            boolean bl = movementSuccessful = newHostBroker != null;
            if (!movementSuccessful) continue;
            LOG.debug("Successfully moved leader replica out {} for topic {} from broker {} to broker {}", new Object[]{replica, topic, broker, newHostBroker});
            ++this.numProposedReassignments;
            boolean bl2 = metTopicLeadersUpperBound = --numLeaderReplicasInBroker < this.leadersForBrokerForTopicUpperLimit(topic, broker) || numLeaderReplicasInBroker == this.leadersForBrokerForTopicUpperLimit(topic, broker) && this.leadersForBrokerForTopicUpperLimit(topic, broker) == this.leadersForBrokerForTopicLowerLimit(topic, broker);
            if (metTopicLeadersUpperBound) {
                LOG.debug("Broker {} successfully met the leaders upper bound for topic {} by moving out extra replicas.", (Object)broker, (Object)topic);
                return;
            }
            destinationBrokers.removeIf(b -> b.equals(newHostBroker));
            boolean candidateCanTakeMoreTopicLeaderReplicas = newHostBroker.numLeaderReplicasOfTopicInBroker(topic) < this.leadersForBrokerForTopicUpperLimit(topic, newHostBroker);
            if (!candidateCanTakeMoreTopicLeaderReplicas) continue;
            destinationBrokers.add(newHostBroker);
        }
    }

    void rebalanceByMovingLeaderReplicasIn(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        PriorityQueue<Broker> sourceBrokers = new PriorityQueue<Broker>(Comparator.comparingInt(b -> b.numLeaderReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numLeaderReplicas).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id).reversed());
        this.topicStats.getEligibleSourceBrokers(clusterModel, broker).stream().filter(b -> b.rack() == broker.rack()).filter(b -> b.numLeaderReplicasOfTopicInBroker(topic) > this.leadersForBrokerForTopicLowerLimit(topic, (Broker)b)).collect(Collectors.toCollection(() -> sourceBrokers));
        int numLeaderReplicasOfTopicInBroker = broker.numLeaderReplicasOfTopicInBroker(topic);
        Set<Broker> candidateBrokers = Collections.singleton(broker);
        block0: while (!sourceBrokers.isEmpty()) {
            Broker sourceBroker = sourceBrokers.poll();
            Collection<Replica> replicasToMove = sourceBroker.leaderReplicasOfTopicInBroker(topic);
            for (Replica replica : replicasToMove) {
                boolean metTopicLeaderLowerBound;
                boolean movementSuccessful;
                LOG.debug("Trying to move leader replica in {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, sourceBroker, candidateBrokers});
                Broker newHostBroker = this.maybeApplyBalancingActions(clusterModel, replica, candidateBrokers, Arrays.asList(ActionType.INTER_BROKER_REPLICA_MOVEMENT, ActionType.LEADERSHIP_MOVEMENT), optimizedGoals, optimizationOptions, Optional.empty(), balancingActionsLogOpt);
                boolean bl = movementSuccessful = newHostBroker != null;
                if (!movementSuccessful) continue;
                LOG.debug("Successfully moved leader replica in {} from broker {} to broker {}", new Object[]{replica, sourceBroker, newHostBroker});
                ++this.numProposedReassignments;
                boolean bl2 = metTopicLeaderLowerBound = ++numLeaderReplicasOfTopicInBroker >= this.leadersForBrokerForTopicLowerLimit(topic, broker);
                if (metTopicLeaderLowerBound) {
                    LOG.debug("Broker {} successfully met the leaders lower bound for topic {} by accepting additional replicas.", (Object)broker, (Object)topic);
                    return;
                }
                if (sourceBroker.numLeaderReplicasOfTopicInBroker(topic) <= this.leadersForBrokerForTopicLowerLimit(topic, sourceBroker)) continue block0;
                boolean requeueSourceBroker = !sourceBrokers.isEmpty() && sourceBroker.numLeaderReplicasOfTopicInBroker(topic) < sourceBrokers.peek().numLeaderReplicasOfTopicInBroker(topic);
                if (!requeueSourceBroker) continue;
                sourceBrokers.add(sourceBroker);
                continue block0;
            }
        }
    }

    private void initializeAverageLeaderAndFollowerReplica(ClusterModel clusterModel) {
        for (String topic : this.topicStats.getEligibleTopicsForRebalance()) {
            this.topicStats.initializeAverageLeadersForBrokersForTopic(clusterModel, topic);
            this.topicStats.initializeAverageFollowersForBrokersForTopic(clusterModel, topic);
        }
    }

    boolean initializeShouldTrigger(ClusterModel clusterModel, OptimizationOptions options) {
        boolean manyTopicsImbalanced;
        this.topicStats.setEligibleTopicsForRebalance(this.topicsToRebalance(clusterModel, options.excludedTopics()));
        if (this.topicStats.getEligibleTopicsForRebalance().isEmpty()) {
            LOG.warn("No topics to rebalance for {} so it won't trigger", (Object)this.name());
            this.shouldTrigger = false;
            return false;
        }
        if (this.runMode.shouldTrigger()) {
            LOG.info("{} will trigger, mode {}", (Object)this.name(), (Object)this.runMode);
            this.shouldTrigger = true;
            return true;
        }
        Double maxTopicImbalancedScore = this.topicStats.getTopicImbalanceScore(this.topicStats.getEligibleTopicsForRebalance().get(0), clusterModel);
        boolean anyTopicBadlyImbalanced = maxTopicImbalancedScore > this.balancingConstraint.topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold();
        LOG.debug("Max topic imabalance score is {} and threshold is {}", (Object)maxTopicImbalancedScore, (Object)this.balancingConstraint.topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold());
        if (anyTopicBadlyImbalanced) {
            LOG.info("{} will trigger, one of the topics is badly imbalanced with a replica distribution based imbalance score: {}", (Object)this.name(), (Object)maxTopicImbalancedScore);
        }
        int numTotalTopics = clusterModel.topics().size();
        double slightlyImbalancedTopicsNum = Math.round((double)numTotalTopics * this.balancingConstraint.topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger());
        boolean bl = manyTopicsImbalanced = (double)this.topicStats.getEligibleTopicsForRebalance().size() > slightlyImbalancedTopicsNum && this.topicStats.getTopicImbalanceScore(this.topicStats.getEligibleTopicsForRebalance().get((int)slightlyImbalancedTopicsNum), clusterModel) > this.balancingConstraint.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold();
        if (manyTopicsImbalanced) {
            LOG.info("{} will trigger, more than {} topics have an imbalance score greater than: {}", new Object[]{this.name(), slightlyImbalancedTopicsNum, this.balancingConstraint.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold()});
        }
        this.shouldTrigger = anyTopicBadlyImbalanced || manyTopicsImbalanced;
        LOG.info("{}'s trigger check is invoked by a goal violation detection: {}", (Object)this.name(), (Object)options.isTriggeredByGoalViolation());
        this.shouldTrigger = this.shouldTrigger != false || !options.isTriggeredByGoalViolation();
        return this.shouldTrigger;
    }

    private boolean interRackActionSelfSatisfy(ClusterModel clusterModel, ReplicaBalancingAction action) {
        String sourceRackId = clusterModel.broker(action.sourceBrokerId()).rack().id();
        String destinationRackId = clusterModel.broker(action.destinationBrokerId()).rack().id();
        if (this.topicStats.isCurrentTopicLeadersCountAtUpperBoundForRack(sourceRackId, clusterModel.broker(action.sourceBrokerId())) && this.topicStats.isCurrentTopicLeadersCountAtLowerBoundForRack(destinationRackId, clusterModel.broker(action.destinationBrokerId()))) {
            return clusterModel.rack(sourceRackId).numLeaderReplicas() - 2 >= clusterModel.rack(destinationRackId).numLeaderReplicas();
        }
        return true;
    }

    private boolean leaderActionSelfSatisfy(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String topic = action.topic();
        if (sourceBroker.numLeaderReplicasOfTopicInBroker(topic) == this.leadersForBrokerForTopicUpperLimit(topic, sourceBroker) && destinationBroker.numLeaderReplicasOfTopicInBroker(topic) == this.leadersForBrokerForTopicLowerLimit(topic, destinationBroker)) {
            return sourceBroker.numLeaderReplicas() - 2 >= destinationBroker.numLeaderReplicas();
        }
        return this.checkLeadershipImbalanceScore(clusterModel, action);
    }

    private boolean followerActionSelfSatisfy(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String topic = action.topic();
        if (sourceBroker.numFollowerReplicasOfTopicInBroker(topic) == this.followersForBrokerForTopicUpperLimit(topic, sourceBroker) && destinationBroker.numFollowerReplicasOfTopicInBroker(topic) == this.followersForBrokerForTopicLowerLimit(topic, destinationBroker)) {
            return sourceBroker.numReplicas() - 2 >= destinationBroker.numReplicas();
        }
        return this.checkTopicReplicaDistributionBasedImbalanceScore(clusterModel, action);
    }

    private boolean checkLeadershipImbalanceScore(ClusterModel clusterModel, ReplicaBalancingAction action) {
        String topic = action.topic();
        List<Integer> leadershipDistributionBefore = this.topicStats.replicaDistributionForTopic(clusterModel, topic, true, clusterModel.broker(action.sourceBrokerId()));
        Double leadershipImbalanceScoreBefore = clusterModel.replicaDistributionImbalanceScore(leadershipDistributionBefore);
        List<Integer> leadershipDistributionAfter = this.topicStats.replicaDistributionAfterAction(clusterModel, action, true);
        Double leadershipImbalanceScoreAfter = clusterModel.replicaDistributionImbalanceScore(leadershipDistributionAfter);
        return leadershipImbalanceScoreBefore > leadershipImbalanceScoreAfter;
    }

    private boolean checkTopicReplicaDistributionBasedImbalanceScore(ClusterModel clusterModel, ReplicaBalancingAction action) {
        String topic = action.topic();
        Double topicImbalanceScoreBefore = this.topicStats.getTopicImbalanceScore(topic, clusterModel, clusterModel.broker(action.sourceBrokerId()));
        List<Integer> leadershipDistributionAfter = this.topicStats.replicaDistributionForTopic(clusterModel, topic, true, clusterModel.broker(action.sourceBrokerId()));
        List<Integer> followerDistributionAfter = this.topicStats.replicaDistributionAfterAction(clusterModel, action, false);
        Double topicImbalanceScoreAfter = clusterModel.calculateTopicReplicaDistributionBasedImbalanceScore(leadershipDistributionAfter, followerDistributionAfter);
        return topicImbalanceScoreBefore > topicImbalanceScoreAfter;
    }

    int leadersForBrokerForTopicUpperLimit(String topic, Broker broker) {
        return (int)Math.ceil(this.topicStats.getAverageLeadersForBrokerForTopic(topic, broker, Double.MAX_VALUE));
    }

    int leadersForBrokerForTopicLowerLimit(String topic, Broker broker) {
        return (int)Math.floor(this.topicStats.getAverageLeadersForBrokerForTopic(topic, broker, 0.0));
    }

    int followersForBrokerForTopicUpperLimit(String topic, Broker broker) {
        return (int)Math.ceil(this.topicStats.getAverageFollowersForBrokerForTopic(topic, broker, Double.MAX_VALUE));
    }

    int followersForBrokerForTopicLowerLimit(String topic, Broker broker) {
        return (int)Math.floor(this.topicStats.getAverageFollowersForBrokerForTopic(topic, broker, 0.0));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Mode {
        DEFAULT{

            @Override
            boolean shouldSkipRebalance(boolean shouldTrigger, int numProposedReassignments, int maxReassignmentsPerIteration) {
                return !shouldTrigger || numProposedReassignments >= maxReassignmentsPerIteration;
            }

            @Override
            boolean isReplicaActionAllowed(ReplicaBalancingAction action, Set<String> eligibleReplicaMoves) {
                return true;
            }

            @Override
            boolean shouldMarkAsInProgress(boolean stopsBeingTriggering, boolean hasMoreToRebalance) {
                return stopsBeingTriggering && hasMoreToRebalance;
            }

            @Override
            TopicSelectionResult topicsToRebalance(ClusterModel clusterModel, List<String> defaultTopicsToRebalance) {
                return new TopicSelectionResult(defaultTopicsToRebalance, Collections.emptySet());
            }

            @Override
            boolean shouldTrigger() {
                return false;
            }
        }
        ,
        HARD_GOAL_TRIGGERED{

            @Override
            boolean shouldSkipRebalance(boolean shouldTrigger, int numProposedReassignments, int maxReassignmentsPerIteration) {
                return false;
            }

            @Override
            boolean isReplicaActionAllowed(ReplicaBalancingAction action, Set<String> eligibleReplicaMoves) {
                return eligibleReplicaMoves.contains(String.valueOf(action.topicPartition()) + "-" + action.sourceBrokerId());
            }

            @Override
            boolean shouldMarkAsInProgress(boolean stopsBeingTriggering, boolean hasMoreToRebalance) {
                return false;
            }

            @Override
            TopicSelectionResult topicsToRebalance(ClusterModel clusterModel, List<String> defaultTopicsToRebalance) {
                HashSet topics = new HashSet();
                HashSet<String> eligibleMoves = new HashSet<String>();
                clusterModel.actionsHistoryItem().forEach(action -> {
                    eligibleMoves.add(String.valueOf(action.getTopicPartition()) + "-" + action.getDestinationBrokerId());
                    topics.add(action.getTopicPartition().topic());
                });
                return new TopicSelectionResult(new ArrayList<String>(topics), eligibleMoves);
            }

            @Override
            boolean shouldTrigger() {
                return true;
            }
        };


        abstract boolean shouldSkipRebalance(boolean var1, int var2, int var3);

        abstract boolean isReplicaActionAllowed(ReplicaBalancingAction var1, Set<String> var2);

        abstract boolean shouldMarkAsInProgress(boolean var1, boolean var2);

        abstract TopicSelectionResult topicsToRebalance(ClusterModel var1, List<String> var2);

        abstract boolean shouldTrigger();
    }

    private class TopicReplicaDistributionGoalStatsComparator
    implements ClusterModelStatsComparator {
        private String reasonForLastNegativeResult;

        private TopicReplicaDistributionGoalStatsComparator() {
        }

        @Override
        public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
            double postLeaderStdDev = stats1.topicLeaderReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            double preLeaderStdDev = stats2.topicLeaderReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            int leaderResult = AnalyzerUtils.compare(preLeaderStdDev, postLeaderStdDev, 1.0E-5);
            if (leaderResult < 0) {
                this.reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Topic Leader Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", IncrementalTopicReplicaDistributionGoal.this.name(), postLeaderStdDev, preLeaderStdDev);
                return leaderResult;
            }
            if (leaderResult == 0) {
                double postFollowerStdDev = stats1.topicFollowerReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
                double preFollowerStdDev = stats2.topicFollowerReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
                int followerResult = AnalyzerUtils.compare(preFollowerStdDev, postFollowerStdDev, 1.0E-5);
                if (followerResult < 0) {
                    this.reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Topic Follower Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", IncrementalTopicReplicaDistributionGoal.this.name(), postFollowerStdDev, preFollowerStdDev);
                    return followerResult;
                }
            }
            return leaderResult;
        }

        @Override
        public String explainLastComparison() {
            return this.reasonForLastNegativeResult;
        }
    }

    record TopicSelectionResult(List<String> topicsToRebalance, Set<String> eligibleReplicaMoves) {
    }

    private class InterRackMovement {
        final Replica replica;
        final Broker sourceBroker;
        final Broker destinationBroker;

        InterRackMovement(Replica replica, Broker sourceBroker, Broker destinationBroker) {
            if (sourceBroker.rack() == destinationBroker.rack()) {
                throw new IllegalArgumentException("For inter rack movement, source broker and destination broker can't be in same rack.");
            }
            this.replica = replica;
            this.sourceBroker = sourceBroker;
            this.destinationBroker = destinationBroker;
        }
    }
}

