/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.DetailedProposal;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import javax.annotation.concurrent.Immutable;

public class BrokerProposalLeaderboard {
    private final PriorityQueue<DetailedProposal.Result> topRejectedProposals;
    private final PriorityQueue<DetailedProposal.Result> topAcceptedProposals;
    private final int brokerId;
    private final int maxNumProposals;
    private boolean finished;
    private Result finishedResult;

    public BrokerProposalLeaderboard(int brokerId, int maxNumProposals) {
        this.maxNumProposals = maxNumProposals;
        if (maxNumProposals <= 0) {
            throw new IllegalArgumentException("maxNumProposals must be positive");
        }
        this.brokerId = brokerId;
        this.topRejectedProposals = new PriorityQueue(maxNumProposals);
        this.topAcceptedProposals = new PriorityQueue(maxNumProposals);
    }

    public Result finish() {
        if (this.finished) {
            return this.finishedResult;
        }
        List<DetailedProposal.Result> topAcceptedProposals = this.drainQueue(this.topAcceptedProposals);
        List<DetailedProposal.Result> topRejectedProposals = this.drainQueue(this.topRejectedProposals);
        this.finishedResult = new Result(this.brokerId, topAcceptedProposals, topRejectedProposals);
        this.finished = true;
        return this.finishedResult;
    }

    public void submitProposal(DetailedProposal.Result detailedProposalResult) {
        if (detailedProposalResult.proposal.brokerForRebalance != this.brokerId) {
            throw new IllegalArgumentException(String.format("The given proposal's broker id %d does not match this leaderboard's broker id %d", detailedProposalResult.proposal.brokerForRebalance, this.brokerId));
        }
        if (detailedProposalResult.isAccepted) {
            this.maybeUpdateQueue(this.topAcceptedProposals, detailedProposalResult);
        } else {
            this.maybeUpdateQueue(this.topRejectedProposals, detailedProposalResult);
        }
    }

    public void revertAcceptedProposals() {
        List<DetailedProposal.Result> acceptedProposals = this.drainQueue(this.topAcceptedProposals);
        acceptedProposals.forEach(proposal -> this.submitProposal(proposal.proposal.result(false)));
    }

    private void maybeUpdateQueue(PriorityQueue<DetailedProposal.Result> queueToUpdate, DetailedProposal.Result newProposal) {
        if (queueToUpdate.size() < this.maxNumProposals) {
            queueToUpdate.add(newProposal);
            return;
        }
        DetailedProposal.Result lastProposal = Objects.requireNonNull(queueToUpdate.peek(), "The last element in the queue was null");
        if (lastProposal.compareTo(newProposal) < 0) {
            queueToUpdate.poll();
            queueToUpdate.add(newProposal);
        }
    }

    private List<DetailedProposal.Result> drainQueue(PriorityQueue<DetailedProposal.Result> topProposalsQueue) {
        LinkedList<DetailedProposal.Result> topProposals = new LinkedList<DetailedProposal.Result>();
        while (!topProposalsQueue.isEmpty()) {
            topProposals.addFirst(topProposalsQueue.poll());
        }
        return topProposals;
    }

    @Immutable
    public static class Result {
        private final int brokerId;
        private final List<DetailedProposal.Result> topAcceptedProposals;
        private final List<DetailedProposal.Result> topRejectedProposals;

        public Result(int brokerId, List<DetailedProposal.Result> topAcceptedProposals, List<DetailedProposal.Result> topRejectedProposals) {
            this.brokerId = brokerId;
            this.topAcceptedProposals = Collections.unmodifiableList(topAcceptedProposals);
            this.topRejectedProposals = Collections.unmodifiableList(topRejectedProposals);
        }

        public int brokerId() {
            return this.brokerId;
        }

        public List<DetailedProposal.Result> topAcceptedProposals() {
            return this.topAcceptedProposals;
        }

        public List<DetailedProposal.Result> topRejectedProposals() {
            return this.topRejectedProposals;
        }
    }
}

