/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import com.linkedin.kafka.cruisecontrol.ConfigFetchErrorHandler;
import com.linkedin.kafka.cruisecontrol.common.SbkAdminUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import io.confluent.databalancer.utils.OperationRetryer;
import io.confluent.databalancer.utils.RetryableResult;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedConfigsFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(BatchedConfigsFetcher.class);
    private static final Duration DESCRIBE_CONFIG_PER_BATCH_WAIT_RETRY_DELAY = Duration.ofSeconds(1L);
    private final Duration describeConfigsPerBatchMaxRetryDuration;
    private final List<ConfigResource> configResources;
    private final KafkaCruiseControlConfig config;
    private final Admin adminClient;
    private final Time time;
    private final int timeoutMs;
    private final boolean includeSynonyms;
    private final boolean ignoreUnknownTopicOrPartition;
    private final ConfigFetchErrorHandler errorHandler;

    public static Builder of(Admin adminClient, KafkaCruiseControlConfig config, ConfigResource.Type type, Time time) {
        return new Builder(adminClient, config, type, time);
    }

    private BatchedConfigsFetcher(Admin adminClient, KafkaCruiseControlConfig config, Collection<String> entities, ConfigResource.Type type, Time time, int timeoutMs, Duration describeConfigsPerBatchMaxRetryDuration, boolean includeSynonyms, boolean ignoreUnknownTopicOrPartition, ConfigFetchErrorHandler errorHandler) {
        this.adminClient = adminClient;
        this.config = config;
        this.includeSynonyms = includeSynonyms;
        this.ignoreUnknownTopicOrPartition = ignoreUnknownTopicOrPartition;
        this.time = time;
        this.timeoutMs = timeoutMs;
        this.describeConfigsPerBatchMaxRetryDuration = describeConfigsPerBatchMaxRetryDuration;
        this.configResources = entities.stream().map(e -> new ConfigResource(type, e)).collect(Collectors.toList());
        this.errorHandler = errorHandler;
    }

    public Map<ConfigResource, Config> getConfigs() {
        int batchSize = this.config.getInt("describe.configs.batch.size");
        AtomicInteger index = new AtomicInteger();
        Set<List<ConfigResource>> batchedConfigResources = batchSize <= 0 ? Collections.singleton(this.configResources) : this.configResources.stream().collect(Collectors.groupingBy(ignore -> index.getAndIncrement() / batchSize)).values();
        LOG.debug("Going to use batch size of {} to get config of {} entities, resulting in {} describeConfigs call", new Object[]{batchSize, this.configResources.size(), batchedConfigResources.size()});
        DescribeConfigsOptions options = new DescribeConfigsOptions().timeoutMs(Integer.valueOf(this.timeoutMs)).includeSynonyms(this.includeSynonyms);
        OperationRetryer retryer = new OperationRetryer(this.time, this.describeConfigsPerBatchMaxRetryDuration, DESCRIBE_CONFIG_PER_BATCH_WAIT_RETRY_DELAY, "Get entity configuration.");
        long startMs = this.time.milliseconds();
        HashMap<ConfigResource, Config> allConfigs = new HashMap<ConfigResource, Config>();
        for (List list : batchedConfigResources) {
            try {
                Map entityConfigs = (Map)retryer.runWithRetries(() -> {
                    DescribeConfigsResult describeConfigsResult = this.adminClient.describeConfigs((Collection)entities, options);
                    HashMap<ConfigResource, Config> fetchedConfigs = new HashMap<ConfigResource, Config>();
                    for (Map.Entry configEntry : describeConfigsResult.values().entrySet()) {
                        try {
                            Config config = (Config)((KafkaFuture)configEntry.getValue()).get((long)this.timeoutMs, TimeUnit.MILLISECONDS);
                            fetchedConfigs.put((ConfigResource)configEntry.getKey(), config);
                        }
                        catch (Exception ex) {
                            if (this.errorHandler == null) {
                                if (ex.getCause() instanceof UnknownTopicOrPartitionException && this.ignoreUnknownTopicOrPartition) {
                                    LOG.error("Ignoring {} as it doesn't exist anymore.", (Object)((ConfigResource)configEntry.getKey()).name());
                                    continue;
                                }
                                LOG.error("Error when describing config for resource: {}", (Object)entities, (Object)ex);
                                return RetryableResult.Incomplete.instance();
                            }
                            if (entities.size() == 1) {
                                return this.errorHandler.handleError((ConfigResource)configEntry.getKey(), ex);
                            }
                            this.errorHandler.handleError((ConfigResource)configEntry.getKey(), ex);
                        }
                    }
                    return RetryableResult.Success.of(fetchedConfigs);
                });
                Optional.ofNullable(entityConfigs).ifPresent(allConfigs::putAll);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                LOG.error("Interrupted when describing config for resource: {}", (Object)list, (Object)ex);
                SbkAdminUtils.sneakyThrow(ex);
            }
        }
        long endMs = this.time.milliseconds();
        if (endMs - startMs > 15000L) {
            LOG.warn("getConfigs completed successfully after a considerable period of time - {} ms", (Object)(endMs - startMs));
        }
        return allConfigs;
    }

    public static class Builder {
        private final KafkaCruiseControlConfig config;
        private final Admin adminClient;
        private final ConfigResource.Type type;
        private final Time time;
        private Collection<String> entities;
        private int timeoutMs;
        private final Duration describeConfigsPerBatchMaxRetryDuration;
        private boolean includeSynonyms;
        private boolean ignoreUnknownTopicOrPartitionException;
        private ConfigFetchErrorHandler errorHandler;

        private Builder(Admin adminClient, KafkaCruiseControlConfig config, ConfigResource.Type type, Time time) {
            this.adminClient = adminClient;
            this.config = config;
            this.type = type;
            this.time = time;
            this.timeoutMs = config.getInt("describe.configs.response.timeout.ms");
            this.describeConfigsPerBatchMaxRetryDuration = Duration.ofMillis((long)this.timeoutMs * 3L);
        }

        public Builder entities(Collection<String> entities) {
            this.entities = entities;
            return this;
        }

        public Builder entity(String entity) {
            this.entities = Collections.singletonList(entity);
            return this;
        }

        public Builder timeout(int timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        public Builder includeSynonyms(boolean includeSynonyms) {
            this.includeSynonyms = includeSynonyms;
            return this;
        }

        public Builder ignoreUnknownTopicOrPartitionException(boolean ignoreUnknownTopicOrPartitionException) {
            this.ignoreUnknownTopicOrPartitionException = ignoreUnknownTopicOrPartitionException;
            return this;
        }

        public Builder errorHandler(ConfigFetchErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public BatchedConfigsFetcher build() {
            if (this.entities == null) {
                throw new IllegalStateException("Entities to fetch configs for is not provided.");
            }
            return new BatchedConfigsFetcher(this.adminClient, this.config, this.entities, this.type, this.time, this.timeoutMs, this.describeConfigsPerBatchMaxRetryDuration, this.includeSynonyms, this.ignoreUnknownTopicOrPartitionException, this.errorHandler);
        }
    }
}

